# Generated by Django 4.2.16 on 2025-01-08 13:28

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("vulnerabilities", "0085_alter_package_is_ghost_alter_package_version_rank_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="CodeFix",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "commits",
                    models.JSONField(
                        blank=True,
                        default=list,
                        help_text="List of commit identifiers using VCS URLs associated with the code change.",
                    ),
                ),
                (
                    "pulls",
                    models.JSONField(
                        blank=True,
                        default=list,
                        help_text="List of pull request URLs associated with the code change.",
                    ),
                ),
                (
                    "downloads",
                    models.JSONField(
                        blank=True,
                        default=list,
                        help_text="List of download URLs for the patched code.",
                    ),
                ),
                (
                    "patch",
                    models.TextField(
                        blank=True,
                        help_text="The code change as a patch in unified diff format.",
                        null=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        help_text="Notes or instructions about this code change.",
                        null=True,
                    ),
                ),
                (
                    "references",
                    models.JSONField(
                        blank=True,
                        default=list,
                        help_text="URL references related to this code change.",
                    ),
                ),
                (
                    "is_reviewed",
                    models.BooleanField(
                        default=False, help_text="Indicates if this code change has been reviewed."
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Timestamp indicating when this code change was created.",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Timestamp indicating when this code change was last updated.",
                    ),
                ),
                (
                    "affected_package_vulnerability",
                    models.ForeignKey(
                        help_text="The affected package version to which this code fix applies.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="code_fix",
                        to="vulnerabilities.affectedbypackagerelatedvulnerability",
                    ),
                ),
                (
                    "base_package_version",
                    models.ForeignKey(
                        blank=True,
                        help_text="The base package version to which this code change applies.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="codechanges",
                        to="vulnerabilities.package",
                    ),
                ),
                (
                    "fixed_package_vulnerability",
                    models.ForeignKey(
                        blank=True,
                        help_text="The fixing package version with this code fix",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="code_fix",
                        to="vulnerabilities.fixingpackagerelatedvulnerability",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
