# Generated by Django 4.2.20 on 2025-05-28 14:48

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("vulnerabilities", "0091_alter_advisory_unique_together_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="PipelineSchedule",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "pipeline_id",
                    models.CharField(
                        help_text="Identify a registered Pipeline class.",
                        max_length=600,
                        unique=True,
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="When set to True, this Pipeline is active. When set to False, this Pipeline is inactive and not run.",
                        null=True,
                    ),
                ),
                (
                    "live_logging",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        help_text="When enabled logs will be streamed live during pipeline execution. For legacy importers and improvers, logs are always made available only after execution completes.",
                    ),
                ),
                (
                    "run_interval",
                    models.PositiveSmallIntegerField(
                        default=1,
                        help_text="Number of days to wait between run of this pipeline.",
                        validators=[
                            django.core.validators.MinValueValidator(
                                1, message="Interval must be at least 1 day."
                            ),
                            django.core.validators.MaxValueValidator(
                                365, message="Interval must be at most 365 days."
                            ),
                        ],
                    ),
                ),
                (
                    "schedule_work_id",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="Identifier used to manage the periodic run job.",
                        max_length=255,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "execution_timeout",
                    models.PositiveSmallIntegerField(
                        default=24,
                        help_text="Number hours before pipeline execution is forcefully terminated.",
                        validators=[
                            django.core.validators.MinValueValidator(
                                1, message="Pipeline timeout must be at least 1 hour."
                            ),
                            django.core.validators.MaxValueValidator(
                                72, message="Pipeline timeout must be at most 72 hours."
                            ),
                        ],
                    ),
                ),
                ("created_date", models.DateTimeField(auto_now_add=True, db_index=True)),
            ],
            options={
                "ordering": ["-created_date"],
            },
        ),
        migrations.CreateModel(
            name="PipelineRun",
            fields=[
                (
                    "run_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                ("run_start_date", models.DateTimeField(blank=True, editable=False, null=True)),
                ("run_end_date", models.DateTimeField(blank=True, editable=False, null=True)),
                ("run_exitcode", models.IntegerField(blank=True, editable=False, null=True)),
                ("run_output", models.TextField(blank=True, editable=False)),
                ("created_date", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("vulnerablecode_version", models.CharField(blank=True, max_length=100, null=True)),
                ("vulnerablecode_commit", models.CharField(blank=True, max_length=300, null=True)),
                ("log", models.TextField(blank=True, editable=False)),
                (
                    "pipeline",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="pipelineruns",
                        to="vulnerabilities.pipelineschedule",
                    ),
                ),
            ],
            options={
                "ordering": ["-created_date"],
            },
        ),
    ]
