/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 16:11:38 EST 2017 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle_c.native -fma -reorder-insns -schedule-for-pipeline -simd -compact -variables 4 -pipeline-latency 8 -twiddle-log3 -precompute-twiddles -no-generate-bytw -n 25 -name t3bv_25 -include t3b.h -sign 1 */

/*
 * This function contains 268 FP additions, 281 FP multiplications,
 * (or, 87 additions, 100 multiplications, 181 fused multiply/add),
 * 223 stack variables, 67 constants, and 50 memory accesses
 */
#include "t3b.h"

static void t3bv_25(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP792626838, +0.792626838241819413632131824093538848057784557);
     DVK(KP876091699, +0.876091699473550838204498029706869638173524346);
     DVK(KP617882369, +0.617882369114440893914546919006756321695042882);
     DVK(KP803003575, +0.803003575438660414833440593570376004635464850);
     DVK(KP242145790, +0.242145790282157779872542093866183953459003101);
     DVK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DVK(KP999544308, +0.999544308746292983948881682379742149196758193);
     DVK(KP916574801, +0.916574801383451584742370439148878693530976769);
     DVK(KP904730450, +0.904730450839922351881287709692877908104763647);
     DVK(KP809385824, +0.809385824416008241660603814668679683846476688);
     DVK(KP447417479, +0.447417479732227551498980015410057305749330693);
     DVK(KP894834959, +0.894834959464455102997960030820114611498661386);
     DVK(KP867381224, +0.867381224396525206773171885031575671309956167);
     DVK(KP683113946, +0.683113946453479238701949862233725244439656928);
     DVK(KP559154169, +0.559154169276087864842202529084232643714075927);
     DVK(KP958953096, +0.958953096729998668045963838399037225970891871);
     DVK(KP831864738, +0.831864738706457140726048799369896829771167132);
     DVK(KP829049696, +0.829049696159252993975487806364305442437946767);
     DVK(KP860541664, +0.860541664367944677098261680920518816412804187);
     DVK(KP897376177, +0.897376177523557693138608077137219684419427330);
     DVK(KP876306680, +0.876306680043863587308115903922062583399064238);
     DVK(KP681693190, +0.681693190061530575150324149145440022633095390);
     DVK(KP560319534, +0.560319534973832390111614715371676131169633784);
     DVK(KP855719849, +0.855719849902058969314654733608091555096772472);
     DVK(KP237294955, +0.237294955877110315393888866460840817927895961);
     DVK(KP949179823, +0.949179823508441261575555465843363271711583843);
     DVK(KP904508497, +0.904508497187473712051146708591409529430077295);
     DVK(KP997675361, +0.997675361079556513670859573984492383596555031);
     DVK(KP763932022, +0.763932022500210303590826331268723764559381640);
     DVK(KP690983005, +0.690983005625052575897706582817180941139845410);
     DVK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DVK(KP952936919, +0.952936919628306576880750665357914584765951388);
     DVK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DVK(KP262346850, +0.262346850930607871785420028382979691334784273);
     DVK(KP570584518, +0.570584518783621657366766175430996792655723863);
     DVK(KP669429328, +0.669429328479476605641803240971985825917022098);
     DVK(KP923225144, +0.923225144846402650453449441572664695995209956);
     DVK(KP945422727, +0.945422727388575946270360266328811958657216298);
     DVK(KP522616830, +0.522616830205754336872861364785224694908468440);
     DVK(KP956723877, +0.956723877038460305821989399535483155872969262);
     DVK(KP906616052, +0.906616052148196230441134447086066874408359177);
     DVK(KP772036680, +0.772036680810363904029489473607579825330539880);
     DVK(KP845997307, +0.845997307939530944175097360758058292389769300);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DVK(KP912575812, +0.912575812670962425556968549836277086778922727);
     DVK(KP921078979, +0.921078979742360627699756128143719920817673854);
     DVK(KP982009705, +0.982009705009746369461829878184175962711969869);
     DVK(KP734762448, +0.734762448793050413546343770063151342619912334);
     DVK(KP494780565, +0.494780565770515410344588413655324772219443730);
     DVK(KP447533225, +0.447533225982656890041886979663652563063114397);
     DVK(KP603558818, +0.603558818296015001454675132653458027918768137);
     DVK(KP667278218, +0.667278218140296670899089292254759909713898805);
     DVK(KP244189809, +0.244189809627953270309879511234821255780225091);
     DVK(KP269969613, +0.269969613759572083574752974412347470060951301);
     DVK(KP578046249, +0.578046249379945007321754579646815604023525655);
     DVK(KP522847744, +0.522847744331509716623755382187077770911012542);
     DVK(KP132830569, +0.132830569247582714407653942074819768844536507);
     DVK(KP120146378, +0.120146378570687701782758537356596213647956445);
     DVK(KP893101515, +0.893101515366181661711202267938416198338079437);
     DVK(KP987388751, +0.987388751065621252324603216482382109400433949);
     DVK(KP059835404, +0.059835404262124915169548397419498386427871950);
     DVK(KP066152395, +0.066152395967733048213034281011006031460903353);
     DVK(KP786782374, +0.786782374965295178365099601674911834788448471);
     DVK(KP869845200, +0.869845200362138853122720822420327157933056305);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP618033988, +0.618033988749894848204586834365638117720309180);
     {
	  INT m;
	  R *x;
	  x = ii;
	  for (m = mb, W = W + (mb * ((TWVL / VL) * 8)); m < me; m = m + VL, x = x + (VL * ms), W = W + (TWVL * 8), MAKE_VOLATILE_STRIDE(25, rs)) {
	       V T2t, T1Z, T2W, T28, T2Q, T2r, T2g, T2u, T2o, T2l;
	       {
		    V T2, T5, T3, T9;
		    T2 = LDW(&(W[0]));
		    T5 = LDW(&(W[TWVL * 4]));
		    T3 = LDW(&(W[TWVL * 2]));
		    T9 = LDW(&(W[TWVL * 6]));
		    {
			 V T2c, T3l, Tn, T49, Tm, T4e, TN, T32, T1d, T3a, T3f, T3z, T3H, T25, T1W;
			 V T2v, T2D, T4a, T1g, T18, T2Z, T11, T31, TK, T1q, T1j, T1n, T4b, T17;
			 {
			      V T1, T1l, Tr, T4, Ty, T1E, Tu, TX, TD, T1h, Tz, T1e, T1I, T1o, TU;
			      V Tk, T2b, T1B, T1D, T1N, T1F, Td, T2a, T1J;
			      {
				   V T7, Tb, TC, Tg, T1L, Ta, T6, Tj, T1A;
				   T1 = LD(&(x[0]), ms, &(x[0]));
				   {
					V Tf, Ti, Te, Th;
					Tf = LD(&(x[WS(rs, 10)]), ms, &(x[0]));
					Ti = LD(&(x[WS(rs, 15)]), ms, &(x[WS(rs, 1)]));
					T7 = LD(&(x[WS(rs, 5)]), ms, &(x[WS(rs, 1)]));
					Tb = LD(&(x[WS(rs, 20)]), ms, &(x[0]));
					Te = VZMUL(T2, T5);
					TC = VZMULJ(T2, T5);
					T1l = VZMUL(T3, T5);
					Tr = VZMULJ(T3, T5);
					T4 = VZMUL(T2, T3);
					Ty = VZMULJ(T2, T3);
					T1E = VZMULJ(T2, T9);
					Th = VZMULJ(T5, T9);
					Tu = VZMULJ(T3, T9);
					Tg = VZMUL(Te, Tf);
					TX = VZMULJ(Te, T9);
					TD = VZMULJ(TC, T9);
					T1h = VZMULJ(Ty, T9);
					Tz = VZMUL(Ty, T5);
					T1e = VZMULJ(Ty, T5);
					T1L = VZMULJ(Tr, T9);
					Ta = VZMULJ(T4, T9);
					T1I = VZMUL(T4, T5);
					T6 = VZMULJ(T4, T5);
					Tj = VZMUL(Th, Ti);
				   }
				   T1A = LD(&(x[WS(rs, 3)]), ms, &(x[WS(rs, 1)]));
				   T1o = VZMULJ(T1e, T9);
				   {
					V Tc, T8, T1C, T1M;
					T1C = LD(&(x[WS(rs, 8)]), ms, &(x[0]));
					T1M = LD(&(x[WS(rs, 18)]), ms, &(x[0]));
					Tc = VZMUL(Ta, Tb);
					T8 = VZMUL(T6, T7);
					TU = VZMULJ(T6, T9);
					Tk = VADD(Tg, Tj);
					T2b = VSUB(Tg, Tj);
					T1B = VZMUL(T3, T1A);
					T1D = VZMUL(TC, T1C);
					T1N = VZMUL(T1L, T1M);
					T1F = LD(&(x[WS(rs, 23)]), ms, &(x[WS(rs, 1)]));
					Td = VADD(T8, Tc);
					T2a = VSUB(T8, Tc);
					T1J = LD(&(x[WS(rs, 13)]), ms, &(x[WS(rs, 1)]));
				   }
			      }
			      {
				   V Tq, Tt, TF, T1T, T1H, Tw, T1U, T1O, TA, Tp, Ts, TE;
				   Tp = LD(&(x[WS(rs, 1)]), ms, &(x[WS(rs, 1)]));
				   Ts = LD(&(x[WS(rs, 6)]), ms, &(x[0]));
				   TE = LD(&(x[WS(rs, 16)]), ms, &(x[0]));
				   {
					V T1K, Tv, T1G, Tl;
					Tv = LD(&(x[WS(rs, 21)]), ms, &(x[WS(rs, 1)]));
					T1G = VZMUL(T1E, T1F);
					T2c = VFMA(LDK(KP618033988), T2b, T2a);
					T3l = VFNMS(LDK(KP618033988), T2a, T2b);
					Tn = VSUB(Td, Tk);
					Tl = VADD(Td, Tk);
					T1K = VZMUL(T1I, T1J);
					Tq = VZMUL(T2, Tp);
					Tt = VZMUL(Tr, Ts);
					TF = VZMUL(TD, TE);
					T1T = VSUB(T1D, T1G);
					T1H = VADD(T1D, T1G);
					T49 = VADD(T1, Tl);
					Tm = VFNMS(LDK(KP250000000), Tl, T1);
					Tw = VZMUL(Tu, Tv);
					T1U = VSUB(T1K, T1N);
					T1O = VADD(T1K, T1N);
					TA = LD(&(x[WS(rs, 11)]), ms, &(x[WS(rs, 1)]));
				   }
				   {
					V Tx, TL, T1R, T38, T1V, T13, TQ, TZ, TS, T1Q, TV, TG, TM, T12, T1c;
					V T16;
					T12 = LD(&(x[WS(rs, 4)]), ms, &(x[0]));
					{
					     V TP, TY, T1P, TB, TR;
					     TP = LD(&(x[WS(rs, 24)]), ms, &(x[0]));
					     TY = LD(&(x[WS(rs, 14)]), ms, &(x[0]));
					     TR = LD(&(x[WS(rs, 9)]), ms, &(x[WS(rs, 1)]));
					     Tx = VADD(Tt, Tw);
					     TL = VSUB(Tt, Tw);
					     T1R = VSUB(T1O, T1H);
					     T1P = VADD(T1H, T1O);
					     T38 = VFNMS(LDK(KP618033988), T1T, T1U);
					     T1V = VFMA(LDK(KP618033988), T1U, T1T);
					     TB = VZMUL(Tz, TA);
					     T13 = VZMUL(T4, T12);
					     TQ = VZMUL(T9, TP);
					     TZ = VZMUL(TX, TY);
					     TS = VZMUL(T5, TR);
					     T4e = VADD(T1B, T1P);
					     T1Q = VFNMS(LDK(KP250000000), T1P, T1B);
					     TV = LD(&(x[WS(rs, 19)]), ms, &(x[WS(rs, 1)]));
					     TG = VADD(TB, TF);
					     TM = VSUB(TF, TB);
					}
					T1c = LD(&(x[WS(rs, 2)]), ms, &(x[0]));
					{
					     V T14, TT, TJ, T15, T10, TI, T1p, T1f, T1i, T1m;
					     T1f = LD(&(x[WS(rs, 7)]), ms, &(x[WS(rs, 1)]));
					     T14 = VADD(TS, TQ);
					     TT = VSUB(TQ, TS);
					     {
						  V T39, T1S, TW, TH;
						  T39 = VFMA(LDK(KP559016994), T1R, T1Q);
						  T1S = VFNMS(LDK(KP559016994), T1R, T1Q);
						  TW = VZMUL(TU, TV);
						  TH = VADD(Tx, TG);
						  TJ = VSUB(Tx, TG);
						  TN = VFNMS(LDK(KP618033988), TM, TL);
						  T32 = VFMA(LDK(KP618033988), TL, TM);
						  T1d = VZMUL(Ty, T1c);
						  T3a = VFMA(LDK(KP869845200), T39, T38);
						  T3f = VFNMS(LDK(KP786782374), T38, T39);
						  T3z = VFMA(LDK(KP066152395), T39, T38);
						  T3H = VFNMS(LDK(KP059835404), T38, T39);
						  T25 = VFMA(LDK(KP987388751), T1S, T1V);
						  T1W = VFNMS(LDK(KP893101515), T1V, T1S);
						  T2v = VFNMS(LDK(KP120146378), T1V, T1S);
						  T2D = VFMA(LDK(KP132830569), T1S, T1V);
						  T15 = VADD(TZ, TW);
						  T10 = VSUB(TW, TZ);
						  TI = VFNMS(LDK(KP250000000), TH, Tq);
						  T4a = VADD(Tq, TH);
						  T1g = VZMUL(T1e, T1f);
					     }
					     T1p = LD(&(x[WS(rs, 17)]), ms, &(x[WS(rs, 1)]));
					     T1i = LD(&(x[WS(rs, 22)]), ms, &(x[0]));
					     T1m = LD(&(x[WS(rs, 12)]), ms, &(x[0]));
					     T18 = VSUB(T14, T15);
					     T16 = VADD(T14, T15);
					     T2Z = VFNMS(LDK(KP618033988), TT, T10);
					     T11 = VFMA(LDK(KP618033988), T10, TT);
					     T31 = VFNMS(LDK(KP559016994), TJ, TI);
					     TK = VFMA(LDK(KP559016994), TJ, TI);
					     T1q = VZMUL(T1o, T1p);
					     T1j = VZMUL(T1h, T1i);
					     T1n = VZMUL(T1l, T1m);
					}
					T4b = VADD(T13, T16);
					T17 = VFMS(LDK(KP250000000), T16, T13);
				   }
			      }
			 }
			 {
			      V T33, T3i, T3C, T3L, T20, TO, T2y, T2G, T1k, T1w, T1r, T1x, T2Y, T19, T4k;
			      V T4c;
			      T33 = VFMA(LDK(KP893101515), T32, T31);
			      T3i = VFNMS(LDK(KP987388751), T31, T32);
			      T3C = VFNMS(LDK(KP522847744), T32, T31);
			      T3L = VFMA(LDK(KP578046249), T31, T32);
			      T20 = VFMA(LDK(KP269969613), TK, TN);
			      TO = VFNMS(LDK(KP244189809), TN, TK);
			      T2y = VFMA(LDK(KP667278218), TK, TN);
			      T2G = VFNMS(LDK(KP603558818), TN, TK);
			      T1k = VADD(T1g, T1j);
			      T1w = VSUB(T1g, T1j);
			      T1r = VADD(T1n, T1q);
			      T1x = VSUB(T1q, T1n);
			      T2Y = VFMA(LDK(KP559016994), T18, T17);
			      T19 = VFNMS(LDK(KP559016994), T18, T17);
			      T4k = VSUB(T4a, T4b);
			      T4c = VADD(T4a, T4b);
			      {
				   V T2X, To, T35, T1y, T2H, T2z, T1a, T21, T3t, T34, T3n, T3j, T3E, T3Y, T3M;
				   V T3R, T1v, T36, T4l, T4f, T1u, T1s;
				   T2X = VFNMS(LDK(KP559016994), Tn, Tm);
				   To = VFMA(LDK(KP559016994), Tn, Tm);
				   T1u = VSUB(T1r, T1k);
				   T1s = VADD(T1k, T1r);
				   T35 = VFMA(LDK(KP618033988), T1w, T1x);
				   T1y = VFNMS(LDK(KP618033988), T1x, T1w);
				   {
					V T3K, T30, T3h, T3D, T4d, T1t;
					T3K = VFMA(LDK(KP447533225), T2Z, T2Y);
					T30 = VFMA(LDK(KP120146378), T2Z, T2Y);
					T3h = VFNMS(LDK(KP132830569), T2Y, T2Z);
					T3D = VFNMS(LDK(KP494780565), T2Y, T2Z);
					T2H = VFNMS(LDK(KP786782374), T11, T19);
					T2z = VFMA(LDK(KP869845200), T19, T11);
					T1a = VFNMS(LDK(KP667278218), T19, T11);
					T21 = VFMA(LDK(KP603558818), T11, T19);
					T4d = VADD(T1d, T1s);
					T1t = VFNMS(LDK(KP250000000), T1s, T1d);
					T3t = VFNMS(LDK(KP734762448), T33, T30);
					T34 = VFMA(LDK(KP734762448), T33, T30);
					T3n = VFMA(LDK(KP734762448), T3i, T3h);
					T3j = VFNMS(LDK(KP734762448), T3i, T3h);
					T3E = VFNMS(LDK(KP982009705), T3D, T3C);
					T3Y = VFMA(LDK(KP982009705), T3D, T3C);
					T3M = VFNMS(LDK(KP921078979), T3L, T3K);
					T3R = VFMA(LDK(KP921078979), T3L, T3K);
					T1v = VFNMS(LDK(KP559016994), T1u, T1t);
					T36 = VFMA(LDK(KP559016994), T1u, T1t);
					T4l = VSUB(T4d, T4e);
					T4f = VADD(T4d, T4e);
				   }
				   {
					V T2L, T2R, T2j, T2q, T2J, T2B, T2e, T26, T2U, T1Y, T23, T2O;
					{
					     V T2I, T24, T2w, T2E, T48, T42, T3y, T3s, T3V, T45, T2A, T1b, T2h, T2i, T1X;
					     T2L = VFNMS(LDK(KP912575812), T2H, T2G);
					     T2I = VFMA(LDK(KP912575812), T2H, T2G);
					     {
						  V T3A, T3e, T37, T3I, T1z;
						  T3A = VFNMS(LDK(KP667278218), T36, T35);
						  T3e = VFNMS(LDK(KP059835404), T35, T36);
						  T37 = VFMA(LDK(KP066152395), T36, T35);
						  T3I = VFMA(LDK(KP603558818), T35, T36);
						  T24 = VFMA(LDK(KP578046249), T1v, T1y);
						  T1z = VFNMS(LDK(KP522847744), T1y, T1v);
						  T2w = VFNMS(LDK(KP494780565), T1v, T1y);
						  T2E = VFMA(LDK(KP447533225), T1y, T1v);
						  {
						       V T4i, T4g, T4o, T4m;
						       T4i = VSUB(T4c, T4f);
						       T4g = VADD(T4c, T4f);
						       T4o = VMUL(LDK(KP951056516), VFNMS(LDK(KP618033988), T4k, T4l));
						       T4m = VMUL(LDK(KP951056516), VFMA(LDK(KP618033988), T4l, T4k));
						       {
							    V T3Q, T3J, T3b, T3u;
							    T3Q = VFNMS(LDK(KP845997307), T3I, T3H);
							    T3J = VFMA(LDK(KP845997307), T3I, T3H);
							    T3b = VFNMS(LDK(KP772036680), T3a, T37);
							    T3u = VFMA(LDK(KP772036680), T3a, T37);
							    {
								 V T3o, T3g, T3B, T3X, T4h;
								 T3o = VFNMS(LDK(KP772036680), T3f, T3e);
								 T3g = VFMA(LDK(KP772036680), T3f, T3e);
								 T3B = VFNMS(LDK(KP845997307), T3A, T3z);
								 T3X = VFMA(LDK(KP845997307), T3A, T3z);
								 ST(&(x[0]), VADD(T4g, T49), ms, &(x[0]));
								 T4h = VFNMS(LDK(KP250000000), T4g, T49);
								 {
								      V T40, T3N, T3c, T3v;
								      T40 = VFMA(LDK(KP906616052), T3M, T3J);
								      T3N = VFNMS(LDK(KP906616052), T3M, T3J);
								      T3c = VFMA(LDK(KP956723877), T3b, T34);
								      T3v = VFMA(LDK(KP522616830), T3j, T3u);
								      {
									   V T3p, T3k, T3S, T3F;
									   T3p = VFNMS(LDK(KP522616830), T34, T3o);
									   T3k = VFMA(LDK(KP945422727), T3j, T3g);
									   T3S = VFNMS(LDK(KP923225144), T3E, T3B);
									   T3F = VFMA(LDK(KP923225144), T3E, T3B);
									   {
										V T46, T3Z, T4j, T4n;
										T46 = VFNMS(LDK(KP669429328), T3X, T3Y);
										T3Z = VFMA(LDK(KP570584518), T3Y, T3X);
										T4j = VFMA(LDK(KP559016994), T4i, T4h);
										T4n = VFNMS(LDK(KP559016994), T4i, T4h);
										{
										     V T3W, T3O, T3d, T3w;
										     T3W = VFMA(LDK(KP262346850), T3N, T3l);
										     T3O = VMUL(LDK(KP998026728), VFNMS(LDK(KP952936919), T3l, T3N));
										     T3d = VFMA(LDK(KP992114701), T3c, T2X);
										     T3w = VFNMS(LDK(KP690983005), T3v, T3g);
										     {
											  V T3q, T3m, T3T, T43;
											  T3q = VFMA(LDK(KP763932022), T3p, T3b);
											  T3m = VMUL(LDK(KP998026728), VFMA(LDK(KP952936919), T3l, T3k));
											  T3T = VFNMS(LDK(KP997675361), T3S, T3R);
											  T43 = VFNMS(LDK(KP904508497), T3S, T3Q);
											  {
											       V T3G, T3P, T47, T41;
											       T3G = VFMA(LDK(KP949179823), T3F, T2X);
											       T3P = VFNMS(LDK(KP237294955), T3F, T2X);
											       T47 = VFNMS(LDK(KP669429328), T40, T46);
											       T41 = VFMA(LDK(KP618033988), T40, T3Z);
											       ST(&(x[WS(rs, 20)]), VFNMSI(T4m, T4j), ms, &(x[0]));
											       ST(&(x[WS(rs, 5)]), VFMAI(T4m, T4j), ms, &(x[WS(rs, 1)]));
											       ST(&(x[WS(rs, 15)]), VFMAI(T4o, T4n), ms, &(x[WS(rs, 1)]));
											       ST(&(x[WS(rs, 10)]), VFNMSI(T4o, T4n), ms, &(x[0]));
											       {
												    V T3x, T3r, T3U, T44;
												    T3x = VFMA(LDK(KP855719849), T3w, T3t);
												    T3r = VFNMS(LDK(KP855719849), T3q, T3n);
												    ST(&(x[WS(rs, 3)]), VFMAI(T3m, T3d), ms, &(x[WS(rs, 1)]));
												    ST(&(x[WS(rs, 22)]), VFNMSI(T3m, T3d), ms, &(x[0]));
												    T3U = VFMA(LDK(KP560319534), T3T, T3Q);
												    T44 = VFNMS(LDK(KP681693190), T43, T3R);
												    ST(&(x[WS(rs, 2)]), VFMAI(T3O, T3G), ms, &(x[0]));
												    ST(&(x[WS(rs, 23)]), VFNMSI(T3O, T3G), ms, &(x[WS(rs, 1)]));
												    T48 = VMUL(LDK(KP951056516), VFNMS(LDK(KP876306680), T47, T3W));
												    T42 = VMUL(LDK(KP951056516), VFNMS(LDK(KP949179823), T41, T3W));
												    T3y = VMUL(LDK(KP951056516), VFNMS(LDK(KP992114701), T3x, T3l));
												    T3s = VFMA(LDK(KP897376177), T3r, T2X);
												    T3V = VFNMS(LDK(KP949179823), T3U, T3P);
												    T45 = VFNMS(LDK(KP860541664), T44, T3P);
												    T2R = VFNMS(LDK(KP912575812), T2z, T2y);
												    T2A = VFMA(LDK(KP912575812), T2z, T2y);
												    T1b = VFMA(LDK(KP829049696), T1a, TO);
												    T2h = VFNMS(LDK(KP829049696), T1a, TO);
												    T2i = VFNMS(LDK(KP831864738), T1W, T1z);
												    T1X = VFMA(LDK(KP831864738), T1W, T1z);
											       }
											  }
										     }
										}
									   }
								      }
								 }
							    }
						       }
						  }
					     }
					     {
						  V T2M, T2F, T2x, T2S, T2T, T2N;
						  T2M = VFNMS(LDK(KP958953096), T2E, T2D);
						  T2F = VFMA(LDK(KP958953096), T2E, T2D);
						  ST(&(x[WS(rs, 17)]), VFNMSI(T3y, T3s), ms, &(x[WS(rs, 1)]));
						  ST(&(x[WS(rs, 8)]), VFMAI(T3y, T3s), ms, &(x[0]));
						  ST(&(x[WS(rs, 13)]), VFMAI(T42, T3V), ms, &(x[WS(rs, 1)]));
						  ST(&(x[WS(rs, 12)]), VFNMSI(T42, T3V), ms, &(x[0]));
						  ST(&(x[WS(rs, 7)]), VFNMSI(T48, T45), ms, &(x[WS(rs, 1)]));
						  ST(&(x[WS(rs, 18)]), VFMAI(T48, T45), ms, &(x[0]));
						  T2j = VFMA(LDK(KP559154169), T2i, T2h);
						  T2q = VFNMS(LDK(KP683113946), T2h, T2i);
						  T2x = VFNMS(LDK(KP867381224), T2w, T2v);
						  T2S = VFMA(LDK(KP867381224), T2w, T2v);
						  T2J = VFMA(LDK(KP894834959), T2I, T2F);
						  T2T = VFMA(LDK(KP447417479), T2I, T2S);
						  T2B = VFNMS(LDK(KP809385824), T2A, T2x);
						  T2N = VFMA(LDK(KP447417479), T2A, T2M);
						  T2e = VFMA(LDK(KP831864738), T25, T24);
						  T26 = VFNMS(LDK(KP831864738), T25, T24);
						  T2U = VFNMS(LDK(KP763932022), T2T, T2F);
						  T1Y = VFMA(LDK(KP904730450), T1X, T1b);
						  T23 = VFNMS(LDK(KP904730450), T1X, T1b);
						  T2O = VFMA(LDK(KP690983005), T2N, T2x);
					     }
					}
					{
					     V T2C, T22, T2d, T2K;
					     T2C = VFNMS(LDK(KP992114701), T2B, To);
					     T22 = VFMA(LDK(KP916574801), T21, T20);
					     T2d = VFNMS(LDK(KP916574801), T21, T20);
					     T2K = VMUL(LDK(KP951056516), VFNMS(LDK(KP992114701), T2J, T2c));
					     {
						  V T27, T2P, T2f, T2k, T2n, T2V;
						  T2V = VFNMS(LDK(KP999544308), T2U, T2R);
						  T27 = VFNMS(LDK(KP904730450), T26, T23);
						  T2t = VFMA(LDK(KP968583161), T1Y, To);
						  T1Z = VFNMS(LDK(KP242145790), T1Y, To);
						  T2P = VFNMS(LDK(KP999544308), T2O, T2L);
						  T2f = VFMA(LDK(KP904730450), T2e, T2d);
						  T2k = VFNMS(LDK(KP904730450), T2e, T2d);
						  T2n = VADD(T22, T23);
						  ST(&(x[WS(rs, 21)]), VFMAI(T2K, T2C), ms, &(x[WS(rs, 1)]));
						  ST(&(x[WS(rs, 4)]), VFNMSI(T2K, T2C), ms, &(x[0]));
						  T2W = VMUL(LDK(KP951056516), VFNMS(LDK(KP803003575), T2V, T2c));
						  T28 = VFNMS(LDK(KP618033988), T27, T22);
						  T2Q = VFNMS(LDK(KP803003575), T2P, To);
						  T2r = VFMA(LDK(KP617882369), T2k, T2q);
						  T2g = VFNMS(LDK(KP242145790), T2f, T2c);
						  T2u = VMUL(LDK(KP951056516), VFMA(LDK(KP968583161), T2f, T2c));
						  T2o = VFNMS(LDK(KP683113946), T2n, T26);
						  T2l = VFMA(LDK(KP559016994), T2k, T2j);
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       {
		    V T29, T2s, T2p, T2m;
		    T29 = VFNMS(LDK(KP876091699), T28, T1Z);
		    ST(&(x[WS(rs, 16)]), VFMAI(T2W, T2Q), ms, &(x[0]));
		    ST(&(x[WS(rs, 9)]), VFNMSI(T2W, T2Q), ms, &(x[WS(rs, 1)]));
		    T2s = VMUL(LDK(KP951056516), VFNMS(LDK(KP876306680), T2r, T2g));
		    ST(&(x[WS(rs, 24)]), VFNMSI(T2u, T2t), ms, &(x[0]));
		    ST(&(x[WS(rs, 1)]), VFMAI(T2u, T2t), ms, &(x[WS(rs, 1)]));
		    T2p = VFMA(LDK(KP792626838), T2o, T1Z);
		    T2m = VMUL(LDK(KP951056516), VFMA(LDK(KP968583161), T2l, T2g));
		    ST(&(x[WS(rs, 11)]), VFMAI(T2s, T2p), ms, &(x[WS(rs, 1)]));
		    ST(&(x[WS(rs, 14)]), VFNMSI(T2s, T2p), ms, &(x[0]));
		    ST(&(x[WS(rs, 19)]), VFNMSI(T2m, T29), ms, &(x[WS(rs, 1)]));
		    ST(&(x[WS(rs, 6)]), VFMAI(T2m, T29), ms, &(x[0]));
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 3),
     VTW(0, 9),
     VTW(0, 24),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 25, XSIMD_STRING("t3bv_25"), twinstr, &GENUS, {87, 100, 181, 0}, 0, 0, 0 };

void XSIMD(codelet_t3bv_25) (planner *p) {
     X(kdft_dit_register) (p, t3bv_25, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle_c.native -simd -compact -variables 4 -pipeline-latency 8 -twiddle-log3 -precompute-twiddles -no-generate-bytw -n 25 -name t3bv_25 -include t3b.h -sign 1 */

/*
 * This function contains 268 FP additions, 228 FP multiplications,
 * (or, 191 additions, 151 multiplications, 77 fused multiply/add),
 * 124 stack variables, 40 constants, and 50 memory accesses
 */
#include "t3b.h"

static void t3bv_25(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP497379774, +0.497379774329709576484567492012895936835134813);
     DVK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DVK(KP248689887, +0.248689887164854788242283746006447968417567406);
     DVK(KP1_937166322, +1.937166322257262238980336750929471627672024806);
     DVK(KP809016994, +0.809016994374947424102293417182819058860154590);
     DVK(KP309016994, +0.309016994374947424102293417182819058860154590);
     DVK(KP1_688655851, +1.688655851004030157097116127933363010763318483);
     DVK(KP535826794, +0.535826794978996618271308767867639978063575346);
     DVK(KP425779291, +0.425779291565072648862502445744251703979973042);
     DVK(KP1_809654104, +1.809654104932039055427337295865395187940827822);
     DVK(KP963507348, +0.963507348203430549974383005744259307057084020);
     DVK(KP876306680, +0.876306680043863587308115903922062583399064238);
     DVK(KP844327925, +0.844327925502015078548558063966681505381659241);
     DVK(KP1_071653589, +1.071653589957993236542617535735279956127150691);
     DVK(KP481753674, +0.481753674101715274987191502872129653528542010);
     DVK(KP1_752613360, +1.752613360087727174616231807844125166798128477);
     DVK(KP851558583, +0.851558583130145297725004891488503407959946084);
     DVK(KP904827052, +0.904827052466019527713668647932697593970413911);
     DVK(KP125333233, +0.125333233564304245373118759816508793942918247);
     DVK(KP1_984229402, +1.984229402628955662099586085571557042906073418);
     DVK(KP1_457937254, +1.457937254842823046293460638110518222745143328);
     DVK(KP684547105, +0.684547105928688673732283357621209269889519233);
     DVK(KP637423989, +0.637423989748689710176712811676016195434917298);
     DVK(KP1_541026485, +1.541026485551578461606019272792355694543335344);
     DVK(KP062790519, +0.062790519529313376076178224565631133122484832);
     DVK(KP1_996053456, +1.996053456856543123904673613726901106673810439);
     DVK(KP770513242, +0.770513242775789230803009636396177847271667672);
     DVK(KP1_274847979, +1.274847979497379420353425623352032390869834596);
     DVK(KP125581039, +0.125581039058626752152356449131262266244969664);
     DVK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DVK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DVK(KP250666467, +0.250666467128608490746237519633017587885836494);
     DVK(KP728968627, +0.728968627421411523146730319055259111372571664);
     DVK(KP1_369094211, +1.369094211857377347464566715242418539779038465);
     DVK(KP293892626, +0.293892626146236564584352977319536384298826219);
     DVK(KP475528258, +0.475528258147576786058219666689691071702849317);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     {
	  INT m;
	  R *x;
	  x = ii;
	  for (m = mb, W = W + (mb * ((TWVL / VL) * 8)); m < me; m = m + VL, x = x + (VL * ms), W = W + (TWVL * 8), MAKE_VOLATILE_STRIDE(25, rs)) {
	       V T1, Td, T8, T9, TF, Te, Tu, TB, TC, T1s, T15, Tf, TY, T4, Ta;
	       V Tx, T1T, Tg, T1N, T1v, T18, TG, T1o, T11;
	       T1 = LDW(&(W[TWVL * 4]));
	       Td = LDW(&(W[TWVL * 2]));
	       T8 = LDW(&(W[0]));
	       T9 = VZMUL(T8, T1);
	       TF = VZMULJ(T8, T1);
	       Te = VZMUL(T8, Td);
	       Tu = VZMULJ(Td, T1);
	       TB = VZMULJ(T8, Td);
	       TC = VZMUL(TB, T1);
	       T1s = VZMUL(Te, T1);
	       T15 = VZMUL(Td, T1);
	       Tf = VZMULJ(Te, T1);
	       TY = VZMULJ(TB, T1);
	       T4 = LDW(&(W[TWVL * 6]));
	       Ta = VZMULJ(T9, T4);
	       Tx = VZMULJ(Td, T4);
	       T1T = VZMULJ(T1, T4);
	       Tg = VZMULJ(Tf, T4);
	       T1N = VZMULJ(Te, T4);
	       T1v = VZMULJ(Tu, T4);
	       T18 = VZMULJ(TY, T4);
	       TG = VZMULJ(TF, T4);
	       T1o = VZMULJ(T8, T4);
	       T11 = VZMULJ(TB, T4);
	       {
		    V T1Y, T1X, T2f, T2g, T1Z, T20, T2e, T39, T1H, T2T, T1E, T3C, T2S, Tk, T2G;
		    V Ts, T3z, T2F, TK, T2I, TS, T3y, T2J, T1k, T2Q, T1h, T3B, T2P;
		    {
			 V T1S, T1V, T1W, T1M, T1P, T1Q, T2d;
			 T1Y = LD(&(x[0]), ms, &(x[0]));
			 {
			      V T1R, T1U, T1L, T1O;
			      T1R = LD(&(x[WS(rs, 10)]), ms, &(x[0]));
			      T1S = VZMUL(T9, T1R);
			      T1U = LD(&(x[WS(rs, 15)]), ms, &(x[WS(rs, 1)]));
			      T1V = VZMUL(T1T, T1U);
			      T1W = VADD(T1S, T1V);
			      T1L = LD(&(x[WS(rs, 5)]), ms, &(x[WS(rs, 1)]));
			      T1M = VZMUL(Tf, T1L);
			      T1O = LD(&(x[WS(rs, 20)]), ms, &(x[0]));
			      T1P = VZMUL(T1N, T1O);
			      T1Q = VADD(T1M, T1P);
			 }
			 T1X = VMUL(LDK(KP559016994), VSUB(T1Q, T1W));
			 T2f = VSUB(T1S, T1V);
			 T2g = VMUL(LDK(KP587785252), T2f);
			 T1Z = VADD(T1Q, T1W);
			 T20 = VFNMS(LDK(KP250000000), T1Z, T1Y);
			 T2d = VSUB(T1M, T1P);
			 T2e = VMUL(LDK(KP951056516), T2d);
			 T39 = VMUL(LDK(KP587785252), T2d);
		    }
		    {
			 V T1B, T1u, T1x, T1y, T1n, T1q, T1r, T1A;
			 T1A = LD(&(x[WS(rs, 3)]), ms, &(x[WS(rs, 1)]));
			 T1B = VZMUL(Td, T1A);
			 {
			      V T1t, T1w, T1m, T1p;
			      T1t = LD(&(x[WS(rs, 13)]), ms, &(x[WS(rs, 1)]));
			      T1u = VZMUL(T1s, T1t);
			      T1w = LD(&(x[WS(rs, 18)]), ms, &(x[0]));
			      T1x = VZMUL(T1v, T1w);
			      T1y = VADD(T1u, T1x);
			      T1m = LD(&(x[WS(rs, 8)]), ms, &(x[0]));
			      T1n = VZMUL(TF, T1m);
			      T1p = LD(&(x[WS(rs, 23)]), ms, &(x[WS(rs, 1)]));
			      T1q = VZMUL(T1o, T1p);
			      T1r = VADD(T1n, T1q);
			 }
			 {
			      V T1F, T1G, T1z, T1C, T1D;
			      T1F = VSUB(T1n, T1q);
			      T1G = VSUB(T1u, T1x);
			      T1H = VFMA(LDK(KP475528258), T1F, VMUL(LDK(KP293892626), T1G));
			      T2T = VFNMS(LDK(KP475528258), T1G, VMUL(LDK(KP293892626), T1F));
			      T1z = VMUL(LDK(KP559016994), VSUB(T1r, T1y));
			      T1C = VADD(T1r, T1y);
			      T1D = VFNMS(LDK(KP250000000), T1C, T1B);
			      T1E = VADD(T1z, T1D);
			      T3C = VADD(T1B, T1C);
			      T2S = VSUB(T1D, T1z);
			 }
		    }
		    {
			 V Tp, Tc, Ti, Tm, T3, T6, Tl, To;
			 To = LD(&(x[WS(rs, 4)]), ms, &(x[0]));
			 Tp = VZMUL(Te, To);
			 {
			      V Tb, Th, T2, T5;
			      Tb = LD(&(x[WS(rs, 14)]), ms, &(x[0]));
			      Tc = VZMUL(Ta, Tb);
			      Th = LD(&(x[WS(rs, 19)]), ms, &(x[WS(rs, 1)]));
			      Ti = VZMUL(Tg, Th);
			      Tm = VADD(Tc, Ti);
			      T2 = LD(&(x[WS(rs, 9)]), ms, &(x[WS(rs, 1)]));
			      T3 = VZMUL(T1, T2);
			      T5 = LD(&(x[WS(rs, 24)]), ms, &(x[0]));
			      T6 = VZMUL(T4, T5);
			      Tl = VADD(T3, T6);
			 }
			 {
			      V T7, Tj, Tn, Tq, Tr;
			      T7 = VSUB(T3, T6);
			      Tj = VSUB(Tc, Ti);
			      Tk = VFMA(LDK(KP475528258), T7, VMUL(LDK(KP293892626), Tj));
			      T2G = VFNMS(LDK(KP475528258), Tj, VMUL(LDK(KP293892626), T7));
			      Tn = VMUL(LDK(KP559016994), VSUB(Tl, Tm));
			      Tq = VADD(Tl, Tm);
			      Tr = VFNMS(LDK(KP250000000), Tq, Tp);
			      Ts = VADD(Tn, Tr);
			      T3z = VADD(Tp, Tq);
			      T2F = VSUB(Tr, Tn);
			 }
		    }
		    {
			 V TP, TE, TI, TM, Tw, Tz, TL, TO;
			 TO = LD(&(x[WS(rs, 1)]), ms, &(x[WS(rs, 1)]));
			 TP = VZMUL(T8, TO);
			 {
			      V TD, TH, Tv, Ty;
			      TD = LD(&(x[WS(rs, 11)]), ms, &(x[WS(rs, 1)]));
			      TE = VZMUL(TC, TD);
			      TH = LD(&(x[WS(rs, 16)]), ms, &(x[0]));
			      TI = VZMUL(TG, TH);
			      TM = VADD(TE, TI);
			      Tv = LD(&(x[WS(rs, 6)]), ms, &(x[0]));
			      Tw = VZMUL(Tu, Tv);
			      Ty = LD(&(x[WS(rs, 21)]), ms, &(x[WS(rs, 1)]));
			      Tz = VZMUL(Tx, Ty);
			      TL = VADD(Tw, Tz);
			 }
			 {
			      V TA, TJ, TN, TQ, TR;
			      TA = VSUB(Tw, Tz);
			      TJ = VSUB(TE, TI);
			      TK = VFMA(LDK(KP475528258), TA, VMUL(LDK(KP293892626), TJ));
			      T2I = VFNMS(LDK(KP475528258), TJ, VMUL(LDK(KP293892626), TA));
			      TN = VMUL(LDK(KP559016994), VSUB(TL, TM));
			      TQ = VADD(TL, TM);
			      TR = VFNMS(LDK(KP250000000), TQ, TP);
			      TS = VADD(TN, TR);
			      T3y = VADD(TP, TQ);
			      T2J = VSUB(TR, TN);
			 }
		    }
		    {
			 V T1e, T17, T1a, T1b, T10, T13, T14, T1d;
			 T1d = LD(&(x[WS(rs, 2)]), ms, &(x[0]));
			 T1e = VZMUL(TB, T1d);
			 {
			      V T16, T19, TZ, T12;
			      T16 = LD(&(x[WS(rs, 12)]), ms, &(x[0]));
			      T17 = VZMUL(T15, T16);
			      T19 = LD(&(x[WS(rs, 17)]), ms, &(x[WS(rs, 1)]));
			      T1a = VZMUL(T18, T19);
			      T1b = VADD(T17, T1a);
			      TZ = LD(&(x[WS(rs, 7)]), ms, &(x[WS(rs, 1)]));
			      T10 = VZMUL(TY, TZ);
			      T12 = LD(&(x[WS(rs, 22)]), ms, &(x[0]));
			      T13 = VZMUL(T11, T12);
			      T14 = VADD(T10, T13);
			 }
			 {
			      V T1i, T1j, T1c, T1f, T1g;
			      T1i = VSUB(T10, T13);
			      T1j = VSUB(T17, T1a);
			      T1k = VFMA(LDK(KP475528258), T1i, VMUL(LDK(KP293892626), T1j));
			      T2Q = VFNMS(LDK(KP475528258), T1j, VMUL(LDK(KP293892626), T1i));
			      T1c = VMUL(LDK(KP559016994), VSUB(T14, T1b));
			      T1f = VADD(T14, T1b);
			      T1g = VFNMS(LDK(KP250000000), T1f, T1e);
			      T1h = VADD(T1c, T1g);
			      T3B = VADD(T1e, T1f);
			      T2P = VSUB(T1g, T1c);
			 }
		    }
		    {
			 V T3E, T3M, T3I, T3J, T3H, T3K, T3N, T3L;
			 {
			      V T3A, T3D, T3F, T3G;
			      T3A = VSUB(T3y, T3z);
			      T3D = VSUB(T3B, T3C);
			      T3E = VBYI(VFMA(LDK(KP951056516), T3A, VMUL(LDK(KP587785252), T3D)));
			      T3M = VBYI(VFNMS(LDK(KP951056516), T3D, VMUL(LDK(KP587785252), T3A)));
			      T3I = VADD(T1Y, T1Z);
			      T3F = VADD(T3y, T3z);
			      T3G = VADD(T3B, T3C);
			      T3J = VADD(T3F, T3G);
			      T3H = VMUL(LDK(KP559016994), VSUB(T3F, T3G));
			      T3K = VFNMS(LDK(KP250000000), T3J, T3I);
			 }
			 ST(&(x[0]), VADD(T3I, T3J), ms, &(x[0]));
			 T3N = VSUB(T3K, T3H);
			 ST(&(x[WS(rs, 10)]), VADD(T3M, T3N), ms, &(x[0]));
			 ST(&(x[WS(rs, 15)]), VSUB(T3N, T3M), ms, &(x[WS(rs, 1)]));
			 T3L = VADD(T3H, T3K);
			 ST(&(x[WS(rs, 5)]), VADD(T3E, T3L), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 20)]), VSUB(T3L, T3E), ms, &(x[0]));
		    }
		    {
			 V T2X, T3a, T3i, T3j, T3k, T3s, T3t, T3u, T3l, T3m, T3n, T3p, T3q, T3r, T2L;
			 V T3b, T32, T38, T2W, T35, T2Y, T34, T3w, T3x;
			 T2X = VSUB(T20, T1X);
			 T3a = VFNMS(LDK(KP951056516), T2f, T39);
			 T3i = VFMA(LDK(KP1_369094211), T2I, VMUL(LDK(KP728968627), T2J));
			 T3j = VFNMS(LDK(KP992114701), T2F, VMUL(LDK(KP250666467), T2G));
			 T3k = VADD(T3i, T3j);
			 T3s = VFNMS(LDK(KP125581039), T2Q, VMUL(LDK(KP998026728), T2P));
			 T3t = VFMA(LDK(KP1_274847979), T2T, VMUL(LDK(KP770513242), T2S));
			 T3u = VADD(T3s, T3t);
			 T3l = VFMA(LDK(KP1_996053456), T2Q, VMUL(LDK(KP062790519), T2P));
			 T3m = VFNMS(LDK(KP637423989), T2S, VMUL(LDK(KP1_541026485), T2T));
			 T3n = VADD(T3l, T3m);
			 T3p = VFNMS(LDK(KP1_457937254), T2I, VMUL(LDK(KP684547105), T2J));
			 T3q = VFMA(LDK(KP1_984229402), T2G, VMUL(LDK(KP125333233), T2F));
			 T3r = VADD(T3p, T3q);
			 {
			      V T2H, T2K, T36, T30, T31, T37;
			      T2H = VFNMS(LDK(KP851558583), T2G, VMUL(LDK(KP904827052), T2F));
			      T2K = VFMA(LDK(KP1_752613360), T2I, VMUL(LDK(KP481753674), T2J));
			      T36 = VADD(T2K, T2H);
			      T30 = VFMA(LDK(KP1_071653589), T2Q, VMUL(LDK(KP844327925), T2P));
			      T31 = VFMA(LDK(KP125581039), T2T, VMUL(LDK(KP998026728), T2S));
			      T37 = VADD(T30, T31);
			      T2L = VSUB(T2H, T2K);
			      T3b = VADD(T36, T37);
			      T32 = VSUB(T30, T31);
			      T38 = VMUL(LDK(KP559016994), VSUB(T36, T37));
			 }
			 {
			      V T2M, T2N, T2O, T2R, T2U, T2V;
			      T2M = VFNMS(LDK(KP963507348), T2I, VMUL(LDK(KP876306680), T2J));
			      T2N = VFMA(LDK(KP1_809654104), T2G, VMUL(LDK(KP425779291), T2F));
			      T2O = VSUB(T2M, T2N);
			      T2R = VFNMS(LDK(KP1_688655851), T2Q, VMUL(LDK(KP535826794), T2P));
			      T2U = VFNMS(LDK(KP1_996053456), T2T, VMUL(LDK(KP062790519), T2S));
			      T2V = VADD(T2R, T2U);
			      T2W = VMUL(LDK(KP559016994), VSUB(T2O, T2V));
			      T35 = VSUB(T2R, T2U);
			      T2Y = VADD(T2O, T2V);
			      T34 = VADD(T2M, T2N);
			 }
			 {
			      V T3g, T3h, T3o, T3v;
			      T3g = VADD(T2X, T2Y);
			      T3h = VBYI(VADD(T3a, T3b));
			      ST(&(x[WS(rs, 23)]), VSUB(T3g, T3h), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 2)]), VADD(T3g, T3h), ms, &(x[0]));
			      T3o = VADD(T2X, VADD(T3k, T3n));
			      T3v = VBYI(VSUB(VADD(T3r, T3u), T3a));
			      ST(&(x[WS(rs, 22)]), VSUB(T3o, T3v), ms, &(x[0]));
			      ST(&(x[WS(rs, 3)]), VADD(T3o, T3v), ms, &(x[WS(rs, 1)]));
			 }
			 T3w = VBYI(VSUB(VFMA(LDK(KP951056516), VSUB(T3i, T3j), VFMA(LDK(KP309016994), T3r, VFNMS(LDK(KP809016994), T3u, VMUL(LDK(KP587785252), VSUB(T3l, T3m))))), T3a));
			 T3x = VFMA(LDK(KP309016994), T3k, VFMA(LDK(KP951056516), VSUB(T3q, T3p), VFMA(LDK(KP587785252), VSUB(T3t, T3s), VFNMS(LDK(KP809016994), T3n, T2X))));
			 ST(&(x[WS(rs, 8)]), VADD(T3w, T3x), ms, &(x[0]));
			 ST(&(x[WS(rs, 17)]), VSUB(T3x, T3w), ms, &(x[WS(rs, 1)]));
			 {
			      V T33, T3e, T3d, T3f, T2Z, T3c;
			      T2Z = VFNMS(LDK(KP250000000), T2Y, T2X);
			      T33 = VFMA(LDK(KP951056516), T2L, VADD(T2W, VFNMS(LDK(KP587785252), T32, T2Z)));
			      T3e = VFMA(LDK(KP587785252), T2L, VFMA(LDK(KP951056516), T32, VSUB(T2Z, T2W)));
			      T3c = VFNMS(LDK(KP250000000), T3b, T3a);
			      T3d = VBYI(VADD(VFMA(LDK(KP951056516), T34, VMUL(LDK(KP587785252), T35)), VADD(T38, T3c)));
			      T3f = VBYI(VADD(VFNMS(LDK(KP951056516), T35, VMUL(LDK(KP587785252), T34)), VSUB(T3c, T38)));
			      ST(&(x[WS(rs, 18)]), VSUB(T33, T3d), ms, &(x[0]));
			      ST(&(x[WS(rs, 12)]), VADD(T3e, T3f), ms, &(x[0]));
			      ST(&(x[WS(rs, 7)]), VADD(T33, T3d), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 13)]), VSUB(T3e, T3f), ms, &(x[WS(rs, 1)]));
			 }
		    }
		    {
			 V T21, T2h, T2p, T2q, T2r, T2z, T2A, T2B, T2s, T2t, T2u, T2w, T2x, T2y, TU;
			 V T2i, T26, T2c, T1K, T29, T22, T28, T2D, T2E;
			 T21 = VADD(T1X, T20);
			 T2h = VADD(T2e, T2g);
			 T2p = VFMA(LDK(KP1_688655851), TK, VMUL(LDK(KP535826794), TS));
			 T2q = VFMA(LDK(KP1_541026485), Tk, VMUL(LDK(KP637423989), Ts));
			 T2r = VSUB(T2p, T2q);
			 T2z = VFMA(LDK(KP851558583), T1k, VMUL(LDK(KP904827052), T1h));
			 T2A = VFMA(LDK(KP1_984229402), T1H, VMUL(LDK(KP125333233), T1E));
			 T2B = VADD(T2z, T2A);
			 T2s = VFNMS(LDK(KP425779291), T1h, VMUL(LDK(KP1_809654104), T1k));
			 T2t = VFNMS(LDK(KP992114701), T1E, VMUL(LDK(KP250666467), T1H));
			 T2u = VADD(T2s, T2t);
			 T2w = VFNMS(LDK(KP1_071653589), TK, VMUL(LDK(KP844327925), TS));
			 T2x = VFNMS(LDK(KP770513242), Ts, VMUL(LDK(KP1_274847979), Tk));
			 T2y = VADD(T2w, T2x);
			 {
			      V Tt, TT, T2a, T24, T25, T2b;
			      Tt = VFMA(LDK(KP1_071653589), Tk, VMUL(LDK(KP844327925), Ts));
			      TT = VFMA(LDK(KP1_937166322), TK, VMUL(LDK(KP248689887), TS));
			      T2a = VADD(TT, Tt);
			      T24 = VFMA(LDK(KP1_752613360), T1k, VMUL(LDK(KP481753674), T1h));
			      T25 = VFMA(LDK(KP1_457937254), T1H, VMUL(LDK(KP684547105), T1E));
			      T2b = VADD(T24, T25);
			      TU = VSUB(Tt, TT);
			      T2i = VADD(T2a, T2b);
			      T26 = VSUB(T24, T25);
			      T2c = VMUL(LDK(KP559016994), VSUB(T2a, T2b));
			 }
			 {
			      V TV, TW, TX, T1l, T1I, T1J;
			      TV = VFNMS(LDK(KP497379774), TK, VMUL(LDK(KP968583161), TS));
			      TW = VFNMS(LDK(KP1_688655851), Tk, VMUL(LDK(KP535826794), Ts));
			      TX = VADD(TV, TW);
			      T1l = VFNMS(LDK(KP963507348), T1k, VMUL(LDK(KP876306680), T1h));
			      T1I = VFNMS(LDK(KP1_369094211), T1H, VMUL(LDK(KP728968627), T1E));
			      T1J = VADD(T1l, T1I);
			      T1K = VMUL(LDK(KP559016994), VSUB(TX, T1J));
			      T29 = VSUB(T1l, T1I);
			      T22 = VADD(TX, T1J);
			      T28 = VSUB(TV, TW);
			 }
			 {
			      V T2n, T2o, T2v, T2C;
			      T2n = VADD(T21, T22);
			      T2o = VBYI(VADD(T2h, T2i));
			      ST(&(x[WS(rs, 24)]), VSUB(T2n, T2o), ms, &(x[0]));
			      ST(&(x[WS(rs, 1)]), VADD(T2n, T2o), ms, &(x[WS(rs, 1)]));
			      T2v = VADD(T21, VADD(T2r, T2u));
			      T2C = VBYI(VSUB(VADD(T2y, T2B), T2h));
			      ST(&(x[WS(rs, 21)]), VSUB(T2v, T2C), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 4)]), VADD(T2v, T2C), ms, &(x[0]));
			 }
			 T2D = VBYI(VSUB(VFMA(LDK(KP309016994), T2y, VFMA(LDK(KP951056516), VADD(T2p, T2q), VFNMS(LDK(KP809016994), T2B, VMUL(LDK(KP587785252), VSUB(T2s, T2t))))), T2h));
			 T2E = VFMA(LDK(KP951056516), VSUB(T2x, T2w), VFMA(LDK(KP309016994), T2r, VFMA(LDK(KP587785252), VSUB(T2A, T2z), VFNMS(LDK(KP809016994), T2u, T21))));
			 ST(&(x[WS(rs, 9)]), VADD(T2D, T2E), ms, &(x[WS(rs, 1)]));
			 ST(&(x[WS(rs, 16)]), VSUB(T2E, T2D), ms, &(x[0]));
			 {
			      V T27, T2l, T2k, T2m, T23, T2j;
			      T23 = VFNMS(LDK(KP250000000), T22, T21);
			      T27 = VFMA(LDK(KP951056516), TU, VADD(T1K, VFNMS(LDK(KP587785252), T26, T23)));
			      T2l = VFMA(LDK(KP587785252), TU, VFMA(LDK(KP951056516), T26, VSUB(T23, T1K)));
			      T2j = VFNMS(LDK(KP250000000), T2i, T2h);
			      T2k = VBYI(VADD(VFMA(LDK(KP951056516), T28, VMUL(LDK(KP587785252), T29)), VADD(T2c, T2j)));
			      T2m = VBYI(VADD(VFNMS(LDK(KP951056516), T29, VMUL(LDK(KP587785252), T28)), VSUB(T2j, T2c)));
			      ST(&(x[WS(rs, 19)]), VSUB(T27, T2k), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 11)]), VADD(T2l, T2m), ms, &(x[WS(rs, 1)]));
			      ST(&(x[WS(rs, 6)]), VADD(T27, T2k), ms, &(x[0]));
			      ST(&(x[WS(rs, 14)]), VSUB(T2l, T2m), ms, &(x[0]));
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 3),
     VTW(0, 9),
     VTW(0, 24),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 25, XSIMD_STRING("t3bv_25"), twinstr, &GENUS, {191, 151, 77, 0}, 0, 0, 0 };

void XSIMD(codelet_t3bv_25) (planner *p) {
     X(kdft_dit_register) (p, t3bv_25, &desc);
}
#endif				/* HAVE_FMA */
