import { Construct } from 'constructs';
/**
 * @experimental
 */
export interface GetContextKeyOptions {
    /**
     * (experimental) The context provider to query.
     *
     * @experimental
     */
    readonly provider: string;
    /**
     * (experimental) Provider-specific properties.
     *
     * @experimental
     */
    readonly props?: {
        [key: string]: any;
    };
}
/**
 * @experimental
 */
export interface GetContextValueOptions extends GetContextKeyOptions {
    /**
     * (experimental) The value to return if the context value was not found and a missing context is reported.
     *
     * This should be a dummy value that should preferably
     * fail during deployment since it represents an invalid state.
     *
     * @experimental
     */
    readonly dummyValue: any;
}
/**
 * @experimental
 */
export interface GetContextKeyResult {
    /**
     * @experimental
     */
    readonly key: string;
    /**
     * @experimental
     */
    readonly props: {
        [key: string]: any;
    };
}
/**
 * @experimental
 */
export interface GetContextValueResult {
    /**
     * @experimental
     */
    readonly value?: any;
}
/**
 * (experimental) Base class for the model side of context providers.
 *
 * Instances of this class communicate with context provider plugins in the 'cdk
 * toolkit' via context variables (input), outputting specialized queries for
 * more context variables (output).
 *
 * ContextProvider needs access to a Construct to hook into the context mechanism.
 *
 * @experimental
 */
export declare class ContextProvider {
    /**
     * @returns the context key or undefined if a key cannot be rendered (due to tokens used in any of the props)
     * @experimental
     */
    static getKey(scope: Construct, options: GetContextKeyOptions): GetContextKeyResult;
    /**
     * @experimental
     */
    static getValue(scope: Construct, options: GetContextValueOptions): GetContextValueResult;
    private constructor();
}
