import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
import { StackSynthesizer } from './stack-synthesizer';
/**
 * Use the original deployment environment.
 *
 * This deployment environment is restricted in cross-environment deployments,
 * CI/CD deployments, and will use up CloudFormation parameters in your template.
 *
 * This is the only StackSynthesizer that supports customizing asset behavior
 * by overriding `Stack.addFileAsset()` and `Stack.addDockerImageAsset()`.
 */
export declare class LegacyStackSynthesizer extends StackSynthesizer {
    private stack?;
    private cycle;
    /**
     * Includes all parameters synthesized for assets (lazy).
     */
    private _assetParameters?;
    /**
     * The image ID of all the docker image assets that were already added to this
     * stack (to avoid duplication).
     */
    private readonly addedImageAssets;
    /**
     * Bind to the stack this environment is going to be used on.
     *
     * Must be called before any of the other methods are called.
     */
    bind(stack: Stack): void;
    /**
     * Register a File Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     */
    addFileAsset(asset: FileAssetSource): FileAssetLocation;
    /**
     * Register a Docker Image Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     */
    addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    /**
     * Synthesize the associated stack to the session.
     */
    synthesize(session: ISynthesisSession): void;
    private doAddDockerImageAsset;
    private doAddFileAsset;
    private get assetParameters();
}
