import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#id DataAzurermAppConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#name DataAzurermAppConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#resource_group_name DataAzurermAppConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#timeouts DataAzurermAppConfiguration#timeouts}
    */
    readonly timeouts?: DataAzurermAppConfigurationTimeouts;
}
export interface DataAzurermAppConfigurationPrimaryReadKey {
}
export declare function dataAzurermAppConfigurationPrimaryReadKeyToTerraform(struct?: DataAzurermAppConfigurationPrimaryReadKey): any;
export declare class DataAzurermAppConfigurationPrimaryReadKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationPrimaryReadKey | undefined;
    set internalValue(value: DataAzurermAppConfigurationPrimaryReadKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationPrimaryReadKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationPrimaryReadKeyOutputReference;
}
export interface DataAzurermAppConfigurationPrimaryWriteKey {
}
export declare function dataAzurermAppConfigurationPrimaryWriteKeyToTerraform(struct?: DataAzurermAppConfigurationPrimaryWriteKey): any;
export declare class DataAzurermAppConfigurationPrimaryWriteKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationPrimaryWriteKey | undefined;
    set internalValue(value: DataAzurermAppConfigurationPrimaryWriteKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationPrimaryWriteKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationPrimaryWriteKeyOutputReference;
}
export interface DataAzurermAppConfigurationSecondaryReadKey {
}
export declare function dataAzurermAppConfigurationSecondaryReadKeyToTerraform(struct?: DataAzurermAppConfigurationSecondaryReadKey): any;
export declare class DataAzurermAppConfigurationSecondaryReadKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationSecondaryReadKey | undefined;
    set internalValue(value: DataAzurermAppConfigurationSecondaryReadKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationSecondaryReadKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationSecondaryReadKeyOutputReference;
}
export interface DataAzurermAppConfigurationSecondaryWriteKey {
}
export declare function dataAzurermAppConfigurationSecondaryWriteKeyToTerraform(struct?: DataAzurermAppConfigurationSecondaryWriteKey): any;
export declare class DataAzurermAppConfigurationSecondaryWriteKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationSecondaryWriteKey | undefined;
    set internalValue(value: DataAzurermAppConfigurationSecondaryWriteKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationSecondaryWriteKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationSecondaryWriteKeyOutputReference;
}
export interface DataAzurermAppConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#read DataAzurermAppConfiguration#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppConfigurationTimeoutsToTerraform(struct?: DataAzurermAppConfigurationTimeoutsOutputReference | DataAzurermAppConfigurationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAppConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAppConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration azurerm_app_configuration}
*/
export declare class DataAzurermAppConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_app_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration azurerm_app_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppConfigurationConfig);
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryReadKey;
    get primaryReadKey(): DataAzurermAppConfigurationPrimaryReadKeyList;
    private _primaryWriteKey;
    get primaryWriteKey(): DataAzurermAppConfigurationPrimaryWriteKeyList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _secondaryReadKey;
    get secondaryReadKey(): DataAzurermAppConfigurationSecondaryReadKeyList;
    private _secondaryWriteKey;
    get secondaryWriteKey(): DataAzurermAppConfigurationSecondaryWriteKeyList;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermAppConfigurationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAppConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
