import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAttestationProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#id DataAzurermAttestationProvider#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#name DataAzurermAttestationProvider#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#resource_group_name DataAzurermAttestationProvider#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#timeouts DataAzurermAttestationProvider#timeouts}
    */
    readonly timeouts?: DataAzurermAttestationProviderTimeouts;
}
export interface DataAzurermAttestationProviderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#read DataAzurermAttestationProvider#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAttestationProviderTimeoutsToTerraform(struct?: DataAzurermAttestationProviderTimeoutsOutputReference | DataAzurermAttestationProviderTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAttestationProviderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAttestationProviderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAttestationProviderTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider azurerm_attestation_provider}
*/
export declare class DataAzurermAttestationProvider extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_attestation_provider";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider azurerm_attestation_provider} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAttestationProviderConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAttestationProviderConfig);
    get attestationUri(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get trustModel(): string;
    private _timeouts;
    get timeouts(): DataAzurermAttestationProviderTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAttestationProviderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAttestationProviderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
