import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermManagedDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#id DataAzurermManagedDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#name DataAzurermManagedDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#resource_group_name DataAzurermManagedDisk#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#timeouts DataAzurermManagedDisk#timeouts}
    */
    readonly timeouts?: DataAzurermManagedDiskTimeouts;
}
export interface DataAzurermManagedDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#read DataAzurermManagedDisk#read}
    */
    readonly read?: string;
}
export declare function dataAzurermManagedDiskTimeoutsToTerraform(struct?: DataAzurermManagedDiskTimeoutsOutputReference | DataAzurermManagedDiskTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermManagedDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermManagedDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermManagedDiskTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk azurerm_managed_disk}
*/
export declare class DataAzurermManagedDisk extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_managed_disk";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk azurerm_managed_disk} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermManagedDiskConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermManagedDiskConfig);
    get createOption(): string;
    get diskAccessId(): string;
    get diskEncryptionSetId(): string;
    get diskIopsReadWrite(): number;
    get diskMbpsReadWrite(): number;
    get diskSizeGb(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imageReferenceId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkAccessPolicy(): string;
    get osType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sourceResourceId(): string;
    get sourceUri(): string;
    get storageAccountId(): string;
    get storageAccountType(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermManagedDiskTimeoutsOutputReference;
    putTimeouts(value: DataAzurermManagedDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermManagedDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
