import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermWindowsWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/windows_web_app#id DataAzurermWindowsWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/windows_web_app#name DataAzurermWindowsWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/windows_web_app#resource_group_name DataAzurermWindowsWebApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/windows_web_app#timeouts DataAzurermWindowsWebApp#timeouts}
    */
    readonly timeouts?: DataAzurermWindowsWebAppTimeouts;
}
export interface DataAzurermWindowsWebAppAuthSettingsActiveDirectory {
}
export declare function dataAzurermWindowsWebAppAuthSettingsActiveDirectoryToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsActiveDirectory): any;
export declare class DataAzurermWindowsWebAppAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsActiveDirectory | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsActiveDirectory | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsActiveDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsActiveDirectoryOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsFacebook {
}
export declare function dataAzurermWindowsWebAppAuthSettingsFacebookToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsFacebook): any;
export declare class DataAzurermWindowsWebAppAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsFacebook | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsFacebook | undefined);
    get appId(): string;
    get appSecret(): string;
    get appSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsFacebookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsFacebookOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsGithub {
}
export declare function dataAzurermWindowsWebAppAuthSettingsGithubToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsGithub): any;
export declare class DataAzurermWindowsWebAppAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsGithub | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsGithub | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsGithubOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsGoogle {
}
export declare function dataAzurermWindowsWebAppAuthSettingsGoogleToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsGoogle): any;
export declare class DataAzurermWindowsWebAppAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsGoogle | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsGoogle | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsGoogleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsGoogleOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsMicrosoft {
}
export declare function dataAzurermWindowsWebAppAuthSettingsMicrosoftToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsMicrosoft): any;
export declare class DataAzurermWindowsWebAppAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsMicrosoft | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsMicrosoft | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermWindowsWebAppAuthSettingsMicrosoftList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsMicrosoftOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettingsTwitter {
}
export declare function dataAzurermWindowsWebAppAuthSettingsTwitterToTerraform(struct?: DataAzurermWindowsWebAppAuthSettingsTwitter): any;
export declare class DataAzurermWindowsWebAppAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettingsTwitter | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettingsTwitter | undefined);
    get consumerKey(): string;
    get consumerSecret(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsTwitterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsTwitterOutputReference;
}
export interface DataAzurermWindowsWebAppAuthSettings {
}
export declare function dataAzurermWindowsWebAppAuthSettingsToTerraform(struct?: DataAzurermWindowsWebAppAuthSettings): any;
export declare class DataAzurermWindowsWebAppAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppAuthSettings | undefined;
    set internalValue(value: DataAzurermWindowsWebAppAuthSettings | undefined);
    private _activeDirectory;
    get activeDirectory(): DataAzurermWindowsWebAppAuthSettingsActiveDirectoryList;
    private _additionalLoginParameters;
    get additionalLoginParameters(): cdktf.StringMap;
    get allowedExternalRedirectUrls(): string[];
    get defaultProvider(): string;
    get enabled(): cdktf.IResolvable;
    private _facebook;
    get facebook(): DataAzurermWindowsWebAppAuthSettingsFacebookList;
    private _github;
    get github(): DataAzurermWindowsWebAppAuthSettingsGithubList;
    private _google;
    get google(): DataAzurermWindowsWebAppAuthSettingsGoogleList;
    get issuer(): string;
    private _microsoft;
    get microsoft(): DataAzurermWindowsWebAppAuthSettingsMicrosoftList;
    get runtimeVersion(): string;
    get tokenRefreshExtensionHours(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    private _twitter;
    get twitter(): DataAzurermWindowsWebAppAuthSettingsTwitterList;
    get unauthenticatedClientAction(): string;
}
export declare class DataAzurermWindowsWebAppAuthSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppAuthSettingsOutputReference;
}
export interface DataAzurermWindowsWebAppBackupSchedule {
}
export declare function dataAzurermWindowsWebAppBackupScheduleToTerraform(struct?: DataAzurermWindowsWebAppBackupSchedule): any;
export declare class DataAzurermWindowsWebAppBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppBackupSchedule | undefined;
    set internalValue(value: DataAzurermWindowsWebAppBackupSchedule | undefined);
    get frequencyInterval(): number;
    get frequencyUnit(): string;
    get keepAtLeastOneBackup(): cdktf.IResolvable;
    get lastExecutionTime(): string;
    get retentionPeriodDays(): number;
    get startTime(): string;
}
export declare class DataAzurermWindowsWebAppBackupScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppBackupScheduleOutputReference;
}
export interface DataAzurermWindowsWebAppBackup {
}
export declare function dataAzurermWindowsWebAppBackupToTerraform(struct?: DataAzurermWindowsWebAppBackup): any;
export declare class DataAzurermWindowsWebAppBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppBackup | undefined;
    set internalValue(value: DataAzurermWindowsWebAppBackup | undefined);
    get enabled(): cdktf.IResolvable;
    get name(): string;
    private _schedule;
    get schedule(): DataAzurermWindowsWebAppBackupScheduleList;
    get storageAccountUrl(): string;
}
export declare class DataAzurermWindowsWebAppBackupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppBackupOutputReference;
}
export interface DataAzurermWindowsWebAppConnectionString {
}
export declare function dataAzurermWindowsWebAppConnectionStringToTerraform(struct?: DataAzurermWindowsWebAppConnectionString): any;
export declare class DataAzurermWindowsWebAppConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppConnectionString | undefined;
    set internalValue(value: DataAzurermWindowsWebAppConnectionString | undefined);
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermWindowsWebAppConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppConnectionStringOutputReference;
}
export interface DataAzurermWindowsWebAppIdentity {
}
export declare function dataAzurermWindowsWebAppIdentityToTerraform(struct?: DataAzurermWindowsWebAppIdentity): any;
export declare class DataAzurermWindowsWebAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppIdentity | undefined;
    set internalValue(value: DataAzurermWindowsWebAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermWindowsWebAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppIdentityOutputReference;
}
export interface DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage {
}
export declare function dataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageToTerraform(struct?: DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage): any;
export declare class DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorage | undefined);
    get level(): string;
    get retentionInDays(): number;
    get sasUrl(): string;
}
export declare class DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageOutputReference;
}
export interface DataAzurermWindowsWebAppLogsApplicationLogs {
}
export declare function dataAzurermWindowsWebAppLogsApplicationLogsToTerraform(struct?: DataAzurermWindowsWebAppLogsApplicationLogs): any;
export declare class DataAzurermWindowsWebAppLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsApplicationLogs | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsApplicationLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): DataAzurermWindowsWebAppLogsApplicationLogsAzureBlobStorageList;
    get fileSystemLevel(): string;
}
export declare class DataAzurermWindowsWebAppLogsApplicationLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsApplicationLogsOutputReference;
}
export interface DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage {
}
export declare function dataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageToTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage): any;
export declare class DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorage | undefined);
    get retentionInDays(): number;
    get sasUrl(): string;
}
export declare class DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageOutputReference;
}
export interface DataAzurermWindowsWebAppLogsHttpLogsFileSystem {
}
export declare function dataAzurermWindowsWebAppLogsHttpLogsFileSystemToTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogsFileSystem): any;
export declare class DataAzurermWindowsWebAppLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsHttpLogsFileSystem | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsHttpLogsFileSystem | undefined);
    get retentionInDays(): number;
    get retentionInMb(): number;
}
export declare class DataAzurermWindowsWebAppLogsHttpLogsFileSystemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsHttpLogsFileSystemOutputReference;
}
export interface DataAzurermWindowsWebAppLogsHttpLogs {
}
export declare function dataAzurermWindowsWebAppLogsHttpLogsToTerraform(struct?: DataAzurermWindowsWebAppLogsHttpLogs): any;
export declare class DataAzurermWindowsWebAppLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogsHttpLogs | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogsHttpLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): DataAzurermWindowsWebAppLogsHttpLogsAzureBlobStorageList;
    private _fileSystem;
    get fileSystem(): DataAzurermWindowsWebAppLogsHttpLogsFileSystemList;
}
export declare class DataAzurermWindowsWebAppLogsHttpLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsHttpLogsOutputReference;
}
export interface DataAzurermWindowsWebAppLogs {
}
export declare function dataAzurermWindowsWebAppLogsToTerraform(struct?: DataAzurermWindowsWebAppLogs): any;
export declare class DataAzurermWindowsWebAppLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppLogs | undefined;
    set internalValue(value: DataAzurermWindowsWebAppLogs | undefined);
    private _applicationLogs;
    get applicationLogs(): DataAzurermWindowsWebAppLogsApplicationLogsList;
    get detailedErrorMessages(): cdktf.IResolvable;
    get failedRequestTracing(): cdktf.IResolvable;
    private _httpLogs;
    get httpLogs(): DataAzurermWindowsWebAppLogsHttpLogsList;
}
export declare class DataAzurermWindowsWebAppLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppLogsOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigApplicationStack {
}
export declare function dataAzurermWindowsWebAppSiteConfigApplicationStackToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigApplicationStack): any;
export declare class DataAzurermWindowsWebAppSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigApplicationStack | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigApplicationStack | undefined);
    get currentStack(): string;
    get dockerContainerName(): string;
    get dockerContainerRegistry(): string;
    get dockerContainerTag(): string;
    get dotnetVersion(): string;
    get javaContainer(): string;
    get javaContainerVersion(): string;
    get javaVersion(): string;
    get nodeVersion(): string;
    get phpVersion(): string;
    get pythonVersion(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigApplicationStackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigApplicationStackOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomAction | undefined);
    get executable(): string;
    get parameters(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingActionToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingAction | undefined);
    get actionType(): string;
    private _customAction;
    get customAction(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionCustomActionList;
    get minimumProcessExecutionTime(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequests | undefined);
    get count(): number;
    get interval(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined);
    get count(): number;
    get interval(): string;
    get path(): string;
    get timeTaken(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode | undefined);
    get count(): number;
    get interval(): string;
    get path(): string;
    get statusCodeRange(): string;
    get subStatus(): number;
    get win32Status(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSettingTrigger | undefined);
    get privateMemoryKb(): number;
    private _requests;
    get requests(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerRequestsList;
    private _slowRequest;
    get slowRequest(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestList;
    private _statusCode;
    get statusCode(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeList;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigAutoHealSetting {
}
export declare function dataAzurermWindowsWebAppSiteConfigAutoHealSettingToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigAutoHealSetting): any;
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigAutoHealSetting | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigAutoHealSetting | undefined);
    private _action;
    get action(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingActionList;
    private _trigger;
    get trigger(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingTriggerList;
}
export declare class DataAzurermWindowsWebAppSiteConfigAutoHealSettingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigAutoHealSettingOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigCors {
}
export declare function dataAzurermWindowsWebAppSiteConfigCorsToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigCors): any;
export declare class DataAzurermWindowsWebAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigCors | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigCors | undefined);
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermWindowsWebAppSiteConfigCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigCorsOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders {
}
export declare function dataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders): any;
export declare class DataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigIpRestriction {
}
export declare function dataAzurermWindowsWebAppSiteConfigIpRestrictionToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigIpRestriction): any;
export declare class DataAzurermWindowsWebAppSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigIpRestriction | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigIpRestriction | undefined);
    get action(): string;
    private _headers;
    get headers(): DataAzurermWindowsWebAppSiteConfigIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigIpRestrictionOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders {
}
export declare function dataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders): any;
export declare class DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigScmIpRestriction {
}
export declare function dataAzurermWindowsWebAppSiteConfigScmIpRestrictionToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigScmIpRestriction): any;
export declare class DataAzurermWindowsWebAppSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigScmIpRestriction | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigScmIpRestriction | undefined);
    get action(): string;
    private _headers;
    get headers(): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory {
}
export declare function dataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory): any;
export declare class DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectory | undefined);
    get physicalPath(): string;
    get virtualPath(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfigVirtualApplication {
}
export declare function dataAzurermWindowsWebAppSiteConfigVirtualApplicationToTerraform(struct?: DataAzurermWindowsWebAppSiteConfigVirtualApplication): any;
export declare class DataAzurermWindowsWebAppSiteConfigVirtualApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfigVirtualApplication | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfigVirtualApplication | undefined);
    get physicalPath(): string;
    get preload(): cdktf.IResolvable;
    private _virtualDirectory;
    get virtualDirectory(): DataAzurermWindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryList;
    get virtualPath(): string;
}
export declare class DataAzurermWindowsWebAppSiteConfigVirtualApplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigVirtualApplicationOutputReference;
}
export interface DataAzurermWindowsWebAppSiteConfig {
}
export declare function dataAzurermWindowsWebAppSiteConfigToTerraform(struct?: DataAzurermWindowsWebAppSiteConfig): any;
export declare class DataAzurermWindowsWebAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteConfig | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteConfig | undefined);
    get alwaysOn(): cdktf.IResolvable;
    get apiDefinitionUrl(): string;
    get apiManagementApiId(): string;
    get appCommandLine(): string;
    private _applicationStack;
    get applicationStack(): DataAzurermWindowsWebAppSiteConfigApplicationStackList;
    get autoHealEnabled(): cdktf.IResolvable;
    private _autoHealSetting;
    get autoHealSetting(): DataAzurermWindowsWebAppSiteConfigAutoHealSettingList;
    get containerRegistryManagedIdentityClientId(): string;
    get containerRegistryUseManagedIdentity(): cdktf.IResolvable;
    private _cors;
    get cors(): DataAzurermWindowsWebAppSiteConfigCorsList;
    get defaultDocuments(): string[];
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    get ftpsState(): string;
    get healthCheckEvictionTimeInMin(): number;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    private _ipRestriction;
    get ipRestriction(): DataAzurermWindowsWebAppSiteConfigIpRestrictionList;
    get loadBalancingMode(): string;
    get localMysqlEnabled(): cdktf.IResolvable;
    get managedPipelineMode(): string;
    get minimumTlsVersion(): string;
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    get remoteDebuggingVersion(): string;
    private _scmIpRestriction;
    get scmIpRestriction(): DataAzurermWindowsWebAppSiteConfigScmIpRestrictionList;
    get scmMinimumTlsVersion(): string;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorker(): cdktf.IResolvable;
    private _virtualApplication;
    get virtualApplication(): DataAzurermWindowsWebAppSiteConfigVirtualApplicationList;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
    get windowsFxVersion(): string;
    get workerCount(): number;
}
export declare class DataAzurermWindowsWebAppSiteConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteConfigOutputReference;
}
export interface DataAzurermWindowsWebAppSiteCredential {
}
export declare function dataAzurermWindowsWebAppSiteCredentialToTerraform(struct?: DataAzurermWindowsWebAppSiteCredential): any;
export declare class DataAzurermWindowsWebAppSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppSiteCredential | undefined;
    set internalValue(value: DataAzurermWindowsWebAppSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class DataAzurermWindowsWebAppSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppSiteCredentialOutputReference;
}
export interface DataAzurermWindowsWebAppStickySettings {
}
export declare function dataAzurermWindowsWebAppStickySettingsToTerraform(struct?: DataAzurermWindowsWebAppStickySettings): any;
export declare class DataAzurermWindowsWebAppStickySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppStickySettings | undefined;
    set internalValue(value: DataAzurermWindowsWebAppStickySettings | undefined);
    get appSettingNames(): string[];
    get connectionStringNames(): string[];
}
export declare class DataAzurermWindowsWebAppStickySettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppStickySettingsOutputReference;
}
export interface DataAzurermWindowsWebAppStorageAccount {
}
export declare function dataAzurermWindowsWebAppStorageAccountToTerraform(struct?: DataAzurermWindowsWebAppStorageAccount): any;
export declare class DataAzurermWindowsWebAppStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermWindowsWebAppStorageAccount | undefined;
    set internalValue(value: DataAzurermWindowsWebAppStorageAccount | undefined);
    get accessKey(): string;
    get accountName(): string;
    get mountPath(): string;
    get name(): string;
    get shareName(): string;
    get type(): string;
}
export declare class DataAzurermWindowsWebAppStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermWindowsWebAppStorageAccountOutputReference;
}
export interface DataAzurermWindowsWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/windows_web_app#read DataAzurermWindowsWebApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermWindowsWebAppTimeoutsToTerraform(struct?: DataAzurermWindowsWebAppTimeoutsOutputReference | DataAzurermWindowsWebAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermWindowsWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermWindowsWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermWindowsWebAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/windows_web_app azurerm_windows_web_app}
*/
export declare class DataAzurermWindowsWebApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_windows_web_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/windows_web_app azurerm_windows_web_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermWindowsWebAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermWindowsWebAppConfig);
    private _appSettings;
    get appSettings(): cdktf.StringMap;
    private _authSettings;
    get authSettings(): DataAzurermWindowsWebAppAuthSettingsList;
    private _backup;
    get backup(): DataAzurermWindowsWebAppBackupList;
    get clientAffinityEnabled(): cdktf.IResolvable;
    get clientCertificateEnabled(): cdktf.IResolvable;
    get clientCertificateMode(): string;
    private _connectionString;
    get connectionString(): DataAzurermWindowsWebAppConnectionStringList;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    get enabled(): cdktf.IResolvable;
    get httpsOnly(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermWindowsWebAppIdentityList;
    get kind(): string;
    get location(): string;
    private _logs;
    get logs(): DataAzurermWindowsWebAppLogsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get servicePlanId(): string;
    private _siteConfig;
    get siteConfig(): DataAzurermWindowsWebAppSiteConfigList;
    private _siteCredential;
    get siteCredential(): DataAzurermWindowsWebAppSiteCredentialList;
    private _stickySettings;
    get stickySettings(): DataAzurermWindowsWebAppStickySettingsList;
    private _storageAccount;
    get storageAccount(): DataAzurermWindowsWebAppStorageAccountList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermWindowsWebAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermWindowsWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermWindowsWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
