import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExpressRouteCircuitPeeringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#express_route_circuit_name ExpressRouteCircuitPeering#express_route_circuit_name}
    */
    readonly expressRouteCircuitName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#id ExpressRouteCircuitPeering#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#peer_asn ExpressRouteCircuitPeering#peer_asn}
    */
    readonly peerAsn?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#peering_type ExpressRouteCircuitPeering#peering_type}
    */
    readonly peeringType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#primary_peer_address_prefix ExpressRouteCircuitPeering#primary_peer_address_prefix}
    */
    readonly primaryPeerAddressPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#resource_group_name ExpressRouteCircuitPeering#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#route_filter_id ExpressRouteCircuitPeering#route_filter_id}
    */
    readonly routeFilterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#secondary_peer_address_prefix ExpressRouteCircuitPeering#secondary_peer_address_prefix}
    */
    readonly secondaryPeerAddressPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#shared_key ExpressRouteCircuitPeering#shared_key}
    */
    readonly sharedKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#vlan_id ExpressRouteCircuitPeering#vlan_id}
    */
    readonly vlanId: number;
    /**
    * ipv6 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#ipv6 ExpressRouteCircuitPeering#ipv6}
    */
    readonly ipv6?: ExpressRouteCircuitPeeringIpv6;
    /**
    * microsoft_peering_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#microsoft_peering_config ExpressRouteCircuitPeering#microsoft_peering_config}
    */
    readonly microsoftPeeringConfig?: ExpressRouteCircuitPeeringMicrosoftPeeringConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#timeouts ExpressRouteCircuitPeering#timeouts}
    */
    readonly timeouts?: ExpressRouteCircuitPeeringTimeouts;
}
export interface ExpressRouteCircuitPeeringIpv6MicrosoftPeering {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#advertised_public_prefixes ExpressRouteCircuitPeering#advertised_public_prefixes}
    */
    readonly advertisedPublicPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#customer_asn ExpressRouteCircuitPeering#customer_asn}
    */
    readonly customerAsn?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#routing_registry_name ExpressRouteCircuitPeering#routing_registry_name}
    */
    readonly routingRegistryName?: string;
}
export declare function expressRouteCircuitPeeringIpv6MicrosoftPeeringToTerraform(struct?: ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference | ExpressRouteCircuitPeeringIpv6MicrosoftPeering): any;
export declare class ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteCircuitPeeringIpv6MicrosoftPeering | undefined;
    set internalValue(value: ExpressRouteCircuitPeeringIpv6MicrosoftPeering | undefined);
    private _advertisedPublicPrefixes?;
    get advertisedPublicPrefixes(): string[];
    set advertisedPublicPrefixes(value: string[]);
    resetAdvertisedPublicPrefixes(): void;
    get advertisedPublicPrefixesInput(): string[] | undefined;
    private _customerAsn?;
    get customerAsn(): number;
    set customerAsn(value: number);
    resetCustomerAsn(): void;
    get customerAsnInput(): number | undefined;
    private _routingRegistryName?;
    get routingRegistryName(): string;
    set routingRegistryName(value: string);
    resetRoutingRegistryName(): void;
    get routingRegistryNameInput(): string | undefined;
}
export interface ExpressRouteCircuitPeeringIpv6 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#primary_peer_address_prefix ExpressRouteCircuitPeering#primary_peer_address_prefix}
    */
    readonly primaryPeerAddressPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#route_filter_id ExpressRouteCircuitPeering#route_filter_id}
    */
    readonly routeFilterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#secondary_peer_address_prefix ExpressRouteCircuitPeering#secondary_peer_address_prefix}
    */
    readonly secondaryPeerAddressPrefix: string;
    /**
    * microsoft_peering block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#microsoft_peering ExpressRouteCircuitPeering#microsoft_peering}
    */
    readonly microsoftPeering: ExpressRouteCircuitPeeringIpv6MicrosoftPeering;
}
export declare function expressRouteCircuitPeeringIpv6ToTerraform(struct?: ExpressRouteCircuitPeeringIpv6OutputReference | ExpressRouteCircuitPeeringIpv6): any;
export declare class ExpressRouteCircuitPeeringIpv6OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteCircuitPeeringIpv6 | undefined;
    set internalValue(value: ExpressRouteCircuitPeeringIpv6 | undefined);
    private _primaryPeerAddressPrefix?;
    get primaryPeerAddressPrefix(): string;
    set primaryPeerAddressPrefix(value: string);
    get primaryPeerAddressPrefixInput(): string | undefined;
    private _routeFilterId?;
    get routeFilterId(): string;
    set routeFilterId(value: string);
    resetRouteFilterId(): void;
    get routeFilterIdInput(): string | undefined;
    private _secondaryPeerAddressPrefix?;
    get secondaryPeerAddressPrefix(): string;
    set secondaryPeerAddressPrefix(value: string);
    get secondaryPeerAddressPrefixInput(): string | undefined;
    private _microsoftPeering;
    get microsoftPeering(): ExpressRouteCircuitPeeringIpv6MicrosoftPeeringOutputReference;
    putMicrosoftPeering(value: ExpressRouteCircuitPeeringIpv6MicrosoftPeering): void;
    get microsoftPeeringInput(): ExpressRouteCircuitPeeringIpv6MicrosoftPeering | undefined;
}
export interface ExpressRouteCircuitPeeringMicrosoftPeeringConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#advertised_public_prefixes ExpressRouteCircuitPeering#advertised_public_prefixes}
    */
    readonly advertisedPublicPrefixes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#customer_asn ExpressRouteCircuitPeering#customer_asn}
    */
    readonly customerAsn?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#routing_registry_name ExpressRouteCircuitPeering#routing_registry_name}
    */
    readonly routingRegistryName?: string;
}
export declare function expressRouteCircuitPeeringMicrosoftPeeringConfigToTerraform(struct?: ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference | ExpressRouteCircuitPeeringMicrosoftPeeringConfig): any;
export declare class ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteCircuitPeeringMicrosoftPeeringConfig | undefined;
    set internalValue(value: ExpressRouteCircuitPeeringMicrosoftPeeringConfig | undefined);
    private _advertisedPublicPrefixes?;
    get advertisedPublicPrefixes(): string[];
    set advertisedPublicPrefixes(value: string[]);
    get advertisedPublicPrefixesInput(): string[] | undefined;
    private _customerAsn?;
    get customerAsn(): number;
    set customerAsn(value: number);
    resetCustomerAsn(): void;
    get customerAsnInput(): number | undefined;
    private _routingRegistryName?;
    get routingRegistryName(): string;
    set routingRegistryName(value: string);
    resetRoutingRegistryName(): void;
    get routingRegistryNameInput(): string | undefined;
}
export interface ExpressRouteCircuitPeeringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#create ExpressRouteCircuitPeering#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#delete ExpressRouteCircuitPeering#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#read ExpressRouteCircuitPeering#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering#update ExpressRouteCircuitPeering#update}
    */
    readonly update?: string;
}
export declare function expressRouteCircuitPeeringTimeoutsToTerraform(struct?: ExpressRouteCircuitPeeringTimeoutsOutputReference | ExpressRouteCircuitPeeringTimeouts | cdktf.IResolvable): any;
export declare class ExpressRouteCircuitPeeringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExpressRouteCircuitPeeringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ExpressRouteCircuitPeeringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering azurerm_express_route_circuit_peering}
*/
export declare class ExpressRouteCircuitPeering extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_express_route_circuit_peering";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_circuit_peering azurerm_express_route_circuit_peering} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExpressRouteCircuitPeeringConfig
    */
    constructor(scope: Construct, id: string, config: ExpressRouteCircuitPeeringConfig);
    get azureAsn(): number;
    private _expressRouteCircuitName?;
    get expressRouteCircuitName(): string;
    set expressRouteCircuitName(value: string);
    get expressRouteCircuitNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _peerAsn?;
    get peerAsn(): number;
    set peerAsn(value: number);
    resetPeerAsn(): void;
    get peerAsnInput(): number | undefined;
    private _peeringType?;
    get peeringType(): string;
    set peeringType(value: string);
    get peeringTypeInput(): string | undefined;
    get primaryAzurePort(): string;
    private _primaryPeerAddressPrefix?;
    get primaryPeerAddressPrefix(): string;
    set primaryPeerAddressPrefix(value: string);
    get primaryPeerAddressPrefixInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _routeFilterId?;
    get routeFilterId(): string;
    set routeFilterId(value: string);
    resetRouteFilterId(): void;
    get routeFilterIdInput(): string | undefined;
    get secondaryAzurePort(): string;
    private _secondaryPeerAddressPrefix?;
    get secondaryPeerAddressPrefix(): string;
    set secondaryPeerAddressPrefix(value: string);
    get secondaryPeerAddressPrefixInput(): string | undefined;
    private _sharedKey?;
    get sharedKey(): string;
    set sharedKey(value: string);
    resetSharedKey(): void;
    get sharedKeyInput(): string | undefined;
    private _vlanId?;
    get vlanId(): number;
    set vlanId(value: number);
    get vlanIdInput(): number | undefined;
    private _ipv6;
    get ipv6(): ExpressRouteCircuitPeeringIpv6OutputReference;
    putIpv6(value: ExpressRouteCircuitPeeringIpv6): void;
    resetIpv6(): void;
    get ipv6Input(): ExpressRouteCircuitPeeringIpv6 | undefined;
    private _microsoftPeeringConfig;
    get microsoftPeeringConfig(): ExpressRouteCircuitPeeringMicrosoftPeeringConfigOutputReference;
    putMicrosoftPeeringConfig(value: ExpressRouteCircuitPeeringMicrosoftPeeringConfig): void;
    resetMicrosoftPeeringConfig(): void;
    get microsoftPeeringConfigInput(): ExpressRouteCircuitPeeringMicrosoftPeeringConfig | undefined;
    private _timeouts;
    get timeouts(): ExpressRouteCircuitPeeringTimeoutsOutputReference;
    putTimeouts(value: ExpressRouteCircuitPeeringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ExpressRouteCircuitPeeringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
