import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LbBackendAddressPoolAddressConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#backend_address_pool_id LbBackendAddressPoolAddress#backend_address_pool_id}
    */
    readonly backendAddressPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#id LbBackendAddressPoolAddress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#ip_address LbBackendAddressPoolAddress#ip_address}
    */
    readonly ipAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#name LbBackendAddressPoolAddress#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#virtual_network_id LbBackendAddressPoolAddress#virtual_network_id}
    */
    readonly virtualNetworkId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#timeouts LbBackendAddressPoolAddress#timeouts}
    */
    readonly timeouts?: LbBackendAddressPoolAddressTimeouts;
}
export interface LbBackendAddressPoolAddressInboundNatRulePortMapping {
}
export declare function lbBackendAddressPoolAddressInboundNatRulePortMappingToTerraform(struct?: LbBackendAddressPoolAddressInboundNatRulePortMapping): any;
export declare class LbBackendAddressPoolAddressInboundNatRulePortMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LbBackendAddressPoolAddressInboundNatRulePortMapping | undefined;
    set internalValue(value: LbBackendAddressPoolAddressInboundNatRulePortMapping | undefined);
    get backendPort(): number;
    get frontendPort(): number;
    get inboundNatRuleName(): string;
}
export declare class LbBackendAddressPoolAddressInboundNatRulePortMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LbBackendAddressPoolAddressInboundNatRulePortMappingOutputReference;
}
export interface LbBackendAddressPoolAddressTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#create LbBackendAddressPoolAddress#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#delete LbBackendAddressPoolAddress#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#read LbBackendAddressPoolAddress#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address#update LbBackendAddressPoolAddress#update}
    */
    readonly update?: string;
}
export declare function lbBackendAddressPoolAddressTimeoutsToTerraform(struct?: LbBackendAddressPoolAddressTimeoutsOutputReference | LbBackendAddressPoolAddressTimeouts | cdktf.IResolvable): any;
export declare class LbBackendAddressPoolAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LbBackendAddressPoolAddressTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LbBackendAddressPoolAddressTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address azurerm_lb_backend_address_pool_address}
*/
export declare class LbBackendAddressPoolAddress extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lb_backend_address_pool_address";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/lb_backend_address_pool_address azurerm_lb_backend_address_pool_address} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LbBackendAddressPoolAddressConfig
    */
    constructor(scope: Construct, id: string, config: LbBackendAddressPoolAddressConfig);
    private _backendAddressPoolId?;
    get backendAddressPoolId(): string;
    set backendAddressPoolId(value: string);
    get backendAddressPoolIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inboundNatRulePortMapping;
    get inboundNatRulePortMapping(): LbBackendAddressPoolAddressInboundNatRulePortMappingList;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): LbBackendAddressPoolAddressTimeoutsOutputReference;
    putTimeouts(value: LbBackendAddressPoolAddressTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LbBackendAddressPoolAddressTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
