import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaTransformConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#description MediaTransform#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#id MediaTransform#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#media_services_account_name MediaTransform#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#name MediaTransform#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#resource_group_name MediaTransform#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * output block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#output MediaTransform#output}
    */
    readonly output?: MediaTransformOutput[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#timeouts MediaTransform#timeouts}
    */
    readonly timeouts?: MediaTransformTimeouts;
}
export interface MediaTransformOutputAudioAnalyzerPreset {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_analysis_mode MediaTransform#audio_analysis_mode}
    */
    readonly audioAnalysisMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_language MediaTransform#audio_language}
    */
    readonly audioLanguage?: string;
}
export declare function mediaTransformOutputAudioAnalyzerPresetToTerraform(struct?: MediaTransformOutputAudioAnalyzerPresetOutputReference | MediaTransformOutputAudioAnalyzerPreset): any;
export declare class MediaTransformOutputAudioAnalyzerPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputAudioAnalyzerPreset | undefined;
    set internalValue(value: MediaTransformOutputAudioAnalyzerPreset | undefined);
    private _audioAnalysisMode?;
    get audioAnalysisMode(): string;
    set audioAnalysisMode(value: string);
    resetAudioAnalysisMode(): void;
    get audioAnalysisModeInput(): string | undefined;
    private _audioLanguage?;
    get audioLanguage(): string;
    set audioLanguage(value: string);
    resetAudioLanguage(): void;
    get audioLanguageInput(): string | undefined;
}
export interface MediaTransformOutputBuiltinPreset {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#preset_name MediaTransform#preset_name}
    */
    readonly presetName?: string;
}
export declare function mediaTransformOutputBuiltinPresetToTerraform(struct?: MediaTransformOutputBuiltinPresetOutputReference | MediaTransformOutputBuiltinPreset): any;
export declare class MediaTransformOutputBuiltinPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputBuiltinPreset | undefined;
    set internalValue(value: MediaTransformOutputBuiltinPreset | undefined);
    private _presetName?;
    get presetName(): string;
    set presetName(value: string);
    resetPresetName(): void;
    get presetNameInput(): string | undefined;
}
export interface MediaTransformOutputFaceDetectorPreset {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#analysis_resolution MediaTransform#analysis_resolution}
    */
    readonly analysisResolution?: string;
}
export declare function mediaTransformOutputFaceDetectorPresetToTerraform(struct?: MediaTransformOutputFaceDetectorPresetOutputReference | MediaTransformOutputFaceDetectorPreset): any;
export declare class MediaTransformOutputFaceDetectorPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputFaceDetectorPreset | undefined;
    set internalValue(value: MediaTransformOutputFaceDetectorPreset | undefined);
    private _analysisResolution?;
    get analysisResolution(): string;
    set analysisResolution(value: string);
    resetAnalysisResolution(): void;
    get analysisResolutionInput(): string | undefined;
}
export interface MediaTransformOutputVideoAnalyzerPreset {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_analysis_mode MediaTransform#audio_analysis_mode}
    */
    readonly audioAnalysisMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_language MediaTransform#audio_language}
    */
    readonly audioLanguage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#insights_type MediaTransform#insights_type}
    */
    readonly insightsType?: string;
}
export declare function mediaTransformOutputVideoAnalyzerPresetToTerraform(struct?: MediaTransformOutputVideoAnalyzerPresetOutputReference | MediaTransformOutputVideoAnalyzerPreset): any;
export declare class MediaTransformOutputVideoAnalyzerPresetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformOutputVideoAnalyzerPreset | undefined;
    set internalValue(value: MediaTransformOutputVideoAnalyzerPreset | undefined);
    private _audioAnalysisMode?;
    get audioAnalysisMode(): string;
    set audioAnalysisMode(value: string);
    resetAudioAnalysisMode(): void;
    get audioAnalysisModeInput(): string | undefined;
    private _audioLanguage?;
    get audioLanguage(): string;
    set audioLanguage(value: string);
    resetAudioLanguage(): void;
    get audioLanguageInput(): string | undefined;
    private _insightsType?;
    get insightsType(): string;
    set insightsType(value: string);
    resetInsightsType(): void;
    get insightsTypeInput(): string | undefined;
}
export interface MediaTransformOutput {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#on_error_action MediaTransform#on_error_action}
    */
    readonly onErrorAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#relative_priority MediaTransform#relative_priority}
    */
    readonly relativePriority?: string;
    /**
    * audio_analyzer_preset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#audio_analyzer_preset MediaTransform#audio_analyzer_preset}
    */
    readonly audioAnalyzerPreset?: MediaTransformOutputAudioAnalyzerPreset;
    /**
    * builtin_preset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#builtin_preset MediaTransform#builtin_preset}
    */
    readonly builtinPreset?: MediaTransformOutputBuiltinPreset;
    /**
    * face_detector_preset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#face_detector_preset MediaTransform#face_detector_preset}
    */
    readonly faceDetectorPreset?: MediaTransformOutputFaceDetectorPreset;
    /**
    * video_analyzer_preset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#video_analyzer_preset MediaTransform#video_analyzer_preset}
    */
    readonly videoAnalyzerPreset?: MediaTransformOutputVideoAnalyzerPreset;
}
export declare function mediaTransformOutputToTerraform(struct?: MediaTransformOutput | cdktf.IResolvable): any;
export declare class MediaTransformOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaTransformOutput | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformOutput | cdktf.IResolvable | undefined);
    private _onErrorAction?;
    get onErrorAction(): string;
    set onErrorAction(value: string);
    resetOnErrorAction(): void;
    get onErrorActionInput(): string | undefined;
    private _relativePriority?;
    get relativePriority(): string;
    set relativePriority(value: string);
    resetRelativePriority(): void;
    get relativePriorityInput(): string | undefined;
    private _audioAnalyzerPreset;
    get audioAnalyzerPreset(): MediaTransformOutputAudioAnalyzerPresetOutputReference;
    putAudioAnalyzerPreset(value: MediaTransformOutputAudioAnalyzerPreset): void;
    resetAudioAnalyzerPreset(): void;
    get audioAnalyzerPresetInput(): MediaTransformOutputAudioAnalyzerPreset | undefined;
    private _builtinPreset;
    get builtinPreset(): MediaTransformOutputBuiltinPresetOutputReference;
    putBuiltinPreset(value: MediaTransformOutputBuiltinPreset): void;
    resetBuiltinPreset(): void;
    get builtinPresetInput(): MediaTransformOutputBuiltinPreset | undefined;
    private _faceDetectorPreset;
    get faceDetectorPreset(): MediaTransformOutputFaceDetectorPresetOutputReference;
    putFaceDetectorPreset(value: MediaTransformOutputFaceDetectorPreset): void;
    resetFaceDetectorPreset(): void;
    get faceDetectorPresetInput(): MediaTransformOutputFaceDetectorPreset | undefined;
    private _videoAnalyzerPreset;
    get videoAnalyzerPreset(): MediaTransformOutputVideoAnalyzerPresetOutputReference;
    putVideoAnalyzerPreset(value: MediaTransformOutputVideoAnalyzerPreset): void;
    resetVideoAnalyzerPreset(): void;
    get videoAnalyzerPresetInput(): MediaTransformOutputVideoAnalyzerPreset | undefined;
}
export declare class MediaTransformOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaTransformOutput[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaTransformOutputOutputReference;
}
export interface MediaTransformTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#create MediaTransform#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#delete MediaTransform#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#read MediaTransform#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform#update MediaTransform#update}
    */
    readonly update?: string;
}
export declare function mediaTransformTimeoutsToTerraform(struct?: MediaTransformTimeoutsOutputReference | MediaTransformTimeouts | cdktf.IResolvable): any;
export declare class MediaTransformTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaTransformTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaTransformTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform azurerm_media_transform}
*/
export declare class MediaTransform extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_transform";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_transform azurerm_media_transform} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaTransformConfig
    */
    constructor(scope: Construct, id: string, config: MediaTransformConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _output;
    get output(): MediaTransformOutputList;
    putOutput(value: MediaTransformOutput[] | cdktf.IResolvable): void;
    resetOutput(): void;
    get outputInput(): cdktf.IResolvable | MediaTransformOutput[] | undefined;
    private _timeouts;
    get timeouts(): MediaTransformTimeoutsOutputReference;
    putTimeouts(value: MediaTransformTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaTransformTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
