"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServicebusQueue = exports.ServicebusQueueTimeoutsOutputReference = exports.servicebusQueueTimeoutsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function servicebusQueueTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.servicebusQueueTimeoutsToTerraform = servicebusQueueTimeoutsToTerraform;
class ServicebusQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.ServicebusQueueTimeoutsOutputReference = ServicebusQueueTimeoutsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ServicebusQueueTimeoutsOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.ServicebusQueueTimeoutsOutputReference", version: "0.8.13" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue azurerm_servicebus_queue}
*/
class ServicebusQueue extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_queue azurerm_servicebus_queue} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicebusQueueConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_servicebus_queue',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.10'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new ServicebusQueueTimeoutsOutputReference(this, "timeouts");
        this._autoDeleteOnIdle = config.autoDeleteOnIdle;
        this._deadLetteringOnMessageExpiration = config.deadLetteringOnMessageExpiration;
        this._defaultMessageTtl = config.defaultMessageTtl;
        this._duplicateDetectionHistoryTimeWindow = config.duplicateDetectionHistoryTimeWindow;
        this._enableBatchedOperations = config.enableBatchedOperations;
        this._enableExpress = config.enableExpress;
        this._enablePartitioning = config.enablePartitioning;
        this._forwardDeadLetteredMessagesTo = config.forwardDeadLetteredMessagesTo;
        this._forwardTo = config.forwardTo;
        this._id = config.id;
        this._lockDuration = config.lockDuration;
        this._maxDeliveryCount = config.maxDeliveryCount;
        this._maxMessageSizeInKilobytes = config.maxMessageSizeInKilobytes;
        this._maxSizeInMegabytes = config.maxSizeInMegabytes;
        this._name = config.name;
        this._namespaceId = config.namespaceId;
        this._requiresDuplicateDetection = config.requiresDuplicateDetection;
        this._requiresSession = config.requiresSession;
        this._status = config.status;
        this._timeouts.internalValue = config.timeouts;
    }
    get autoDeleteOnIdle() {
        return this.getStringAttribute('auto_delete_on_idle');
    }
    set autoDeleteOnIdle(value) {
        this._autoDeleteOnIdle = value;
    }
    resetAutoDeleteOnIdle() {
        this._autoDeleteOnIdle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoDeleteOnIdleInput() {
        return this._autoDeleteOnIdle;
    }
    get deadLetteringOnMessageExpiration() {
        return this.getBooleanAttribute('dead_lettering_on_message_expiration');
    }
    set deadLetteringOnMessageExpiration(value) {
        this._deadLetteringOnMessageExpiration = value;
    }
    resetDeadLetteringOnMessageExpiration() {
        this._deadLetteringOnMessageExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadLetteringOnMessageExpirationInput() {
        return this._deadLetteringOnMessageExpiration;
    }
    get defaultMessageTtl() {
        return this.getStringAttribute('default_message_ttl');
    }
    set defaultMessageTtl(value) {
        this._defaultMessageTtl = value;
    }
    resetDefaultMessageTtl() {
        this._defaultMessageTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultMessageTtlInput() {
        return this._defaultMessageTtl;
    }
    get duplicateDetectionHistoryTimeWindow() {
        return this.getStringAttribute('duplicate_detection_history_time_window');
    }
    set duplicateDetectionHistoryTimeWindow(value) {
        this._duplicateDetectionHistoryTimeWindow = value;
    }
    resetDuplicateDetectionHistoryTimeWindow() {
        this._duplicateDetectionHistoryTimeWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get duplicateDetectionHistoryTimeWindowInput() {
        return this._duplicateDetectionHistoryTimeWindow;
    }
    get enableBatchedOperations() {
        return this.getBooleanAttribute('enable_batched_operations');
    }
    set enableBatchedOperations(value) {
        this._enableBatchedOperations = value;
    }
    resetEnableBatchedOperations() {
        this._enableBatchedOperations = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableBatchedOperationsInput() {
        return this._enableBatchedOperations;
    }
    get enableExpress() {
        return this.getBooleanAttribute('enable_express');
    }
    set enableExpress(value) {
        this._enableExpress = value;
    }
    resetEnableExpress() {
        this._enableExpress = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableExpressInput() {
        return this._enableExpress;
    }
    get enablePartitioning() {
        return this.getBooleanAttribute('enable_partitioning');
    }
    set enablePartitioning(value) {
        this._enablePartitioning = value;
    }
    resetEnablePartitioning() {
        this._enablePartitioning = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enablePartitioningInput() {
        return this._enablePartitioning;
    }
    get forwardDeadLetteredMessagesTo() {
        return this.getStringAttribute('forward_dead_lettered_messages_to');
    }
    set forwardDeadLetteredMessagesTo(value) {
        this._forwardDeadLetteredMessagesTo = value;
    }
    resetForwardDeadLetteredMessagesTo() {
        this._forwardDeadLetteredMessagesTo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forwardDeadLetteredMessagesToInput() {
        return this._forwardDeadLetteredMessagesTo;
    }
    get forwardTo() {
        return this.getStringAttribute('forward_to');
    }
    set forwardTo(value) {
        this._forwardTo = value;
    }
    resetForwardTo() {
        this._forwardTo = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forwardToInput() {
        return this._forwardTo;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get lockDuration() {
        return this.getStringAttribute('lock_duration');
    }
    set lockDuration(value) {
        this._lockDuration = value;
    }
    resetLockDuration() {
        this._lockDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lockDurationInput() {
        return this._lockDuration;
    }
    get maxDeliveryCount() {
        return this.getNumberAttribute('max_delivery_count');
    }
    set maxDeliveryCount(value) {
        this._maxDeliveryCount = value;
    }
    resetMaxDeliveryCount() {
        this._maxDeliveryCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxDeliveryCountInput() {
        return this._maxDeliveryCount;
    }
    get maxMessageSizeInKilobytes() {
        return this.getNumberAttribute('max_message_size_in_kilobytes');
    }
    set maxMessageSizeInKilobytes(value) {
        this._maxMessageSizeInKilobytes = value;
    }
    resetMaxMessageSizeInKilobytes() {
        this._maxMessageSizeInKilobytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxMessageSizeInKilobytesInput() {
        return this._maxMessageSizeInKilobytes;
    }
    get maxSizeInMegabytes() {
        return this.getNumberAttribute('max_size_in_megabytes');
    }
    set maxSizeInMegabytes(value) {
        this._maxSizeInMegabytes = value;
    }
    resetMaxSizeInMegabytes() {
        this._maxSizeInMegabytes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxSizeInMegabytesInput() {
        return this._maxSizeInMegabytes;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespaceId() {
        return this.getStringAttribute('namespace_id');
    }
    set namespaceId(value) {
        this._namespaceId = value;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceIdInput() {
        return this._namespaceId;
    }
    get requiresDuplicateDetection() {
        return this.getBooleanAttribute('requires_duplicate_detection');
    }
    set requiresDuplicateDetection(value) {
        this._requiresDuplicateDetection = value;
    }
    resetRequiresDuplicateDetection() {
        this._requiresDuplicateDetection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requiresDuplicateDetectionInput() {
        return this._requiresDuplicateDetection;
    }
    get requiresSession() {
        return this.getBooleanAttribute('requires_session');
    }
    set requiresSession(value) {
        this._requiresSession = value;
    }
    resetRequiresSession() {
        this._requiresSession = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requiresSessionInput() {
        return this._requiresSession;
    }
    get status() {
        return this.getStringAttribute('status');
    }
    set status(value) {
        this._status = value;
    }
    resetStatus() {
        this._status = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get statusInput() {
        return this._status;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_delete_on_idle: cdktf.stringToTerraform(this._autoDeleteOnIdle),
            dead_lettering_on_message_expiration: cdktf.booleanToTerraform(this._deadLetteringOnMessageExpiration),
            default_message_ttl: cdktf.stringToTerraform(this._defaultMessageTtl),
            duplicate_detection_history_time_window: cdktf.stringToTerraform(this._duplicateDetectionHistoryTimeWindow),
            enable_batched_operations: cdktf.booleanToTerraform(this._enableBatchedOperations),
            enable_express: cdktf.booleanToTerraform(this._enableExpress),
            enable_partitioning: cdktf.booleanToTerraform(this._enablePartitioning),
            forward_dead_lettered_messages_to: cdktf.stringToTerraform(this._forwardDeadLetteredMessagesTo),
            forward_to: cdktf.stringToTerraform(this._forwardTo),
            id: cdktf.stringToTerraform(this._id),
            lock_duration: cdktf.stringToTerraform(this._lockDuration),
            max_delivery_count: cdktf.numberToTerraform(this._maxDeliveryCount),
            max_message_size_in_kilobytes: cdktf.numberToTerraform(this._maxMessageSizeInKilobytes),
            max_size_in_megabytes: cdktf.numberToTerraform(this._maxSizeInMegabytes),
            name: cdktf.stringToTerraform(this._name),
            namespace_id: cdktf.stringToTerraform(this._namespaceId),
            requires_duplicate_detection: cdktf.booleanToTerraform(this._requiresDuplicateDetection),
            requires_session: cdktf.booleanToTerraform(this._requiresSession),
            status: cdktf.stringToTerraform(this._status),
            timeouts: servicebusQueueTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.ServicebusQueue = ServicebusQueue;
_b = JSII_RTTI_SYMBOL_1;
ServicebusQueue[_b] = { fqn: "@cdktf/provider-azurerm.ServicebusQueue", version: "0.8.13" };
// =================
// STATIC PROPERTIES
// =================
ServicebusQueue.tfResourceType = "azurerm_servicebus_queue";
//# sourceMappingURL=data:application/json;base64,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