import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#access_tier StorageShare#access_tier}
    */
    readonly accessTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#enabled_protocol StorageShare#enabled_protocol}
    */
    readonly enabledProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#id StorageShare#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#metadata StorageShare#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#name StorageShare#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#quota StorageShare#quota}
    */
    readonly quota: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#storage_account_name StorageShare#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * acl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#acl StorageShare#acl}
    */
    readonly acl?: StorageShareAcl[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#timeouts StorageShare#timeouts}
    */
    readonly timeouts?: StorageShareTimeouts;
}
export interface StorageShareAclAccessPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#expiry StorageShare#expiry}
    */
    readonly expiry?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#permissions StorageShare#permissions}
    */
    readonly permissions: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#start StorageShare#start}
    */
    readonly start?: string;
}
export declare function storageShareAclAccessPolicyToTerraform(struct?: StorageShareAclAccessPolicy | cdktf.IResolvable): any;
export declare class StorageShareAclAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageShareAclAccessPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: StorageShareAclAccessPolicy | cdktf.IResolvable | undefined);
    private _expiry?;
    get expiry(): string;
    set expiry(value: string);
    resetExpiry(): void;
    get expiryInput(): string | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    get permissionsInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    resetStart(): void;
    get startInput(): string | undefined;
}
export declare class StorageShareAclAccessPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageShareAclAccessPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageShareAclAccessPolicyOutputReference;
}
export interface StorageShareAcl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#id StorageShare#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
    /**
    * access_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#access_policy StorageShare#access_policy}
    */
    readonly accessPolicy?: StorageShareAclAccessPolicy[] | cdktf.IResolvable;
}
export declare function storageShareAclToTerraform(struct?: StorageShareAcl | cdktf.IResolvable): any;
export declare class StorageShareAclOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageShareAcl | cdktf.IResolvable | undefined;
    set internalValue(value: StorageShareAcl | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _accessPolicy;
    get accessPolicy(): StorageShareAclAccessPolicyList;
    putAccessPolicy(value: StorageShareAclAccessPolicy[] | cdktf.IResolvable): void;
    resetAccessPolicy(): void;
    get accessPolicyInput(): cdktf.IResolvable | StorageShareAclAccessPolicy[] | undefined;
}
export declare class StorageShareAclList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageShareAcl[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageShareAclOutputReference;
}
export interface StorageShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#create StorageShare#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#delete StorageShare#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#read StorageShare#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share#update StorageShare#update}
    */
    readonly update?: string;
}
export declare function storageShareTimeoutsToTerraform(struct?: StorageShareTimeoutsOutputReference | StorageShareTimeouts | cdktf.IResolvable): any;
export declare class StorageShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageShareTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageShareTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share azurerm_storage_share}
*/
export declare class StorageShare extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_share";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_share azurerm_storage_share} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageShareConfig
    */
    constructor(scope: Construct, id: string, config: StorageShareConfig);
    private _accessTier?;
    get accessTier(): string;
    set accessTier(value: string);
    resetAccessTier(): void;
    get accessTierInput(): string | undefined;
    private _enabledProtocol?;
    get enabledProtocol(): string;
    set enabledProtocol(value: string);
    resetEnabledProtocol(): void;
    get enabledProtocolInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _quota?;
    get quota(): number;
    set quota(value: number);
    get quotaInput(): number | undefined;
    get resourceManagerId(): string;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    get url(): string;
    private _acl;
    get acl(): StorageShareAclList;
    putAcl(value: StorageShareAcl[] | cdktf.IResolvable): void;
    resetAcl(): void;
    get aclInput(): cdktf.IResolvable | StorageShareAcl[] | undefined;
    private _timeouts;
    get timeouts(): StorageShareTimeoutsOutputReference;
    putTimeouts(value: StorageShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
