import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebApplicationFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#id WebApplicationFirewallPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#location WebApplicationFirewallPolicy#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#name WebApplicationFirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#resource_group_name WebApplicationFirewallPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#tags WebApplicationFirewallPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * custom_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#custom_rules WebApplicationFirewallPolicy#custom_rules}
    */
    readonly customRules?: WebApplicationFirewallPolicyCustomRules[] | cdktf.IResolvable;
    /**
    * managed_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#managed_rules WebApplicationFirewallPolicy#managed_rules}
    */
    readonly managedRules: WebApplicationFirewallPolicyManagedRules;
    /**
    * policy_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#policy_settings WebApplicationFirewallPolicy#policy_settings}
    */
    readonly policySettings?: WebApplicationFirewallPolicyPolicySettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#timeouts WebApplicationFirewallPolicy#timeouts}
    */
    readonly timeouts?: WebApplicationFirewallPolicyTimeouts;
}
export interface WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#selector WebApplicationFirewallPolicy#selector}
    */
    readonly selector?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#variable_name WebApplicationFirewallPolicy#variable_name}
    */
    readonly variableName: string;
}
export declare function webApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariablesToTerraform(struct?: WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables | cdktf.IResolvable): any;
export declare class WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariablesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables | cdktf.IResolvable | undefined;
    set internalValue(value: WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables | cdktf.IResolvable | undefined);
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
    private _variableName?;
    get variableName(): string;
    set variableName(value: string);
    get variableNameInput(): string | undefined;
}
export declare class WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariablesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariablesOutputReference;
}
export interface WebApplicationFirewallPolicyCustomRulesMatchConditions {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#match_values WebApplicationFirewallPolicy#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#negation_condition WebApplicationFirewallPolicy#negation_condition}
    */
    readonly negationCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#operator WebApplicationFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#transforms WebApplicationFirewallPolicy#transforms}
    */
    readonly transforms?: string[];
    /**
    * match_variables block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#match_variables WebApplicationFirewallPolicy#match_variables}
    */
    readonly matchVariables: WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables[] | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyCustomRulesMatchConditionsToTerraform(struct?: WebApplicationFirewallPolicyCustomRulesMatchConditions | cdktf.IResolvable): any;
export declare class WebApplicationFirewallPolicyCustomRulesMatchConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebApplicationFirewallPolicyCustomRulesMatchConditions | cdktf.IResolvable | undefined;
    set internalValue(value: WebApplicationFirewallPolicyCustomRulesMatchConditions | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _negationCondition?;
    get negationCondition(): boolean | cdktf.IResolvable;
    set negationCondition(value: boolean | cdktf.IResolvable);
    resetNegationCondition(): void;
    get negationConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
    private _matchVariables;
    get matchVariables(): WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariablesList;
    putMatchVariables(value: WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables[] | cdktf.IResolvable): void;
    get matchVariablesInput(): cdktf.IResolvable | WebApplicationFirewallPolicyCustomRulesMatchConditionsMatchVariables[] | undefined;
}
export declare class WebApplicationFirewallPolicyCustomRulesMatchConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebApplicationFirewallPolicyCustomRulesMatchConditions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebApplicationFirewallPolicyCustomRulesMatchConditionsOutputReference;
}
export interface WebApplicationFirewallPolicyCustomRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#action WebApplicationFirewallPolicy#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#name WebApplicationFirewallPolicy#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#priority WebApplicationFirewallPolicy#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#rule_type WebApplicationFirewallPolicy#rule_type}
    */
    readonly ruleType: string;
    /**
    * match_conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#match_conditions WebApplicationFirewallPolicy#match_conditions}
    */
    readonly matchConditions: WebApplicationFirewallPolicyCustomRulesMatchConditions[] | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyCustomRulesToTerraform(struct?: WebApplicationFirewallPolicyCustomRules | cdktf.IResolvable): any;
export declare class WebApplicationFirewallPolicyCustomRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebApplicationFirewallPolicyCustomRules | cdktf.IResolvable | undefined;
    set internalValue(value: WebApplicationFirewallPolicyCustomRules | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _ruleType?;
    get ruleType(): string;
    set ruleType(value: string);
    get ruleTypeInput(): string | undefined;
    private _matchConditions;
    get matchConditions(): WebApplicationFirewallPolicyCustomRulesMatchConditionsList;
    putMatchConditions(value: WebApplicationFirewallPolicyCustomRulesMatchConditions[] | cdktf.IResolvable): void;
    get matchConditionsInput(): cdktf.IResolvable | WebApplicationFirewallPolicyCustomRulesMatchConditions[] | undefined;
}
export declare class WebApplicationFirewallPolicyCustomRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebApplicationFirewallPolicyCustomRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebApplicationFirewallPolicyCustomRulesOutputReference;
}
export interface WebApplicationFirewallPolicyManagedRulesExclusion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#match_variable WebApplicationFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#selector WebApplicationFirewallPolicy#selector}
    */
    readonly selector: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#selector_match_operator WebApplicationFirewallPolicy#selector_match_operator}
    */
    readonly selectorMatchOperator: string;
}
export declare function webApplicationFirewallPolicyManagedRulesExclusionToTerraform(struct?: WebApplicationFirewallPolicyManagedRulesExclusion | cdktf.IResolvable): any;
export declare class WebApplicationFirewallPolicyManagedRulesExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebApplicationFirewallPolicyManagedRulesExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: WebApplicationFirewallPolicyManagedRulesExclusion | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
    private _selectorMatchOperator?;
    get selectorMatchOperator(): string;
    set selectorMatchOperator(value: string);
    get selectorMatchOperatorInput(): string | undefined;
}
export declare class WebApplicationFirewallPolicyManagedRulesExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebApplicationFirewallPolicyManagedRulesExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebApplicationFirewallPolicyManagedRulesExclusionOutputReference;
}
export interface WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#disabled_rules WebApplicationFirewallPolicy#disabled_rules}
    */
    readonly disabledRules?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#rule_group_name WebApplicationFirewallPolicy#rule_group_name}
    */
    readonly ruleGroupName: string;
}
export declare function webApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverrideToTerraform(struct?: WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride | cdktf.IResolvable): any;
export declare class WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride | cdktf.IResolvable | undefined;
    set internalValue(value: WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride | cdktf.IResolvable | undefined);
    private _disabledRules?;
    get disabledRules(): string[];
    set disabledRules(value: string[]);
    resetDisabledRules(): void;
    get disabledRulesInput(): string[] | undefined;
    private _ruleGroupName?;
    get ruleGroupName(): string;
    set ruleGroupName(value: string);
    get ruleGroupNameInput(): string | undefined;
}
export declare class WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverrideList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverrideOutputReference;
}
export interface WebApplicationFirewallPolicyManagedRulesManagedRuleSet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#type WebApplicationFirewallPolicy#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#version WebApplicationFirewallPolicy#version}
    */
    readonly version: string;
    /**
    * rule_group_override block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#rule_group_override WebApplicationFirewallPolicy#rule_group_override}
    */
    readonly ruleGroupOverride?: WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride[] | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyManagedRulesManagedRuleSetToTerraform(struct?: WebApplicationFirewallPolicyManagedRulesManagedRuleSet | cdktf.IResolvable): any;
export declare class WebApplicationFirewallPolicyManagedRulesManagedRuleSetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebApplicationFirewallPolicyManagedRulesManagedRuleSet | cdktf.IResolvable | undefined;
    set internalValue(value: WebApplicationFirewallPolicyManagedRulesManagedRuleSet | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _ruleGroupOverride;
    get ruleGroupOverride(): WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverrideList;
    putRuleGroupOverride(value: WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride[] | cdktf.IResolvable): void;
    resetRuleGroupOverride(): void;
    get ruleGroupOverrideInput(): cdktf.IResolvable | WebApplicationFirewallPolicyManagedRulesManagedRuleSetRuleGroupOverride[] | undefined;
}
export declare class WebApplicationFirewallPolicyManagedRulesManagedRuleSetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebApplicationFirewallPolicyManagedRulesManagedRuleSet[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebApplicationFirewallPolicyManagedRulesManagedRuleSetOutputReference;
}
export interface WebApplicationFirewallPolicyManagedRules {
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#exclusion WebApplicationFirewallPolicy#exclusion}
    */
    readonly exclusion?: WebApplicationFirewallPolicyManagedRulesExclusion[] | cdktf.IResolvable;
    /**
    * managed_rule_set block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#managed_rule_set WebApplicationFirewallPolicy#managed_rule_set}
    */
    readonly managedRuleSet: WebApplicationFirewallPolicyManagedRulesManagedRuleSet[] | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyManagedRulesToTerraform(struct?: WebApplicationFirewallPolicyManagedRulesOutputReference | WebApplicationFirewallPolicyManagedRules): any;
export declare class WebApplicationFirewallPolicyManagedRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebApplicationFirewallPolicyManagedRules | undefined;
    set internalValue(value: WebApplicationFirewallPolicyManagedRules | undefined);
    private _exclusion;
    get exclusion(): WebApplicationFirewallPolicyManagedRulesExclusionList;
    putExclusion(value: WebApplicationFirewallPolicyManagedRulesExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | WebApplicationFirewallPolicyManagedRulesExclusion[] | undefined;
    private _managedRuleSet;
    get managedRuleSet(): WebApplicationFirewallPolicyManagedRulesManagedRuleSetList;
    putManagedRuleSet(value: WebApplicationFirewallPolicyManagedRulesManagedRuleSet[] | cdktf.IResolvable): void;
    get managedRuleSetInput(): cdktf.IResolvable | WebApplicationFirewallPolicyManagedRulesManagedRuleSet[] | undefined;
}
export interface WebApplicationFirewallPolicyPolicySettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#enabled WebApplicationFirewallPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#file_upload_limit_in_mb WebApplicationFirewallPolicy#file_upload_limit_in_mb}
    */
    readonly fileUploadLimitInMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#max_request_body_size_in_kb WebApplicationFirewallPolicy#max_request_body_size_in_kb}
    */
    readonly maxRequestBodySizeInKb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#mode WebApplicationFirewallPolicy#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#request_body_check WebApplicationFirewallPolicy#request_body_check}
    */
    readonly requestBodyCheck?: boolean | cdktf.IResolvable;
}
export declare function webApplicationFirewallPolicyPolicySettingsToTerraform(struct?: WebApplicationFirewallPolicyPolicySettingsOutputReference | WebApplicationFirewallPolicyPolicySettings): any;
export declare class WebApplicationFirewallPolicyPolicySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebApplicationFirewallPolicyPolicySettings | undefined;
    set internalValue(value: WebApplicationFirewallPolicyPolicySettings | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _fileUploadLimitInMb?;
    get fileUploadLimitInMb(): number;
    set fileUploadLimitInMb(value: number);
    resetFileUploadLimitInMb(): void;
    get fileUploadLimitInMbInput(): number | undefined;
    private _maxRequestBodySizeInKb?;
    get maxRequestBodySizeInKb(): number;
    set maxRequestBodySizeInKb(value: number);
    resetMaxRequestBodySizeInKb(): void;
    get maxRequestBodySizeInKbInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _requestBodyCheck?;
    get requestBodyCheck(): boolean | cdktf.IResolvable;
    set requestBodyCheck(value: boolean | cdktf.IResolvable);
    resetRequestBodyCheck(): void;
    get requestBodyCheckInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WebApplicationFirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#create WebApplicationFirewallPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#delete WebApplicationFirewallPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#read WebApplicationFirewallPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy#update WebApplicationFirewallPolicy#update}
    */
    readonly update?: string;
}
export declare function webApplicationFirewallPolicyTimeoutsToTerraform(struct?: WebApplicationFirewallPolicyTimeoutsOutputReference | WebApplicationFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class WebApplicationFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebApplicationFirewallPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WebApplicationFirewallPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy azurerm_web_application_firewall_policy}
*/
export declare class WebApplicationFirewallPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_web_application_firewall_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/web_application_firewall_policy azurerm_web_application_firewall_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebApplicationFirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: WebApplicationFirewallPolicyConfig);
    get httpListenerIds(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pathBasedRuleIds(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _customRules;
    get customRules(): WebApplicationFirewallPolicyCustomRulesList;
    putCustomRules(value: WebApplicationFirewallPolicyCustomRules[] | cdktf.IResolvable): void;
    resetCustomRules(): void;
    get customRulesInput(): cdktf.IResolvable | WebApplicationFirewallPolicyCustomRules[] | undefined;
    private _managedRules;
    get managedRules(): WebApplicationFirewallPolicyManagedRulesOutputReference;
    putManagedRules(value: WebApplicationFirewallPolicyManagedRules): void;
    get managedRulesInput(): WebApplicationFirewallPolicyManagedRules | undefined;
    private _policySettings;
    get policySettings(): WebApplicationFirewallPolicyPolicySettingsOutputReference;
    putPolicySettings(value: WebApplicationFirewallPolicyPolicySettings): void;
    resetPolicySettings(): void;
    get policySettingsInput(): WebApplicationFirewallPolicyPolicySettings | undefined;
    private _timeouts;
    get timeouts(): WebApplicationFirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: WebApplicationFirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WebApplicationFirewallPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
