# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .email_id import EmailId
from .mpesa_transaction_type import MpesaTransactionType
from .tag import Tag

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MpesaDetails(pydantic.BaseModel):
    """
    Model for Mpesa payment method
    """

    business_short_code: str = pydantic.Field(alias="businessShortCode", description="Business code")
    transaction_type: MpesaTransactionType = pydantic.Field(alias="transactionType")
    phone_number: str = pydantic.Field(alias="phoneNumber", description="Contact Number of the account holder")
    email_id: typing.Optional[EmailId] = pydantic.Field(alias="emailId")
    tags: typing.Optional[typing.List[Tag]] = pydantic.Field(
        description="Additional information that can be added via tags"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
