# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class TransactionType(str, enum.Enum):
    DEPOSIT = "DEPOSIT"
    TRANSFER = "TRANSFER"
    EXTERNAL_PAYMENT = "EXTERNAL_PAYMENT"
    WITHDRAWAL = "WITHDRAWAL"
    REFUND = "REFUND"
    OTHER = "OTHER"

    def visit(
        self,
        deposit: typing.Callable[[], T_Result],
        transfer: typing.Callable[[], T_Result],
        external_payment: typing.Callable[[], T_Result],
        withdrawal: typing.Callable[[], T_Result],
        refund: typing.Callable[[], T_Result],
        other: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is TransactionType.DEPOSIT:
            return deposit()
        if self is TransactionType.TRANSFER:
            return transfer()
        if self is TransactionType.EXTERNAL_PAYMENT:
            return external_payment()
        if self is TransactionType.WITHDRAWAL:
            return withdrawal()
        if self is TransactionType.REFUND:
            return refund()
        if self is TransactionType.OTHER:
            return other()
