# Engineering Log (Devlog)

Daily or per-feature development logs capturing implementation progress, reasoning, and context.

## Format

Use the template: [YYYY-MM-DD-template.md](./YYYY-MM-DD-template.md)

## When to Write

Write devlog entries:
- At the start of a new feature or significant task
- At the end of each day (or after key milestones)
- When making important implementation decisions
- When encountering surprises or blockers

## What to Capture

**Focus on:**
- What you're working on and why
- Decisions made during implementation
- Surprises or learnings
- Blockers or challenges
- Next steps

**Don't capture:**
- Simple bug fixes (commit message is enough)
- Routine tasks with no decision-making
- Meeting notes (unless they led to technical decisions)

## Tips

- Write as you work, not at end of day (context is fresh)
- Link to related ADRs, PRs, and issues
- Be honest about mistakes and dead-ends (helps others)
- Use diagrams or code snippets when helpful
