# Lessons Learned

Retrospectives, insights, and post-mortems capturing wisdom gained from experience.

## Format

Use the template: [YYYY-MM-DD-template.md](./YYYY-MM-DD-template.md)

## When to Write

Write lessons:
- After completing major features or projects
- After resolving complex problems
- After incidents or post-mortems
- During regular retrospectives

## What to Capture

- **What happened** - The situation or problem
- **What we learned** - Key insight or pattern
- **What we'll do differently** - Changed behavior or process

## Be Honest

Lessons are most valuable when honest about:
- What went wrong and why
- Assumptions that proved incorrect
- Processes that didn't work
- Skills or knowledge gaps discovered

This isn't about blame—it's about learning.

## Review Periodically

Lessons become patterns:
- Review lessons quarterly
- Look for repeated themes
- Consider promoting patterns to ADRs
- Update team practices based on lessons
