import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PostgresqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#charset PostgresqlDatabase#charset}.
     *
     * @stability stable
     */
    readonly charset: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#collation PostgresqlDatabase#collation}.
     *
     * @stability stable
     */
    readonly collation: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#name PostgresqlDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#resource_group_name PostgresqlDatabase#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#server_name PostgresqlDatabase#server_name}.
     *
     * @stability stable
     */
    readonly serverName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#timeouts PostgresqlDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PostgresqlDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface PostgresqlDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#create PostgresqlDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#delete PostgresqlDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#read PostgresqlDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html#update PostgresqlDatabase#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function postgresqlDatabaseTimeoutsToTerraform(struct?: PostgresqlDatabaseTimeoutsOutputReference | PostgresqlDatabaseTimeouts): any;
/**
 * @stability stable
 */
export declare class PostgresqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PostgresqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PostgresqlDatabaseTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html azurerm_postgresql_database}.
 *
 * @stability stable
 */
export declare class PostgresqlDatabase extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database.html azurerm_postgresql_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PostgresqlDatabaseConfig);
    private _charset?;
    /**
     * @stability stable
     */
    get charset(): string;
    /**
     * @stability stable
     */
    set charset(value: string);
    /**
     * @stability stable
     */
    get charsetInput(): string | undefined;
    private _collation?;
    /**
     * @stability stable
     */
    get collation(): string;
    /**
     * @stability stable
     */
    set collation(value: string);
    /**
     * @stability stable
     */
    get collationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    /**
     * @stability stable
     */
    get serverName(): string;
    /**
     * @stability stable
     */
    set serverName(value: string);
    /**
     * @stability stable
     */
    get serverNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PostgresqlDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PostgresqlDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PostgresqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
