from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.code_interpreter_tool_call_type import CodeInterpreterToolCallType

if TYPE_CHECKING:
    from ..models.code_interpreter_tool_call_code_interpreter import CodeInterpreterToolCallCodeInterpreter


T = TypeVar("T", bound="CodeInterpreterToolCall")


@_attrs_define
class CodeInterpreterToolCall:
    """Details of the Code Interpreter tool call the run step was involved in.

    Attributes:
        id (str): The ID of the tool call.
        type (CodeInterpreterToolCallType): The type of tool call. This is always going to be `code_interpreter` for
            this type of tool call.
        code_interpreter (CodeInterpreterToolCallCodeInterpreter): The Code Interpreter tool call definition.
    """

    id: str
    type: CodeInterpreterToolCallType
    code_interpreter: "CodeInterpreterToolCallCodeInterpreter"
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        id = self.id

        type = self.type.value

        code_interpreter = self.code_interpreter.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
                "type": type,
                "code_interpreter": code_interpreter,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.code_interpreter_tool_call_code_interpreter import CodeInterpreterToolCallCodeInterpreter

        d = src_dict.copy()
        id = d.pop("id")

        type = CodeInterpreterToolCallType(d.pop("type"))

        code_interpreter = CodeInterpreterToolCallCodeInterpreter.from_dict(d.pop("code_interpreter"))

        code_interpreter_tool_call = cls(
            id=id,
            type=type,
            code_interpreter=code_interpreter,
        )

        code_interpreter_tool_call.additional_properties = d
        return code_interpreter_tool_call

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
