/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeStorageIntegrationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/storage_integrations#id DataSnowflakeStorageIntegrations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataSnowflakeStorageIntegrationsStorageIntegrations {
}
export declare function dataSnowflakeStorageIntegrationsStorageIntegrationsToTerraform(struct?: DataSnowflakeStorageIntegrationsStorageIntegrations): any;
export declare function dataSnowflakeStorageIntegrationsStorageIntegrationsToHclTerraform(struct?: DataSnowflakeStorageIntegrationsStorageIntegrations): any;
export declare class DataSnowflakeStorageIntegrationsStorageIntegrationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeStorageIntegrationsStorageIntegrations | undefined;
    set internalValue(value: DataSnowflakeStorageIntegrationsStorageIntegrations | undefined);
    get comment(): string;
    get enabled(): cdktf.IResolvable;
    get name(): string;
    get type(): string;
}
export declare class DataSnowflakeStorageIntegrationsStorageIntegrationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeStorageIntegrationsStorageIntegrationsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/storage_integrations snowflake_storage_integrations}
*/
export declare class DataSnowflakeStorageIntegrations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_storage_integrations";
    /**
    * Generates CDKTF code for importing a DataSnowflakeStorageIntegrations resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeStorageIntegrations to import
    * @param importFromId The id of the existing DataSnowflakeStorageIntegrations that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/storage_integrations#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeStorageIntegrations to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/storage_integrations snowflake_storage_integrations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeStorageIntegrationsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeStorageIntegrationsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _storageIntegrations;
    get storageIntegrations(): DataSnowflakeStorageIntegrationsStorageIntegrationsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
