/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExecuteConfig extends cdktf.TerraformMetaArguments {
    /**
    * SQL statement to execute. Forces recreation of resource on change.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#execute Execute#execute}
    */
    readonly execute: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#id Execute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional SQL statement to do a read. Invoked on every resource refresh and every time it is changed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#query Execute#query}
    */
    readonly query?: string;
    /**
    * SQL statement to revert the execute statement. Invoked when resource is being destroyed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#revert Execute#revert}
    */
    readonly revert: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#timeouts Execute#timeouts}
    */
    readonly timeouts?: ExecuteTimeouts;
}
export interface ExecuteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#create Execute#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#delete Execute#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#read Execute#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#update Execute#update}
    */
    readonly update?: string;
}
export declare function executeTimeoutsToTerraform(struct?: ExecuteTimeouts | cdktf.IResolvable): any;
export declare function executeTimeoutsToHclTerraform(struct?: ExecuteTimeouts | cdktf.IResolvable): any;
export declare class ExecuteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ExecuteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ExecuteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute snowflake_execute}
*/
export declare class Execute extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_execute";
    /**
    * Generates CDKTF code for importing a Execute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Execute to import
    * @param importFromId The id of the existing Execute that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Execute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/execute snowflake_execute} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExecuteConfig
    */
    constructor(scope: Construct, id: string, config: ExecuteConfig);
    private _execute?;
    get execute(): string;
    set execute(value: string);
    get executeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    resetQuery(): void;
    get queryInput(): string | undefined;
    private _queryResults;
    get queryResults(): cdktf.StringMapList;
    private _revert?;
    get revert(): string;
    set revert(value: string);
    get revertInput(): string | undefined;
    private _timeouts;
    get timeouts(): ExecuteTimeoutsOutputReference;
    putTimeouts(value: ExecuteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ExecuteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
