/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ObjectParameterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#id ObjectParameter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of object parameter. Valid values are those in [object parameters](https://docs.snowflake.com/en/sql-reference/parameters.html#object-parameters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#key ObjectParameter#key}
    */
    readonly key: string;
    /**
    * Type of object to which the parameter applies. Valid values are those in [object types](https://docs.snowflake.com/en/sql-reference/parameters.html#object-types). If no value is provided, then the resource will default to setting the object parameter at account level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#object_type ObjectParameter#object_type}
    */
    readonly objectType?: string;
    /**
    * If true, the object parameter will be set on the account level.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#on_account ObjectParameter#on_account}
    */
    readonly onAccount?: boolean | cdktf.IResolvable;
    /**
    * Value of object parameter, as a string. Constraints are the same as those for the parameters in Snowflake documentation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#value ObjectParameter#value}
    */
    readonly value: string;
    /**
    * object_identifier block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#object_identifier ObjectParameter#object_identifier}
    */
    readonly objectIdentifier?: ObjectParameterObjectIdentifier[] | cdktf.IResolvable;
}
export interface ObjectParameterObjectIdentifier {
    /**
    * Name of the database that the object was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#database ObjectParameter#database}
    */
    readonly database?: string;
    /**
    * Name of the object to set the parameter for.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#name ObjectParameter#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the object was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#schema ObjectParameter#schema}
    */
    readonly schema?: string;
}
export declare function objectParameterObjectIdentifierToTerraform(struct?: ObjectParameterObjectIdentifier | cdktf.IResolvable): any;
export declare function objectParameterObjectIdentifierToHclTerraform(struct?: ObjectParameterObjectIdentifier | cdktf.IResolvable): any;
export declare class ObjectParameterObjectIdentifierOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ObjectParameterObjectIdentifier | cdktf.IResolvable | undefined;
    set internalValue(value: ObjectParameterObjectIdentifier | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export declare class ObjectParameterObjectIdentifierList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ObjectParameterObjectIdentifier[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ObjectParameterObjectIdentifierOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter snowflake_object_parameter}
*/
export declare class ObjectParameter extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_object_parameter";
    /**
    * Generates CDKTF code for importing a ObjectParameter resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ObjectParameter to import
    * @param importFromId The id of the existing ObjectParameter that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ObjectParameter to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/object_parameter snowflake_object_parameter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ObjectParameterConfig
    */
    constructor(scope: Construct, id: string, config: ObjectParameterConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
    private _onAccount?;
    get onAccount(): boolean | cdktf.IResolvable;
    set onAccount(value: boolean | cdktf.IResolvable);
    resetOnAccount(): void;
    get onAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _objectIdentifier;
    get objectIdentifier(): ObjectParameterObjectIdentifierList;
    putObjectIdentifier(value: ObjectParameterObjectIdentifier[] | cdktf.IResolvable): void;
    resetObjectIdentifier(): void;
    get objectIdentifierInput(): cdktf.IResolvable | ObjectParameterObjectIdentifier[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
