/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SnowflakeProviderConfig {
    /**
    * Specifies your Snowflake account name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#account-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ACCOUNT_NAME` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#account_name SnowflakeProvider#account_name}
    */
    readonly accountName?: string;
    /**
    * Specifies the [authentication type](https://pkg.go.dev/github.com/snowflakedb/gosnowflake#AuthType) to use when connecting to Snowflake. Valid options are: `SNOWFLAKE` | `OAUTH` | `EXTERNALBROWSER` | `OKTA` | `SNOWFLAKE_JWT` | `TOKENACCESSOR` | `USERNAMEPASSWORDMFA`. Can also be sourced from the `SNOWFLAKE_AUTHENTICATOR` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#authenticator SnowflakeProvider#authenticator}
    */
    readonly authenticator?: string;
    /**
    * IP address for network checks. Can also be sourced from the `SNOWFLAKE_CLIENT_IP` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#client_ip SnowflakeProvider#client_ip}
    */
    readonly clientIp?: string;
    /**
    * When true the MFA token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_REQUEST_MFA_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#client_request_mfa_token SnowflakeProvider#client_request_mfa_token}
    */
    readonly clientRequestMfaToken?: string;
    /**
    * When true the ID token is cached in the credential manager. True by default in Windows/OSX. False for Linux. Can also be sourced from the `SNOWFLAKE_CLIENT_STORE_TEMPORARY_CREDENTIAL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#client_store_temporary_credential SnowflakeProvider#client_store_temporary_credential}
    */
    readonly clientStoreTemporaryCredential?: string;
    /**
    * The timeout in seconds for the client to complete the authentication. Can also be sourced from the `SNOWFLAKE_CLIENT_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#client_timeout SnowflakeProvider#client_timeout}
    */
    readonly clientTimeout?: number;
    /**
    * Indicates whether console login should be disabled in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_CONSOLE_LOGIN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#disable_console_login SnowflakeProvider#disable_console_login}
    */
    readonly disableConsoleLogin?: string;
    /**
    * Disables HTAP query context cache in the driver. Can also be sourced from the `SNOWFLAKE_DISABLE_QUERY_CONTEXT_CACHE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#disable_query_context_cache SnowflakeProvider#disable_query_context_cache}
    */
    readonly disableQueryContextCache?: boolean | cdktf.IResolvable;
    /**
    * Disables telemetry in the driver. Can also be sourced from the `DISABLE_TELEMETRY` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#disable_telemetry SnowflakeProvider#disable_telemetry}
    */
    readonly disableTelemetry?: boolean | cdktf.IResolvable;
    /**
    * Specifies the logging level to be used by the driver. Valid options are: `trace` | `debug` | `info` | `print` | `warning` | `error` | `fatal` | `panic`. Can also be sourced from the `SNOWFLAKE_DRIVER_TRACING` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#driver_tracing SnowflakeProvider#driver_tracing}
    */
    readonly driverTracing?: string;
    /**
    * The timeout in seconds for the external browser to complete the authentication. Can also be sourced from the `SNOWFLAKE_EXTERNAL_BROWSER_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#external_browser_timeout SnowflakeProvider#external_browser_timeout}
    */
    readonly externalBrowserTimeout?: number;
    /**
    * Specifies a custom host value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_HOST` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#host SnowflakeProvider#host}
    */
    readonly host?: string;
    /**
    * Should retried request contain retry reason. Can also be sourced from the `SNOWFLAKE_INCLUDE_RETRY_REASON` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#include_retry_reason SnowflakeProvider#include_retry_reason}
    */
    readonly includeRetryReason?: string;
    /**
    * If true, bypass the Online Certificate Status Protocol (OCSP) certificate revocation check. IMPORTANT: Change the default value for testing or emergency situations only. Can also be sourced from the `SNOWFLAKE_INSECURE_MODE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#insecure_mode SnowflakeProvider#insecure_mode}
    */
    readonly insecureMode?: boolean | cdktf.IResolvable;
    /**
    * The timeout in seconds for the JWT client to complete the authentication. Can also be sourced from the `SNOWFLAKE_JWT_CLIENT_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#jwt_client_timeout SnowflakeProvider#jwt_client_timeout}
    */
    readonly jwtClientTimeout?: number;
    /**
    * JWT expire after timeout in seconds. Can also be sourced from the `SNOWFLAKE_JWT_EXPIRE_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#jwt_expire_timeout SnowflakeProvider#jwt_expire_timeout}
    */
    readonly jwtExpireTimeout?: number;
    /**
    * Enables the session to persist even after the connection is closed. Can also be sourced from the `SNOWFLAKE_KEEP_SESSION_ALIVE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#keep_session_alive SnowflakeProvider#keep_session_alive}
    */
    readonly keepSessionAlive?: boolean | cdktf.IResolvable;
    /**
    * Login retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_LOGIN_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#login_timeout SnowflakeProvider#login_timeout}
    */
    readonly loginTimeout?: number;
    /**
    * Specifies how many times non-periodic HTTP request can be retried by the driver. Can also be sourced from the `SNOWFLAKE_MAX_RETRY_COUNT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#max_retry_count SnowflakeProvider#max_retry_count}
    */
    readonly maxRetryCount?: number;
    /**
    * True represents OCSP fail open mode. False represents OCSP fail closed mode. Fail open true by default. Can also be sourced from the `SNOWFLAKE_OCSP_FAIL_OPEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#ocsp_fail_open SnowflakeProvider#ocsp_fail_open}
    */
    readonly ocspFailOpen?: string;
    /**
    * The URL of the Okta server. e.g. https://example.okta.com. Okta URL host needs to to have a suffix `okta.com`. Read more in Snowflake [docs](https://docs.snowflake.com/en/user-guide/oauth-okta). Can also be sourced from the `SNOWFLAKE_OKTA_URL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#okta_url SnowflakeProvider#okta_url}
    */
    readonly oktaUrl?: string;
    /**
    * Specifies your Snowflake organization name assigned by Snowflake. For information about account identifiers, see the [Snowflake documentation](https://docs.snowflake.com/en/user-guide/admin-account-identifier#organization-name). Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_ORGANIZATION_NAME` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#organization_name SnowflakeProvider#organization_name}
    */
    readonly organizationName?: string;
    /**
    * Sets other connection (i.e. session) parameters. [Parameters](https://docs.snowflake.com/en/sql-reference/parameters). This field can not be set with environmental variables.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#params SnowflakeProvider#params}
    */
    readonly params?: {
        [key: string]: string;
    };
    /**
    * Specifies the passcode provided by Duo when using multi-factor authentication (MFA) for login. Can also be sourced from the `SNOWFLAKE_PASSCODE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#passcode SnowflakeProvider#passcode}
    */
    readonly passcode?: string;
    /**
    * False by default. Set to true if the MFA passcode is embedded to the configured password. Can also be sourced from the `SNOWFLAKE_PASSCODE_IN_PASSWORD` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#passcode_in_password SnowflakeProvider#passcode_in_password}
    */
    readonly passcodeInPassword?: boolean | cdktf.IResolvable;
    /**
    * Password for user + password auth. Cannot be used with `private_key` and `private_key_passphrase`. Can also be sourced from the `SNOWFLAKE_PASSWORD` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#password SnowflakeProvider#password}
    */
    readonly password?: string;
    /**
    * Specifies a custom port value used by the driver for privatelink connections. Can also be sourced from the `SNOWFLAKE_PORT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#port SnowflakeProvider#port}
    */
    readonly port?: number;
    /**
    * A list of preview features that are handled by the provider. See [preview features list](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/v1-preparations/LIST_OF_PREVIEW_FEATURES_FOR_V1.md). Preview features may have breaking changes in future releases, even without raising the major version. This field can not be set with environmental variables. Valid options are: `snowflake_current_account_datasource` | `snowflake_account_authentication_policy_attachment_resource` | `snowflake_account_password_policy_attachment_resource` | `snowflake_alert_resource` | `snowflake_alerts_datasource` | `snowflake_api_integration_resource` | `snowflake_authentication_policy_resource` | `snowflake_cortex_search_service_resource` | `snowflake_cortex_search_services_datasource` | `snowflake_database_datasource` | `snowflake_database_role_datasource` | `snowflake_dynamic_table_resource` | `snowflake_dynamic_tables_datasource` | `snowflake_external_function_resource` | `snowflake_external_functions_datasource` | `snowflake_external_table_resource` | `snowflake_external_tables_datasource` | `snowflake_external_volume_resource` | `snowflake_failover_group_resource` | `snowflake_failover_groups_datasource` | `snowflake_file_format_resource` | `snowflake_file_formats_datasource` | `snowflake_function_java_resource` | `snowflake_function_javascript_resource` | `snowflake_function_python_resource` | `snowflake_function_scala_resource` | `snowflake_function_sql_resource` | `snowflake_functions_datasource` | `snowflake_managed_account_resource` | `snowflake_materialized_view_resource` | `snowflake_materialized_views_datasource` | `snowflake_network_policy_attachment_resource` | `snowflake_network_rule_resource` | `snowflake_email_notification_integration_resource` | `snowflake_notification_integration_resource` | `snowflake_object_parameter_resource` | `snowflake_password_policy_resource` | `snowflake_pipe_resource` | `snowflake_pipes_datasource` | `snowflake_current_role_datasource` | `snowflake_sequence_resource` | `snowflake_sequences_datasource` | `snowflake_share_resource` | `snowflake_shares_datasource` | `snowflake_parameters_datasource` | `snowflake_procedure_java_resource` | `snowflake_procedure_javascript_resource` | `snowflake_procedure_python_resource` | `snowflake_procedure_scala_resource` | `snowflake_procedure_sql_resource` | `snowflake_procedures_datasource` | `snowflake_stage_resource` | `snowflake_stages_datasource` | `snowflake_storage_integration_resource` | `snowflake_storage_integrations_datasource` | `snowflake_system_generate_scim_access_token_datasource` | `snowflake_system_get_aws_sns_iam_policy_datasource` | `snowflake_system_get_privatelink_config_datasource` | `snowflake_system_get_snowflake_platform_info_datasource` | `snowflake_table_column_masking_policy_application_resource` | `snowflake_table_constraint_resource` | `snowflake_table_resource` | `snowflake_tables_datasource` | `snowflake_user_authentication_policy_attachment_resource` | `snowflake_user_public_keys_resource` | `snowflake_user_password_policy_attachment_resource`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#preview_features_enabled SnowflakeProvider#preview_features_enabled}
    */
    readonly previewFeaturesEnabled?: string[];
    /**
    * Private Key for username+private-key auth. Cannot be used with `password`. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#private_key SnowflakeProvider#private_key}
    */
    readonly privateKey?: string;
    /**
    * Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc. Can also be sourced from the `SNOWFLAKE_PRIVATE_KEY_PASSPHRASE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#private_key_passphrase SnowflakeProvider#private_key_passphrase}
    */
    readonly privateKeyPassphrase?: string;
    /**
    * Sets the profile to read from ~/.snowflake/config file. Can also be sourced from the `SNOWFLAKE_PROFILE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#profile SnowflakeProvider#profile}
    */
    readonly profile?: string;
    /**
    * A protocol used in the connection. Valid options are: `http` | `https`. Can also be sourced from the `SNOWFLAKE_PROTOCOL` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#protocol SnowflakeProvider#protocol}
    */
    readonly protocol?: string;
    /**
    * request retry timeout in seconds EXCLUDING network roundtrip and read out http response. Can also be sourced from the `SNOWFLAKE_REQUEST_TIMEOUT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#request_timeout SnowflakeProvider#request_timeout}
    */
    readonly requestTimeout?: number;
    /**
    * Specifies the role to use by default for accessing Snowflake objects in the client session. Can also be sourced from the `SNOWFLAKE_ROLE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#role SnowflakeProvider#role}
    */
    readonly role?: string;
    /**
    * Sets temporary directory used by the driver for operations like encrypting, compressing etc. Can also be sourced from the `SNOWFLAKE_TMP_DIRECTORY_PATH` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#tmp_directory_path SnowflakeProvider#tmp_directory_path}
    */
    readonly tmpDirectoryPath?: string;
    /**
    * Token to use for OAuth and other forms of token based auth. Can also be sourced from the `SNOWFLAKE_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#token SnowflakeProvider#token}
    */
    readonly token?: string;
    /**
    * Username. Required unless using `profile`. Can also be sourced from the `SNOWFLAKE_USER` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#user SnowflakeProvider#user}
    */
    readonly user?: string;
    /**
    * True by default. If false, disables the validation checks for Database, Schema, Warehouse and Role at the time a connection is established. Can also be sourced from the `SNOWFLAKE_VALIDATE_DEFAULT_PARAMETERS` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#validate_default_parameters SnowflakeProvider#validate_default_parameters}
    */
    readonly validateDefaultParameters?: string;
    /**
    * Specifies the virtual warehouse to use by default for queries, loading, etc. in the client session. Can also be sourced from the `SNOWFLAKE_WAREHOUSE` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#warehouse SnowflakeProvider#warehouse}
    */
    readonly warehouse?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#alias SnowflakeProvider#alias}
    */
    readonly alias?: string;
    /**
    * token_accessor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#token_accessor SnowflakeProvider#token_accessor}
    */
    readonly tokenAccessor?: SnowflakeProviderTokenAccessor;
}
export interface SnowflakeProviderTokenAccessor {
    /**
    * The client ID for the OAuth provider when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_CLIENT_ID` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#client_id SnowflakeProvider#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret for the OAuth provider when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_CLIENT_SECRET` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#client_secret SnowflakeProvider#client_secret}
    */
    readonly clientSecret: string;
    /**
    * The redirect URI for the OAuth provider when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_REDIRECT_URI` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#redirect_uri SnowflakeProvider#redirect_uri}
    */
    readonly redirectUri: string;
    /**
    * The refresh token for the OAuth provider when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_REFRESH_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#refresh_token SnowflakeProvider#refresh_token}
    */
    readonly refreshToken: string;
    /**
    * The token endpoint for the OAuth provider e.g. https://{yourDomain}/oauth/token when using a refresh token to renew access token. Can also be sourced from the `SNOWFLAKE_TOKEN_ACCESSOR_TOKEN_ENDPOINT` environment variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#token_endpoint SnowflakeProvider#token_endpoint}
    */
    readonly tokenEndpoint: string;
}
export declare function snowflakeProviderTokenAccessorToTerraform(struct?: SnowflakeProviderTokenAccessor): any;
export declare function snowflakeProviderTokenAccessorToHclTerraform(struct?: SnowflakeProviderTokenAccessor): any;
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs snowflake}
*/
export declare class SnowflakeProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "snowflake";
    /**
    * Generates CDKTF code for importing a SnowflakeProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SnowflakeProvider to import
    * @param importFromId The id of the existing SnowflakeProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SnowflakeProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: SnowflakeProviderConfig);
    private _accountName?;
    get accountName(): string | undefined;
    set accountName(value: string | undefined);
    resetAccountName(): void;
    get accountNameInput(): string | undefined;
    private _authenticator?;
    get authenticator(): string | undefined;
    set authenticator(value: string | undefined);
    resetAuthenticator(): void;
    get authenticatorInput(): string | undefined;
    private _clientIp?;
    get clientIp(): string | undefined;
    set clientIp(value: string | undefined);
    resetClientIp(): void;
    get clientIpInput(): string | undefined;
    private _clientRequestMfaToken?;
    get clientRequestMfaToken(): string | undefined;
    set clientRequestMfaToken(value: string | undefined);
    resetClientRequestMfaToken(): void;
    get clientRequestMfaTokenInput(): string | undefined;
    private _clientStoreTemporaryCredential?;
    get clientStoreTemporaryCredential(): string | undefined;
    set clientStoreTemporaryCredential(value: string | undefined);
    resetClientStoreTemporaryCredential(): void;
    get clientStoreTemporaryCredentialInput(): string | undefined;
    private _clientTimeout?;
    get clientTimeout(): number | undefined;
    set clientTimeout(value: number | undefined);
    resetClientTimeout(): void;
    get clientTimeoutInput(): number | undefined;
    private _disableConsoleLogin?;
    get disableConsoleLogin(): string | undefined;
    set disableConsoleLogin(value: string | undefined);
    resetDisableConsoleLogin(): void;
    get disableConsoleLoginInput(): string | undefined;
    private _disableQueryContextCache?;
    get disableQueryContextCache(): boolean | cdktf.IResolvable | undefined;
    set disableQueryContextCache(value: boolean | cdktf.IResolvable | undefined);
    resetDisableQueryContextCache(): void;
    get disableQueryContextCacheInput(): boolean | cdktf.IResolvable | undefined;
    private _disableTelemetry?;
    get disableTelemetry(): boolean | cdktf.IResolvable | undefined;
    set disableTelemetry(value: boolean | cdktf.IResolvable | undefined);
    resetDisableTelemetry(): void;
    get disableTelemetryInput(): boolean | cdktf.IResolvable | undefined;
    private _driverTracing?;
    get driverTracing(): string | undefined;
    set driverTracing(value: string | undefined);
    resetDriverTracing(): void;
    get driverTracingInput(): string | undefined;
    private _externalBrowserTimeout?;
    get externalBrowserTimeout(): number | undefined;
    set externalBrowserTimeout(value: number | undefined);
    resetExternalBrowserTimeout(): void;
    get externalBrowserTimeoutInput(): number | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _includeRetryReason?;
    get includeRetryReason(): string | undefined;
    set includeRetryReason(value: string | undefined);
    resetIncludeRetryReason(): void;
    get includeRetryReasonInput(): string | undefined;
    private _insecureMode?;
    get insecureMode(): boolean | cdktf.IResolvable | undefined;
    set insecureMode(value: boolean | cdktf.IResolvable | undefined);
    resetInsecureMode(): void;
    get insecureModeInput(): boolean | cdktf.IResolvable | undefined;
    private _jwtClientTimeout?;
    get jwtClientTimeout(): number | undefined;
    set jwtClientTimeout(value: number | undefined);
    resetJwtClientTimeout(): void;
    get jwtClientTimeoutInput(): number | undefined;
    private _jwtExpireTimeout?;
    get jwtExpireTimeout(): number | undefined;
    set jwtExpireTimeout(value: number | undefined);
    resetJwtExpireTimeout(): void;
    get jwtExpireTimeoutInput(): number | undefined;
    private _keepSessionAlive?;
    get keepSessionAlive(): boolean | cdktf.IResolvable | undefined;
    set keepSessionAlive(value: boolean | cdktf.IResolvable | undefined);
    resetKeepSessionAlive(): void;
    get keepSessionAliveInput(): boolean | cdktf.IResolvable | undefined;
    private _loginTimeout?;
    get loginTimeout(): number | undefined;
    set loginTimeout(value: number | undefined);
    resetLoginTimeout(): void;
    get loginTimeoutInput(): number | undefined;
    private _maxRetryCount?;
    get maxRetryCount(): number | undefined;
    set maxRetryCount(value: number | undefined);
    resetMaxRetryCount(): void;
    get maxRetryCountInput(): number | undefined;
    private _ocspFailOpen?;
    get ocspFailOpen(): string | undefined;
    set ocspFailOpen(value: string | undefined);
    resetOcspFailOpen(): void;
    get ocspFailOpenInput(): string | undefined;
    private _oktaUrl?;
    get oktaUrl(): string | undefined;
    set oktaUrl(value: string | undefined);
    resetOktaUrl(): void;
    get oktaUrlInput(): string | undefined;
    private _organizationName?;
    get organizationName(): string | undefined;
    set organizationName(value: string | undefined);
    resetOrganizationName(): void;
    get organizationNameInput(): string | undefined;
    private _params?;
    get params(): {
        [key: string]: string;
    } | undefined;
    set params(value: {
        [key: string]: string;
    } | undefined);
    resetParams(): void;
    get paramsInput(): {
        [key: string]: string;
    } | undefined;
    private _passcode?;
    get passcode(): string | undefined;
    set passcode(value: string | undefined);
    resetPasscode(): void;
    get passcodeInput(): string | undefined;
    private _passcodeInPassword?;
    get passcodeInPassword(): boolean | cdktf.IResolvable | undefined;
    set passcodeInPassword(value: boolean | cdktf.IResolvable | undefined);
    resetPasscodeInPassword(): void;
    get passcodeInPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _previewFeaturesEnabled?;
    get previewFeaturesEnabled(): string[] | undefined;
    set previewFeaturesEnabled(value: string[] | undefined);
    resetPreviewFeaturesEnabled(): void;
    get previewFeaturesEnabledInput(): string[] | undefined;
    private _privateKey?;
    get privateKey(): string | undefined;
    set privateKey(value: string | undefined);
    resetPrivateKey(): void;
    get privateKeyInput(): string | undefined;
    private _privateKeyPassphrase?;
    get privateKeyPassphrase(): string | undefined;
    set privateKeyPassphrase(value: string | undefined);
    resetPrivateKeyPassphrase(): void;
    get privateKeyPassphraseInput(): string | undefined;
    private _profile?;
    get profile(): string | undefined;
    set profile(value: string | undefined);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _protocol?;
    get protocol(): string | undefined;
    set protocol(value: string | undefined);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _requestTimeout?;
    get requestTimeout(): number | undefined;
    set requestTimeout(value: number | undefined);
    resetRequestTimeout(): void;
    get requestTimeoutInput(): number | undefined;
    private _role?;
    get role(): string | undefined;
    set role(value: string | undefined);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _tmpDirectoryPath?;
    get tmpDirectoryPath(): string | undefined;
    set tmpDirectoryPath(value: string | undefined);
    resetTmpDirectoryPath(): void;
    get tmpDirectoryPathInput(): string | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _user?;
    get user(): string | undefined;
    set user(value: string | undefined);
    resetUser(): void;
    get userInput(): string | undefined;
    private _validateDefaultParameters?;
    get validateDefaultParameters(): string | undefined;
    set validateDefaultParameters(value: string | undefined);
    resetValidateDefaultParameters(): void;
    get validateDefaultParametersInput(): string | undefined;
    private _warehouse?;
    get warehouse(): string | undefined;
    set warehouse(value: string | undefined);
    resetWarehouse(): void;
    get warehouseInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _tokenAccessor?;
    get tokenAccessor(): SnowflakeProviderTokenAccessor | undefined;
    set tokenAccessor(value: SnowflakeProviderTokenAccessor | undefined);
    resetTokenAccessor(): void;
    get tokenAccessorInput(): SnowflakeProviderTokenAccessor | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
