"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceMonitor = exports.ResourceMonitorShowOutputList = exports.ResourceMonitorShowOutputOutputReference = void 0;
exports.resourceMonitorShowOutputToTerraform = resourceMonitorShowOutputToTerraform;
exports.resourceMonitorShowOutputToHclTerraform = resourceMonitorShowOutputToHclTerraform;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function resourceMonitorShowOutputToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
function resourceMonitorShowOutputToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {};
    return attrs;
}
class ResourceMonitorShowOutputOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // comment - computed: true, optional: false, required: false
    get comment() {
        return this.getStringAttribute('comment');
    }
    // created_on - computed: true, optional: false, required: false
    get createdOn() {
        return this.getStringAttribute('created_on');
    }
    // credit_quota - computed: true, optional: false, required: false
    get creditQuota() {
        return this.getNumberAttribute('credit_quota');
    }
    // end_time - computed: true, optional: false, required: false
    get endTime() {
        return this.getStringAttribute('end_time');
    }
    // frequency - computed: true, optional: false, required: false
    get frequency() {
        return this.getStringAttribute('frequency');
    }
    // level - computed: true, optional: false, required: false
    get level() {
        return this.getStringAttribute('level');
    }
    // name - computed: true, optional: false, required: false
    get name() {
        return this.getStringAttribute('name');
    }
    // owner - computed: true, optional: false, required: false
    get owner() {
        return this.getStringAttribute('owner');
    }
    // remaining_credits - computed: true, optional: false, required: false
    get remainingCredits() {
        return this.getNumberAttribute('remaining_credits');
    }
    // start_time - computed: true, optional: false, required: false
    get startTime() {
        return this.getStringAttribute('start_time');
    }
    // suspend_at - computed: true, optional: false, required: false
    get suspendAt() {
        return this.getNumberAttribute('suspend_at');
    }
    // suspend_immediate_at - computed: true, optional: false, required: false
    get suspendImmediateAt() {
        return this.getNumberAttribute('suspend_immediate_at');
    }
    // used_credits - computed: true, optional: false, required: false
    get usedCredits() {
        return this.getNumberAttribute('used_credits');
    }
}
exports.ResourceMonitorShowOutputOutputReference = ResourceMonitorShowOutputOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ResourceMonitorShowOutputOutputReference[_a] = { fqn: "@cdktf/provider-snowflake.resourceMonitor.ResourceMonitorShowOutputOutputReference", version: "12.0.4" };
class ResourceMonitorShowOutputList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new ResourceMonitorShowOutputOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.ResourceMonitorShowOutputList = ResourceMonitorShowOutputList;
_b = JSII_RTTI_SYMBOL_1;
ResourceMonitorShowOutputList[_b] = { fqn: "@cdktf/provider-snowflake.resourceMonitor.ResourceMonitorShowOutputList", version: "12.0.4" };
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/resource_monitor snowflake_resource_monitor}
*/
class ResourceMonitor extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a ResourceMonitor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceMonitor to import
    * @param importFromId The id of the existing ResourceMonitor that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/resource_monitor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceMonitor to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "snowflake_resource_monitor", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/resource_monitor snowflake_resource_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceMonitorConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_resource_monitor',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '1.0.4',
                providerVersionConstraint: ' ~> 1.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // show_output - computed: true, optional: false, required: false
        this._showOutput = new ResourceMonitorShowOutputList(this, "show_output", false);
        this._creditQuota = config.creditQuota;
        this._endTimestamp = config.endTimestamp;
        this._frequency = config.frequency;
        this._id = config.id;
        this._name = config.name;
        this._notifyTriggers = config.notifyTriggers;
        this._notifyUsers = config.notifyUsers;
        this._startTimestamp = config.startTimestamp;
        this._suspendImmediateTrigger = config.suspendImmediateTrigger;
        this._suspendTrigger = config.suspendTrigger;
    }
    get creditQuota() {
        return this.getNumberAttribute('credit_quota');
    }
    set creditQuota(value) {
        this._creditQuota = value;
    }
    resetCreditQuota() {
        this._creditQuota = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get creditQuotaInput() {
        return this._creditQuota;
    }
    get endTimestamp() {
        return this.getStringAttribute('end_timestamp');
    }
    set endTimestamp(value) {
        this._endTimestamp = value;
    }
    resetEndTimestamp() {
        this._endTimestamp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get endTimestampInput() {
        return this._endTimestamp;
    }
    get frequency() {
        return this.getStringAttribute('frequency');
    }
    set frequency(value) {
        this._frequency = value;
    }
    resetFrequency() {
        this._frequency = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get frequencyInput() {
        return this._frequency;
    }
    // fully_qualified_name - computed: true, optional: false, required: false
    get fullyQualifiedName() {
        return this.getStringAttribute('fully_qualified_name');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get notifyTriggers() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('notify_triggers')));
    }
    set notifyTriggers(value) {
        this._notifyTriggers = value;
    }
    resetNotifyTriggers() {
        this._notifyTriggers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyTriggersInput() {
        return this._notifyTriggers;
    }
    get notifyUsers() {
        return cdktf.Fn.tolist(this.getListAttribute('notify_users'));
    }
    set notifyUsers(value) {
        this._notifyUsers = value;
    }
    resetNotifyUsers() {
        this._notifyUsers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notifyUsersInput() {
        return this._notifyUsers;
    }
    get showOutput() {
        return this._showOutput;
    }
    get startTimestamp() {
        return this.getStringAttribute('start_timestamp');
    }
    set startTimestamp(value) {
        this._startTimestamp = value;
    }
    resetStartTimestamp() {
        this._startTimestamp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get startTimestampInput() {
        return this._startTimestamp;
    }
    get suspendImmediateTrigger() {
        return this.getNumberAttribute('suspend_immediate_trigger');
    }
    set suspendImmediateTrigger(value) {
        this._suspendImmediateTrigger = value;
    }
    resetSuspendImmediateTrigger() {
        this._suspendImmediateTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendImmediateTriggerInput() {
        return this._suspendImmediateTrigger;
    }
    get suspendTrigger() {
        return this.getNumberAttribute('suspend_trigger');
    }
    set suspendTrigger(value) {
        this._suspendTrigger = value;
    }
    resetSuspendTrigger() {
        this._suspendTrigger = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendTriggerInput() {
        return this._suspendTrigger;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            credit_quota: cdktf.numberToTerraform(this._creditQuota),
            end_timestamp: cdktf.stringToTerraform(this._endTimestamp),
            frequency: cdktf.stringToTerraform(this._frequency),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            notify_triggers: cdktf.listMapper(cdktf.numberToTerraform, false)(this._notifyTriggers),
            notify_users: cdktf.listMapper(cdktf.stringToTerraform, false)(this._notifyUsers),
            start_timestamp: cdktf.stringToTerraform(this._startTimestamp),
            suspend_immediate_trigger: cdktf.numberToTerraform(this._suspendImmediateTrigger),
            suspend_trigger: cdktf.numberToTerraform(this._suspendTrigger),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            credit_quota: {
                value: cdktf.numberToHclTerraform(this._creditQuota),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            end_timestamp: {
                value: cdktf.stringToHclTerraform(this._endTimestamp),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            frequency: {
                value: cdktf.stringToHclTerraform(this._frequency),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            notify_triggers: {
                value: cdktf.listMapperHcl(cdktf.numberToHclTerraform, false)(this._notifyTriggers),
                isBlock: false,
                type: "set",
                storageClassType: "numberList",
            },
            notify_users: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._notifyUsers),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            start_timestamp: {
                value: cdktf.stringToHclTerraform(this._startTimestamp),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            suspend_immediate_trigger: {
                value: cdktf.numberToHclTerraform(this._suspendImmediateTrigger),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            suspend_trigger: {
                value: cdktf.numberToHclTerraform(this._suspendTrigger),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.ResourceMonitor = ResourceMonitor;
_c = JSII_RTTI_SYMBOL_1;
ResourceMonitor[_c] = { fqn: "@cdktf/provider-snowflake.resourceMonitor.ResourceMonitor", version: "12.0.4" };
// =================
// STATIC PROPERTIES
// =================
ResourceMonitor.tfResourceType = "snowflake_resource_monitor";
//# sourceMappingURL=data:application/json;base64,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