/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecondaryDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * A fully qualified path to a database to create a replica from. A fully qualified path follows the format of `"<organization_name>"."<account_name>"."<database_name>"`. For more information about this resource, see [docs](./database).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#as_replica_of SecondaryDatabase#as_replica_of}
    */
    readonly asReplicaOf: string;
    /**
    * The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#catalog SecondaryDatabase#catalog}
    */
    readonly catalog?: string;
    /**
    * Specifies a comment for the database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#comment SecondaryDatabase#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#data_retention_time_in_days SecondaryDatabase#data_retention_time_in_days}
    */
    readonly dataRetentionTimeInDays?: number;
    /**
    * Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#default_ddl_collation SecondaryDatabase#default_ddl_collation}
    */
    readonly defaultDdlCollation?: string;
    /**
    * If true, enables stdout/stderr fast path logging for anonymous stored procedures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#enable_console_output SecondaryDatabase#enable_console_output}
    */
    readonly enableConsoleOutput?: boolean | cdktf.IResolvable;
    /**
    * The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#external_volume SecondaryDatabase#external_volume}
    */
    readonly externalVolume?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#id SecondaryDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the database as transient. Transient databases do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#is_transient SecondaryDatabase#is_transient}
    */
    readonly isTransient?: boolean | cdktf.IResolvable;
    /**
    * Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#log_level SecondaryDatabase#log_level}
    */
    readonly logLevel?: string;
    /**
    * Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX_DATA_EXTENSION_TIME_IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#max_data_extension_time_in_days SecondaryDatabase#max_data_extension_time_in_days}
    */
    readonly maxDataExtensionTimeInDays?: number;
    /**
    * Specifies the identifier for the database; must be unique for your account. As a best practice for [Database Replication and Failover](https://docs.snowflake.com/en/user-guide/db-replication-intro), it is recommended to give each secondary database the same name as its primary database. This practice supports referencing fully-qualified objects (i.e. '<db>.<schema>.<object>') by other objects in the same database, such as querying a fully-qualified table name in a view. If a secondary database has a different name from the primary database, then these object references would break in the secondary database. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#name SecondaryDatabase#name}
    */
    readonly name: string;
    /**
    * If true, the case of quoted identifiers is ignored. For more information, see [QUOTED_IDENTIFIERS_IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#quoted_identifiers_ignore_case SecondaryDatabase#quoted_identifiers_ignore_case}
    */
    readonly quotedIdentifiersIgnoreCase?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE_INVALID_CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#replace_invalid_characters SecondaryDatabase#replace_invalid_characters}
    */
    readonly replaceInvalidCharacters?: boolean | cdktf.IResolvable;
    /**
    * The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE_SERIALIZATION_POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#storage_serialization_policy SecondaryDatabase#storage_serialization_policy}
    */
    readonly storageSerializationPolicy?: string;
    /**
    * How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND_TASK_AFTER_NUM_FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#suspend_task_after_num_failures SecondaryDatabase#suspend_task_after_num_failures}
    */
    readonly suspendTaskAfterNumFailures?: number;
    /**
    * Maximum automatic retries allowed for a user task. For more information, see [TASK_AUTO_RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#task_auto_retry_attempts SecondaryDatabase#task_auto_retry_attempts}
    */
    readonly taskAutoRetryAttempts?: number;
    /**
    * Controls how trace events are ingested into the event table. Valid options are: [ALWAYS ON_EVENT OFF]. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#trace_level SecondaryDatabase#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER_TASK_MANAGED_INITIAL_WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#user_task_managed_initial_warehouse_size SecondaryDatabase#user_task_managed_initial_warehouse_size}
    */
    readonly userTaskManagedInitialWarehouseSize?: string;
    /**
    * Minimum amount of time between Triggered Task executions in seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#user_task_minimum_trigger_interval_in_seconds SecondaryDatabase#user_task_minimum_trigger_interval_in_seconds}
    */
    readonly userTaskMinimumTriggerIntervalInSeconds?: number;
    /**
    * User task execution timeout in milliseconds. For more information, see [USER_TASK_TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#user_task_timeout_ms SecondaryDatabase#user_task_timeout_ms}
    */
    readonly userTaskTimeoutMs?: number;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database snowflake_secondary_database}
*/
export declare class SecondaryDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_secondary_database";
    /**
    * Generates CDKTF code for importing a SecondaryDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecondaryDatabase to import
    * @param importFromId The id of the existing SecondaryDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecondaryDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database snowflake_secondary_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecondaryDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: SecondaryDatabaseConfig);
    private _asReplicaOf?;
    get asReplicaOf(): string;
    set asReplicaOf(value: string);
    get asReplicaOfInput(): string | undefined;
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRetentionTimeInDays?;
    get dataRetentionTimeInDays(): number;
    set dataRetentionTimeInDays(value: number);
    resetDataRetentionTimeInDays(): void;
    get dataRetentionTimeInDaysInput(): number | undefined;
    private _defaultDdlCollation?;
    get defaultDdlCollation(): string;
    set defaultDdlCollation(value: string);
    resetDefaultDdlCollation(): void;
    get defaultDdlCollationInput(): string | undefined;
    private _enableConsoleOutput?;
    get enableConsoleOutput(): boolean | cdktf.IResolvable;
    set enableConsoleOutput(value: boolean | cdktf.IResolvable);
    resetEnableConsoleOutput(): void;
    get enableConsoleOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _externalVolume?;
    get externalVolume(): string;
    set externalVolume(value: string);
    resetExternalVolume(): void;
    get externalVolumeInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isTransient?;
    get isTransient(): boolean | cdktf.IResolvable;
    set isTransient(value: boolean | cdktf.IResolvable);
    resetIsTransient(): void;
    get isTransientInput(): boolean | cdktf.IResolvable | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _maxDataExtensionTimeInDays?;
    get maxDataExtensionTimeInDays(): number;
    set maxDataExtensionTimeInDays(value: number);
    resetMaxDataExtensionTimeInDays(): void;
    get maxDataExtensionTimeInDaysInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _quotedIdentifiersIgnoreCase?;
    get quotedIdentifiersIgnoreCase(): boolean | cdktf.IResolvable;
    set quotedIdentifiersIgnoreCase(value: boolean | cdktf.IResolvable);
    resetQuotedIdentifiersIgnoreCase(): void;
    get quotedIdentifiersIgnoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _replaceInvalidCharacters?;
    get replaceInvalidCharacters(): boolean | cdktf.IResolvable;
    set replaceInvalidCharacters(value: boolean | cdktf.IResolvable);
    resetReplaceInvalidCharacters(): void;
    get replaceInvalidCharactersInput(): boolean | cdktf.IResolvable | undefined;
    private _storageSerializationPolicy?;
    get storageSerializationPolicy(): string;
    set storageSerializationPolicy(value: string);
    resetStorageSerializationPolicy(): void;
    get storageSerializationPolicyInput(): string | undefined;
    private _suspendTaskAfterNumFailures?;
    get suspendTaskAfterNumFailures(): number;
    set suspendTaskAfterNumFailures(value: number);
    resetSuspendTaskAfterNumFailures(): void;
    get suspendTaskAfterNumFailuresInput(): number | undefined;
    private _taskAutoRetryAttempts?;
    get taskAutoRetryAttempts(): number;
    set taskAutoRetryAttempts(value: number);
    resetTaskAutoRetryAttempts(): void;
    get taskAutoRetryAttemptsInput(): number | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _userTaskManagedInitialWarehouseSize?;
    get userTaskManagedInitialWarehouseSize(): string;
    set userTaskManagedInitialWarehouseSize(value: string);
    resetUserTaskManagedInitialWarehouseSize(): void;
    get userTaskManagedInitialWarehouseSizeInput(): string | undefined;
    private _userTaskMinimumTriggerIntervalInSeconds?;
    get userTaskMinimumTriggerIntervalInSeconds(): number;
    set userTaskMinimumTriggerIntervalInSeconds(value: number);
    resetUserTaskMinimumTriggerIntervalInSeconds(): void;
    get userTaskMinimumTriggerIntervalInSecondsInput(): number | undefined;
    private _userTaskTimeoutMs?;
    get userTaskTimeoutMs(): number;
    set userTaskTimeoutMs(value: number);
    resetUserTaskTimeoutMs(): void;
    get userTaskTimeoutMsInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
