/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretWithGenericStringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string#comment SecretWithGenericString#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the secret Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string#database SecretWithGenericString#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string#id SecretWithGenericString#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String that specifies the identifier (i.e. name) for the secret, must be unique in your schema. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string#name SecretWithGenericString#name}
    */
    readonly name: string;
    /**
    * The schema in which to create the secret. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string#schema SecretWithGenericString#schema}
    */
    readonly schema: string;
    /**
    * Specifies the string to store in the secret. The string can be an API token or a string of sensitive value that can be used in the handler code of a UDF or stored procedure. For details, see [Creating and using an external access integration](https://docs.snowflake.com/en/developer-guide/external-network-access/creating-using-external-network-access). You should not use this property to store any kind of OAuth token; use one of the other secret types for your OAuth use cases. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string#secret_string SecretWithGenericString#secret_string}
    */
    readonly secretString: string;
}
export interface SecretWithGenericStringDescribeOutput {
}
export declare function secretWithGenericStringDescribeOutputToTerraform(struct?: SecretWithGenericStringDescribeOutput): any;
export declare function secretWithGenericStringDescribeOutputToHclTerraform(struct?: SecretWithGenericStringDescribeOutput): any;
export declare class SecretWithGenericStringDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecretWithGenericStringDescribeOutput | undefined;
    set internalValue(value: SecretWithGenericStringDescribeOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get integrationName(): string;
    get name(): string;
    get oauthAccessTokenExpiryTime(): string;
    get oauthRefreshTokenExpiryTime(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get schemaName(): string;
    get secretType(): string;
    get username(): string;
}
export declare class SecretWithGenericStringDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecretWithGenericStringDescribeOutputOutputReference;
}
export interface SecretWithGenericStringShowOutput {
}
export declare function secretWithGenericStringShowOutputToTerraform(struct?: SecretWithGenericStringShowOutput): any;
export declare function secretWithGenericStringShowOutputToHclTerraform(struct?: SecretWithGenericStringShowOutput): any;
export declare class SecretWithGenericStringShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecretWithGenericStringShowOutput | undefined;
    set internalValue(value: SecretWithGenericStringShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get secretType(): string;
}
export declare class SecretWithGenericStringShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecretWithGenericStringShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string snowflake_secret_with_generic_string}
*/
export declare class SecretWithGenericString extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_secret_with_generic_string";
    /**
    * Generates CDKTF code for importing a SecretWithGenericString resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecretWithGenericString to import
    * @param importFromId The id of the existing SecretWithGenericString that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecretWithGenericString to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secret_with_generic_string snowflake_secret_with_generic_string} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretWithGenericStringConfig
    */
    constructor(scope: Construct, id: string, config: SecretWithGenericStringConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): SecretWithGenericStringDescribeOutputList;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _secretString?;
    get secretString(): string;
    set secretString(value: string);
    get secretStringInput(): string | undefined;
    get secretType(): string;
    private _showOutput;
    get showOutput(): SecretWithGenericStringShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
