/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TaskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT_DETACHED_QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#abort_detached_query Task#abort_detached_query}
    */
    readonly abortDetachedQuery?: boolean | cdktf.IResolvable;
    /**
    * Specifies one or more predecessor tasks for the current task. Use this option to [create a DAG](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-task-dag) of tasks or add this task to an existing DAG. A DAG is a series of tasks that starts with a scheduled root task and is linked together by dependencies. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#after Task#after}
    */
    readonly after?: string[];
    /**
    * By default, Snowflake ensures that only one instance of a particular DAG is allowed to run at a time, setting the parameter value to TRUE permits DAG runs to overlap. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#allow_overlapping_execution Task#allow_overlapping_execution}
    */
    readonly allowOverlappingExecution?: string;
    /**
    * Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#autocommit Task#autocommit}
    */
    readonly autocommit?: boolean | cdktf.IResolvable;
    /**
    * The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#binary_input_format Task#binary_input_format}
    */
    readonly binaryInputFormat?: string;
    /**
    * The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#binary_output_format Task#binary_output_format}
    */
    readonly binaryOutputFormat?: string;
    /**
    * Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT_MEMORY_LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#client_memory_limit Task#client_memory_limit}
    */
    readonly clientMemoryLimit?: number;
    /**
    * For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#client_metadata_request_use_connection_ctx Task#client_metadata_request_use_connection_ctx}
    */
    readonly clientMetadataRequestUseConnectionCtx?: boolean | cdktf.IResolvable;
    /**
    * Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT_PREFETCH_THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#client_prefetch_threads Task#client_prefetch_threads}
    */
    readonly clientPrefetchThreads?: number;
    /**
    * Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT_RESULT_CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#client_result_chunk_size Task#client_result_chunk_size}
    */
    readonly clientResultChunkSize?: number;
    /**
    * Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT_RESULT_COLUMN_CASE_INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#client_result_column_case_insensitive Task#client_result_column_case_insensitive}
    */
    readonly clientResultColumnCaseInsensitive?: boolean | cdktf.IResolvable;
    /**
    * Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT_SESSION_KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#client_session_keep_alive Task#client_session_keep_alive}
    */
    readonly clientSessionKeepAlive?: boolean | cdktf.IResolvable;
    /**
    * Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#client_session_keep_alive_heartbeat_frequency Task#client_session_keep_alive_heartbeat_frequency}
    */
    readonly clientSessionKeepAliveHeartbeatFrequency?: number;
    /**
    * Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT_TIMESTAMP_TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#client_timestamp_type_mapping Task#client_timestamp_type_mapping}
    */
    readonly clientTimestampTypeMapping?: string;
    /**
    * Specifies a comment for the task.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#comment Task#comment}
    */
    readonly comment?: string;
    /**
    * Specifies a string representation of key value pairs that can be accessed by all tasks in the task graph. Must be in JSON format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#config Task#config}
    */
    readonly config?: string;
    /**
    * The database in which to create the task. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#database Task#database}
    */
    readonly database: string;
    /**
    * Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#date_input_format Task#date_input_format}
    */
    readonly dateInputFormat?: string;
    /**
    * Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#date_output_format Task#date_output_format}
    */
    readonly dateOutputFormat?: string;
    /**
    * Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE_UNLOAD_PHYSICAL_TYPE_OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#enable_unload_physical_type_optimization Task#enable_unload_physical_type_optimization}
    */
    readonly enableUnloadPhysicalTypeOptimization?: boolean | cdktf.IResolvable;
    /**
    * Specifies the name of the notification integration used for error notifications. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`. For more information about this resource, see [docs](./notification_integration).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#error_integration Task#error_integration}
    */
    readonly errorIntegration?: string;
    /**
    * Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR_ON_NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#error_on_nondeterministic_merge Task#error_on_nondeterministic_merge}
    */
    readonly errorOnNondeterministicMerge?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR_ON_NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#error_on_nondeterministic_update Task#error_on_nondeterministic_update}
    */
    readonly errorOnNondeterministicUpdate?: boolean | cdktf.IResolvable;
    /**
    * Specifies the name of a root task that the finalizer task is associated with. Finalizer tasks run after all other tasks in the task graph run to completion. You can define the SQL of a finalizer task to handle notifications and the release and cleanup of resources that a task graph uses. For more information, see [Release and cleanup of task graphs](https://docs.snowflake.com/en/user-guide/tasks-graphs.html#label-finalizer-task). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#finalize Task#finalize}
    */
    readonly finalize?: string;
    /**
    * Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#geography_output_format Task#geography_output_format}
    */
    readonly geographyOutputFormat?: string;
    /**
    * Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#geometry_output_format Task#geometry_output_format}
    */
    readonly geometryOutputFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#id Task#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies how JDBC processes TIMESTAMP_NTZ values. For more information, check [JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#jdbc_treat_timestamp_ntz_as_utc Task#jdbc_treat_timestamp_ntz_as_utc}
    */
    readonly jdbcTreatTimestampNtzAsUtc?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC_USE_SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#jdbc_use_session_timezone Task#jdbc_use_session_timezone}
    */
    readonly jdbcUseSessionTimezone?: boolean | cdktf.IResolvable;
    /**
    * Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#json_indent Task#json_indent}
    */
    readonly jsonIndent?: number;
    /**
    * Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#lock_timeout Task#lock_timeout}
    */
    readonly lockTimeout?: number;
    /**
    * Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#log_level Task#log_level}
    */
    readonly logLevel?: string;
    /**
    * Number of statements to execute when using the multi-statement capability. For more information, check [MULTI_STATEMENT_COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#multi_statement_count Task#multi_statement_count}
    */
    readonly multiStatementCount?: number;
    /**
    * Specifies the identifier for the task; must be unique for the database and schema in which the task is created. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#name Task#name}
    */
    readonly name: string;
    /**
    * Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER_SEQUENCE_AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#noorder_sequence_as_default Task#noorder_sequence_as_default}
    */
    readonly noorderSequenceAsDefault?: boolean | cdktf.IResolvable;
    /**
    * Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC_TREAT_DECIMAL_AS_INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#odbc_treat_decimal_as_int Task#odbc_treat_decimal_as_int}
    */
    readonly odbcTreatDecimalAsInt?: boolean | cdktf.IResolvable;
    /**
    * Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY_HISTORY, QUERY_HISTORY_BY_*](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#query_tag Task#query_tag}
    */
    readonly queryTag?: string;
    /**
    * Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED_IDENTIFIERS_IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#quoted_identifiers_ignore_case Task#quoted_identifiers_ignore_case}
    */
    readonly quotedIdentifiersIgnoreCase?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS_PER_RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#rows_per_resultset Task#rows_per_resultset}
    */
    readonly rowsPerResultset?: number;
    /**
    * Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3_STAGE_VPCE_DNS_NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#s3_stage_vpce_dns_name Task#s3_stage_vpce_dns_name}
    */
    readonly s3StageVpceDnsName?: string;
    /**
    * The schema in which to create the task. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#schema Task#schema}
    */
    readonly schema: string;
    /**
    * Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#search_path Task#search_path}
    */
    readonly searchPath?: string;
    /**
    * Any single SQL statement, or a call to a stored procedure, executed when the task runs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#sql_statement Task#sql_statement}
    */
    readonly sqlStatement: string;
    /**
    * Specifies if the task should be started or suspended.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#started Task#started}
    */
    readonly started: boolean | cdktf.IResolvable;
    /**
    * Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX_CONCURRENCY_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT_QUEUED_TIMEOUT_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#statement_queued_timeout_in_seconds Task#statement_queued_timeout_in_seconds}
    */
    readonly statementQueuedTimeoutInSeconds?: number;
    /**
    * Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT_TIMEOUT_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#statement_timeout_in_seconds Task#statement_timeout_in_seconds}
    */
    readonly statementTimeoutInSeconds?: number;
    /**
    * This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT_JSON_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#strict_json_output Task#strict_json_output}
    */
    readonly strictJsonOutput?: boolean | cdktf.IResolvable;
    /**
    * Specifies the number of consecutive failed task runs after which the current task is suspended automatically. The default is 0 (no automatic suspension). For more information, check [SUSPEND_TASK_AFTER_NUM_FAILURES docs](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#suspend_task_after_num_failures Task#suspend_task_after_num_failures}
    */
    readonly suspendTaskAfterNumFailures?: number;
    /**
    * Specifies the number of automatic task graph retry attempts. If any task graphs complete in a FAILED state, Snowflake can automatically retry the task graphs from the last task in the graph that failed. For more information, check [TASK_AUTO_RETRY_ATTEMPTS docs](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#task_auto_retry_attempts Task#task_auto_retry_attempts}
    */
    readonly taskAutoRetryAttempts?: number;
    /**
    * Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#time_input_format Task#time_input_format}
    */
    readonly timeInputFormat?: string;
    /**
    * Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#time_output_format Task#time_output_format}
    */
    readonly timeOutputFormat?: string;
    /**
    * Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP_DAY_IS_ALWAYS_24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#timestamp_day_is_always_24h Task#timestamp_day_is_always_24h}
    */
    readonly timestampDayIsAlways24H?: boolean | cdktf.IResolvable;
    /**
    * Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#timestamp_input_format Task#timestamp_input_format}
    */
    readonly timestampInputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP_LTZ data type. If no format is specified, defaults to [TIMESTAMP_OUTPUT_FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_LTZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#timestamp_ltz_output_format Task#timestamp_ltz_output_format}
    */
    readonly timestampLtzOutputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP_NTZ data type. For more information, check [TIMESTAMP_NTZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#timestamp_ntz_output_format Task#timestamp_ntz_output_format}
    */
    readonly timestampNtzOutputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#timestamp_output_format Task#timestamp_output_format}
    */
    readonly timestampOutputFormat?: string;
    /**
    * Specifies the TIMESTAMP_* variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP_TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#timestamp_type_mapping Task#timestamp_type_mapping}
    */
    readonly timestampTypeMapping?: string;
    /**
    * Specifies the display format for the TIMESTAMP_TZ data type. If no format is specified, defaults to [TIMESTAMP_OUTPUT_FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_TZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#timestamp_tz_output_format Task#timestamp_tz_output_format}
    */
    readonly timestampTzOutputFormat?: string;
    /**
    * Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#timezone Task#timezone}
    */
    readonly timezone?: string;
    /**
    * Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#trace_level Task#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION_ABORT_ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#transaction_abort_on_error Task#transaction_abort_on_error}
    */
    readonly transactionAbortOnError?: boolean | cdktf.IResolvable;
    /**
    * Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION_DEFAULT_ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#transaction_default_isolation_level Task#transaction_default_isolation_level}
    */
    readonly transactionDefaultIsolationLevel?: string;
    /**
    * Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO_DIGIT_CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#two_digit_century_start Task#two_digit_century_start}
    */
    readonly twoDigitCenturyStart?: number;
    /**
    * Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED_DDL_ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#unsupported_ddl_action Task#unsupported_ddl_action}
    */
    readonly unsupportedDdlAction?: string;
    /**
    * Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE_CACHED_RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#use_cached_result Task#use_cached_result}
    */
    readonly useCachedResult?: boolean | cdktf.IResolvable;
    /**
    * Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size. Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. Valid values are (case-insensitive): %s. (Conflicts with warehouse). For more information about warehouses, see [docs](./warehouse). For more information, check [USER_TASK_MANAGED_INITIAL_WAREHOUSE_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#user_task_managed_initial_warehouse_size Task#user_task_managed_initial_warehouse_size}
    */
    readonly userTaskManagedInitialWarehouseSize?: string;
    /**
    * Minimum amount of time between Triggered Task executions in seconds For more information, check [USER_TASK_MINIMUM_TRIGGER_INTERVAL_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-minimum-trigger-interval-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#user_task_minimum_trigger_interval_in_seconds Task#user_task_minimum_trigger_interval_in_seconds}
    */
    readonly userTaskMinimumTriggerIntervalInSeconds?: number;
    /**
    * Specifies the time limit on a single run of the task before it times out (in milliseconds). For more information, check [USER_TASK_TIMEOUT_MS docs](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#user_task_timeout_ms Task#user_task_timeout_ms}
    */
    readonly userTaskTimeoutMs?: number;
    /**
    * The warehouse the task will use. Omit this parameter to use Snowflake-managed compute resources for runs of this task. Due to Snowflake limitations warehouse identifier can consist of only upper-cased letters. (Conflicts with user_task_managed_initial_warehouse_size) For more information about this resource, see [docs](./warehouse).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#warehouse Task#warehouse}
    */
    readonly warehouse?: string;
    /**
    * Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK_OF_YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#week_of_year_policy Task#week_of_year_policy}
    */
    readonly weekOfYearPolicy?: number;
    /**
    * Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#week_start Task#week_start}
    */
    readonly weekStart?: number;
    /**
    * Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported. When a task is triggered (based on its SCHEDULE or AFTER setting), it validates the conditions of the expression to determine whether to execute. If the conditions of the expression are not met, then the task skips the current run. Any tasks that identify this task as a predecessor also don’t run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#when Task#when}
    */
    readonly when?: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#schedule Task#schedule}
    */
    readonly schedule?: TaskSchedule;
}
export interface TaskParametersAbortDetachedQuery {
}
export declare function taskParametersAbortDetachedQueryToTerraform(struct?: TaskParametersAbortDetachedQuery): any;
export declare function taskParametersAbortDetachedQueryToHclTerraform(struct?: TaskParametersAbortDetachedQuery): any;
export declare class TaskParametersAbortDetachedQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersAbortDetachedQuery | undefined;
    set internalValue(value: TaskParametersAbortDetachedQuery | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersAbortDetachedQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersAbortDetachedQueryOutputReference;
}
export interface TaskParametersAutocommit {
}
export declare function taskParametersAutocommitToTerraform(struct?: TaskParametersAutocommit): any;
export declare function taskParametersAutocommitToHclTerraform(struct?: TaskParametersAutocommit): any;
export declare class TaskParametersAutocommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersAutocommit | undefined;
    set internalValue(value: TaskParametersAutocommit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersAutocommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersAutocommitOutputReference;
}
export interface TaskParametersBinaryInputFormat {
}
export declare function taskParametersBinaryInputFormatToTerraform(struct?: TaskParametersBinaryInputFormat): any;
export declare function taskParametersBinaryInputFormatToHclTerraform(struct?: TaskParametersBinaryInputFormat): any;
export declare class TaskParametersBinaryInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersBinaryInputFormat | undefined;
    set internalValue(value: TaskParametersBinaryInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersBinaryInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersBinaryInputFormatOutputReference;
}
export interface TaskParametersBinaryOutputFormat {
}
export declare function taskParametersBinaryOutputFormatToTerraform(struct?: TaskParametersBinaryOutputFormat): any;
export declare function taskParametersBinaryOutputFormatToHclTerraform(struct?: TaskParametersBinaryOutputFormat): any;
export declare class TaskParametersBinaryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersBinaryOutputFormat | undefined;
    set internalValue(value: TaskParametersBinaryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersBinaryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersBinaryOutputFormatOutputReference;
}
export interface TaskParametersClientMemoryLimit {
}
export declare function taskParametersClientMemoryLimitToTerraform(struct?: TaskParametersClientMemoryLimit): any;
export declare function taskParametersClientMemoryLimitToHclTerraform(struct?: TaskParametersClientMemoryLimit): any;
export declare class TaskParametersClientMemoryLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersClientMemoryLimit | undefined;
    set internalValue(value: TaskParametersClientMemoryLimit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersClientMemoryLimitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersClientMemoryLimitOutputReference;
}
export interface TaskParametersClientMetadataRequestUseConnectionCtx {
}
export declare function taskParametersClientMetadataRequestUseConnectionCtxToTerraform(struct?: TaskParametersClientMetadataRequestUseConnectionCtx): any;
export declare function taskParametersClientMetadataRequestUseConnectionCtxToHclTerraform(struct?: TaskParametersClientMetadataRequestUseConnectionCtx): any;
export declare class TaskParametersClientMetadataRequestUseConnectionCtxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersClientMetadataRequestUseConnectionCtx | undefined;
    set internalValue(value: TaskParametersClientMetadataRequestUseConnectionCtx | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersClientMetadataRequestUseConnectionCtxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersClientMetadataRequestUseConnectionCtxOutputReference;
}
export interface TaskParametersClientPrefetchThreads {
}
export declare function taskParametersClientPrefetchThreadsToTerraform(struct?: TaskParametersClientPrefetchThreads): any;
export declare function taskParametersClientPrefetchThreadsToHclTerraform(struct?: TaskParametersClientPrefetchThreads): any;
export declare class TaskParametersClientPrefetchThreadsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersClientPrefetchThreads | undefined;
    set internalValue(value: TaskParametersClientPrefetchThreads | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersClientPrefetchThreadsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersClientPrefetchThreadsOutputReference;
}
export interface TaskParametersClientResultChunkSize {
}
export declare function taskParametersClientResultChunkSizeToTerraform(struct?: TaskParametersClientResultChunkSize): any;
export declare function taskParametersClientResultChunkSizeToHclTerraform(struct?: TaskParametersClientResultChunkSize): any;
export declare class TaskParametersClientResultChunkSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersClientResultChunkSize | undefined;
    set internalValue(value: TaskParametersClientResultChunkSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersClientResultChunkSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersClientResultChunkSizeOutputReference;
}
export interface TaskParametersClientResultColumnCaseInsensitive {
}
export declare function taskParametersClientResultColumnCaseInsensitiveToTerraform(struct?: TaskParametersClientResultColumnCaseInsensitive): any;
export declare function taskParametersClientResultColumnCaseInsensitiveToHclTerraform(struct?: TaskParametersClientResultColumnCaseInsensitive): any;
export declare class TaskParametersClientResultColumnCaseInsensitiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersClientResultColumnCaseInsensitive | undefined;
    set internalValue(value: TaskParametersClientResultColumnCaseInsensitive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersClientResultColumnCaseInsensitiveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersClientResultColumnCaseInsensitiveOutputReference;
}
export interface TaskParametersClientSessionKeepAlive {
}
export declare function taskParametersClientSessionKeepAliveToTerraform(struct?: TaskParametersClientSessionKeepAlive): any;
export declare function taskParametersClientSessionKeepAliveToHclTerraform(struct?: TaskParametersClientSessionKeepAlive): any;
export declare class TaskParametersClientSessionKeepAliveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersClientSessionKeepAlive | undefined;
    set internalValue(value: TaskParametersClientSessionKeepAlive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersClientSessionKeepAliveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersClientSessionKeepAliveOutputReference;
}
export interface TaskParametersClientSessionKeepAliveHeartbeatFrequency {
}
export declare function taskParametersClientSessionKeepAliveHeartbeatFrequencyToTerraform(struct?: TaskParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare function taskParametersClientSessionKeepAliveHeartbeatFrequencyToHclTerraform(struct?: TaskParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare class TaskParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersClientSessionKeepAliveHeartbeatFrequency | undefined;
    set internalValue(value: TaskParametersClientSessionKeepAliveHeartbeatFrequency | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersClientSessionKeepAliveHeartbeatFrequencyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference;
}
export interface TaskParametersClientTimestampTypeMapping {
}
export declare function taskParametersClientTimestampTypeMappingToTerraform(struct?: TaskParametersClientTimestampTypeMapping): any;
export declare function taskParametersClientTimestampTypeMappingToHclTerraform(struct?: TaskParametersClientTimestampTypeMapping): any;
export declare class TaskParametersClientTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersClientTimestampTypeMapping | undefined;
    set internalValue(value: TaskParametersClientTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersClientTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersClientTimestampTypeMappingOutputReference;
}
export interface TaskParametersDateInputFormat {
}
export declare function taskParametersDateInputFormatToTerraform(struct?: TaskParametersDateInputFormat): any;
export declare function taskParametersDateInputFormatToHclTerraform(struct?: TaskParametersDateInputFormat): any;
export declare class TaskParametersDateInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersDateInputFormat | undefined;
    set internalValue(value: TaskParametersDateInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersDateInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersDateInputFormatOutputReference;
}
export interface TaskParametersDateOutputFormat {
}
export declare function taskParametersDateOutputFormatToTerraform(struct?: TaskParametersDateOutputFormat): any;
export declare function taskParametersDateOutputFormatToHclTerraform(struct?: TaskParametersDateOutputFormat): any;
export declare class TaskParametersDateOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersDateOutputFormat | undefined;
    set internalValue(value: TaskParametersDateOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersDateOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersDateOutputFormatOutputReference;
}
export interface TaskParametersEnableUnloadPhysicalTypeOptimization {
}
export declare function taskParametersEnableUnloadPhysicalTypeOptimizationToTerraform(struct?: TaskParametersEnableUnloadPhysicalTypeOptimization): any;
export declare function taskParametersEnableUnloadPhysicalTypeOptimizationToHclTerraform(struct?: TaskParametersEnableUnloadPhysicalTypeOptimization): any;
export declare class TaskParametersEnableUnloadPhysicalTypeOptimizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersEnableUnloadPhysicalTypeOptimization | undefined;
    set internalValue(value: TaskParametersEnableUnloadPhysicalTypeOptimization | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersEnableUnloadPhysicalTypeOptimizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersEnableUnloadPhysicalTypeOptimizationOutputReference;
}
export interface TaskParametersErrorOnNondeterministicMerge {
}
export declare function taskParametersErrorOnNondeterministicMergeToTerraform(struct?: TaskParametersErrorOnNondeterministicMerge): any;
export declare function taskParametersErrorOnNondeterministicMergeToHclTerraform(struct?: TaskParametersErrorOnNondeterministicMerge): any;
export declare class TaskParametersErrorOnNondeterministicMergeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersErrorOnNondeterministicMerge | undefined;
    set internalValue(value: TaskParametersErrorOnNondeterministicMerge | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersErrorOnNondeterministicMergeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersErrorOnNondeterministicMergeOutputReference;
}
export interface TaskParametersErrorOnNondeterministicUpdate {
}
export declare function taskParametersErrorOnNondeterministicUpdateToTerraform(struct?: TaskParametersErrorOnNondeterministicUpdate): any;
export declare function taskParametersErrorOnNondeterministicUpdateToHclTerraform(struct?: TaskParametersErrorOnNondeterministicUpdate): any;
export declare class TaskParametersErrorOnNondeterministicUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersErrorOnNondeterministicUpdate | undefined;
    set internalValue(value: TaskParametersErrorOnNondeterministicUpdate | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersErrorOnNondeterministicUpdateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersErrorOnNondeterministicUpdateOutputReference;
}
export interface TaskParametersGeographyOutputFormat {
}
export declare function taskParametersGeographyOutputFormatToTerraform(struct?: TaskParametersGeographyOutputFormat): any;
export declare function taskParametersGeographyOutputFormatToHclTerraform(struct?: TaskParametersGeographyOutputFormat): any;
export declare class TaskParametersGeographyOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersGeographyOutputFormat | undefined;
    set internalValue(value: TaskParametersGeographyOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersGeographyOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersGeographyOutputFormatOutputReference;
}
export interface TaskParametersGeometryOutputFormat {
}
export declare function taskParametersGeometryOutputFormatToTerraform(struct?: TaskParametersGeometryOutputFormat): any;
export declare function taskParametersGeometryOutputFormatToHclTerraform(struct?: TaskParametersGeometryOutputFormat): any;
export declare class TaskParametersGeometryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersGeometryOutputFormat | undefined;
    set internalValue(value: TaskParametersGeometryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersGeometryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersGeometryOutputFormatOutputReference;
}
export interface TaskParametersJdbcTreatTimestampNtzAsUtc {
}
export declare function taskParametersJdbcTreatTimestampNtzAsUtcToTerraform(struct?: TaskParametersJdbcTreatTimestampNtzAsUtc): any;
export declare function taskParametersJdbcTreatTimestampNtzAsUtcToHclTerraform(struct?: TaskParametersJdbcTreatTimestampNtzAsUtc): any;
export declare class TaskParametersJdbcTreatTimestampNtzAsUtcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersJdbcTreatTimestampNtzAsUtc | undefined;
    set internalValue(value: TaskParametersJdbcTreatTimestampNtzAsUtc | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersJdbcTreatTimestampNtzAsUtcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersJdbcTreatTimestampNtzAsUtcOutputReference;
}
export interface TaskParametersJdbcUseSessionTimezone {
}
export declare function taskParametersJdbcUseSessionTimezoneToTerraform(struct?: TaskParametersJdbcUseSessionTimezone): any;
export declare function taskParametersJdbcUseSessionTimezoneToHclTerraform(struct?: TaskParametersJdbcUseSessionTimezone): any;
export declare class TaskParametersJdbcUseSessionTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersJdbcUseSessionTimezone | undefined;
    set internalValue(value: TaskParametersJdbcUseSessionTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersJdbcUseSessionTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersJdbcUseSessionTimezoneOutputReference;
}
export interface TaskParametersJsonIndent {
}
export declare function taskParametersJsonIndentToTerraform(struct?: TaskParametersJsonIndent): any;
export declare function taskParametersJsonIndentToHclTerraform(struct?: TaskParametersJsonIndent): any;
export declare class TaskParametersJsonIndentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersJsonIndent | undefined;
    set internalValue(value: TaskParametersJsonIndent | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersJsonIndentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersJsonIndentOutputReference;
}
export interface TaskParametersLockTimeout {
}
export declare function taskParametersLockTimeoutToTerraform(struct?: TaskParametersLockTimeout): any;
export declare function taskParametersLockTimeoutToHclTerraform(struct?: TaskParametersLockTimeout): any;
export declare class TaskParametersLockTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersLockTimeout | undefined;
    set internalValue(value: TaskParametersLockTimeout | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersLockTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersLockTimeoutOutputReference;
}
export interface TaskParametersLogLevel {
}
export declare function taskParametersLogLevelToTerraform(struct?: TaskParametersLogLevel): any;
export declare function taskParametersLogLevelToHclTerraform(struct?: TaskParametersLogLevel): any;
export declare class TaskParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersLogLevel | undefined;
    set internalValue(value: TaskParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersLogLevelOutputReference;
}
export interface TaskParametersMultiStatementCount {
}
export declare function taskParametersMultiStatementCountToTerraform(struct?: TaskParametersMultiStatementCount): any;
export declare function taskParametersMultiStatementCountToHclTerraform(struct?: TaskParametersMultiStatementCount): any;
export declare class TaskParametersMultiStatementCountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersMultiStatementCount | undefined;
    set internalValue(value: TaskParametersMultiStatementCount | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersMultiStatementCountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersMultiStatementCountOutputReference;
}
export interface TaskParametersNoorderSequenceAsDefault {
}
export declare function taskParametersNoorderSequenceAsDefaultToTerraform(struct?: TaskParametersNoorderSequenceAsDefault): any;
export declare function taskParametersNoorderSequenceAsDefaultToHclTerraform(struct?: TaskParametersNoorderSequenceAsDefault): any;
export declare class TaskParametersNoorderSequenceAsDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersNoorderSequenceAsDefault | undefined;
    set internalValue(value: TaskParametersNoorderSequenceAsDefault | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersNoorderSequenceAsDefaultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersNoorderSequenceAsDefaultOutputReference;
}
export interface TaskParametersOdbcTreatDecimalAsInt {
}
export declare function taskParametersOdbcTreatDecimalAsIntToTerraform(struct?: TaskParametersOdbcTreatDecimalAsInt): any;
export declare function taskParametersOdbcTreatDecimalAsIntToHclTerraform(struct?: TaskParametersOdbcTreatDecimalAsInt): any;
export declare class TaskParametersOdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersOdbcTreatDecimalAsInt | undefined;
    set internalValue(value: TaskParametersOdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersOdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersOdbcTreatDecimalAsIntOutputReference;
}
export interface TaskParametersQueryTag {
}
export declare function taskParametersQueryTagToTerraform(struct?: TaskParametersQueryTag): any;
export declare function taskParametersQueryTagToHclTerraform(struct?: TaskParametersQueryTag): any;
export declare class TaskParametersQueryTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersQueryTag | undefined;
    set internalValue(value: TaskParametersQueryTag | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersQueryTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersQueryTagOutputReference;
}
export interface TaskParametersQuotedIdentifiersIgnoreCase {
}
export declare function taskParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: TaskParametersQuotedIdentifiersIgnoreCase): any;
export declare function taskParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: TaskParametersQuotedIdentifiersIgnoreCase): any;
export declare class TaskParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: TaskParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface TaskParametersRowsPerResultset {
}
export declare function taskParametersRowsPerResultsetToTerraform(struct?: TaskParametersRowsPerResultset): any;
export declare function taskParametersRowsPerResultsetToHclTerraform(struct?: TaskParametersRowsPerResultset): any;
export declare class TaskParametersRowsPerResultsetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersRowsPerResultset | undefined;
    set internalValue(value: TaskParametersRowsPerResultset | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersRowsPerResultsetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersRowsPerResultsetOutputReference;
}
export interface TaskParametersS3StageVpceDnsName {
}
export declare function taskParametersS3StageVpceDnsNameToTerraform(struct?: TaskParametersS3StageVpceDnsName): any;
export declare function taskParametersS3StageVpceDnsNameToHclTerraform(struct?: TaskParametersS3StageVpceDnsName): any;
export declare class TaskParametersS3StageVpceDnsNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersS3StageVpceDnsName | undefined;
    set internalValue(value: TaskParametersS3StageVpceDnsName | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersS3StageVpceDnsNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersS3StageVpceDnsNameOutputReference;
}
export interface TaskParametersSearchPath {
}
export declare function taskParametersSearchPathToTerraform(struct?: TaskParametersSearchPath): any;
export declare function taskParametersSearchPathToHclTerraform(struct?: TaskParametersSearchPath): any;
export declare class TaskParametersSearchPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersSearchPath | undefined;
    set internalValue(value: TaskParametersSearchPath | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersSearchPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersSearchPathOutputReference;
}
export interface TaskParametersStatementQueuedTimeoutInSeconds {
}
export declare function taskParametersStatementQueuedTimeoutInSecondsToTerraform(struct?: TaskParametersStatementQueuedTimeoutInSeconds): any;
export declare function taskParametersStatementQueuedTimeoutInSecondsToHclTerraform(struct?: TaskParametersStatementQueuedTimeoutInSeconds): any;
export declare class TaskParametersStatementQueuedTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersStatementQueuedTimeoutInSeconds | undefined;
    set internalValue(value: TaskParametersStatementQueuedTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersStatementQueuedTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersStatementQueuedTimeoutInSecondsOutputReference;
}
export interface TaskParametersStatementTimeoutInSeconds {
}
export declare function taskParametersStatementTimeoutInSecondsToTerraform(struct?: TaskParametersStatementTimeoutInSeconds): any;
export declare function taskParametersStatementTimeoutInSecondsToHclTerraform(struct?: TaskParametersStatementTimeoutInSeconds): any;
export declare class TaskParametersStatementTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersStatementTimeoutInSeconds | undefined;
    set internalValue(value: TaskParametersStatementTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersStatementTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersStatementTimeoutInSecondsOutputReference;
}
export interface TaskParametersStrictJsonOutput {
}
export declare function taskParametersStrictJsonOutputToTerraform(struct?: TaskParametersStrictJsonOutput): any;
export declare function taskParametersStrictJsonOutputToHclTerraform(struct?: TaskParametersStrictJsonOutput): any;
export declare class TaskParametersStrictJsonOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersStrictJsonOutput | undefined;
    set internalValue(value: TaskParametersStrictJsonOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersStrictJsonOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersStrictJsonOutputOutputReference;
}
export interface TaskParametersSuspendTaskAfterNumFailures {
}
export declare function taskParametersSuspendTaskAfterNumFailuresToTerraform(struct?: TaskParametersSuspendTaskAfterNumFailures): any;
export declare function taskParametersSuspendTaskAfterNumFailuresToHclTerraform(struct?: TaskParametersSuspendTaskAfterNumFailures): any;
export declare class TaskParametersSuspendTaskAfterNumFailuresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersSuspendTaskAfterNumFailures | undefined;
    set internalValue(value: TaskParametersSuspendTaskAfterNumFailures | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersSuspendTaskAfterNumFailuresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersSuspendTaskAfterNumFailuresOutputReference;
}
export interface TaskParametersTaskAutoRetryAttempts {
}
export declare function taskParametersTaskAutoRetryAttemptsToTerraform(struct?: TaskParametersTaskAutoRetryAttempts): any;
export declare function taskParametersTaskAutoRetryAttemptsToHclTerraform(struct?: TaskParametersTaskAutoRetryAttempts): any;
export declare class TaskParametersTaskAutoRetryAttemptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTaskAutoRetryAttempts | undefined;
    set internalValue(value: TaskParametersTaskAutoRetryAttempts | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTaskAutoRetryAttemptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTaskAutoRetryAttemptsOutputReference;
}
export interface TaskParametersTimeInputFormat {
}
export declare function taskParametersTimeInputFormatToTerraform(struct?: TaskParametersTimeInputFormat): any;
export declare function taskParametersTimeInputFormatToHclTerraform(struct?: TaskParametersTimeInputFormat): any;
export declare class TaskParametersTimeInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimeInputFormat | undefined;
    set internalValue(value: TaskParametersTimeInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimeInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimeInputFormatOutputReference;
}
export interface TaskParametersTimeOutputFormat {
}
export declare function taskParametersTimeOutputFormatToTerraform(struct?: TaskParametersTimeOutputFormat): any;
export declare function taskParametersTimeOutputFormatToHclTerraform(struct?: TaskParametersTimeOutputFormat): any;
export declare class TaskParametersTimeOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimeOutputFormat | undefined;
    set internalValue(value: TaskParametersTimeOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimeOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimeOutputFormatOutputReference;
}
export interface TaskParametersTimestampDayIsAlways24H {
}
export declare function taskParametersTimestampDayIsAlways24HToTerraform(struct?: TaskParametersTimestampDayIsAlways24H): any;
export declare function taskParametersTimestampDayIsAlways24HToHclTerraform(struct?: TaskParametersTimestampDayIsAlways24H): any;
export declare class TaskParametersTimestampDayIsAlways24HOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimestampDayIsAlways24H | undefined;
    set internalValue(value: TaskParametersTimestampDayIsAlways24H | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimestampDayIsAlways24HList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimestampDayIsAlways24HOutputReference;
}
export interface TaskParametersTimestampInputFormat {
}
export declare function taskParametersTimestampInputFormatToTerraform(struct?: TaskParametersTimestampInputFormat): any;
export declare function taskParametersTimestampInputFormatToHclTerraform(struct?: TaskParametersTimestampInputFormat): any;
export declare class TaskParametersTimestampInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimestampInputFormat | undefined;
    set internalValue(value: TaskParametersTimestampInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimestampInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimestampInputFormatOutputReference;
}
export interface TaskParametersTimestampLtzOutputFormat {
}
export declare function taskParametersTimestampLtzOutputFormatToTerraform(struct?: TaskParametersTimestampLtzOutputFormat): any;
export declare function taskParametersTimestampLtzOutputFormatToHclTerraform(struct?: TaskParametersTimestampLtzOutputFormat): any;
export declare class TaskParametersTimestampLtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimestampLtzOutputFormat | undefined;
    set internalValue(value: TaskParametersTimestampLtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimestampLtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimestampLtzOutputFormatOutputReference;
}
export interface TaskParametersTimestampNtzOutputFormat {
}
export declare function taskParametersTimestampNtzOutputFormatToTerraform(struct?: TaskParametersTimestampNtzOutputFormat): any;
export declare function taskParametersTimestampNtzOutputFormatToHclTerraform(struct?: TaskParametersTimestampNtzOutputFormat): any;
export declare class TaskParametersTimestampNtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimestampNtzOutputFormat | undefined;
    set internalValue(value: TaskParametersTimestampNtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimestampNtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimestampNtzOutputFormatOutputReference;
}
export interface TaskParametersTimestampOutputFormat {
}
export declare function taskParametersTimestampOutputFormatToTerraform(struct?: TaskParametersTimestampOutputFormat): any;
export declare function taskParametersTimestampOutputFormatToHclTerraform(struct?: TaskParametersTimestampOutputFormat): any;
export declare class TaskParametersTimestampOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimestampOutputFormat | undefined;
    set internalValue(value: TaskParametersTimestampOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimestampOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimestampOutputFormatOutputReference;
}
export interface TaskParametersTimestampTypeMapping {
}
export declare function taskParametersTimestampTypeMappingToTerraform(struct?: TaskParametersTimestampTypeMapping): any;
export declare function taskParametersTimestampTypeMappingToHclTerraform(struct?: TaskParametersTimestampTypeMapping): any;
export declare class TaskParametersTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimestampTypeMapping | undefined;
    set internalValue(value: TaskParametersTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimestampTypeMappingOutputReference;
}
export interface TaskParametersTimestampTzOutputFormat {
}
export declare function taskParametersTimestampTzOutputFormatToTerraform(struct?: TaskParametersTimestampTzOutputFormat): any;
export declare function taskParametersTimestampTzOutputFormatToHclTerraform(struct?: TaskParametersTimestampTzOutputFormat): any;
export declare class TaskParametersTimestampTzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimestampTzOutputFormat | undefined;
    set internalValue(value: TaskParametersTimestampTzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimestampTzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimestampTzOutputFormatOutputReference;
}
export interface TaskParametersTimezone {
}
export declare function taskParametersTimezoneToTerraform(struct?: TaskParametersTimezone): any;
export declare function taskParametersTimezoneToHclTerraform(struct?: TaskParametersTimezone): any;
export declare class TaskParametersTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTimezone | undefined;
    set internalValue(value: TaskParametersTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTimezoneOutputReference;
}
export interface TaskParametersTraceLevel {
}
export declare function taskParametersTraceLevelToTerraform(struct?: TaskParametersTraceLevel): any;
export declare function taskParametersTraceLevelToHclTerraform(struct?: TaskParametersTraceLevel): any;
export declare class TaskParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTraceLevel | undefined;
    set internalValue(value: TaskParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTraceLevelOutputReference;
}
export interface TaskParametersTransactionAbortOnError {
}
export declare function taskParametersTransactionAbortOnErrorToTerraform(struct?: TaskParametersTransactionAbortOnError): any;
export declare function taskParametersTransactionAbortOnErrorToHclTerraform(struct?: TaskParametersTransactionAbortOnError): any;
export declare class TaskParametersTransactionAbortOnErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTransactionAbortOnError | undefined;
    set internalValue(value: TaskParametersTransactionAbortOnError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTransactionAbortOnErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTransactionAbortOnErrorOutputReference;
}
export interface TaskParametersTransactionDefaultIsolationLevel {
}
export declare function taskParametersTransactionDefaultIsolationLevelToTerraform(struct?: TaskParametersTransactionDefaultIsolationLevel): any;
export declare function taskParametersTransactionDefaultIsolationLevelToHclTerraform(struct?: TaskParametersTransactionDefaultIsolationLevel): any;
export declare class TaskParametersTransactionDefaultIsolationLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTransactionDefaultIsolationLevel | undefined;
    set internalValue(value: TaskParametersTransactionDefaultIsolationLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTransactionDefaultIsolationLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTransactionDefaultIsolationLevelOutputReference;
}
export interface TaskParametersTwoDigitCenturyStart {
}
export declare function taskParametersTwoDigitCenturyStartToTerraform(struct?: TaskParametersTwoDigitCenturyStart): any;
export declare function taskParametersTwoDigitCenturyStartToHclTerraform(struct?: TaskParametersTwoDigitCenturyStart): any;
export declare class TaskParametersTwoDigitCenturyStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersTwoDigitCenturyStart | undefined;
    set internalValue(value: TaskParametersTwoDigitCenturyStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersTwoDigitCenturyStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersTwoDigitCenturyStartOutputReference;
}
export interface TaskParametersUnsupportedDdlAction {
}
export declare function taskParametersUnsupportedDdlActionToTerraform(struct?: TaskParametersUnsupportedDdlAction): any;
export declare function taskParametersUnsupportedDdlActionToHclTerraform(struct?: TaskParametersUnsupportedDdlAction): any;
export declare class TaskParametersUnsupportedDdlActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersUnsupportedDdlAction | undefined;
    set internalValue(value: TaskParametersUnsupportedDdlAction | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersUnsupportedDdlActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersUnsupportedDdlActionOutputReference;
}
export interface TaskParametersUseCachedResult {
}
export declare function taskParametersUseCachedResultToTerraform(struct?: TaskParametersUseCachedResult): any;
export declare function taskParametersUseCachedResultToHclTerraform(struct?: TaskParametersUseCachedResult): any;
export declare class TaskParametersUseCachedResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersUseCachedResult | undefined;
    set internalValue(value: TaskParametersUseCachedResult | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersUseCachedResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersUseCachedResultOutputReference;
}
export interface TaskParametersUserTaskManagedInitialWarehouseSize {
}
export declare function taskParametersUserTaskManagedInitialWarehouseSizeToTerraform(struct?: TaskParametersUserTaskManagedInitialWarehouseSize): any;
export declare function taskParametersUserTaskManagedInitialWarehouseSizeToHclTerraform(struct?: TaskParametersUserTaskManagedInitialWarehouseSize): any;
export declare class TaskParametersUserTaskManagedInitialWarehouseSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersUserTaskManagedInitialWarehouseSize | undefined;
    set internalValue(value: TaskParametersUserTaskManagedInitialWarehouseSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersUserTaskManagedInitialWarehouseSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersUserTaskManagedInitialWarehouseSizeOutputReference;
}
export interface TaskParametersUserTaskMinimumTriggerIntervalInSeconds {
}
export declare function taskParametersUserTaskMinimumTriggerIntervalInSecondsToTerraform(struct?: TaskParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare function taskParametersUserTaskMinimumTriggerIntervalInSecondsToHclTerraform(struct?: TaskParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare class TaskParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersUserTaskMinimumTriggerIntervalInSeconds | undefined;
    set internalValue(value: TaskParametersUserTaskMinimumTriggerIntervalInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersUserTaskMinimumTriggerIntervalInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference;
}
export interface TaskParametersUserTaskTimeoutMs {
}
export declare function taskParametersUserTaskTimeoutMsToTerraform(struct?: TaskParametersUserTaskTimeoutMs): any;
export declare function taskParametersUserTaskTimeoutMsToHclTerraform(struct?: TaskParametersUserTaskTimeoutMs): any;
export declare class TaskParametersUserTaskTimeoutMsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersUserTaskTimeoutMs | undefined;
    set internalValue(value: TaskParametersUserTaskTimeoutMs | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersUserTaskTimeoutMsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersUserTaskTimeoutMsOutputReference;
}
export interface TaskParametersWeekOfYearPolicy {
}
export declare function taskParametersWeekOfYearPolicyToTerraform(struct?: TaskParametersWeekOfYearPolicy): any;
export declare function taskParametersWeekOfYearPolicyToHclTerraform(struct?: TaskParametersWeekOfYearPolicy): any;
export declare class TaskParametersWeekOfYearPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersWeekOfYearPolicy | undefined;
    set internalValue(value: TaskParametersWeekOfYearPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersWeekOfYearPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersWeekOfYearPolicyOutputReference;
}
export interface TaskParametersWeekStart {
}
export declare function taskParametersWeekStartToTerraform(struct?: TaskParametersWeekStart): any;
export declare function taskParametersWeekStartToHclTerraform(struct?: TaskParametersWeekStart): any;
export declare class TaskParametersWeekStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParametersWeekStart | undefined;
    set internalValue(value: TaskParametersWeekStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class TaskParametersWeekStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersWeekStartOutputReference;
}
export interface TaskParameters {
}
export declare function taskParametersToTerraform(struct?: TaskParameters): any;
export declare function taskParametersToHclTerraform(struct?: TaskParameters): any;
export declare class TaskParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskParameters | undefined;
    set internalValue(value: TaskParameters | undefined);
    private _abortDetachedQuery;
    get abortDetachedQuery(): TaskParametersAbortDetachedQueryList;
    private _autocommit;
    get autocommit(): TaskParametersAutocommitList;
    private _binaryInputFormat;
    get binaryInputFormat(): TaskParametersBinaryInputFormatList;
    private _binaryOutputFormat;
    get binaryOutputFormat(): TaskParametersBinaryOutputFormatList;
    private _clientMemoryLimit;
    get clientMemoryLimit(): TaskParametersClientMemoryLimitList;
    private _clientMetadataRequestUseConnectionCtx;
    get clientMetadataRequestUseConnectionCtx(): TaskParametersClientMetadataRequestUseConnectionCtxList;
    private _clientPrefetchThreads;
    get clientPrefetchThreads(): TaskParametersClientPrefetchThreadsList;
    private _clientResultChunkSize;
    get clientResultChunkSize(): TaskParametersClientResultChunkSizeList;
    private _clientResultColumnCaseInsensitive;
    get clientResultColumnCaseInsensitive(): TaskParametersClientResultColumnCaseInsensitiveList;
    private _clientSessionKeepAlive;
    get clientSessionKeepAlive(): TaskParametersClientSessionKeepAliveList;
    private _clientSessionKeepAliveHeartbeatFrequency;
    get clientSessionKeepAliveHeartbeatFrequency(): TaskParametersClientSessionKeepAliveHeartbeatFrequencyList;
    private _clientTimestampTypeMapping;
    get clientTimestampTypeMapping(): TaskParametersClientTimestampTypeMappingList;
    private _dateInputFormat;
    get dateInputFormat(): TaskParametersDateInputFormatList;
    private _dateOutputFormat;
    get dateOutputFormat(): TaskParametersDateOutputFormatList;
    private _enableUnloadPhysicalTypeOptimization;
    get enableUnloadPhysicalTypeOptimization(): TaskParametersEnableUnloadPhysicalTypeOptimizationList;
    private _errorOnNondeterministicMerge;
    get errorOnNondeterministicMerge(): TaskParametersErrorOnNondeterministicMergeList;
    private _errorOnNondeterministicUpdate;
    get errorOnNondeterministicUpdate(): TaskParametersErrorOnNondeterministicUpdateList;
    private _geographyOutputFormat;
    get geographyOutputFormat(): TaskParametersGeographyOutputFormatList;
    private _geometryOutputFormat;
    get geometryOutputFormat(): TaskParametersGeometryOutputFormatList;
    private _jdbcTreatTimestampNtzAsUtc;
    get jdbcTreatTimestampNtzAsUtc(): TaskParametersJdbcTreatTimestampNtzAsUtcList;
    private _jdbcUseSessionTimezone;
    get jdbcUseSessionTimezone(): TaskParametersJdbcUseSessionTimezoneList;
    private _jsonIndent;
    get jsonIndent(): TaskParametersJsonIndentList;
    private _lockTimeout;
    get lockTimeout(): TaskParametersLockTimeoutList;
    private _logLevel;
    get logLevel(): TaskParametersLogLevelList;
    private _multiStatementCount;
    get multiStatementCount(): TaskParametersMultiStatementCountList;
    private _noorderSequenceAsDefault;
    get noorderSequenceAsDefault(): TaskParametersNoorderSequenceAsDefaultList;
    private _odbcTreatDecimalAsInt;
    get odbcTreatDecimalAsInt(): TaskParametersOdbcTreatDecimalAsIntList;
    private _queryTag;
    get queryTag(): TaskParametersQueryTagList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): TaskParametersQuotedIdentifiersIgnoreCaseList;
    private _rowsPerResultset;
    get rowsPerResultset(): TaskParametersRowsPerResultsetList;
    private _s3StageVpceDnsName;
    get s3StageVpceDnsName(): TaskParametersS3StageVpceDnsNameList;
    private _searchPath;
    get searchPath(): TaskParametersSearchPathList;
    private _statementQueuedTimeoutInSeconds;
    get statementQueuedTimeoutInSeconds(): TaskParametersStatementQueuedTimeoutInSecondsList;
    private _statementTimeoutInSeconds;
    get statementTimeoutInSeconds(): TaskParametersStatementTimeoutInSecondsList;
    private _strictJsonOutput;
    get strictJsonOutput(): TaskParametersStrictJsonOutputList;
    private _suspendTaskAfterNumFailures;
    get suspendTaskAfterNumFailures(): TaskParametersSuspendTaskAfterNumFailuresList;
    private _taskAutoRetryAttempts;
    get taskAutoRetryAttempts(): TaskParametersTaskAutoRetryAttemptsList;
    private _timeInputFormat;
    get timeInputFormat(): TaskParametersTimeInputFormatList;
    private _timeOutputFormat;
    get timeOutputFormat(): TaskParametersTimeOutputFormatList;
    private _timestampDayIsAlways24H;
    get timestampDayIsAlways24H(): TaskParametersTimestampDayIsAlways24HList;
    private _timestampInputFormat;
    get timestampInputFormat(): TaskParametersTimestampInputFormatList;
    private _timestampLtzOutputFormat;
    get timestampLtzOutputFormat(): TaskParametersTimestampLtzOutputFormatList;
    private _timestampNtzOutputFormat;
    get timestampNtzOutputFormat(): TaskParametersTimestampNtzOutputFormatList;
    private _timestampOutputFormat;
    get timestampOutputFormat(): TaskParametersTimestampOutputFormatList;
    private _timestampTypeMapping;
    get timestampTypeMapping(): TaskParametersTimestampTypeMappingList;
    private _timestampTzOutputFormat;
    get timestampTzOutputFormat(): TaskParametersTimestampTzOutputFormatList;
    private _timezone;
    get timezone(): TaskParametersTimezoneList;
    private _traceLevel;
    get traceLevel(): TaskParametersTraceLevelList;
    private _transactionAbortOnError;
    get transactionAbortOnError(): TaskParametersTransactionAbortOnErrorList;
    private _transactionDefaultIsolationLevel;
    get transactionDefaultIsolationLevel(): TaskParametersTransactionDefaultIsolationLevelList;
    private _twoDigitCenturyStart;
    get twoDigitCenturyStart(): TaskParametersTwoDigitCenturyStartList;
    private _unsupportedDdlAction;
    get unsupportedDdlAction(): TaskParametersUnsupportedDdlActionList;
    private _useCachedResult;
    get useCachedResult(): TaskParametersUseCachedResultList;
    private _userTaskManagedInitialWarehouseSize;
    get userTaskManagedInitialWarehouseSize(): TaskParametersUserTaskManagedInitialWarehouseSizeList;
    private _userTaskMinimumTriggerIntervalInSeconds;
    get userTaskMinimumTriggerIntervalInSeconds(): TaskParametersUserTaskMinimumTriggerIntervalInSecondsList;
    private _userTaskTimeoutMs;
    get userTaskTimeoutMs(): TaskParametersUserTaskTimeoutMsList;
    private _weekOfYearPolicy;
    get weekOfYearPolicy(): TaskParametersWeekOfYearPolicyList;
    private _weekStart;
    get weekStart(): TaskParametersWeekStartList;
}
export declare class TaskParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskParametersOutputReference;
}
export interface TaskShowOutputTaskRelations {
}
export declare function taskShowOutputTaskRelationsToTerraform(struct?: TaskShowOutputTaskRelations): any;
export declare function taskShowOutputTaskRelationsToHclTerraform(struct?: TaskShowOutputTaskRelations): any;
export declare class TaskShowOutputTaskRelationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskShowOutputTaskRelations | undefined;
    set internalValue(value: TaskShowOutputTaskRelations | undefined);
    get finalizedRootTask(): string;
    get finalizer(): string;
    get predecessors(): string[];
}
export declare class TaskShowOutputTaskRelationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskShowOutputTaskRelationsOutputReference;
}
export interface TaskShowOutput {
}
export declare function taskShowOutputToTerraform(struct?: TaskShowOutput): any;
export declare function taskShowOutputToHclTerraform(struct?: TaskShowOutput): any;
export declare class TaskShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): TaskShowOutput | undefined;
    set internalValue(value: TaskShowOutput | undefined);
    get allowOverlappingExecution(): cdktf.IResolvable;
    get budget(): string;
    get comment(): string;
    get condition(): string;
    get config(): string;
    get createdOn(): string;
    get databaseName(): string;
    get definition(): string;
    get errorIntegration(): string;
    get id(): string;
    get lastCommittedOn(): string;
    get lastSuspendedOn(): string;
    get lastSuspendedReason(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get predecessors(): string[];
    get schedule(): string;
    get schemaName(): string;
    get state(): string;
    private _taskRelations;
    get taskRelations(): TaskShowOutputTaskRelationsList;
    get warehouse(): string;
}
export declare class TaskShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): TaskShowOutputOutputReference;
}
export interface TaskSchedule {
    /**
    * Specifies an interval (in minutes) of wait time inserted between runs of the task. Accepts positive integers only. (conflicts with `using_cron`)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#minutes Task#minutes}
    */
    readonly minutes?: number;
    /**
    * Specifies a cron expression and time zone for periodically running the task. Supports a subset of standard cron utility syntax. (conflicts with `minutes`)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#using_cron Task#using_cron}
    */
    readonly usingCron?: string;
}
export declare function taskScheduleToTerraform(struct?: TaskScheduleOutputReference | TaskSchedule): any;
export declare function taskScheduleToHclTerraform(struct?: TaskScheduleOutputReference | TaskSchedule): any;
export declare class TaskScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TaskSchedule | undefined;
    set internalValue(value: TaskSchedule | undefined);
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _usingCron?;
    get usingCron(): string;
    set usingCron(value: string);
    resetUsingCron(): void;
    get usingCronInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task snowflake_task}
*/
export declare class Task extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_task";
    /**
    * Generates CDKTF code for importing a Task resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Task to import
    * @param importFromId The id of the existing Task that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Task to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/task snowflake_task} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TaskConfig
    */
    constructor(scope: Construct, id: string, config: TaskConfig);
    private _abortDetachedQuery?;
    get abortDetachedQuery(): boolean | cdktf.IResolvable;
    set abortDetachedQuery(value: boolean | cdktf.IResolvable);
    resetAbortDetachedQuery(): void;
    get abortDetachedQueryInput(): boolean | cdktf.IResolvable | undefined;
    private _after?;
    get after(): string[];
    set after(value: string[]);
    resetAfter(): void;
    get afterInput(): string[] | undefined;
    private _allowOverlappingExecution?;
    get allowOverlappingExecution(): string;
    set allowOverlappingExecution(value: string);
    resetAllowOverlappingExecution(): void;
    get allowOverlappingExecutionInput(): string | undefined;
    private _autocommit?;
    get autocommit(): boolean | cdktf.IResolvable;
    set autocommit(value: boolean | cdktf.IResolvable);
    resetAutocommit(): void;
    get autocommitInput(): boolean | cdktf.IResolvable | undefined;
    private _binaryInputFormat?;
    get binaryInputFormat(): string;
    set binaryInputFormat(value: string);
    resetBinaryInputFormat(): void;
    get binaryInputFormatInput(): string | undefined;
    private _binaryOutputFormat?;
    get binaryOutputFormat(): string;
    set binaryOutputFormat(value: string);
    resetBinaryOutputFormat(): void;
    get binaryOutputFormatInput(): string | undefined;
    private _clientMemoryLimit?;
    get clientMemoryLimit(): number;
    set clientMemoryLimit(value: number);
    resetClientMemoryLimit(): void;
    get clientMemoryLimitInput(): number | undefined;
    private _clientMetadataRequestUseConnectionCtx?;
    get clientMetadataRequestUseConnectionCtx(): boolean | cdktf.IResolvable;
    set clientMetadataRequestUseConnectionCtx(value: boolean | cdktf.IResolvable);
    resetClientMetadataRequestUseConnectionCtx(): void;
    get clientMetadataRequestUseConnectionCtxInput(): boolean | cdktf.IResolvable | undefined;
    private _clientPrefetchThreads?;
    get clientPrefetchThreads(): number;
    set clientPrefetchThreads(value: number);
    resetClientPrefetchThreads(): void;
    get clientPrefetchThreadsInput(): number | undefined;
    private _clientResultChunkSize?;
    get clientResultChunkSize(): number;
    set clientResultChunkSize(value: number);
    resetClientResultChunkSize(): void;
    get clientResultChunkSizeInput(): number | undefined;
    private _clientResultColumnCaseInsensitive?;
    get clientResultColumnCaseInsensitive(): boolean | cdktf.IResolvable;
    set clientResultColumnCaseInsensitive(value: boolean | cdktf.IResolvable);
    resetClientResultColumnCaseInsensitive(): void;
    get clientResultColumnCaseInsensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _clientSessionKeepAlive?;
    get clientSessionKeepAlive(): boolean | cdktf.IResolvable;
    set clientSessionKeepAlive(value: boolean | cdktf.IResolvable);
    resetClientSessionKeepAlive(): void;
    get clientSessionKeepAliveInput(): boolean | cdktf.IResolvable | undefined;
    private _clientSessionKeepAliveHeartbeatFrequency?;
    get clientSessionKeepAliveHeartbeatFrequency(): number;
    set clientSessionKeepAliveHeartbeatFrequency(value: number);
    resetClientSessionKeepAliveHeartbeatFrequency(): void;
    get clientSessionKeepAliveHeartbeatFrequencyInput(): number | undefined;
    private _clientTimestampTypeMapping?;
    get clientTimestampTypeMapping(): string;
    set clientTimestampTypeMapping(value: string);
    resetClientTimestampTypeMapping(): void;
    get clientTimestampTypeMappingInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _config?;
    get config(): string;
    set config(value: string);
    resetConfig(): void;
    get configInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _dateInputFormat?;
    get dateInputFormat(): string;
    set dateInputFormat(value: string);
    resetDateInputFormat(): void;
    get dateInputFormatInput(): string | undefined;
    private _dateOutputFormat?;
    get dateOutputFormat(): string;
    set dateOutputFormat(value: string);
    resetDateOutputFormat(): void;
    get dateOutputFormatInput(): string | undefined;
    private _enableUnloadPhysicalTypeOptimization?;
    get enableUnloadPhysicalTypeOptimization(): boolean | cdktf.IResolvable;
    set enableUnloadPhysicalTypeOptimization(value: boolean | cdktf.IResolvable);
    resetEnableUnloadPhysicalTypeOptimization(): void;
    get enableUnloadPhysicalTypeOptimizationInput(): boolean | cdktf.IResolvable | undefined;
    private _errorIntegration?;
    get errorIntegration(): string;
    set errorIntegration(value: string);
    resetErrorIntegration(): void;
    get errorIntegrationInput(): string | undefined;
    private _errorOnNondeterministicMerge?;
    get errorOnNondeterministicMerge(): boolean | cdktf.IResolvable;
    set errorOnNondeterministicMerge(value: boolean | cdktf.IResolvable);
    resetErrorOnNondeterministicMerge(): void;
    get errorOnNondeterministicMergeInput(): boolean | cdktf.IResolvable | undefined;
    private _errorOnNondeterministicUpdate?;
    get errorOnNondeterministicUpdate(): boolean | cdktf.IResolvable;
    set errorOnNondeterministicUpdate(value: boolean | cdktf.IResolvable);
    resetErrorOnNondeterministicUpdate(): void;
    get errorOnNondeterministicUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _finalize?;
    get finalize(): string;
    set finalize(value: string);
    resetFinalize(): void;
    get finalizeInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _geographyOutputFormat?;
    get geographyOutputFormat(): string;
    set geographyOutputFormat(value: string);
    resetGeographyOutputFormat(): void;
    get geographyOutputFormatInput(): string | undefined;
    private _geometryOutputFormat?;
    get geometryOutputFormat(): string;
    set geometryOutputFormat(value: string);
    resetGeometryOutputFormat(): void;
    get geometryOutputFormatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jdbcTreatTimestampNtzAsUtc?;
    get jdbcTreatTimestampNtzAsUtc(): boolean | cdktf.IResolvable;
    set jdbcTreatTimestampNtzAsUtc(value: boolean | cdktf.IResolvable);
    resetJdbcTreatTimestampNtzAsUtc(): void;
    get jdbcTreatTimestampNtzAsUtcInput(): boolean | cdktf.IResolvable | undefined;
    private _jdbcUseSessionTimezone?;
    get jdbcUseSessionTimezone(): boolean | cdktf.IResolvable;
    set jdbcUseSessionTimezone(value: boolean | cdktf.IResolvable);
    resetJdbcUseSessionTimezone(): void;
    get jdbcUseSessionTimezoneInput(): boolean | cdktf.IResolvable | undefined;
    private _jsonIndent?;
    get jsonIndent(): number;
    set jsonIndent(value: number);
    resetJsonIndent(): void;
    get jsonIndentInput(): number | undefined;
    private _lockTimeout?;
    get lockTimeout(): number;
    set lockTimeout(value: number);
    resetLockTimeout(): void;
    get lockTimeoutInput(): number | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _multiStatementCount?;
    get multiStatementCount(): number;
    set multiStatementCount(value: number);
    resetMultiStatementCount(): void;
    get multiStatementCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _noorderSequenceAsDefault?;
    get noorderSequenceAsDefault(): boolean | cdktf.IResolvable;
    set noorderSequenceAsDefault(value: boolean | cdktf.IResolvable);
    resetNoorderSequenceAsDefault(): void;
    get noorderSequenceAsDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _odbcTreatDecimalAsInt?;
    get odbcTreatDecimalAsInt(): boolean | cdktf.IResolvable;
    set odbcTreatDecimalAsInt(value: boolean | cdktf.IResolvable);
    resetOdbcTreatDecimalAsInt(): void;
    get odbcTreatDecimalAsIntInput(): boolean | cdktf.IResolvable | undefined;
    private _parameters;
    get parameters(): TaskParametersList;
    private _queryTag?;
    get queryTag(): string;
    set queryTag(value: string);
    resetQueryTag(): void;
    get queryTagInput(): string | undefined;
    private _quotedIdentifiersIgnoreCase?;
    get quotedIdentifiersIgnoreCase(): boolean | cdktf.IResolvable;
    set quotedIdentifiersIgnoreCase(value: boolean | cdktf.IResolvable);
    resetQuotedIdentifiersIgnoreCase(): void;
    get quotedIdentifiersIgnoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _rowsPerResultset?;
    get rowsPerResultset(): number;
    set rowsPerResultset(value: number);
    resetRowsPerResultset(): void;
    get rowsPerResultsetInput(): number | undefined;
    private _s3StageVpceDnsName?;
    get s3StageVpceDnsName(): string;
    set s3StageVpceDnsName(value: string);
    resetS3StageVpceDnsName(): void;
    get s3StageVpceDnsNameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _searchPath?;
    get searchPath(): string;
    set searchPath(value: string);
    resetSearchPath(): void;
    get searchPathInput(): string | undefined;
    private _showOutput;
    get showOutput(): TaskShowOutputList;
    private _sqlStatement?;
    get sqlStatement(): string;
    set sqlStatement(value: string);
    get sqlStatementInput(): string | undefined;
    private _started?;
    get started(): boolean | cdktf.IResolvable;
    set started(value: boolean | cdktf.IResolvable);
    get startedInput(): boolean | cdktf.IResolvable | undefined;
    private _statementQueuedTimeoutInSeconds?;
    get statementQueuedTimeoutInSeconds(): number;
    set statementQueuedTimeoutInSeconds(value: number);
    resetStatementQueuedTimeoutInSeconds(): void;
    get statementQueuedTimeoutInSecondsInput(): number | undefined;
    private _statementTimeoutInSeconds?;
    get statementTimeoutInSeconds(): number;
    set statementTimeoutInSeconds(value: number);
    resetStatementTimeoutInSeconds(): void;
    get statementTimeoutInSecondsInput(): number | undefined;
    private _strictJsonOutput?;
    get strictJsonOutput(): boolean | cdktf.IResolvable;
    set strictJsonOutput(value: boolean | cdktf.IResolvable);
    resetStrictJsonOutput(): void;
    get strictJsonOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _suspendTaskAfterNumFailures?;
    get suspendTaskAfterNumFailures(): number;
    set suspendTaskAfterNumFailures(value: number);
    resetSuspendTaskAfterNumFailures(): void;
    get suspendTaskAfterNumFailuresInput(): number | undefined;
    private _taskAutoRetryAttempts?;
    get taskAutoRetryAttempts(): number;
    set taskAutoRetryAttempts(value: number);
    resetTaskAutoRetryAttempts(): void;
    get taskAutoRetryAttemptsInput(): number | undefined;
    private _timeInputFormat?;
    get timeInputFormat(): string;
    set timeInputFormat(value: string);
    resetTimeInputFormat(): void;
    get timeInputFormatInput(): string | undefined;
    private _timeOutputFormat?;
    get timeOutputFormat(): string;
    set timeOutputFormat(value: string);
    resetTimeOutputFormat(): void;
    get timeOutputFormatInput(): string | undefined;
    private _timestampDayIsAlways24H?;
    get timestampDayIsAlways24H(): boolean | cdktf.IResolvable;
    set timestampDayIsAlways24H(value: boolean | cdktf.IResolvable);
    resetTimestampDayIsAlways24H(): void;
    get timestampDayIsAlways24HInput(): boolean | cdktf.IResolvable | undefined;
    private _timestampInputFormat?;
    get timestampInputFormat(): string;
    set timestampInputFormat(value: string);
    resetTimestampInputFormat(): void;
    get timestampInputFormatInput(): string | undefined;
    private _timestampLtzOutputFormat?;
    get timestampLtzOutputFormat(): string;
    set timestampLtzOutputFormat(value: string);
    resetTimestampLtzOutputFormat(): void;
    get timestampLtzOutputFormatInput(): string | undefined;
    private _timestampNtzOutputFormat?;
    get timestampNtzOutputFormat(): string;
    set timestampNtzOutputFormat(value: string);
    resetTimestampNtzOutputFormat(): void;
    get timestampNtzOutputFormatInput(): string | undefined;
    private _timestampOutputFormat?;
    get timestampOutputFormat(): string;
    set timestampOutputFormat(value: string);
    resetTimestampOutputFormat(): void;
    get timestampOutputFormatInput(): string | undefined;
    private _timestampTypeMapping?;
    get timestampTypeMapping(): string;
    set timestampTypeMapping(value: string);
    resetTimestampTypeMapping(): void;
    get timestampTypeMappingInput(): string | undefined;
    private _timestampTzOutputFormat?;
    get timestampTzOutputFormat(): string;
    set timestampTzOutputFormat(value: string);
    resetTimestampTzOutputFormat(): void;
    get timestampTzOutputFormatInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _transactionAbortOnError?;
    get transactionAbortOnError(): boolean | cdktf.IResolvable;
    set transactionAbortOnError(value: boolean | cdktf.IResolvable);
    resetTransactionAbortOnError(): void;
    get transactionAbortOnErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _transactionDefaultIsolationLevel?;
    get transactionDefaultIsolationLevel(): string;
    set transactionDefaultIsolationLevel(value: string);
    resetTransactionDefaultIsolationLevel(): void;
    get transactionDefaultIsolationLevelInput(): string | undefined;
    private _twoDigitCenturyStart?;
    get twoDigitCenturyStart(): number;
    set twoDigitCenturyStart(value: number);
    resetTwoDigitCenturyStart(): void;
    get twoDigitCenturyStartInput(): number | undefined;
    private _unsupportedDdlAction?;
    get unsupportedDdlAction(): string;
    set unsupportedDdlAction(value: string);
    resetUnsupportedDdlAction(): void;
    get unsupportedDdlActionInput(): string | undefined;
    private _useCachedResult?;
    get useCachedResult(): boolean | cdktf.IResolvable;
    set useCachedResult(value: boolean | cdktf.IResolvable);
    resetUseCachedResult(): void;
    get useCachedResultInput(): boolean | cdktf.IResolvable | undefined;
    private _userTaskManagedInitialWarehouseSize?;
    get userTaskManagedInitialWarehouseSize(): string;
    set userTaskManagedInitialWarehouseSize(value: string);
    resetUserTaskManagedInitialWarehouseSize(): void;
    get userTaskManagedInitialWarehouseSizeInput(): string | undefined;
    private _userTaskMinimumTriggerIntervalInSeconds?;
    get userTaskMinimumTriggerIntervalInSeconds(): number;
    set userTaskMinimumTriggerIntervalInSeconds(value: number);
    resetUserTaskMinimumTriggerIntervalInSeconds(): void;
    get userTaskMinimumTriggerIntervalInSecondsInput(): number | undefined;
    private _userTaskTimeoutMs?;
    get userTaskTimeoutMs(): number;
    set userTaskTimeoutMs(value: number);
    resetUserTaskTimeoutMs(): void;
    get userTaskTimeoutMsInput(): number | undefined;
    private _warehouse?;
    get warehouse(): string;
    set warehouse(value: string);
    resetWarehouse(): void;
    get warehouseInput(): string | undefined;
    private _weekOfYearPolicy?;
    get weekOfYearPolicy(): number;
    set weekOfYearPolicy(value: number);
    resetWeekOfYearPolicy(): void;
    get weekOfYearPolicyInput(): number | undefined;
    private _weekStart?;
    get weekStart(): number;
    set weekStart(value: number);
    resetWeekStart(): void;
    get weekStartInput(): number | undefined;
    private _when?;
    get when(): string;
    set when(value: string);
    resetWhen(): void;
    get whenInput(): string | undefined;
    private _schedule;
    get schedule(): TaskScheduleOutputReference;
    putSchedule(value: TaskSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): TaskSchedule | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
