/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WarehouseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#auto_resume Warehouse#auto_resume}
    */
    readonly autoResume?: string;
    /**
    * Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#auto_suspend Warehouse#auto_suspend}
    */
    readonly autoSuspend?: number;
    /**
    * Specifies a comment for the warehouse.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#comment Warehouse#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether to enable the query acceleration service for queries that rely on this warehouse for compute resources. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#enable_query_acceleration Warehouse#enable_query_acceleration}
    */
    readonly enableQueryAcceleration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#id Warehouse#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies whether the warehouse is created initially in the ‘Suspended’ state.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#initially_suspended Warehouse#initially_suspended}
    */
    readonly initiallySuspended?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum number of server clusters for the warehouse.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#max_cluster_count Warehouse#max_cluster_count}
    */
    readonly maxClusterCount?: number;
    /**
    * Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#max_concurrency_level Warehouse#max_concurrency_level}
    */
    readonly maxConcurrencyLevel?: number;
    /**
    * Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#min_cluster_count Warehouse#min_cluster_count}
    */
    readonly minClusterCount?: number;
    /**
    * Identifier for the virtual warehouse; must be unique for your account. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#name Warehouse#name}
    */
    readonly name: string;
    /**
    * Specifies the maximum scale factor for leasing compute resources for query acceleration. The scale factor is used as a multiplier based on warehouse size.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#query_acceleration_max_scale_factor Warehouse#query_acceleration_max_scale_factor}
    */
    readonly queryAccelerationMaxScaleFactor?: number;
    /**
    * Specifies the name of a resource monitor that is explicitly assigned to the warehouse. For more information about this resource, see [docs](./resource_monitor).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#resource_monitor Warehouse#resource_monitor}
    */
    readonly resourceMonitor?: string;
    /**
    * Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode. Valid values are (case-insensitive): `STANDARD` | `ECONOMY`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#scaling_policy Warehouse#scaling_policy}
    */
    readonly scalingPolicy?: string;
    /**
    * Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#statement_queued_timeout_in_seconds Warehouse#statement_queued_timeout_in_seconds}
    */
    readonly statementQueuedTimeoutInSeconds?: number;
    /**
    * Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#statement_timeout_in_seconds Warehouse#statement_timeout_in_seconds}
    */
    readonly statementTimeoutInSeconds?: number;
    /**
    * Specifies the size of the virtual warehouse. Valid values are (case-insensitive): `XSMALL` | `X-SMALL` | `SMALL` | `MEDIUM` | `LARGE` | `XLARGE` | `X-LARGE` | `XXLARGE` | `X2LARGE` | `2X-LARGE` | `XXXLARGE` | `X3LARGE` | `3X-LARGE` | `X4LARGE` | `4X-LARGE` | `X5LARGE` | `5X-LARGE` | `X6LARGE` | `6X-LARGE`. Consult [warehouse documentation](https://docs.snowflake.com/en/sql-reference/sql/create-warehouse#optional-properties-objectproperties) for the details. Note: removing the size from config will result in the resource recreation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#warehouse_size Warehouse#warehouse_size}
    */
    readonly warehouseSize?: string;
    /**
    * Specifies warehouse type. Valid values are (case-insensitive): `STANDARD` | `SNOWPARK-OPTIMIZED`. Warehouse needs to be suspended to change its type. Provider will handle automatic suspension and resumption if needed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#warehouse_type Warehouse#warehouse_type}
    */
    readonly warehouseType?: string;
}
export interface WarehouseParametersMaxConcurrencyLevel {
}
export declare function warehouseParametersMaxConcurrencyLevelToTerraform(struct?: WarehouseParametersMaxConcurrencyLevel): any;
export declare function warehouseParametersMaxConcurrencyLevelToHclTerraform(struct?: WarehouseParametersMaxConcurrencyLevel): any;
export declare class WarehouseParametersMaxConcurrencyLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WarehouseParametersMaxConcurrencyLevel | undefined;
    set internalValue(value: WarehouseParametersMaxConcurrencyLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class WarehouseParametersMaxConcurrencyLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WarehouseParametersMaxConcurrencyLevelOutputReference;
}
export interface WarehouseParametersStatementQueuedTimeoutInSeconds {
}
export declare function warehouseParametersStatementQueuedTimeoutInSecondsToTerraform(struct?: WarehouseParametersStatementQueuedTimeoutInSeconds): any;
export declare function warehouseParametersStatementQueuedTimeoutInSecondsToHclTerraform(struct?: WarehouseParametersStatementQueuedTimeoutInSeconds): any;
export declare class WarehouseParametersStatementQueuedTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WarehouseParametersStatementQueuedTimeoutInSeconds | undefined;
    set internalValue(value: WarehouseParametersStatementQueuedTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class WarehouseParametersStatementQueuedTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WarehouseParametersStatementQueuedTimeoutInSecondsOutputReference;
}
export interface WarehouseParametersStatementTimeoutInSeconds {
}
export declare function warehouseParametersStatementTimeoutInSecondsToTerraform(struct?: WarehouseParametersStatementTimeoutInSeconds): any;
export declare function warehouseParametersStatementTimeoutInSecondsToHclTerraform(struct?: WarehouseParametersStatementTimeoutInSeconds): any;
export declare class WarehouseParametersStatementTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WarehouseParametersStatementTimeoutInSeconds | undefined;
    set internalValue(value: WarehouseParametersStatementTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class WarehouseParametersStatementTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WarehouseParametersStatementTimeoutInSecondsOutputReference;
}
export interface WarehouseParameters {
}
export declare function warehouseParametersToTerraform(struct?: WarehouseParameters): any;
export declare function warehouseParametersToHclTerraform(struct?: WarehouseParameters): any;
export declare class WarehouseParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WarehouseParameters | undefined;
    set internalValue(value: WarehouseParameters | undefined);
    private _maxConcurrencyLevel;
    get maxConcurrencyLevel(): WarehouseParametersMaxConcurrencyLevelList;
    private _statementQueuedTimeoutInSeconds;
    get statementQueuedTimeoutInSeconds(): WarehouseParametersStatementQueuedTimeoutInSecondsList;
    private _statementTimeoutInSeconds;
    get statementTimeoutInSeconds(): WarehouseParametersStatementTimeoutInSecondsList;
}
export declare class WarehouseParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WarehouseParametersOutputReference;
}
export interface WarehouseShowOutput {
}
export declare function warehouseShowOutputToTerraform(struct?: WarehouseShowOutput): any;
export declare function warehouseShowOutputToHclTerraform(struct?: WarehouseShowOutput): any;
export declare class WarehouseShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WarehouseShowOutput | undefined;
    set internalValue(value: WarehouseShowOutput | undefined);
    get autoResume(): cdktf.IResolvable;
    get autoSuspend(): number;
    get available(): number;
    get comment(): string;
    get createdOn(): string;
    get enableQueryAcceleration(): cdktf.IResolvable;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get maxClusterCount(): number;
    get minClusterCount(): number;
    get name(): string;
    get other(): number;
    get owner(): string;
    get ownerRoleType(): string;
    get provisioning(): number;
    get queryAccelerationMaxScaleFactor(): number;
    get queued(): number;
    get quiescing(): number;
    get resourceMonitor(): string;
    get resumedOn(): string;
    get running(): number;
    get scalingPolicy(): string;
    get size(): string;
    get startedClusters(): number;
    get state(): string;
    get type(): string;
    get updatedOn(): string;
}
export declare class WarehouseShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WarehouseShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse snowflake_warehouse}
*/
export declare class Warehouse extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_warehouse";
    /**
    * Generates CDKTF code for importing a Warehouse resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Warehouse to import
    * @param importFromId The id of the existing Warehouse that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Warehouse to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/warehouse snowflake_warehouse} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WarehouseConfig
    */
    constructor(scope: Construct, id: string, config: WarehouseConfig);
    private _autoResume?;
    get autoResume(): string;
    set autoResume(value: string);
    resetAutoResume(): void;
    get autoResumeInput(): string | undefined;
    private _autoSuspend?;
    get autoSuspend(): number;
    set autoSuspend(value: number);
    resetAutoSuspend(): void;
    get autoSuspendInput(): number | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _enableQueryAcceleration?;
    get enableQueryAcceleration(): string;
    set enableQueryAcceleration(value: string);
    resetEnableQueryAcceleration(): void;
    get enableQueryAccelerationInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initiallySuspended?;
    get initiallySuspended(): boolean | cdktf.IResolvable;
    set initiallySuspended(value: boolean | cdktf.IResolvable);
    resetInitiallySuspended(): void;
    get initiallySuspendedInput(): boolean | cdktf.IResolvable | undefined;
    private _maxClusterCount?;
    get maxClusterCount(): number;
    set maxClusterCount(value: number);
    resetMaxClusterCount(): void;
    get maxClusterCountInput(): number | undefined;
    private _maxConcurrencyLevel?;
    get maxConcurrencyLevel(): number;
    set maxConcurrencyLevel(value: number);
    resetMaxConcurrencyLevel(): void;
    get maxConcurrencyLevelInput(): number | undefined;
    private _minClusterCount?;
    get minClusterCount(): number;
    set minClusterCount(value: number);
    resetMinClusterCount(): void;
    get minClusterCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters;
    get parameters(): WarehouseParametersList;
    private _queryAccelerationMaxScaleFactor?;
    get queryAccelerationMaxScaleFactor(): number;
    set queryAccelerationMaxScaleFactor(value: number);
    resetQueryAccelerationMaxScaleFactor(): void;
    get queryAccelerationMaxScaleFactorInput(): number | undefined;
    private _resourceMonitor?;
    get resourceMonitor(): string;
    set resourceMonitor(value: string);
    resetResourceMonitor(): void;
    get resourceMonitorInput(): string | undefined;
    private _scalingPolicy?;
    get scalingPolicy(): string;
    set scalingPolicy(value: string);
    resetScalingPolicy(): void;
    get scalingPolicyInput(): string | undefined;
    private _showOutput;
    get showOutput(): WarehouseShowOutputList;
    private _statementQueuedTimeoutInSeconds?;
    get statementQueuedTimeoutInSeconds(): number;
    set statementQueuedTimeoutInSeconds(value: number);
    resetStatementQueuedTimeoutInSeconds(): void;
    get statementQueuedTimeoutInSecondsInput(): number | undefined;
    private _statementTimeoutInSeconds?;
    get statementTimeoutInSeconds(): number;
    set statementTimeoutInSeconds(value: number);
    resetStatementTimeoutInSeconds(): void;
    get statementTimeoutInSecondsInput(): number | undefined;
    private _warehouseSize?;
    get warehouseSize(): string;
    set warehouseSize(value: string);
    resetWarehouseSize(): void;
    get warehouseSizeInput(): string | undefined;
    private _warehouseType?;
    get warehouseType(): string;
    set warehouseType(value: string);
    resetWarehouseType(): void;
    get warehouseTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
