/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeMaskingPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#id DataSnowflakeMaskingPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#like DataSnowflakeMaskingPolicies#like}
    */
    readonly like?: string;
    /**
    * Runs DESC MASKING POLICY for each masking policy returned by SHOW MASKING POLICIES. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#with_describe DataSnowflakeMaskingPolicies#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#in DataSnowflakeMaskingPolicies#in}
    */
    readonly in?: DataSnowflakeMaskingPoliciesIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#limit DataSnowflakeMaskingPolicies#limit}
    */
    readonly limit?: DataSnowflakeMaskingPoliciesLimit;
}
export interface DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignature {
}
export declare function dataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignatureToTerraform(struct?: DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignature): any;
export declare function dataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignatureToHclTerraform(struct?: DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignature): any;
export declare class DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignatureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignature | undefined;
    set internalValue(value: DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignature | undefined);
    get name(): string;
    get type(): string;
}
export declare class DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignatureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignatureOutputReference;
}
export interface DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutput {
}
export declare function dataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputToTerraform(struct?: DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutput): any;
export declare function dataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputToHclTerraform(struct?: DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutput): any;
export declare class DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutput | undefined);
    get body(): string;
    get name(): string;
    get returnType(): string;
    private _signature;
    get signature(): DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputSignatureList;
}
export declare class DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputOutputReference;
}
export interface DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutput {
}
export declare function dataSnowflakeMaskingPoliciesMaskingPoliciesShowOutputToTerraform(struct?: DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutput): any;
export declare function dataSnowflakeMaskingPoliciesMaskingPoliciesShowOutputToHclTerraform(struct?: DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutput): any;
export declare class DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutput | undefined;
    set internalValue(value: DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get exemptOtherPolicies(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
}
export declare class DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutputOutputReference;
}
export interface DataSnowflakeMaskingPoliciesMaskingPolicies {
}
export declare function dataSnowflakeMaskingPoliciesMaskingPoliciesToTerraform(struct?: DataSnowflakeMaskingPoliciesMaskingPolicies): any;
export declare function dataSnowflakeMaskingPoliciesMaskingPoliciesToHclTerraform(struct?: DataSnowflakeMaskingPoliciesMaskingPolicies): any;
export declare class DataSnowflakeMaskingPoliciesMaskingPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeMaskingPoliciesMaskingPolicies | undefined;
    set internalValue(value: DataSnowflakeMaskingPoliciesMaskingPolicies | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeMaskingPoliciesMaskingPoliciesDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeMaskingPoliciesMaskingPoliciesShowOutputList;
}
export declare class DataSnowflakeMaskingPoliciesMaskingPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeMaskingPoliciesMaskingPoliciesOutputReference;
}
export interface DataSnowflakeMaskingPoliciesIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#account DataSnowflakeMaskingPolicies#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the specified application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#application DataSnowflakeMaskingPolicies#application}
    */
    readonly application?: string;
    /**
    * Returns records for the specified application package.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#application_package DataSnowflakeMaskingPolicies#application_package}
    */
    readonly applicationPackage?: string;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#database DataSnowflakeMaskingPolicies#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#schema DataSnowflakeMaskingPolicies#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeMaskingPoliciesInToTerraform(struct?: DataSnowflakeMaskingPoliciesInOutputReference | DataSnowflakeMaskingPoliciesIn): any;
export declare function dataSnowflakeMaskingPoliciesInToHclTerraform(struct?: DataSnowflakeMaskingPoliciesInOutputReference | DataSnowflakeMaskingPoliciesIn): any;
export declare class DataSnowflakeMaskingPoliciesInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeMaskingPoliciesIn | undefined;
    set internalValue(value: DataSnowflakeMaskingPoliciesIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _applicationPackage?;
    get applicationPackage(): string;
    set applicationPackage(value: string);
    resetApplicationPackage(): void;
    get applicationPackageInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeMaskingPoliciesLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#from DataSnowflakeMaskingPolicies#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#rows DataSnowflakeMaskingPolicies#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeMaskingPoliciesLimitToTerraform(struct?: DataSnowflakeMaskingPoliciesLimitOutputReference | DataSnowflakeMaskingPoliciesLimit): any;
export declare function dataSnowflakeMaskingPoliciesLimitToHclTerraform(struct?: DataSnowflakeMaskingPoliciesLimitOutputReference | DataSnowflakeMaskingPoliciesLimit): any;
export declare class DataSnowflakeMaskingPoliciesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeMaskingPoliciesLimit | undefined;
    set internalValue(value: DataSnowflakeMaskingPoliciesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies snowflake_masking_policies}
*/
export declare class DataSnowflakeMaskingPolicies extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_masking_policies";
    /**
    * Generates CDKTF code for importing a DataSnowflakeMaskingPolicies resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeMaskingPolicies to import
    * @param importFromId The id of the existing DataSnowflakeMaskingPolicies that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeMaskingPolicies to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/masking_policies snowflake_masking_policies} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeMaskingPoliciesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeMaskingPoliciesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _maskingPolicies;
    get maskingPolicies(): DataSnowflakeMaskingPoliciesMaskingPoliciesList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeMaskingPoliciesInOutputReference;
    putIn(value: DataSnowflakeMaskingPoliciesIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeMaskingPoliciesIn | undefined;
    private _limit;
    get limit(): DataSnowflakeMaskingPoliciesLimitOutputReference;
    putLimit(value: DataSnowflakeMaskingPoliciesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeMaskingPoliciesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
