/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeUsersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#id DataSnowflakeUsers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#like DataSnowflakeUsers#like}
    */
    readonly like?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#starts_with DataSnowflakeUsers#starts_with}
    */
    readonly startsWith?: string;
    /**
    * Runs DESC USER for each user returned by SHOW USERS. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#with_describe DataSnowflakeUsers#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * Runs SHOW PARAMETERS FOR USER for each user returned by SHOW USERS. The output of describe is saved to the parameters field as a map. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#with_parameters DataSnowflakeUsers#with_parameters}
    */
    readonly withParameters?: boolean | cdktf.IResolvable;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#limit DataSnowflakeUsers#limit}
    */
    readonly limit?: DataSnowflakeUsersLimit;
}
export interface DataSnowflakeUsersUsersDescribeOutput {
}
export declare function dataSnowflakeUsersUsersDescribeOutputToTerraform(struct?: DataSnowflakeUsersUsersDescribeOutput): any;
export declare function dataSnowflakeUsersUsersDescribeOutputToHclTerraform(struct?: DataSnowflakeUsersUsersDescribeOutput): any;
export declare class DataSnowflakeUsersUsersDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeUsersUsersDescribeOutput | undefined);
    get comment(): string;
    get customLandingPageUrl(): string;
    get customLandingPageUrlFlushNextUiLoad(): cdktf.IResolvable;
    get daysToExpiry(): number;
    get defaultNamespace(): string;
    get defaultRole(): string;
    get defaultSecondaryRoles(): string;
    get defaultWarehouse(): string;
    get disabled(): cdktf.IResolvable;
    get displayName(): string;
    get email(): string;
    get extAuthnDuo(): cdktf.IResolvable;
    get extAuthnUid(): string;
    get firstName(): string;
    get hasMfa(): cdktf.IResolvable;
    get lastName(): string;
    get loginName(): string;
    get middleName(): string;
    get minsToBypassMfa(): number;
    get minsToBypassNetworkPolicy(): number;
    get minsToUnlock(): number;
    get mustChangePassword(): cdktf.IResolvable;
    get name(): string;
    get password(): string;
    get passwordLastSetTime(): string;
    get rsaPublicKey(): string;
    get rsaPublicKey2(): string;
    get rsaPublicKey2Fp(): string;
    get rsaPublicKeyFp(): string;
    get snowflakeLock(): cdktf.IResolvable;
    get snowflakeSupport(): cdktf.IResolvable;
    get type(): string;
}
export declare class DataSnowflakeUsersUsersDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersDescribeOutputOutputReference;
}
export interface DataSnowflakeUsersUsersParametersAbortDetachedQuery {
}
export declare function dataSnowflakeUsersUsersParametersAbortDetachedQueryToTerraform(struct?: DataSnowflakeUsersUsersParametersAbortDetachedQuery): any;
export declare function dataSnowflakeUsersUsersParametersAbortDetachedQueryToHclTerraform(struct?: DataSnowflakeUsersUsersParametersAbortDetachedQuery): any;
export declare class DataSnowflakeUsersUsersParametersAbortDetachedQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersAbortDetachedQuery | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersAbortDetachedQuery | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersAbortDetachedQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersAbortDetachedQueryOutputReference;
}
export interface DataSnowflakeUsersUsersParametersAutocommit {
}
export declare function dataSnowflakeUsersUsersParametersAutocommitToTerraform(struct?: DataSnowflakeUsersUsersParametersAutocommit): any;
export declare function dataSnowflakeUsersUsersParametersAutocommitToHclTerraform(struct?: DataSnowflakeUsersUsersParametersAutocommit): any;
export declare class DataSnowflakeUsersUsersParametersAutocommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersAutocommit | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersAutocommit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersAutocommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersAutocommitOutputReference;
}
export interface DataSnowflakeUsersUsersParametersBinaryInputFormat {
}
export declare function dataSnowflakeUsersUsersParametersBinaryInputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersBinaryInputFormat): any;
export declare function dataSnowflakeUsersUsersParametersBinaryInputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersBinaryInputFormat): any;
export declare class DataSnowflakeUsersUsersParametersBinaryInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersBinaryInputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersBinaryInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersBinaryInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersBinaryInputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersBinaryOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersBinaryOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersBinaryOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersBinaryOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersBinaryOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersBinaryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersBinaryOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersBinaryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersBinaryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersBinaryOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersClientMemoryLimit {
}
export declare function dataSnowflakeUsersUsersParametersClientMemoryLimitToTerraform(struct?: DataSnowflakeUsersUsersParametersClientMemoryLimit): any;
export declare function dataSnowflakeUsersUsersParametersClientMemoryLimitToHclTerraform(struct?: DataSnowflakeUsersUsersParametersClientMemoryLimit): any;
export declare class DataSnowflakeUsersUsersParametersClientMemoryLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersClientMemoryLimit | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersClientMemoryLimit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersClientMemoryLimitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersClientMemoryLimitOutputReference;
}
export interface DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtx {
}
export declare function dataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtxToTerraform(struct?: DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtx): any;
export declare function dataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtxToHclTerraform(struct?: DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtx): any;
export declare class DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtx | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtx | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtxOutputReference;
}
export interface DataSnowflakeUsersUsersParametersClientPrefetchThreads {
}
export declare function dataSnowflakeUsersUsersParametersClientPrefetchThreadsToTerraform(struct?: DataSnowflakeUsersUsersParametersClientPrefetchThreads): any;
export declare function dataSnowflakeUsersUsersParametersClientPrefetchThreadsToHclTerraform(struct?: DataSnowflakeUsersUsersParametersClientPrefetchThreads): any;
export declare class DataSnowflakeUsersUsersParametersClientPrefetchThreadsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersClientPrefetchThreads | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersClientPrefetchThreads | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersClientPrefetchThreadsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersClientPrefetchThreadsOutputReference;
}
export interface DataSnowflakeUsersUsersParametersClientResultChunkSize {
}
export declare function dataSnowflakeUsersUsersParametersClientResultChunkSizeToTerraform(struct?: DataSnowflakeUsersUsersParametersClientResultChunkSize): any;
export declare function dataSnowflakeUsersUsersParametersClientResultChunkSizeToHclTerraform(struct?: DataSnowflakeUsersUsersParametersClientResultChunkSize): any;
export declare class DataSnowflakeUsersUsersParametersClientResultChunkSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersClientResultChunkSize | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersClientResultChunkSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersClientResultChunkSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersClientResultChunkSizeOutputReference;
}
export interface DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitive {
}
export declare function dataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitiveToTerraform(struct?: DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitive): any;
export declare function dataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitiveToHclTerraform(struct?: DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitive): any;
export declare class DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitive | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitiveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitiveOutputReference;
}
export interface DataSnowflakeUsersUsersParametersClientSessionKeepAlive {
}
export declare function dataSnowflakeUsersUsersParametersClientSessionKeepAliveToTerraform(struct?: DataSnowflakeUsersUsersParametersClientSessionKeepAlive): any;
export declare function dataSnowflakeUsersUsersParametersClientSessionKeepAliveToHclTerraform(struct?: DataSnowflakeUsersUsersParametersClientSessionKeepAlive): any;
export declare class DataSnowflakeUsersUsersParametersClientSessionKeepAliveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersClientSessionKeepAlive | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersClientSessionKeepAlive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersClientSessionKeepAliveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersClientSessionKeepAliveOutputReference;
}
export interface DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequency {
}
export declare function dataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequencyToTerraform(struct?: DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare function dataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequencyToHclTerraform(struct?: DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare class DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequency | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequency | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequencyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference;
}
export interface DataSnowflakeUsersUsersParametersClientTimestampTypeMapping {
}
export declare function dataSnowflakeUsersUsersParametersClientTimestampTypeMappingToTerraform(struct?: DataSnowflakeUsersUsersParametersClientTimestampTypeMapping): any;
export declare function dataSnowflakeUsersUsersParametersClientTimestampTypeMappingToHclTerraform(struct?: DataSnowflakeUsersUsersParametersClientTimestampTypeMapping): any;
export declare class DataSnowflakeUsersUsersParametersClientTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersClientTimestampTypeMapping | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersClientTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersClientTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersClientTimestampTypeMappingOutputReference;
}
export interface DataSnowflakeUsersUsersParametersDateInputFormat {
}
export declare function dataSnowflakeUsersUsersParametersDateInputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersDateInputFormat): any;
export declare function dataSnowflakeUsersUsersParametersDateInputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersDateInputFormat): any;
export declare class DataSnowflakeUsersUsersParametersDateInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersDateInputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersDateInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersDateInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersDateInputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersDateOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersDateOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersDateOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersDateOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersDateOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersDateOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersDateOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersDateOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersDateOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersDateOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimization {
}
export declare function dataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimizationToTerraform(struct?: DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimization): any;
export declare function dataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimizationToHclTerraform(struct?: DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimization): any;
export declare class DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimization | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimization | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimizationOutputReference;
}
export interface DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxError {
}
export declare function dataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxErrorToTerraform(struct?: DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxError): any;
export declare function dataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxErrorToHclTerraform(struct?: DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxError): any;
export declare class DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxError | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxErrorOutputReference;
}
export interface DataSnowflakeUsersUsersParametersErrorOnNondeterministicMerge {
}
export declare function dataSnowflakeUsersUsersParametersErrorOnNondeterministicMergeToTerraform(struct?: DataSnowflakeUsersUsersParametersErrorOnNondeterministicMerge): any;
export declare function dataSnowflakeUsersUsersParametersErrorOnNondeterministicMergeToHclTerraform(struct?: DataSnowflakeUsersUsersParametersErrorOnNondeterministicMerge): any;
export declare class DataSnowflakeUsersUsersParametersErrorOnNondeterministicMergeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersErrorOnNondeterministicMerge | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersErrorOnNondeterministicMerge | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersErrorOnNondeterministicMergeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersErrorOnNondeterministicMergeOutputReference;
}
export interface DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdate {
}
export declare function dataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdateToTerraform(struct?: DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdate): any;
export declare function dataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdateToHclTerraform(struct?: DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdate): any;
export declare class DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdate | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdate | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdateOutputReference;
}
export interface DataSnowflakeUsersUsersParametersGeographyOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersGeographyOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersGeographyOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersGeographyOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersGeographyOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersGeographyOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersGeographyOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersGeographyOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersGeographyOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersGeographyOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersGeometryOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersGeometryOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersGeometryOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersGeometryOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersGeometryOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersGeometryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersGeometryOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersGeometryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersGeometryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersGeometryOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsInt {
}
export declare function dataSnowflakeUsersUsersParametersJdbcTreatDecimalAsIntToTerraform(struct?: DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsInt): any;
export declare function dataSnowflakeUsersUsersParametersJdbcTreatDecimalAsIntToHclTerraform(struct?: DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsInt): any;
export declare class DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsInt | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsIntOutputReference;
}
export interface DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtc {
}
export declare function dataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtcToTerraform(struct?: DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtc): any;
export declare function dataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtcToHclTerraform(struct?: DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtc): any;
export declare class DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtc | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtc | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtcOutputReference;
}
export interface DataSnowflakeUsersUsersParametersJdbcUseSessionTimezone {
}
export declare function dataSnowflakeUsersUsersParametersJdbcUseSessionTimezoneToTerraform(struct?: DataSnowflakeUsersUsersParametersJdbcUseSessionTimezone): any;
export declare function dataSnowflakeUsersUsersParametersJdbcUseSessionTimezoneToHclTerraform(struct?: DataSnowflakeUsersUsersParametersJdbcUseSessionTimezone): any;
export declare class DataSnowflakeUsersUsersParametersJdbcUseSessionTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersJdbcUseSessionTimezone | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersJdbcUseSessionTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersJdbcUseSessionTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersJdbcUseSessionTimezoneOutputReference;
}
export interface DataSnowflakeUsersUsersParametersJsonIndent {
}
export declare function dataSnowflakeUsersUsersParametersJsonIndentToTerraform(struct?: DataSnowflakeUsersUsersParametersJsonIndent): any;
export declare function dataSnowflakeUsersUsersParametersJsonIndentToHclTerraform(struct?: DataSnowflakeUsersUsersParametersJsonIndent): any;
export declare class DataSnowflakeUsersUsersParametersJsonIndentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersJsonIndent | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersJsonIndent | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersJsonIndentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersJsonIndentOutputReference;
}
export interface DataSnowflakeUsersUsersParametersLockTimeout {
}
export declare function dataSnowflakeUsersUsersParametersLockTimeoutToTerraform(struct?: DataSnowflakeUsersUsersParametersLockTimeout): any;
export declare function dataSnowflakeUsersUsersParametersLockTimeoutToHclTerraform(struct?: DataSnowflakeUsersUsersParametersLockTimeout): any;
export declare class DataSnowflakeUsersUsersParametersLockTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersLockTimeout | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersLockTimeout | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersLockTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersLockTimeoutOutputReference;
}
export interface DataSnowflakeUsersUsersParametersLogLevel {
}
export declare function dataSnowflakeUsersUsersParametersLogLevelToTerraform(struct?: DataSnowflakeUsersUsersParametersLogLevel): any;
export declare function dataSnowflakeUsersUsersParametersLogLevelToHclTerraform(struct?: DataSnowflakeUsersUsersParametersLogLevel): any;
export declare class DataSnowflakeUsersUsersParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersLogLevel | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersLogLevelOutputReference;
}
export interface DataSnowflakeUsersUsersParametersMultiStatementCount {
}
export declare function dataSnowflakeUsersUsersParametersMultiStatementCountToTerraform(struct?: DataSnowflakeUsersUsersParametersMultiStatementCount): any;
export declare function dataSnowflakeUsersUsersParametersMultiStatementCountToHclTerraform(struct?: DataSnowflakeUsersUsersParametersMultiStatementCount): any;
export declare class DataSnowflakeUsersUsersParametersMultiStatementCountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersMultiStatementCount | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersMultiStatementCount | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersMultiStatementCountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersMultiStatementCountOutputReference;
}
export interface DataSnowflakeUsersUsersParametersNetworkPolicy {
}
export declare function dataSnowflakeUsersUsersParametersNetworkPolicyToTerraform(struct?: DataSnowflakeUsersUsersParametersNetworkPolicy): any;
export declare function dataSnowflakeUsersUsersParametersNetworkPolicyToHclTerraform(struct?: DataSnowflakeUsersUsersParametersNetworkPolicy): any;
export declare class DataSnowflakeUsersUsersParametersNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersNetworkPolicy | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersNetworkPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersNetworkPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersNetworkPolicyOutputReference;
}
export interface DataSnowflakeUsersUsersParametersNoorderSequenceAsDefault {
}
export declare function dataSnowflakeUsersUsersParametersNoorderSequenceAsDefaultToTerraform(struct?: DataSnowflakeUsersUsersParametersNoorderSequenceAsDefault): any;
export declare function dataSnowflakeUsersUsersParametersNoorderSequenceAsDefaultToHclTerraform(struct?: DataSnowflakeUsersUsersParametersNoorderSequenceAsDefault): any;
export declare class DataSnowflakeUsersUsersParametersNoorderSequenceAsDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersNoorderSequenceAsDefault | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersNoorderSequenceAsDefault | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersNoorderSequenceAsDefaultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersNoorderSequenceAsDefaultOutputReference;
}
export interface DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsInt {
}
export declare function dataSnowflakeUsersUsersParametersOdbcTreatDecimalAsIntToTerraform(struct?: DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsInt): any;
export declare function dataSnowflakeUsersUsersParametersOdbcTreatDecimalAsIntToHclTerraform(struct?: DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsInt): any;
export declare class DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsInt | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsIntOutputReference;
}
export interface DataSnowflakeUsersUsersParametersPreventUnloadToInternalStages {
}
export declare function dataSnowflakeUsersUsersParametersPreventUnloadToInternalStagesToTerraform(struct?: DataSnowflakeUsersUsersParametersPreventUnloadToInternalStages): any;
export declare function dataSnowflakeUsersUsersParametersPreventUnloadToInternalStagesToHclTerraform(struct?: DataSnowflakeUsersUsersParametersPreventUnloadToInternalStages): any;
export declare class DataSnowflakeUsersUsersParametersPreventUnloadToInternalStagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersPreventUnloadToInternalStages | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersPreventUnloadToInternalStages | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersPreventUnloadToInternalStagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersPreventUnloadToInternalStagesOutputReference;
}
export interface DataSnowflakeUsersUsersParametersQueryTag {
}
export declare function dataSnowflakeUsersUsersParametersQueryTagToTerraform(struct?: DataSnowflakeUsersUsersParametersQueryTag): any;
export declare function dataSnowflakeUsersUsersParametersQueryTagToHclTerraform(struct?: DataSnowflakeUsersUsersParametersQueryTag): any;
export declare class DataSnowflakeUsersUsersParametersQueryTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersQueryTag | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersQueryTag | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersQueryTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersQueryTagOutputReference;
}
export interface DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCase {
}
export declare function dataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCase): any;
export declare function dataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCase): any;
export declare class DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface DataSnowflakeUsersUsersParametersRowsPerResultset {
}
export declare function dataSnowflakeUsersUsersParametersRowsPerResultsetToTerraform(struct?: DataSnowflakeUsersUsersParametersRowsPerResultset): any;
export declare function dataSnowflakeUsersUsersParametersRowsPerResultsetToHclTerraform(struct?: DataSnowflakeUsersUsersParametersRowsPerResultset): any;
export declare class DataSnowflakeUsersUsersParametersRowsPerResultsetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersRowsPerResultset | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersRowsPerResultset | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersRowsPerResultsetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersRowsPerResultsetOutputReference;
}
export interface DataSnowflakeUsersUsersParametersS3StageVpceDnsName {
}
export declare function dataSnowflakeUsersUsersParametersS3StageVpceDnsNameToTerraform(struct?: DataSnowflakeUsersUsersParametersS3StageVpceDnsName): any;
export declare function dataSnowflakeUsersUsersParametersS3StageVpceDnsNameToHclTerraform(struct?: DataSnowflakeUsersUsersParametersS3StageVpceDnsName): any;
export declare class DataSnowflakeUsersUsersParametersS3StageVpceDnsNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersS3StageVpceDnsName | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersS3StageVpceDnsName | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersS3StageVpceDnsNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersS3StageVpceDnsNameOutputReference;
}
export interface DataSnowflakeUsersUsersParametersSearchPath {
}
export declare function dataSnowflakeUsersUsersParametersSearchPathToTerraform(struct?: DataSnowflakeUsersUsersParametersSearchPath): any;
export declare function dataSnowflakeUsersUsersParametersSearchPathToHclTerraform(struct?: DataSnowflakeUsersUsersParametersSearchPath): any;
export declare class DataSnowflakeUsersUsersParametersSearchPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersSearchPath | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersSearchPath | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersSearchPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersSearchPathOutputReference;
}
export interface DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumer {
}
export declare function dataSnowflakeUsersUsersParametersSimulatedDataSharingConsumerToTerraform(struct?: DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumer): any;
export declare function dataSnowflakeUsersUsersParametersSimulatedDataSharingConsumerToHclTerraform(struct?: DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumer): any;
export declare class DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumer | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumer | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumerOutputReference;
}
export interface DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSeconds {
}
export declare function dataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSecondsToTerraform(struct?: DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSeconds): any;
export declare function dataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSecondsToHclTerraform(struct?: DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSeconds): any;
export declare class DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSeconds | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSecondsOutputReference;
}
export interface DataSnowflakeUsersUsersParametersStatementTimeoutInSeconds {
}
export declare function dataSnowflakeUsersUsersParametersStatementTimeoutInSecondsToTerraform(struct?: DataSnowflakeUsersUsersParametersStatementTimeoutInSeconds): any;
export declare function dataSnowflakeUsersUsersParametersStatementTimeoutInSecondsToHclTerraform(struct?: DataSnowflakeUsersUsersParametersStatementTimeoutInSeconds): any;
export declare class DataSnowflakeUsersUsersParametersStatementTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersStatementTimeoutInSeconds | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersStatementTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersStatementTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersStatementTimeoutInSecondsOutputReference;
}
export interface DataSnowflakeUsersUsersParametersStrictJsonOutput {
}
export declare function dataSnowflakeUsersUsersParametersStrictJsonOutputToTerraform(struct?: DataSnowflakeUsersUsersParametersStrictJsonOutput): any;
export declare function dataSnowflakeUsersUsersParametersStrictJsonOutputToHclTerraform(struct?: DataSnowflakeUsersUsersParametersStrictJsonOutput): any;
export declare class DataSnowflakeUsersUsersParametersStrictJsonOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersStrictJsonOutput | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersStrictJsonOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersStrictJsonOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersStrictJsonOutputOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimeInputFormat {
}
export declare function dataSnowflakeUsersUsersParametersTimeInputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersTimeInputFormat): any;
export declare function dataSnowflakeUsersUsersParametersTimeInputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimeInputFormat): any;
export declare class DataSnowflakeUsersUsersParametersTimeInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimeInputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimeInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimeInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimeInputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimeOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersTimeOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersTimeOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersTimeOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimeOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersTimeOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimeOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimeOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimeOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimeOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimestampDayIsAlways24H {
}
export declare function dataSnowflakeUsersUsersParametersTimestampDayIsAlways24HToTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampDayIsAlways24H): any;
export declare function dataSnowflakeUsersUsersParametersTimestampDayIsAlways24HToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampDayIsAlways24H): any;
export declare class DataSnowflakeUsersUsersParametersTimestampDayIsAlways24HOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimestampDayIsAlways24H | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimestampDayIsAlways24H | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimestampDayIsAlways24HList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimestampDayIsAlways24HOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimestampInputFormat {
}
export declare function dataSnowflakeUsersUsersParametersTimestampInputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampInputFormat): any;
export declare function dataSnowflakeUsersUsersParametersTimestampInputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampInputFormat): any;
export declare class DataSnowflakeUsersUsersParametersTimestampInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimestampInputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimestampInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimestampInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimestampInputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimestampLtzOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersTimestampLtzOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampLtzOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersTimestampLtzOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampLtzOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersTimestampLtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimestampLtzOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimestampLtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimestampLtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimestampLtzOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimestampNtzOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersTimestampNtzOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampNtzOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersTimestampNtzOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampNtzOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersTimestampNtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimestampNtzOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimestampNtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimestampNtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimestampNtzOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimestampOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersTimestampOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersTimestampOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersTimestampOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimestampOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimestampOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimestampOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimestampOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimestampTypeMapping {
}
export declare function dataSnowflakeUsersUsersParametersTimestampTypeMappingToTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampTypeMapping): any;
export declare function dataSnowflakeUsersUsersParametersTimestampTypeMappingToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampTypeMapping): any;
export declare class DataSnowflakeUsersUsersParametersTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimestampTypeMapping | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimestampTypeMappingOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimestampTzOutputFormat {
}
export declare function dataSnowflakeUsersUsersParametersTimestampTzOutputFormatToTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampTzOutputFormat): any;
export declare function dataSnowflakeUsersUsersParametersTimestampTzOutputFormatToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimestampTzOutputFormat): any;
export declare class DataSnowflakeUsersUsersParametersTimestampTzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimestampTzOutputFormat | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimestampTzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimestampTzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimestampTzOutputFormatOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTimezone {
}
export declare function dataSnowflakeUsersUsersParametersTimezoneToTerraform(struct?: DataSnowflakeUsersUsersParametersTimezone): any;
export declare function dataSnowflakeUsersUsersParametersTimezoneToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTimezone): any;
export declare class DataSnowflakeUsersUsersParametersTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTimezone | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTimezoneOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTraceLevel {
}
export declare function dataSnowflakeUsersUsersParametersTraceLevelToTerraform(struct?: DataSnowflakeUsersUsersParametersTraceLevel): any;
export declare function dataSnowflakeUsersUsersParametersTraceLevelToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTraceLevel): any;
export declare class DataSnowflakeUsersUsersParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTraceLevel | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTraceLevelOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTransactionAbortOnError {
}
export declare function dataSnowflakeUsersUsersParametersTransactionAbortOnErrorToTerraform(struct?: DataSnowflakeUsersUsersParametersTransactionAbortOnError): any;
export declare function dataSnowflakeUsersUsersParametersTransactionAbortOnErrorToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTransactionAbortOnError): any;
export declare class DataSnowflakeUsersUsersParametersTransactionAbortOnErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTransactionAbortOnError | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTransactionAbortOnError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTransactionAbortOnErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTransactionAbortOnErrorOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevel {
}
export declare function dataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevelToTerraform(struct?: DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevel): any;
export declare function dataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevelToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevel): any;
export declare class DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevel | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevelOutputReference;
}
export interface DataSnowflakeUsersUsersParametersTwoDigitCenturyStart {
}
export declare function dataSnowflakeUsersUsersParametersTwoDigitCenturyStartToTerraform(struct?: DataSnowflakeUsersUsersParametersTwoDigitCenturyStart): any;
export declare function dataSnowflakeUsersUsersParametersTwoDigitCenturyStartToHclTerraform(struct?: DataSnowflakeUsersUsersParametersTwoDigitCenturyStart): any;
export declare class DataSnowflakeUsersUsersParametersTwoDigitCenturyStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersTwoDigitCenturyStart | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersTwoDigitCenturyStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersTwoDigitCenturyStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersTwoDigitCenturyStartOutputReference;
}
export interface DataSnowflakeUsersUsersParametersUnsupportedDdlAction {
}
export declare function dataSnowflakeUsersUsersParametersUnsupportedDdlActionToTerraform(struct?: DataSnowflakeUsersUsersParametersUnsupportedDdlAction): any;
export declare function dataSnowflakeUsersUsersParametersUnsupportedDdlActionToHclTerraform(struct?: DataSnowflakeUsersUsersParametersUnsupportedDdlAction): any;
export declare class DataSnowflakeUsersUsersParametersUnsupportedDdlActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersUnsupportedDdlAction | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersUnsupportedDdlAction | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersUnsupportedDdlActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersUnsupportedDdlActionOutputReference;
}
export interface DataSnowflakeUsersUsersParametersUseCachedResult {
}
export declare function dataSnowflakeUsersUsersParametersUseCachedResultToTerraform(struct?: DataSnowflakeUsersUsersParametersUseCachedResult): any;
export declare function dataSnowflakeUsersUsersParametersUseCachedResultToHclTerraform(struct?: DataSnowflakeUsersUsersParametersUseCachedResult): any;
export declare class DataSnowflakeUsersUsersParametersUseCachedResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersUseCachedResult | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersUseCachedResult | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersUseCachedResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersUseCachedResultOutputReference;
}
export interface DataSnowflakeUsersUsersParametersWeekOfYearPolicy {
}
export declare function dataSnowflakeUsersUsersParametersWeekOfYearPolicyToTerraform(struct?: DataSnowflakeUsersUsersParametersWeekOfYearPolicy): any;
export declare function dataSnowflakeUsersUsersParametersWeekOfYearPolicyToHclTerraform(struct?: DataSnowflakeUsersUsersParametersWeekOfYearPolicy): any;
export declare class DataSnowflakeUsersUsersParametersWeekOfYearPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersWeekOfYearPolicy | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersWeekOfYearPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersWeekOfYearPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersWeekOfYearPolicyOutputReference;
}
export interface DataSnowflakeUsersUsersParametersWeekStart {
}
export declare function dataSnowflakeUsersUsersParametersWeekStartToTerraform(struct?: DataSnowflakeUsersUsersParametersWeekStart): any;
export declare function dataSnowflakeUsersUsersParametersWeekStartToHclTerraform(struct?: DataSnowflakeUsersUsersParametersWeekStart): any;
export declare class DataSnowflakeUsersUsersParametersWeekStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParametersWeekStart | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParametersWeekStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeUsersUsersParametersWeekStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersWeekStartOutputReference;
}
export interface DataSnowflakeUsersUsersParameters {
}
export declare function dataSnowflakeUsersUsersParametersToTerraform(struct?: DataSnowflakeUsersUsersParameters): any;
export declare function dataSnowflakeUsersUsersParametersToHclTerraform(struct?: DataSnowflakeUsersUsersParameters): any;
export declare class DataSnowflakeUsersUsersParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersParameters | undefined;
    set internalValue(value: DataSnowflakeUsersUsersParameters | undefined);
    private _abortDetachedQuery;
    get abortDetachedQuery(): DataSnowflakeUsersUsersParametersAbortDetachedQueryList;
    private _autocommit;
    get autocommit(): DataSnowflakeUsersUsersParametersAutocommitList;
    private _binaryInputFormat;
    get binaryInputFormat(): DataSnowflakeUsersUsersParametersBinaryInputFormatList;
    private _binaryOutputFormat;
    get binaryOutputFormat(): DataSnowflakeUsersUsersParametersBinaryOutputFormatList;
    private _clientMemoryLimit;
    get clientMemoryLimit(): DataSnowflakeUsersUsersParametersClientMemoryLimitList;
    private _clientMetadataRequestUseConnectionCtx;
    get clientMetadataRequestUseConnectionCtx(): DataSnowflakeUsersUsersParametersClientMetadataRequestUseConnectionCtxList;
    private _clientPrefetchThreads;
    get clientPrefetchThreads(): DataSnowflakeUsersUsersParametersClientPrefetchThreadsList;
    private _clientResultChunkSize;
    get clientResultChunkSize(): DataSnowflakeUsersUsersParametersClientResultChunkSizeList;
    private _clientResultColumnCaseInsensitive;
    get clientResultColumnCaseInsensitive(): DataSnowflakeUsersUsersParametersClientResultColumnCaseInsensitiveList;
    private _clientSessionKeepAlive;
    get clientSessionKeepAlive(): DataSnowflakeUsersUsersParametersClientSessionKeepAliveList;
    private _clientSessionKeepAliveHeartbeatFrequency;
    get clientSessionKeepAliveHeartbeatFrequency(): DataSnowflakeUsersUsersParametersClientSessionKeepAliveHeartbeatFrequencyList;
    private _clientTimestampTypeMapping;
    get clientTimestampTypeMapping(): DataSnowflakeUsersUsersParametersClientTimestampTypeMappingList;
    private _dateInputFormat;
    get dateInputFormat(): DataSnowflakeUsersUsersParametersDateInputFormatList;
    private _dateOutputFormat;
    get dateOutputFormat(): DataSnowflakeUsersUsersParametersDateOutputFormatList;
    private _enableUnloadPhysicalTypeOptimization;
    get enableUnloadPhysicalTypeOptimization(): DataSnowflakeUsersUsersParametersEnableUnloadPhysicalTypeOptimizationList;
    private _enableUnredactedQuerySyntaxError;
    get enableUnredactedQuerySyntaxError(): DataSnowflakeUsersUsersParametersEnableUnredactedQuerySyntaxErrorList;
    private _errorOnNondeterministicMerge;
    get errorOnNondeterministicMerge(): DataSnowflakeUsersUsersParametersErrorOnNondeterministicMergeList;
    private _errorOnNondeterministicUpdate;
    get errorOnNondeterministicUpdate(): DataSnowflakeUsersUsersParametersErrorOnNondeterministicUpdateList;
    private _geographyOutputFormat;
    get geographyOutputFormat(): DataSnowflakeUsersUsersParametersGeographyOutputFormatList;
    private _geometryOutputFormat;
    get geometryOutputFormat(): DataSnowflakeUsersUsersParametersGeometryOutputFormatList;
    private _jdbcTreatDecimalAsInt;
    get jdbcTreatDecimalAsInt(): DataSnowflakeUsersUsersParametersJdbcTreatDecimalAsIntList;
    private _jdbcTreatTimestampNtzAsUtc;
    get jdbcTreatTimestampNtzAsUtc(): DataSnowflakeUsersUsersParametersJdbcTreatTimestampNtzAsUtcList;
    private _jdbcUseSessionTimezone;
    get jdbcUseSessionTimezone(): DataSnowflakeUsersUsersParametersJdbcUseSessionTimezoneList;
    private _jsonIndent;
    get jsonIndent(): DataSnowflakeUsersUsersParametersJsonIndentList;
    private _lockTimeout;
    get lockTimeout(): DataSnowflakeUsersUsersParametersLockTimeoutList;
    private _logLevel;
    get logLevel(): DataSnowflakeUsersUsersParametersLogLevelList;
    private _multiStatementCount;
    get multiStatementCount(): DataSnowflakeUsersUsersParametersMultiStatementCountList;
    private _networkPolicy;
    get networkPolicy(): DataSnowflakeUsersUsersParametersNetworkPolicyList;
    private _noorderSequenceAsDefault;
    get noorderSequenceAsDefault(): DataSnowflakeUsersUsersParametersNoorderSequenceAsDefaultList;
    private _odbcTreatDecimalAsInt;
    get odbcTreatDecimalAsInt(): DataSnowflakeUsersUsersParametersOdbcTreatDecimalAsIntList;
    private _preventUnloadToInternalStages;
    get preventUnloadToInternalStages(): DataSnowflakeUsersUsersParametersPreventUnloadToInternalStagesList;
    private _queryTag;
    get queryTag(): DataSnowflakeUsersUsersParametersQueryTagList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): DataSnowflakeUsersUsersParametersQuotedIdentifiersIgnoreCaseList;
    private _rowsPerResultset;
    get rowsPerResultset(): DataSnowflakeUsersUsersParametersRowsPerResultsetList;
    private _s3StageVpceDnsName;
    get s3StageVpceDnsName(): DataSnowflakeUsersUsersParametersS3StageVpceDnsNameList;
    private _searchPath;
    get searchPath(): DataSnowflakeUsersUsersParametersSearchPathList;
    private _simulatedDataSharingConsumer;
    get simulatedDataSharingConsumer(): DataSnowflakeUsersUsersParametersSimulatedDataSharingConsumerList;
    private _statementQueuedTimeoutInSeconds;
    get statementQueuedTimeoutInSeconds(): DataSnowflakeUsersUsersParametersStatementQueuedTimeoutInSecondsList;
    private _statementTimeoutInSeconds;
    get statementTimeoutInSeconds(): DataSnowflakeUsersUsersParametersStatementTimeoutInSecondsList;
    private _strictJsonOutput;
    get strictJsonOutput(): DataSnowflakeUsersUsersParametersStrictJsonOutputList;
    private _timeInputFormat;
    get timeInputFormat(): DataSnowflakeUsersUsersParametersTimeInputFormatList;
    private _timeOutputFormat;
    get timeOutputFormat(): DataSnowflakeUsersUsersParametersTimeOutputFormatList;
    private _timestampDayIsAlways24H;
    get timestampDayIsAlways24H(): DataSnowflakeUsersUsersParametersTimestampDayIsAlways24HList;
    private _timestampInputFormat;
    get timestampInputFormat(): DataSnowflakeUsersUsersParametersTimestampInputFormatList;
    private _timestampLtzOutputFormat;
    get timestampLtzOutputFormat(): DataSnowflakeUsersUsersParametersTimestampLtzOutputFormatList;
    private _timestampNtzOutputFormat;
    get timestampNtzOutputFormat(): DataSnowflakeUsersUsersParametersTimestampNtzOutputFormatList;
    private _timestampOutputFormat;
    get timestampOutputFormat(): DataSnowflakeUsersUsersParametersTimestampOutputFormatList;
    private _timestampTypeMapping;
    get timestampTypeMapping(): DataSnowflakeUsersUsersParametersTimestampTypeMappingList;
    private _timestampTzOutputFormat;
    get timestampTzOutputFormat(): DataSnowflakeUsersUsersParametersTimestampTzOutputFormatList;
    private _timezone;
    get timezone(): DataSnowflakeUsersUsersParametersTimezoneList;
    private _traceLevel;
    get traceLevel(): DataSnowflakeUsersUsersParametersTraceLevelList;
    private _transactionAbortOnError;
    get transactionAbortOnError(): DataSnowflakeUsersUsersParametersTransactionAbortOnErrorList;
    private _transactionDefaultIsolationLevel;
    get transactionDefaultIsolationLevel(): DataSnowflakeUsersUsersParametersTransactionDefaultIsolationLevelList;
    private _twoDigitCenturyStart;
    get twoDigitCenturyStart(): DataSnowflakeUsersUsersParametersTwoDigitCenturyStartList;
    private _unsupportedDdlAction;
    get unsupportedDdlAction(): DataSnowflakeUsersUsersParametersUnsupportedDdlActionList;
    private _useCachedResult;
    get useCachedResult(): DataSnowflakeUsersUsersParametersUseCachedResultList;
    private _weekOfYearPolicy;
    get weekOfYearPolicy(): DataSnowflakeUsersUsersParametersWeekOfYearPolicyList;
    private _weekStart;
    get weekStart(): DataSnowflakeUsersUsersParametersWeekStartList;
}
export declare class DataSnowflakeUsersUsersParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersParametersOutputReference;
}
export interface DataSnowflakeUsersUsersShowOutput {
}
export declare function dataSnowflakeUsersUsersShowOutputToTerraform(struct?: DataSnowflakeUsersUsersShowOutput): any;
export declare function dataSnowflakeUsersUsersShowOutputToHclTerraform(struct?: DataSnowflakeUsersUsersShowOutput): any;
export declare class DataSnowflakeUsersUsersShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsersShowOutput | undefined;
    set internalValue(value: DataSnowflakeUsersUsersShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get daysToExpiry(): string;
    get defaultNamespace(): string;
    get defaultRole(): string;
    get defaultSecondaryRoles(): string;
    get defaultWarehouse(): string;
    get disabled(): cdktf.IResolvable;
    get displayName(): string;
    get email(): string;
    get expiresAtTime(): string;
    get extAuthnDuo(): cdktf.IResolvable;
    get extAuthnUid(): string;
    get firstName(): string;
    get hasMfa(): cdktf.IResolvable;
    get hasPassword(): cdktf.IResolvable;
    get hasRsaPublicKey(): cdktf.IResolvable;
    get lastName(): string;
    get lastSuccessLogin(): string;
    get lockedUntilTime(): string;
    get loginName(): string;
    get minsToBypassMfa(): string;
    get minsToUnlock(): string;
    get mustChangePassword(): cdktf.IResolvable;
    get name(): string;
    get owner(): string;
    get snowflakeLock(): cdktf.IResolvable;
    get type(): string;
}
export declare class DataSnowflakeUsersUsersShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersShowOutputOutputReference;
}
export interface DataSnowflakeUsersUsers {
}
export declare function dataSnowflakeUsersUsersToTerraform(struct?: DataSnowflakeUsersUsers): any;
export declare function dataSnowflakeUsersUsersToHclTerraform(struct?: DataSnowflakeUsersUsers): any;
export declare class DataSnowflakeUsersUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeUsersUsers | undefined;
    set internalValue(value: DataSnowflakeUsersUsers | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeUsersUsersDescribeOutputList;
    private _parameters;
    get parameters(): DataSnowflakeUsersUsersParametersList;
    private _showOutput;
    get showOutput(): DataSnowflakeUsersUsersShowOutputList;
}
export declare class DataSnowflakeUsersUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeUsersUsersOutputReference;
}
export interface DataSnowflakeUsersLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#from DataSnowflakeUsers#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#rows DataSnowflakeUsers#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeUsersLimitToTerraform(struct?: DataSnowflakeUsersLimitOutputReference | DataSnowflakeUsersLimit): any;
export declare function dataSnowflakeUsersLimitToHclTerraform(struct?: DataSnowflakeUsersLimitOutputReference | DataSnowflakeUsersLimit): any;
export declare class DataSnowflakeUsersLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeUsersLimit | undefined;
    set internalValue(value: DataSnowflakeUsersLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users snowflake_users}
*/
export declare class DataSnowflakeUsers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_users";
    /**
    * Generates CDKTF code for importing a DataSnowflakeUsers resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeUsers to import
    * @param importFromId The id of the existing DataSnowflakeUsers that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeUsers to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/data-sources/users snowflake_users} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeUsersConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeUsersConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _users;
    get users(): DataSnowflakeUsersUsersList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _withParameters?;
    get withParameters(): boolean | cdktf.IResolvable;
    set withParameters(value: boolean | cdktf.IResolvable);
    resetWithParameters(): void;
    get withParametersInput(): boolean | cdktf.IResolvable | undefined;
    private _limit;
    get limit(): DataSnowflakeUsersLimitOutputReference;
    putLimit(value: DataSnowflakeUsersLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeUsersLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
