/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionPythonConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#comment FunctionPython#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the function. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#database FunctionPython#database}
    */
    readonly database: string;
    /**
    * Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG_LEVEL). For more information, check [ENABLE_CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#enable_console_output FunctionPython#enable_console_output}
    */
    readonly enableConsoleOutput?: boolean | cdktf.IResolvable;
    /**
    * The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this function’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#external_access_integrations FunctionPython#external_access_integrations}
    */
    readonly externalAccessIntegrations?: string[];
    /**
    * Defines the handler code executed when the UDF is called. Wrapping `$$` signs are added by the provider automatically; do not include them. The `function_definition` value must be Python source code. For more information, see [Introduction to Python UDFs](https://docs.snowflake.com/en/developer-guide/udf/python/udf-python-introduction). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#function_definition FunctionPython#function_definition}
    */
    readonly functionDefinition?: string;
    /**
    * The name of the handler function or class. If the handler is for a scalar UDF, returning a non-tabular value, the HANDLER value should be a function name. If the handler code is in-line with the CREATE FUNCTION statement, you can use the function name alone. When the handler code is referenced at a stage, this value should be qualified with the module name, as in the following form: `my_module.my_function`. If the handler is for a tabular UDF, the HANDLER value should be the name of a handler class.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#handler FunctionPython#handler}
    */
    readonly handler: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#id FunctionPython#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies that the function is an aggregate function. For more information about user-defined aggregate functions, see [Python user-defined aggregate functions](https://docs.snowflake.com/en/developer-guide/udf/python/udf-python-aggregate-functions). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#is_aggregate FunctionPython#is_aggregate}
    */
    readonly isAggregate?: string;
    /**
    * Specifies that the function is secure. By design, the Snowflake's `SHOW FUNCTIONS` command does not provide information about secure functions (consult [function docs](https://docs.snowflake.com/en/sql-reference/sql/create-function#id1) and [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure)) which is essential to manage/import function with Terraform. Use the role owning the function while managing secure functions. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#is_secure FunctionPython#is_secure}
    */
    readonly isSecure?: string;
    /**
    * LOG_LEVEL to use when filtering events For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#log_level FunctionPython#log_level}
    */
    readonly logLevel?: string;
    /**
    * METRIC_LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#metric_level FunctionPython#metric_level}
    */
    readonly metricLevel?: string;
    /**
    * The name of the function; the identifier does not need to be unique for the schema in which the function is created because UDFs are identified and resolved by the combination of the name and argument types. Check the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-function#all-languages). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#name FunctionPython#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the function when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#null_input_behavior FunctionPython#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * The name and version number of packages required as dependencies. The value should be of the form `package_name==version_number`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#packages FunctionPython#packages}
    */
    readonly packages?: string[];
    /**
    * Specifies the behavior of the function when returning results. Valid values are (case-insensitive): `VOLATILE` | `IMMUTABLE`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#return_results_behavior FunctionPython#return_results_behavior}
    */
    readonly returnResultsBehavior?: string;
    /**
    * Specifies the results returned by the UDF, which determines the UDF type. Use `<result_data_type>` to create a scalar UDF that returns a single value with the specified data type. Use `TABLE (col_name col_data_type, ...)` to creates a table UDF that returns tabular results with the specified table column(s) and column type(s). For the details, consult the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-function#all-languages).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#return_type FunctionPython#return_type}
    */
    readonly returnType: string;
    /**
    * Specifies the Python version to use. The supported versions of Python are: 3.9, 3.10, and 3.11.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#runtime_version FunctionPython#runtime_version}
    */
    readonly runtimeVersion: string;
    /**
    * The schema in which to create the function. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#schema FunctionPython#schema}
    */
    readonly schema: string;
    /**
    * Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#trace_level FunctionPython#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#arguments FunctionPython#arguments}
    */
    readonly arguments?: FunctionPythonArguments[] | cdktf.IResolvable;
    /**
    * imports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#imports FunctionPython#imports}
    */
    readonly imports?: FunctionPythonImports[] | cdktf.IResolvable;
    /**
    * secrets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#secrets FunctionPython#secrets}
    */
    readonly secrets?: FunctionPythonSecrets[] | cdktf.IResolvable;
}
export interface FunctionPythonParametersEnableConsoleOutput {
}
export declare function functionPythonParametersEnableConsoleOutputToTerraform(struct?: FunctionPythonParametersEnableConsoleOutput): any;
export declare function functionPythonParametersEnableConsoleOutputToHclTerraform(struct?: FunctionPythonParametersEnableConsoleOutput): any;
export declare class FunctionPythonParametersEnableConsoleOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonParametersEnableConsoleOutput | undefined;
    set internalValue(value: FunctionPythonParametersEnableConsoleOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class FunctionPythonParametersEnableConsoleOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonParametersEnableConsoleOutputOutputReference;
}
export interface FunctionPythonParametersLogLevel {
}
export declare function functionPythonParametersLogLevelToTerraform(struct?: FunctionPythonParametersLogLevel): any;
export declare function functionPythonParametersLogLevelToHclTerraform(struct?: FunctionPythonParametersLogLevel): any;
export declare class FunctionPythonParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonParametersLogLevel | undefined;
    set internalValue(value: FunctionPythonParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class FunctionPythonParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonParametersLogLevelOutputReference;
}
export interface FunctionPythonParametersMetricLevel {
}
export declare function functionPythonParametersMetricLevelToTerraform(struct?: FunctionPythonParametersMetricLevel): any;
export declare function functionPythonParametersMetricLevelToHclTerraform(struct?: FunctionPythonParametersMetricLevel): any;
export declare class FunctionPythonParametersMetricLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonParametersMetricLevel | undefined;
    set internalValue(value: FunctionPythonParametersMetricLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class FunctionPythonParametersMetricLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonParametersMetricLevelOutputReference;
}
export interface FunctionPythonParametersTraceLevel {
}
export declare function functionPythonParametersTraceLevelToTerraform(struct?: FunctionPythonParametersTraceLevel): any;
export declare function functionPythonParametersTraceLevelToHclTerraform(struct?: FunctionPythonParametersTraceLevel): any;
export declare class FunctionPythonParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonParametersTraceLevel | undefined;
    set internalValue(value: FunctionPythonParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class FunctionPythonParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonParametersTraceLevelOutputReference;
}
export interface FunctionPythonParameters {
}
export declare function functionPythonParametersToTerraform(struct?: FunctionPythonParameters): any;
export declare function functionPythonParametersToHclTerraform(struct?: FunctionPythonParameters): any;
export declare class FunctionPythonParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonParameters | undefined;
    set internalValue(value: FunctionPythonParameters | undefined);
    private _enableConsoleOutput;
    get enableConsoleOutput(): FunctionPythonParametersEnableConsoleOutputList;
    private _logLevel;
    get logLevel(): FunctionPythonParametersLogLevelList;
    private _metricLevel;
    get metricLevel(): FunctionPythonParametersMetricLevelList;
    private _traceLevel;
    get traceLevel(): FunctionPythonParametersTraceLevelList;
}
export declare class FunctionPythonParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonParametersOutputReference;
}
export interface FunctionPythonShowOutput {
}
export declare function functionPythonShowOutputToTerraform(struct?: FunctionPythonShowOutput): any;
export declare function functionPythonShowOutputToHclTerraform(struct?: FunctionPythonShowOutput): any;
export declare class FunctionPythonShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonShowOutput | undefined;
    set internalValue(value: FunctionPythonShowOutput | undefined);
    get argumentsRaw(): string;
    get catalogName(): string;
    get createdOn(): string;
    get description(): string;
    get externalAccessIntegrations(): string;
    get isAggregate(): cdktf.IResolvable;
    get isAnsi(): cdktf.IResolvable;
    get isBuiltin(): cdktf.IResolvable;
    get isDataMetric(): cdktf.IResolvable;
    get isExternalFunction(): cdktf.IResolvable;
    get isMemoizable(): cdktf.IResolvable;
    get isSecure(): cdktf.IResolvable;
    get isTableFunction(): cdktf.IResolvable;
    get language(): string;
    get maxNumArguments(): number;
    get minNumArguments(): number;
    get name(): string;
    get schemaName(): string;
    get secrets(): string;
    get validForClustering(): cdktf.IResolvable;
}
export declare class FunctionPythonShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonShowOutputOutputReference;
}
export interface FunctionPythonArguments {
    /**
    * The argument type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#arg_data_type FunctionPython#arg_data_type}
    */
    readonly argDataType: string;
    /**
    * Optional default value for the argument. For text values use single quotes. Numeric values can be unquoted. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#arg_default_value FunctionPython#arg_default_value}
    */
    readonly argDefaultValue?: string;
    /**
    * The argument name. The provider wraps it in double quotes by default, so be aware of that while referencing the argument in the function definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#arg_name FunctionPython#arg_name}
    */
    readonly argName: string;
}
export declare function functionPythonArgumentsToTerraform(struct?: FunctionPythonArguments | cdktf.IResolvable): any;
export declare function functionPythonArgumentsToHclTerraform(struct?: FunctionPythonArguments | cdktf.IResolvable): any;
export declare class FunctionPythonArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonArguments | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionPythonArguments | cdktf.IResolvable | undefined);
    private _argDataType?;
    get argDataType(): string;
    set argDataType(value: string);
    get argDataTypeInput(): string | undefined;
    private _argDefaultValue?;
    get argDefaultValue(): string;
    set argDefaultValue(value: string);
    resetArgDefaultValue(): void;
    get argDefaultValueInput(): string | undefined;
    private _argName?;
    get argName(): string;
    set argName(value: string);
    get argNameInput(): string | undefined;
}
export declare class FunctionPythonArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionPythonArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonArgumentsOutputReference;
}
export interface FunctionPythonImports {
    /**
    * Path for import on stage, without the leading `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#path_on_stage FunctionPython#path_on_stage}
    */
    readonly pathOnStage: string;
    /**
    * Stage location without leading `@`. To use your user's stage set this to `~`, otherwise pass fully qualified name of the stage (with every part contained in double quotes or use `snowflake_stage.<your stage's resource name>.fully_qualified_name` if you manage this stage through terraform).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#stage_location FunctionPython#stage_location}
    */
    readonly stageLocation: string;
}
export declare function functionPythonImportsToTerraform(struct?: FunctionPythonImports | cdktf.IResolvable): any;
export declare function functionPythonImportsToHclTerraform(struct?: FunctionPythonImports | cdktf.IResolvable): any;
export declare class FunctionPythonImportsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonImports | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionPythonImports | cdktf.IResolvable | undefined);
    private _pathOnStage?;
    get pathOnStage(): string;
    set pathOnStage(value: string);
    get pathOnStageInput(): string | undefined;
    private _stageLocation?;
    get stageLocation(): string;
    set stageLocation(value: string);
    get stageLocationInput(): string | undefined;
}
export declare class FunctionPythonImportsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionPythonImports[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonImportsOutputReference;
}
export interface FunctionPythonSecrets {
    /**
    * Fully qualified name of the allowed [secret](https://docs.snowflake.com/en/sql-reference/sql/create-secret). You will receive an error if you specify a SECRETS value whose secret isn’t also included in an integration specified by the EXTERNAL_ACCESS_INTEGRATIONS parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#secret_id FunctionPython#secret_id}
    */
    readonly secretId: string;
    /**
    * The variable that will be used in handler code when retrieving information from the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#secret_variable_name FunctionPython#secret_variable_name}
    */
    readonly secretVariableName: string;
}
export declare function functionPythonSecretsToTerraform(struct?: FunctionPythonSecrets | cdktf.IResolvable): any;
export declare function functionPythonSecretsToHclTerraform(struct?: FunctionPythonSecrets | cdktf.IResolvable): any;
export declare class FunctionPythonSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionPythonSecrets | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionPythonSecrets | cdktf.IResolvable | undefined);
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _secretVariableName?;
    get secretVariableName(): string;
    set secretVariableName(value: string);
    get secretVariableNameInput(): string | undefined;
}
export declare class FunctionPythonSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionPythonSecrets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionPythonSecretsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python snowflake_function_python}
*/
export declare class FunctionPython extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_function_python";
    /**
    * Generates CDKTF code for importing a FunctionPython resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FunctionPython to import
    * @param importFromId The id of the existing FunctionPython that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FunctionPython to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/function_python snowflake_function_python} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionPythonConfig
    */
    constructor(scope: Construct, id: string, config: FunctionPythonConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _enableConsoleOutput?;
    get enableConsoleOutput(): boolean | cdktf.IResolvable;
    set enableConsoleOutput(value: boolean | cdktf.IResolvable);
    resetEnableConsoleOutput(): void;
    get enableConsoleOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _externalAccessIntegrations?;
    get externalAccessIntegrations(): string[];
    set externalAccessIntegrations(value: string[]);
    resetExternalAccessIntegrations(): void;
    get externalAccessIntegrationsInput(): string[] | undefined;
    get fullyQualifiedName(): string;
    private _functionDefinition?;
    get functionDefinition(): string;
    set functionDefinition(value: string);
    resetFunctionDefinition(): void;
    get functionDefinitionInput(): string | undefined;
    get functionLanguage(): string;
    private _handler?;
    get handler(): string;
    set handler(value: string);
    get handlerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isAggregate?;
    get isAggregate(): string;
    set isAggregate(value: string);
    resetIsAggregate(): void;
    get isAggregateInput(): string | undefined;
    private _isSecure?;
    get isSecure(): string;
    set isSecure(value: string);
    resetIsSecure(): void;
    get isSecureInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _metricLevel?;
    get metricLevel(): string;
    set metricLevel(value: string);
    resetMetricLevel(): void;
    get metricLevelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _packages?;
    get packages(): string[];
    set packages(value: string[]);
    resetPackages(): void;
    get packagesInput(): string[] | undefined;
    private _parameters;
    get parameters(): FunctionPythonParametersList;
    private _returnResultsBehavior?;
    get returnResultsBehavior(): string;
    set returnResultsBehavior(value: string);
    resetReturnResultsBehavior(): void;
    get returnResultsBehaviorInput(): string | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    get runtimeVersionInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): FunctionPythonShowOutputList;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _arguments;
    get arguments(): FunctionPythonArgumentsList;
    putArguments(value: FunctionPythonArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | FunctionPythonArguments[] | undefined;
    private _imports;
    get imports(): FunctionPythonImportsList;
    putImports(value: FunctionPythonImports[] | cdktf.IResolvable): void;
    resetImports(): void;
    get importsInput(): cdktf.IResolvable | FunctionPythonImports[] | undefined;
    private _secrets;
    get secrets(): FunctionPythonSecretsList;
    putSecrets(value: FunctionPythonSecrets[] | cdktf.IResolvable): void;
    resetSecrets(): void;
    get secretsInput(): cdktf.IResolvable | FunctionPythonSecrets[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
