/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OauthIntegrationForPartnerApplicationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * A set of Snowflake roles that a user cannot explicitly consent to using after authenticating. By default, this list includes the ACCOUNTADMIN, ORGADMIN and SECURITYADMIN roles. To remove these privileged roles from the list, use the ALTER ACCOUNT command to set the OAUTH_ADD_PRIVILEGED_ROLES_TO_BLOCKED_LIST account parameter to FALSE. For more information about this resource, see [docs](./account_role).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#blocked_roles_list OauthIntegrationForPartnerApplications#blocked_roles_list}
    */
    readonly blockedRolesList?: string[];
    /**
    * Specifies a comment for the OAuth integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#comment OauthIntegrationForPartnerApplications#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#enabled OauthIntegrationForPartnerApplications#enabled}
    */
    readonly enabled?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#id OauthIntegrationForPartnerApplications#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#name OauthIntegrationForPartnerApplications#name}
    */
    readonly name: string;
    /**
    * Creates an OAuth interface between Snowflake and a partner application. Valid options are: `LOOKER` | `TABLEAU_DESKTOP` | `TABLEAU_SERVER`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#oauth_client OauthIntegrationForPartnerApplications#oauth_client}
    */
    readonly oauthClient: string;
    /**
    * Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#oauth_issue_refresh_tokens OauthIntegrationForPartnerApplications#oauth_issue_refresh_tokens}
    */
    readonly oauthIssueRefreshTokens?: string;
    /**
    * Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI. The field should be only set when OAUTH_CLIENT = LOOKER. In any other case the field should be left out empty. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#oauth_redirect_uri OauthIntegrationForPartnerApplications#oauth_redirect_uri}
    */
    readonly oauthRedirectUri?: string;
    /**
    * Specifies how long refresh tokens should be valid (in seconds). OAUTH_ISSUE_REFRESH_TOKENS must be set to TRUE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#oauth_refresh_token_validity OauthIntegrationForPartnerApplications#oauth_refresh_token_validity}
    */
    readonly oauthRefreshTokenValidity?: number;
    /**
    * Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#oauth_use_secondary_roles OauthIntegrationForPartnerApplications#oauth_use_secondary_roles}
    */
    readonly oauthUseSecondaryRoles?: string;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStruct {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStructToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStruct): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStructToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStruct): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStruct | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStruct | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStructOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputComment {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputCommentToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputComment): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputCommentToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputComment): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputCommentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputComment | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputComment | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputCommentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputCommentOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputEnabled {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputEnabledToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputEnabled): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputEnabledToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputEnabled): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputEnabled | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputEnabled | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputEnabledList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputEnabledOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicy {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicyToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicy): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicyToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicy): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicy | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicy | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicyOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUri {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUriToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUri): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUriToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUri): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUriOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUri | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUri | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUriList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUriOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpoints {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpointsToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpoints): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpointsToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpoints): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpoints | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpoints | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpointsOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpoints {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpointsToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpoints): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpointsToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpoints): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpoints | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpoints | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpointsOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpoint {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpointToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpoint): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpointToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpoint): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpoint | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpointOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientId {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthClientIdToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientId): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthClientIdToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientId): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientId | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientId | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientIdOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2Fp {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2FpToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2Fp): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2FpToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2Fp): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2FpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2Fp | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2Fp | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2FpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2FpOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFp {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFpToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFp): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFpToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFp): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFp | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFp | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFpOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientType {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthClientTypeToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientType): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthClientTypeToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientType): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientType | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientType | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientTypeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientTypeOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkce {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkceToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkce): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkceToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkce): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkce | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkce | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkceOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokens {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokensToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokens): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokensToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokens): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokensOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokens | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokens | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokensList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokensOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUri {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUriToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUri): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUriToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUri): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUriOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUri | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUri | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUriList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUriOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidity {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidityToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidity): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidityToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidity): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidity | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidity | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidityOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpoint {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpointToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpoint): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpointToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpoint): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpoint | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpointOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRoles {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRolesToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRoles): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRolesToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRoles): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRoles | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRoles | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRolesOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStruct {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStructToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStruct): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStructToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStruct): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStruct | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStruct | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStructOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsDescribeOutput {
}
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputToTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutput): any;
export declare function oauthIntegrationForPartnerApplicationsDescribeOutputToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsDescribeOutput): any;
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsDescribeOutput | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsDescribeOutput | undefined);
    private _blockedRolesList;
    get blockedRolesList(): OauthIntegrationForPartnerApplicationsDescribeOutputBlockedRolesListStructList;
    private _comment;
    get comment(): OauthIntegrationForPartnerApplicationsDescribeOutputCommentList;
    private _enabled;
    get enabled(): OauthIntegrationForPartnerApplicationsDescribeOutputEnabledList;
    private _networkPolicy;
    get networkPolicy(): OauthIntegrationForPartnerApplicationsDescribeOutputNetworkPolicyList;
    private _oauthAllowNonTlsRedirectUri;
    get oauthAllowNonTlsRedirectUri(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowNonTlsRedirectUriList;
    private _oauthAllowedAuthorizationEndpoints;
    get oauthAllowedAuthorizationEndpoints(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedAuthorizationEndpointsList;
    private _oauthAllowedTokenEndpoints;
    get oauthAllowedTokenEndpoints(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAllowedTokenEndpointsList;
    private _oauthAuthorizationEndpoint;
    get oauthAuthorizationEndpoint(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthAuthorizationEndpointList;
    private _oauthClientId;
    get oauthClientId(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientIdList;
    private _oauthClientRsaPublicKey2Fp;
    get oauthClientRsaPublicKey2Fp(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKey2FpList;
    private _oauthClientRsaPublicKeyFp;
    get oauthClientRsaPublicKeyFp(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientRsaPublicKeyFpList;
    private _oauthClientType;
    get oauthClientType(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthClientTypeList;
    private _oauthEnforcePkce;
    get oauthEnforcePkce(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthEnforcePkceList;
    private _oauthIssueRefreshTokens;
    get oauthIssueRefreshTokens(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthIssueRefreshTokensList;
    private _oauthRedirectUri;
    get oauthRedirectUri(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthRedirectUriList;
    private _oauthRefreshTokenValidity;
    get oauthRefreshTokenValidity(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthRefreshTokenValidityList;
    private _oauthTokenEndpoint;
    get oauthTokenEndpoint(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthTokenEndpointList;
    private _oauthUseSecondaryRoles;
    get oauthUseSecondaryRoles(): OauthIntegrationForPartnerApplicationsDescribeOutputOauthUseSecondaryRolesList;
    private _preAuthorizedRolesList;
    get preAuthorizedRolesList(): OauthIntegrationForPartnerApplicationsDescribeOutputPreAuthorizedRolesListStructList;
}
export declare class OauthIntegrationForPartnerApplicationsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsDescribeOutputOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStruct {
}
export declare function oauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStructToTerraform(struct?: OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStruct): any;
export declare function oauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStructToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStruct): any;
export declare class OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStruct | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStruct | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStructOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsRelatedParameters {
}
export declare function oauthIntegrationForPartnerApplicationsRelatedParametersToTerraform(struct?: OauthIntegrationForPartnerApplicationsRelatedParameters): any;
export declare function oauthIntegrationForPartnerApplicationsRelatedParametersToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsRelatedParameters): any;
export declare class OauthIntegrationForPartnerApplicationsRelatedParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsRelatedParameters | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsRelatedParameters | undefined);
    private _oauthAddPrivilegedRolesToBlockedList;
    get oauthAddPrivilegedRolesToBlockedList(): OauthIntegrationForPartnerApplicationsRelatedParametersOauthAddPrivilegedRolesToBlockedListStructList;
}
export declare class OauthIntegrationForPartnerApplicationsRelatedParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsRelatedParametersOutputReference;
}
export interface OauthIntegrationForPartnerApplicationsShowOutput {
}
export declare function oauthIntegrationForPartnerApplicationsShowOutputToTerraform(struct?: OauthIntegrationForPartnerApplicationsShowOutput): any;
export declare function oauthIntegrationForPartnerApplicationsShowOutputToHclTerraform(struct?: OauthIntegrationForPartnerApplicationsShowOutput): any;
export declare class OauthIntegrationForPartnerApplicationsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForPartnerApplicationsShowOutput | undefined;
    set internalValue(value: OauthIntegrationForPartnerApplicationsShowOutput | undefined);
    get category(): string;
    get comment(): string;
    get createdOn(): string;
    get enabled(): cdktf.IResolvable;
    get integrationType(): string;
    get name(): string;
}
export declare class OauthIntegrationForPartnerApplicationsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForPartnerApplicationsShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications snowflake_oauth_integration_for_partner_applications}
*/
export declare class OauthIntegrationForPartnerApplications extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_oauth_integration_for_partner_applications";
    /**
    * Generates CDKTF code for importing a OauthIntegrationForPartnerApplications resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OauthIntegrationForPartnerApplications to import
    * @param importFromId The id of the existing OauthIntegrationForPartnerApplications that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OauthIntegrationForPartnerApplications to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/oauth_integration_for_partner_applications snowflake_oauth_integration_for_partner_applications} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OauthIntegrationForPartnerApplicationsConfig
    */
    constructor(scope: Construct, id: string, config: OauthIntegrationForPartnerApplicationsConfig);
    private _blockedRolesList?;
    get blockedRolesList(): string[];
    set blockedRolesList(value: string[]);
    resetBlockedRolesList(): void;
    get blockedRolesListInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): OauthIntegrationForPartnerApplicationsDescribeOutputList;
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oauthClient?;
    get oauthClient(): string;
    set oauthClient(value: string);
    get oauthClientInput(): string | undefined;
    private _oauthIssueRefreshTokens?;
    get oauthIssueRefreshTokens(): string;
    set oauthIssueRefreshTokens(value: string);
    resetOauthIssueRefreshTokens(): void;
    get oauthIssueRefreshTokensInput(): string | undefined;
    private _oauthRedirectUri?;
    get oauthRedirectUri(): string;
    set oauthRedirectUri(value: string);
    resetOauthRedirectUri(): void;
    get oauthRedirectUriInput(): string | undefined;
    private _oauthRefreshTokenValidity?;
    get oauthRefreshTokenValidity(): number;
    set oauthRefreshTokenValidity(value: number);
    resetOauthRefreshTokenValidity(): void;
    get oauthRefreshTokenValidityInput(): number | undefined;
    private _oauthUseSecondaryRoles?;
    get oauthUseSecondaryRoles(): string;
    set oauthUseSecondaryRoles(value: string);
    resetOauthUseSecondaryRoles(): void;
    get oauthUseSecondaryRolesInput(): string | undefined;
    private _relatedParameters;
    get relatedParameters(): OauthIntegrationForPartnerApplicationsRelatedParametersList;
    private _showOutput;
    get showOutput(): OauthIntegrationForPartnerApplicationsShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
