/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrimaryConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/primary_connection#comment PrimaryConnection#comment}
    */
    readonly comment?: string;
    /**
    * Enables failover for given connection to provided accounts. Specifies a list of accounts in your organization where a secondary connection for this primary connection can be promoted to serve as the primary connection. Include your organization name for each account in the list. For more information about this resource, see [docs](./account).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/primary_connection#enable_failover_to_accounts PrimaryConnection#enable_failover_to_accounts}
    */
    readonly enableFailoverToAccounts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/primary_connection#id PrimaryConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String that specifies the identifier (i.e. name) for the connection. Must start with an alphabetic character and may only contain letters, decimal digits (0-9), and underscores (_). For a primary connection, the name must be unique across connection names and account names in the organization.  Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/primary_connection#name PrimaryConnection#name}
    */
    readonly name: string;
}
export interface PrimaryConnectionShowOutput {
}
export declare function primaryConnectionShowOutputToTerraform(struct?: PrimaryConnectionShowOutput): any;
export declare function primaryConnectionShowOutputToHclTerraform(struct?: PrimaryConnectionShowOutput): any;
export declare class PrimaryConnectionShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrimaryConnectionShowOutput | undefined;
    set internalValue(value: PrimaryConnectionShowOutput | undefined);
    get accountLocator(): string;
    get accountName(): string;
    get comment(): string;
    get connectionUrl(): string;
    get createdOn(): string;
    get failoverAllowedToAccounts(): string[];
    get isPrimary(): cdktf.IResolvable;
    get name(): string;
    get organizationName(): string;
    get primary(): string;
    get regionGroup(): string;
    get snowflakeRegion(): string;
}
export declare class PrimaryConnectionShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrimaryConnectionShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/primary_connection snowflake_primary_connection}
*/
export declare class PrimaryConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_primary_connection";
    /**
    * Generates CDKTF code for importing a PrimaryConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PrimaryConnection to import
    * @param importFromId The id of the existing PrimaryConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/primary_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PrimaryConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/primary_connection snowflake_primary_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrimaryConnectionConfig
    */
    constructor(scope: Construct, id: string, config: PrimaryConnectionConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _enableFailoverToAccounts?;
    get enableFailoverToAccounts(): string[];
    set enableFailoverToAccounts(value: string[]);
    resetEnableFailoverToAccounts(): void;
    get enableFailoverToAccountsInput(): string[] | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isPrimary(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _showOutput;
    get showOutput(): PrimaryConnectionShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
