/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProcedureJavascriptConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the procedure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#comment ProcedureJavascript#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the procedure. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#database ProcedureJavascript#database}
    */
    readonly database: string;
    /**
    * Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG_LEVEL). For more information, check [ENABLE_CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#enable_console_output ProcedureJavascript#enable_console_output}
    */
    readonly enableConsoleOutput?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#execute_as ProcedureJavascript#execute_as}
    */
    readonly executeAs?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#id ProcedureJavascript#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#is_secure ProcedureJavascript#is_secure}
    */
    readonly isSecure?: string;
    /**
    * LOG_LEVEL to use when filtering events For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#log_level ProcedureJavascript#log_level}
    */
    readonly logLevel?: string;
    /**
    * METRIC_LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#metric_level ProcedureJavascript#metric_level}
    */
    readonly metricLevel?: string;
    /**
    * The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#name ProcedureJavascript#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#null_input_behavior ProcedureJavascript#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be JavaScript source code. For more information, see [JavaScript](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-javascript). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#procedure_definition ProcedureJavascript#procedure_definition}
    */
    readonly procedureDefinition: string;
    /**
    * Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL and JavaScript data type mapping](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-javascript.html#label-stored-procedure-data-type-mapping)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#return_type ProcedureJavascript#return_type}
    */
    readonly returnType: string;
    /**
    * The schema in which to create the procedure. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#schema ProcedureJavascript#schema}
    */
    readonly schema: string;
    /**
    * Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#trace_level ProcedureJavascript#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#arguments ProcedureJavascript#arguments}
    */
    readonly arguments?: ProcedureJavascriptArguments[] | cdktf.IResolvable;
}
export interface ProcedureJavascriptParametersEnableConsoleOutput {
}
export declare function procedureJavascriptParametersEnableConsoleOutputToTerraform(struct?: ProcedureJavascriptParametersEnableConsoleOutput): any;
export declare function procedureJavascriptParametersEnableConsoleOutputToHclTerraform(struct?: ProcedureJavascriptParametersEnableConsoleOutput): any;
export declare class ProcedureJavascriptParametersEnableConsoleOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavascriptParametersEnableConsoleOutput | undefined;
    set internalValue(value: ProcedureJavascriptParametersEnableConsoleOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureJavascriptParametersEnableConsoleOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavascriptParametersEnableConsoleOutputOutputReference;
}
export interface ProcedureJavascriptParametersLogLevel {
}
export declare function procedureJavascriptParametersLogLevelToTerraform(struct?: ProcedureJavascriptParametersLogLevel): any;
export declare function procedureJavascriptParametersLogLevelToHclTerraform(struct?: ProcedureJavascriptParametersLogLevel): any;
export declare class ProcedureJavascriptParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavascriptParametersLogLevel | undefined;
    set internalValue(value: ProcedureJavascriptParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureJavascriptParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavascriptParametersLogLevelOutputReference;
}
export interface ProcedureJavascriptParametersMetricLevel {
}
export declare function procedureJavascriptParametersMetricLevelToTerraform(struct?: ProcedureJavascriptParametersMetricLevel): any;
export declare function procedureJavascriptParametersMetricLevelToHclTerraform(struct?: ProcedureJavascriptParametersMetricLevel): any;
export declare class ProcedureJavascriptParametersMetricLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavascriptParametersMetricLevel | undefined;
    set internalValue(value: ProcedureJavascriptParametersMetricLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureJavascriptParametersMetricLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavascriptParametersMetricLevelOutputReference;
}
export interface ProcedureJavascriptParametersTraceLevel {
}
export declare function procedureJavascriptParametersTraceLevelToTerraform(struct?: ProcedureJavascriptParametersTraceLevel): any;
export declare function procedureJavascriptParametersTraceLevelToHclTerraform(struct?: ProcedureJavascriptParametersTraceLevel): any;
export declare class ProcedureJavascriptParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavascriptParametersTraceLevel | undefined;
    set internalValue(value: ProcedureJavascriptParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureJavascriptParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavascriptParametersTraceLevelOutputReference;
}
export interface ProcedureJavascriptParameters {
}
export declare function procedureJavascriptParametersToTerraform(struct?: ProcedureJavascriptParameters): any;
export declare function procedureJavascriptParametersToHclTerraform(struct?: ProcedureJavascriptParameters): any;
export declare class ProcedureJavascriptParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavascriptParameters | undefined;
    set internalValue(value: ProcedureJavascriptParameters | undefined);
    private _enableConsoleOutput;
    get enableConsoleOutput(): ProcedureJavascriptParametersEnableConsoleOutputList;
    private _logLevel;
    get logLevel(): ProcedureJavascriptParametersLogLevelList;
    private _metricLevel;
    get metricLevel(): ProcedureJavascriptParametersMetricLevelList;
    private _traceLevel;
    get traceLevel(): ProcedureJavascriptParametersTraceLevelList;
}
export declare class ProcedureJavascriptParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavascriptParametersOutputReference;
}
export interface ProcedureJavascriptShowOutput {
}
export declare function procedureJavascriptShowOutputToTerraform(struct?: ProcedureJavascriptShowOutput): any;
export declare function procedureJavascriptShowOutputToHclTerraform(struct?: ProcedureJavascriptShowOutput): any;
export declare class ProcedureJavascriptShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavascriptShowOutput | undefined;
    set internalValue(value: ProcedureJavascriptShowOutput | undefined);
    get argumentsRaw(): string;
    get catalogName(): string;
    get createdOn(): string;
    get description(): string;
    get externalAccessIntegrations(): string;
    get isAggregate(): cdktf.IResolvable;
    get isAnsi(): cdktf.IResolvable;
    get isBuiltin(): cdktf.IResolvable;
    get isSecure(): cdktf.IResolvable;
    get isTableFunction(): cdktf.IResolvable;
    get maxNumArguments(): number;
    get minNumArguments(): number;
    get name(): string;
    get schemaName(): string;
    get secrets(): string;
    get validForClustering(): cdktf.IResolvable;
}
export declare class ProcedureJavascriptShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavascriptShowOutputOutputReference;
}
export interface ProcedureJavascriptArguments {
    /**
    * The argument type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#arg_data_type ProcedureJavascript#arg_data_type}
    */
    readonly argDataType: string;
    /**
    * Optional default value for the argument. For text values use single quotes. Numeric values can be unquoted. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#arg_default_value ProcedureJavascript#arg_default_value}
    */
    readonly argDefaultValue?: string;
    /**
    * The argument name. The provider wraps it in double quotes by default, so be aware of that while referencing the argument in the procedure definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#arg_name ProcedureJavascript#arg_name}
    */
    readonly argName: string;
}
export declare function procedureJavascriptArgumentsToTerraform(struct?: ProcedureJavascriptArguments | cdktf.IResolvable): any;
export declare function procedureJavascriptArgumentsToHclTerraform(struct?: ProcedureJavascriptArguments | cdktf.IResolvable): any;
export declare class ProcedureJavascriptArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureJavascriptArguments | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureJavascriptArguments | cdktf.IResolvable | undefined);
    private _argDataType?;
    get argDataType(): string;
    set argDataType(value: string);
    get argDataTypeInput(): string | undefined;
    private _argDefaultValue?;
    get argDefaultValue(): string;
    set argDefaultValue(value: string);
    resetArgDefaultValue(): void;
    get argDefaultValueInput(): string | undefined;
    private _argName?;
    get argName(): string;
    set argName(value: string);
    get argNameInput(): string | undefined;
}
export declare class ProcedureJavascriptArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureJavascriptArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureJavascriptArgumentsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript snowflake_procedure_javascript}
*/
export declare class ProcedureJavascript extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_procedure_javascript";
    /**
    * Generates CDKTF code for importing a ProcedureJavascript resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProcedureJavascript to import
    * @param importFromId The id of the existing ProcedureJavascript that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProcedureJavascript to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_javascript snowflake_procedure_javascript} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProcedureJavascriptConfig
    */
    constructor(scope: Construct, id: string, config: ProcedureJavascriptConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _enableConsoleOutput?;
    get enableConsoleOutput(): boolean | cdktf.IResolvable;
    set enableConsoleOutput(value: boolean | cdktf.IResolvable);
    resetEnableConsoleOutput(): void;
    get enableConsoleOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _executeAs?;
    get executeAs(): string;
    set executeAs(value: string);
    resetExecuteAs(): void;
    get executeAsInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isSecure?;
    get isSecure(): string;
    set isSecure(value: string);
    resetIsSecure(): void;
    get isSecureInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _metricLevel?;
    get metricLevel(): string;
    set metricLevel(value: string);
    resetMetricLevel(): void;
    get metricLevelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _parameters;
    get parameters(): ProcedureJavascriptParametersList;
    private _procedureDefinition?;
    get procedureDefinition(): string;
    set procedureDefinition(value: string);
    get procedureDefinitionInput(): string | undefined;
    get procedureLanguage(): string;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): ProcedureJavascriptShowOutputList;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _arguments;
    get arguments(): ProcedureJavascriptArgumentsList;
    putArguments(value: ProcedureJavascriptArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | ProcedureJavascriptArguments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
