/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProcedureScalaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the procedure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#comment ProcedureScala#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the procedure. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#database ProcedureScala#database}
    */
    readonly database: string;
    /**
    * Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG_LEVEL). For more information, check [ENABLE_CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#enable_console_output ProcedureScala#enable_console_output}
    */
    readonly enableConsoleOutput?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#execute_as ProcedureScala#execute_as}
    */
    readonly executeAs?: string;
    /**
    * The names of [external access integrations](https://docs.snowflake.com/en/sql-reference/sql/create-external-access-integration) needed in order for this procedure’s handler code to access external networks. An external access integration specifies [network rules](https://docs.snowflake.com/en/sql-reference/sql/create-network-rule) and [secrets](https://docs.snowflake.com/en/sql-reference/sql/create-secret) that specify external locations and credentials (if any) allowed for use by handler code when making requests of an external network, such as an external REST API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#external_access_integrations ProcedureScala#external_access_integrations}
    */
    readonly externalAccessIntegrations?: string[];
    /**
    * Use the fully qualified name of the method or function for the stored procedure. This is typically in the following form: `com.my_company.my_package.MyClass.myMethod` where `com.my_company.my_package` corresponds to the package containing the object or class: `package com.my_company.my_package;`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#handler ProcedureScala#handler}
    */
    readonly handler: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#id ProcedureScala#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#is_secure ProcedureScala#is_secure}
    */
    readonly isSecure?: string;
    /**
    * LOG_LEVEL to use when filtering events For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#log_level ProcedureScala#log_level}
    */
    readonly logLevel?: string;
    /**
    * METRIC_LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#metric_level ProcedureScala#metric_level}
    */
    readonly metricLevel?: string;
    /**
    * The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#name ProcedureScala#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#null_input_behavior ProcedureScala#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * List of the names of packages deployed in Snowflake that should be included in the handler code’s execution environment. The Snowpark package is required for stored procedures, but is specified in the `snowpark_package` attribute. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#packages ProcedureScala#packages}
    */
    readonly packages?: string[];
    /**
    * Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be Scala source code. For more information, see [Scala (using Snowpark)](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-scala). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#procedure_definition ProcedureScala#procedure_definition}
    */
    readonly procedureDefinition?: string;
    /**
    * Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL-Scala Data Type Mappings](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-data-type-mapping.html#label-sql-types-to-scala-types)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#return_type ProcedureScala#return_type}
    */
    readonly returnType: string;
    /**
    * The language runtime version to use. Currently, the supported versions are: 2.12.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#runtime_version ProcedureScala#runtime_version}
    */
    readonly runtimeVersion: string;
    /**
    * The schema in which to create the procedure. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#schema ProcedureScala#schema}
    */
    readonly schema: string;
    /**
    * The Snowpark package is required for stored procedures, so it must always be present. For more information about Snowpark, see [Snowpark API](https://docs.snowflake.com/en/developer-guide/snowpark/index).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#snowpark_package ProcedureScala#snowpark_package}
    */
    readonly snowparkPackage: string;
    /**
    * Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#trace_level ProcedureScala#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#arguments ProcedureScala#arguments}
    */
    readonly arguments?: ProcedureScalaArguments[] | cdktf.IResolvable;
    /**
    * imports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#imports ProcedureScala#imports}
    */
    readonly imports?: ProcedureScalaImports[] | cdktf.IResolvable;
    /**
    * secrets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#secrets ProcedureScala#secrets}
    */
    readonly secrets?: ProcedureScalaSecrets[] | cdktf.IResolvable;
    /**
    * target_path block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#target_path ProcedureScala#target_path}
    */
    readonly targetPath?: ProcedureScalaTargetPath;
}
export interface ProcedureScalaParametersEnableConsoleOutput {
}
export declare function procedureScalaParametersEnableConsoleOutputToTerraform(struct?: ProcedureScalaParametersEnableConsoleOutput): any;
export declare function procedureScalaParametersEnableConsoleOutputToHclTerraform(struct?: ProcedureScalaParametersEnableConsoleOutput): any;
export declare class ProcedureScalaParametersEnableConsoleOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaParametersEnableConsoleOutput | undefined;
    set internalValue(value: ProcedureScalaParametersEnableConsoleOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureScalaParametersEnableConsoleOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaParametersEnableConsoleOutputOutputReference;
}
export interface ProcedureScalaParametersLogLevel {
}
export declare function procedureScalaParametersLogLevelToTerraform(struct?: ProcedureScalaParametersLogLevel): any;
export declare function procedureScalaParametersLogLevelToHclTerraform(struct?: ProcedureScalaParametersLogLevel): any;
export declare class ProcedureScalaParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaParametersLogLevel | undefined;
    set internalValue(value: ProcedureScalaParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureScalaParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaParametersLogLevelOutputReference;
}
export interface ProcedureScalaParametersMetricLevel {
}
export declare function procedureScalaParametersMetricLevelToTerraform(struct?: ProcedureScalaParametersMetricLevel): any;
export declare function procedureScalaParametersMetricLevelToHclTerraform(struct?: ProcedureScalaParametersMetricLevel): any;
export declare class ProcedureScalaParametersMetricLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaParametersMetricLevel | undefined;
    set internalValue(value: ProcedureScalaParametersMetricLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureScalaParametersMetricLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaParametersMetricLevelOutputReference;
}
export interface ProcedureScalaParametersTraceLevel {
}
export declare function procedureScalaParametersTraceLevelToTerraform(struct?: ProcedureScalaParametersTraceLevel): any;
export declare function procedureScalaParametersTraceLevelToHclTerraform(struct?: ProcedureScalaParametersTraceLevel): any;
export declare class ProcedureScalaParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaParametersTraceLevel | undefined;
    set internalValue(value: ProcedureScalaParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureScalaParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaParametersTraceLevelOutputReference;
}
export interface ProcedureScalaParameters {
}
export declare function procedureScalaParametersToTerraform(struct?: ProcedureScalaParameters): any;
export declare function procedureScalaParametersToHclTerraform(struct?: ProcedureScalaParameters): any;
export declare class ProcedureScalaParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaParameters | undefined;
    set internalValue(value: ProcedureScalaParameters | undefined);
    private _enableConsoleOutput;
    get enableConsoleOutput(): ProcedureScalaParametersEnableConsoleOutputList;
    private _logLevel;
    get logLevel(): ProcedureScalaParametersLogLevelList;
    private _metricLevel;
    get metricLevel(): ProcedureScalaParametersMetricLevelList;
    private _traceLevel;
    get traceLevel(): ProcedureScalaParametersTraceLevelList;
}
export declare class ProcedureScalaParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaParametersOutputReference;
}
export interface ProcedureScalaShowOutput {
}
export declare function procedureScalaShowOutputToTerraform(struct?: ProcedureScalaShowOutput): any;
export declare function procedureScalaShowOutputToHclTerraform(struct?: ProcedureScalaShowOutput): any;
export declare class ProcedureScalaShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaShowOutput | undefined;
    set internalValue(value: ProcedureScalaShowOutput | undefined);
    get argumentsRaw(): string;
    get catalogName(): string;
    get createdOn(): string;
    get description(): string;
    get externalAccessIntegrations(): string;
    get isAggregate(): cdktf.IResolvable;
    get isAnsi(): cdktf.IResolvable;
    get isBuiltin(): cdktf.IResolvable;
    get isSecure(): cdktf.IResolvable;
    get isTableFunction(): cdktf.IResolvable;
    get maxNumArguments(): number;
    get minNumArguments(): number;
    get name(): string;
    get schemaName(): string;
    get secrets(): string;
    get validForClustering(): cdktf.IResolvable;
}
export declare class ProcedureScalaShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaShowOutputOutputReference;
}
export interface ProcedureScalaArguments {
    /**
    * The argument type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#arg_data_type ProcedureScala#arg_data_type}
    */
    readonly argDataType: string;
    /**
    * Optional default value for the argument. For text values use single quotes. Numeric values can be unquoted. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#arg_default_value ProcedureScala#arg_default_value}
    */
    readonly argDefaultValue?: string;
    /**
    * The argument name. The provider wraps it in double quotes by default, so be aware of that while referencing the argument in the procedure definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#arg_name ProcedureScala#arg_name}
    */
    readonly argName: string;
}
export declare function procedureScalaArgumentsToTerraform(struct?: ProcedureScalaArguments | cdktf.IResolvable): any;
export declare function procedureScalaArgumentsToHclTerraform(struct?: ProcedureScalaArguments | cdktf.IResolvable): any;
export declare class ProcedureScalaArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaArguments | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureScalaArguments | cdktf.IResolvable | undefined);
    private _argDataType?;
    get argDataType(): string;
    set argDataType(value: string);
    get argDataTypeInput(): string | undefined;
    private _argDefaultValue?;
    get argDefaultValue(): string;
    set argDefaultValue(value: string);
    resetArgDefaultValue(): void;
    get argDefaultValueInput(): string | undefined;
    private _argName?;
    get argName(): string;
    set argName(value: string);
    get argNameInput(): string | undefined;
}
export declare class ProcedureScalaArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureScalaArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaArgumentsOutputReference;
}
export interface ProcedureScalaImports {
    /**
    * Path for import on stage, without the leading `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#path_on_stage ProcedureScala#path_on_stage}
    */
    readonly pathOnStage: string;
    /**
    * Stage location without leading `@`. To use your user's stage set this to `~`, otherwise pass fully qualified name of the stage (with every part contained in double quotes or use `snowflake_stage.<your stage's resource name>.fully_qualified_name` if you manage this stage through terraform).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#stage_location ProcedureScala#stage_location}
    */
    readonly stageLocation: string;
}
export declare function procedureScalaImportsToTerraform(struct?: ProcedureScalaImports | cdktf.IResolvable): any;
export declare function procedureScalaImportsToHclTerraform(struct?: ProcedureScalaImports | cdktf.IResolvable): any;
export declare class ProcedureScalaImportsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaImports | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureScalaImports | cdktf.IResolvable | undefined);
    private _pathOnStage?;
    get pathOnStage(): string;
    set pathOnStage(value: string);
    get pathOnStageInput(): string | undefined;
    private _stageLocation?;
    get stageLocation(): string;
    set stageLocation(value: string);
    get stageLocationInput(): string | undefined;
}
export declare class ProcedureScalaImportsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureScalaImports[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaImportsOutputReference;
}
export interface ProcedureScalaSecrets {
    /**
    * Fully qualified name of the allowed [secret](https://docs.snowflake.com/en/sql-reference/sql/create-secret). You will receive an error if you specify a SECRETS value whose secret isn’t also included in an integration specified by the EXTERNAL_ACCESS_INTEGRATIONS parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#secret_id ProcedureScala#secret_id}
    */
    readonly secretId: string;
    /**
    * The variable that will be used in handler code when retrieving information from the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#secret_variable_name ProcedureScala#secret_variable_name}
    */
    readonly secretVariableName: string;
}
export declare function procedureScalaSecretsToTerraform(struct?: ProcedureScalaSecrets | cdktf.IResolvable): any;
export declare function procedureScalaSecretsToHclTerraform(struct?: ProcedureScalaSecrets | cdktf.IResolvable): any;
export declare class ProcedureScalaSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureScalaSecrets | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureScalaSecrets | cdktf.IResolvable | undefined);
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _secretVariableName?;
    get secretVariableName(): string;
    set secretVariableName(value: string);
    get secretVariableNameInput(): string | undefined;
}
export declare class ProcedureScalaSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureScalaSecrets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureScalaSecretsOutputReference;
}
export interface ProcedureScalaTargetPath {
    /**
    * Path for import on stage, without the leading `/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#path_on_stage ProcedureScala#path_on_stage}
    */
    readonly pathOnStage: string;
    /**
    * Stage location without leading `@`. To use your user's stage set this to `~`, otherwise pass fully qualified name of the stage (with every part contained in double quotes or use `snowflake_stage.<your stage's resource name>.fully_qualified_name` if you manage this stage through terraform).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#stage_location ProcedureScala#stage_location}
    */
    readonly stageLocation: string;
}
export declare function procedureScalaTargetPathToTerraform(struct?: ProcedureScalaTargetPathOutputReference | ProcedureScalaTargetPath): any;
export declare function procedureScalaTargetPathToHclTerraform(struct?: ProcedureScalaTargetPathOutputReference | ProcedureScalaTargetPath): any;
export declare class ProcedureScalaTargetPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProcedureScalaTargetPath | undefined;
    set internalValue(value: ProcedureScalaTargetPath | undefined);
    private _pathOnStage?;
    get pathOnStage(): string;
    set pathOnStage(value: string);
    get pathOnStageInput(): string | undefined;
    private _stageLocation?;
    get stageLocation(): string;
    set stageLocation(value: string);
    get stageLocationInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala snowflake_procedure_scala}
*/
export declare class ProcedureScala extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_procedure_scala";
    /**
    * Generates CDKTF code for importing a ProcedureScala resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProcedureScala to import
    * @param importFromId The id of the existing ProcedureScala that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProcedureScala to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/procedure_scala snowflake_procedure_scala} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProcedureScalaConfig
    */
    constructor(scope: Construct, id: string, config: ProcedureScalaConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _enableConsoleOutput?;
    get enableConsoleOutput(): boolean | cdktf.IResolvable;
    set enableConsoleOutput(value: boolean | cdktf.IResolvable);
    resetEnableConsoleOutput(): void;
    get enableConsoleOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _executeAs?;
    get executeAs(): string;
    set executeAs(value: string);
    resetExecuteAs(): void;
    get executeAsInput(): string | undefined;
    private _externalAccessIntegrations?;
    get externalAccessIntegrations(): string[];
    set externalAccessIntegrations(value: string[]);
    resetExternalAccessIntegrations(): void;
    get externalAccessIntegrationsInput(): string[] | undefined;
    get fullyQualifiedName(): string;
    private _handler?;
    get handler(): string;
    set handler(value: string);
    get handlerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isSecure?;
    get isSecure(): string;
    set isSecure(value: string);
    resetIsSecure(): void;
    get isSecureInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _metricLevel?;
    get metricLevel(): string;
    set metricLevel(value: string);
    resetMetricLevel(): void;
    get metricLevelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _packages?;
    get packages(): string[];
    set packages(value: string[]);
    resetPackages(): void;
    get packagesInput(): string[] | undefined;
    private _parameters;
    get parameters(): ProcedureScalaParametersList;
    private _procedureDefinition?;
    get procedureDefinition(): string;
    set procedureDefinition(value: string);
    resetProcedureDefinition(): void;
    get procedureDefinitionInput(): string | undefined;
    get procedureLanguage(): string;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    get runtimeVersionInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): ProcedureScalaShowOutputList;
    private _snowparkPackage?;
    get snowparkPackage(): string;
    set snowparkPackage(value: string);
    get snowparkPackageInput(): string | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _arguments;
    get arguments(): ProcedureScalaArgumentsList;
    putArguments(value: ProcedureScalaArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | ProcedureScalaArguments[] | undefined;
    private _imports;
    get imports(): ProcedureScalaImportsList;
    putImports(value: ProcedureScalaImports[] | cdktf.IResolvable): void;
    resetImports(): void;
    get importsInput(): cdktf.IResolvable | ProcedureScalaImports[] | undefined;
    private _secrets;
    get secrets(): ProcedureScalaSecretsList;
    putSecrets(value: ProcedureScalaSecrets[] | cdktf.IResolvable): void;
    resetSecrets(): void;
    get secretsInput(): cdktf.IResolvable | ProcedureScalaSecrets[] | undefined;
    private _targetPath;
    get targetPath(): ProcedureScalaTargetPathOutputReference;
    putTargetPath(value: ProcedureScalaTargetPath): void;
    resetTargetPath(): void;
    get targetPathInput(): ProcedureScalaTargetPath | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
