"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecondaryDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database snowflake_secondary_database}
*/
class SecondaryDatabase extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a SecondaryDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecondaryDatabase to import
    * @param importFromId The id of the existing SecondaryDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecondaryDatabase to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "snowflake_secondary_database", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/1.0.4/docs/resources/secondary_database snowflake_secondary_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecondaryDatabaseConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_secondary_database',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '1.0.4',
                providerVersionConstraint: ' ~> 1.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._asReplicaOf = config.asReplicaOf;
        this._catalog = config.catalog;
        this._comment = config.comment;
        this._dataRetentionTimeInDays = config.dataRetentionTimeInDays;
        this._defaultDdlCollation = config.defaultDdlCollation;
        this._enableConsoleOutput = config.enableConsoleOutput;
        this._externalVolume = config.externalVolume;
        this._id = config.id;
        this._isTransient = config.isTransient;
        this._logLevel = config.logLevel;
        this._maxDataExtensionTimeInDays = config.maxDataExtensionTimeInDays;
        this._name = config.name;
        this._quotedIdentifiersIgnoreCase = config.quotedIdentifiersIgnoreCase;
        this._replaceInvalidCharacters = config.replaceInvalidCharacters;
        this._storageSerializationPolicy = config.storageSerializationPolicy;
        this._suspendTaskAfterNumFailures = config.suspendTaskAfterNumFailures;
        this._taskAutoRetryAttempts = config.taskAutoRetryAttempts;
        this._traceLevel = config.traceLevel;
        this._userTaskManagedInitialWarehouseSize = config.userTaskManagedInitialWarehouseSize;
        this._userTaskMinimumTriggerIntervalInSeconds = config.userTaskMinimumTriggerIntervalInSeconds;
        this._userTaskTimeoutMs = config.userTaskTimeoutMs;
    }
    get asReplicaOf() {
        return this.getStringAttribute('as_replica_of');
    }
    set asReplicaOf(value) {
        this._asReplicaOf = value;
    }
    // Temporarily expose input value. Use with caution.
    get asReplicaOfInput() {
        return this._asReplicaOf;
    }
    get catalog() {
        return this.getStringAttribute('catalog');
    }
    set catalog(value) {
        this._catalog = value;
    }
    resetCatalog() {
        this._catalog = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get catalogInput() {
        return this._catalog;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get dataRetentionTimeInDays() {
        return this.getNumberAttribute('data_retention_time_in_days');
    }
    set dataRetentionTimeInDays(value) {
        this._dataRetentionTimeInDays = value;
    }
    resetDataRetentionTimeInDays() {
        this._dataRetentionTimeInDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dataRetentionTimeInDaysInput() {
        return this._dataRetentionTimeInDays;
    }
    get defaultDdlCollation() {
        return this.getStringAttribute('default_ddl_collation');
    }
    set defaultDdlCollation(value) {
        this._defaultDdlCollation = value;
    }
    resetDefaultDdlCollation() {
        this._defaultDdlCollation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultDdlCollationInput() {
        return this._defaultDdlCollation;
    }
    get enableConsoleOutput() {
        return this.getBooleanAttribute('enable_console_output');
    }
    set enableConsoleOutput(value) {
        this._enableConsoleOutput = value;
    }
    resetEnableConsoleOutput() {
        this._enableConsoleOutput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableConsoleOutputInput() {
        return this._enableConsoleOutput;
    }
    get externalVolume() {
        return this.getStringAttribute('external_volume');
    }
    set externalVolume(value) {
        this._externalVolume = value;
    }
    resetExternalVolume() {
        this._externalVolume = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalVolumeInput() {
        return this._externalVolume;
    }
    // fully_qualified_name - computed: true, optional: false, required: false
    get fullyQualifiedName() {
        return this.getStringAttribute('fully_qualified_name');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get isTransient() {
        return this.getBooleanAttribute('is_transient');
    }
    set isTransient(value) {
        this._isTransient = value;
    }
    resetIsTransient() {
        this._isTransient = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get isTransientInput() {
        return this._isTransient;
    }
    get logLevel() {
        return this.getStringAttribute('log_level');
    }
    set logLevel(value) {
        this._logLevel = value;
    }
    resetLogLevel() {
        this._logLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logLevelInput() {
        return this._logLevel;
    }
    get maxDataExtensionTimeInDays() {
        return this.getNumberAttribute('max_data_extension_time_in_days');
    }
    set maxDataExtensionTimeInDays(value) {
        this._maxDataExtensionTimeInDays = value;
    }
    resetMaxDataExtensionTimeInDays() {
        this._maxDataExtensionTimeInDays = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxDataExtensionTimeInDaysInput() {
        return this._maxDataExtensionTimeInDays;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get quotedIdentifiersIgnoreCase() {
        return this.getBooleanAttribute('quoted_identifiers_ignore_case');
    }
    set quotedIdentifiersIgnoreCase(value) {
        this._quotedIdentifiersIgnoreCase = value;
    }
    resetQuotedIdentifiersIgnoreCase() {
        this._quotedIdentifiersIgnoreCase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get quotedIdentifiersIgnoreCaseInput() {
        return this._quotedIdentifiersIgnoreCase;
    }
    get replaceInvalidCharacters() {
        return this.getBooleanAttribute('replace_invalid_characters');
    }
    set replaceInvalidCharacters(value) {
        this._replaceInvalidCharacters = value;
    }
    resetReplaceInvalidCharacters() {
        this._replaceInvalidCharacters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceInvalidCharactersInput() {
        return this._replaceInvalidCharacters;
    }
    get storageSerializationPolicy() {
        return this.getStringAttribute('storage_serialization_policy');
    }
    set storageSerializationPolicy(value) {
        this._storageSerializationPolicy = value;
    }
    resetStorageSerializationPolicy() {
        this._storageSerializationPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageSerializationPolicyInput() {
        return this._storageSerializationPolicy;
    }
    get suspendTaskAfterNumFailures() {
        return this.getNumberAttribute('suspend_task_after_num_failures');
    }
    set suspendTaskAfterNumFailures(value) {
        this._suspendTaskAfterNumFailures = value;
    }
    resetSuspendTaskAfterNumFailures() {
        this._suspendTaskAfterNumFailures = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get suspendTaskAfterNumFailuresInput() {
        return this._suspendTaskAfterNumFailures;
    }
    get taskAutoRetryAttempts() {
        return this.getNumberAttribute('task_auto_retry_attempts');
    }
    set taskAutoRetryAttempts(value) {
        this._taskAutoRetryAttempts = value;
    }
    resetTaskAutoRetryAttempts() {
        this._taskAutoRetryAttempts = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get taskAutoRetryAttemptsInput() {
        return this._taskAutoRetryAttempts;
    }
    get traceLevel() {
        return this.getStringAttribute('trace_level');
    }
    set traceLevel(value) {
        this._traceLevel = value;
    }
    resetTraceLevel() {
        this._traceLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get traceLevelInput() {
        return this._traceLevel;
    }
    get userTaskManagedInitialWarehouseSize() {
        return this.getStringAttribute('user_task_managed_initial_warehouse_size');
    }
    set userTaskManagedInitialWarehouseSize(value) {
        this._userTaskManagedInitialWarehouseSize = value;
    }
    resetUserTaskManagedInitialWarehouseSize() {
        this._userTaskManagedInitialWarehouseSize = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskManagedInitialWarehouseSizeInput() {
        return this._userTaskManagedInitialWarehouseSize;
    }
    get userTaskMinimumTriggerIntervalInSeconds() {
        return this.getNumberAttribute('user_task_minimum_trigger_interval_in_seconds');
    }
    set userTaskMinimumTriggerIntervalInSeconds(value) {
        this._userTaskMinimumTriggerIntervalInSeconds = value;
    }
    resetUserTaskMinimumTriggerIntervalInSeconds() {
        this._userTaskMinimumTriggerIntervalInSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskMinimumTriggerIntervalInSecondsInput() {
        return this._userTaskMinimumTriggerIntervalInSeconds;
    }
    get userTaskTimeoutMs() {
        return this.getNumberAttribute('user_task_timeout_ms');
    }
    set userTaskTimeoutMs(value) {
        this._userTaskTimeoutMs = value;
    }
    resetUserTaskTimeoutMs() {
        this._userTaskTimeoutMs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTaskTimeoutMsInput() {
        return this._userTaskTimeoutMs;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            as_replica_of: cdktf.stringToTerraform(this._asReplicaOf),
            catalog: cdktf.stringToTerraform(this._catalog),
            comment: cdktf.stringToTerraform(this._comment),
            data_retention_time_in_days: cdktf.numberToTerraform(this._dataRetentionTimeInDays),
            default_ddl_collation: cdktf.stringToTerraform(this._defaultDdlCollation),
            enable_console_output: cdktf.booleanToTerraform(this._enableConsoleOutput),
            external_volume: cdktf.stringToTerraform(this._externalVolume),
            id: cdktf.stringToTerraform(this._id),
            is_transient: cdktf.booleanToTerraform(this._isTransient),
            log_level: cdktf.stringToTerraform(this._logLevel),
            max_data_extension_time_in_days: cdktf.numberToTerraform(this._maxDataExtensionTimeInDays),
            name: cdktf.stringToTerraform(this._name),
            quoted_identifiers_ignore_case: cdktf.booleanToTerraform(this._quotedIdentifiersIgnoreCase),
            replace_invalid_characters: cdktf.booleanToTerraform(this._replaceInvalidCharacters),
            storage_serialization_policy: cdktf.stringToTerraform(this._storageSerializationPolicy),
            suspend_task_after_num_failures: cdktf.numberToTerraform(this._suspendTaskAfterNumFailures),
            task_auto_retry_attempts: cdktf.numberToTerraform(this._taskAutoRetryAttempts),
            trace_level: cdktf.stringToTerraform(this._traceLevel),
            user_task_managed_initial_warehouse_size: cdktf.stringToTerraform(this._userTaskManagedInitialWarehouseSize),
            user_task_minimum_trigger_interval_in_seconds: cdktf.numberToTerraform(this._userTaskMinimumTriggerIntervalInSeconds),
            user_task_timeout_ms: cdktf.numberToTerraform(this._userTaskTimeoutMs),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            as_replica_of: {
                value: cdktf.stringToHclTerraform(this._asReplicaOf),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            catalog: {
                value: cdktf.stringToHclTerraform(this._catalog),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            comment: {
                value: cdktf.stringToHclTerraform(this._comment),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            data_retention_time_in_days: {
                value: cdktf.numberToHclTerraform(this._dataRetentionTimeInDays),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            default_ddl_collation: {
                value: cdktf.stringToHclTerraform(this._defaultDdlCollation),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            enable_console_output: {
                value: cdktf.booleanToHclTerraform(this._enableConsoleOutput),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            external_volume: {
                value: cdktf.stringToHclTerraform(this._externalVolume),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            is_transient: {
                value: cdktf.booleanToHclTerraform(this._isTransient),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            log_level: {
                value: cdktf.stringToHclTerraform(this._logLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            max_data_extension_time_in_days: {
                value: cdktf.numberToHclTerraform(this._maxDataExtensionTimeInDays),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            quoted_identifiers_ignore_case: {
                value: cdktf.booleanToHclTerraform(this._quotedIdentifiersIgnoreCase),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            replace_invalid_characters: {
                value: cdktf.booleanToHclTerraform(this._replaceInvalidCharacters),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            storage_serialization_policy: {
                value: cdktf.stringToHclTerraform(this._storageSerializationPolicy),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            suspend_task_after_num_failures: {
                value: cdktf.numberToHclTerraform(this._suspendTaskAfterNumFailures),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            task_auto_retry_attempts: {
                value: cdktf.numberToHclTerraform(this._taskAutoRetryAttempts),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            trace_level: {
                value: cdktf.stringToHclTerraform(this._traceLevel),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_task_managed_initial_warehouse_size: {
                value: cdktf.stringToHclTerraform(this._userTaskManagedInitialWarehouseSize),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_task_minimum_trigger_interval_in_seconds: {
                value: cdktf.numberToHclTerraform(this._userTaskMinimumTriggerIntervalInSeconds),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            user_task_timeout_ms: {
                value: cdktf.numberToHclTerraform(this._userTaskTimeoutMs),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.SecondaryDatabase = SecondaryDatabase;
_a = JSII_RTTI_SYMBOL_1;
SecondaryDatabase[_a] = { fqn: "@cdktf/provider-snowflake.secondaryDatabase.SecondaryDatabase", version: "12.0.4" };
// =================
// STATIC PROPERTIES
// =================
SecondaryDatabase.tfResourceType = "snowflake_secondary_database";
//# sourceMappingURL=data:application/json;base64,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