# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from pulpcore.client.pulpcore.models.app_status_response import AppStatusResponse
from pulpcore.client.pulpcore.models.content_settings_response import ContentSettingsResponse
from pulpcore.client.pulpcore.models.database_connection_response import DatabaseConnectionResponse
from pulpcore.client.pulpcore.models.redis_connection_response import RedisConnectionResponse
from pulpcore.client.pulpcore.models.storage_response import StorageResponse
from pulpcore.client.pulpcore.models.version_response import VersionResponse
from typing import Optional, Set
from typing_extensions import Self

class StatusResponse(BaseModel):
    """
    Serializer for the status information of the app
    """ # noqa: E501
    versions: List[VersionResponse] = Field(description="Version information of Pulp components")
    online_workers: List[AppStatusResponse] = Field(description="List of online workers known to the application. An online worker is actively heartbeating and can respond to new work.")
    online_api_apps: List[AppStatusResponse] = Field(description="List of online api apps known to the application. An online api app is actively heartbeating and can serve the rest api to clients.")
    online_content_apps: List[AppStatusResponse] = Field(description="List of online content apps known to the application. An online content app is actively heartbeating and can serve data to clients.")
    database_connection: DatabaseConnectionResponse = Field(description="Database connection information")
    redis_connection: Optional[RedisConnectionResponse] = Field(default=None, description="Redis connection information")
    storage: Optional[StorageResponse] = Field(default=None, description="Storage information")
    content_settings: ContentSettingsResponse = Field(description="Content-app settings")
    domain_enabled: StrictBool = Field(description="Is Domains enabled")
    __properties: ClassVar[List[str]] = ["versions", "online_workers", "online_api_apps", "online_content_apps", "database_connection", "redis_connection", "storage", "content_settings", "domain_enabled"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StatusResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in versions (list)
        _items = []
        if self.versions:
            for _item_versions in self.versions:
                if _item_versions:
                    _items.append(_item_versions.to_dict())
            _dict['versions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in online_workers (list)
        _items = []
        if self.online_workers:
            for _item_online_workers in self.online_workers:
                if _item_online_workers:
                    _items.append(_item_online_workers.to_dict())
            _dict['online_workers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in online_api_apps (list)
        _items = []
        if self.online_api_apps:
            for _item_online_api_apps in self.online_api_apps:
                if _item_online_api_apps:
                    _items.append(_item_online_api_apps.to_dict())
            _dict['online_api_apps'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in online_content_apps (list)
        _items = []
        if self.online_content_apps:
            for _item_online_content_apps in self.online_content_apps:
                if _item_online_content_apps:
                    _items.append(_item_online_content_apps.to_dict())
            _dict['online_content_apps'] = _items
        # override the default output from pydantic by calling `to_dict()` of database_connection
        if self.database_connection:
            _dict['database_connection'] = self.database_connection.to_dict()
        # override the default output from pydantic by calling `to_dict()` of redis_connection
        if self.redis_connection:
            _dict['redis_connection'] = self.redis_connection.to_dict()
        # override the default output from pydantic by calling `to_dict()` of storage
        if self.storage:
            _dict['storage'] = self.storage.to_dict()
        # override the default output from pydantic by calling `to_dict()` of content_settings
        if self.content_settings:
            _dict['content_settings'] = self.content_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StatusResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "versions": [VersionResponse.from_dict(_item) for _item in obj["versions"]] if obj.get("versions") is not None else None,
            "online_workers": [AppStatusResponse.from_dict(_item) for _item in obj["online_workers"]] if obj.get("online_workers") is not None else None,
            "online_api_apps": [AppStatusResponse.from_dict(_item) for _item in obj["online_api_apps"]] if obj.get("online_api_apps") is not None else None,
            "online_content_apps": [AppStatusResponse.from_dict(_item) for _item in obj["online_content_apps"]] if obj.get("online_content_apps") is not None else None,
            "database_connection": DatabaseConnectionResponse.from_dict(obj["database_connection"]) if obj.get("database_connection") is not None else None,
            "redis_connection": RedisConnectionResponse.from_dict(obj["redis_connection"]) if obj.get("redis_connection") is not None else None,
            "storage": StorageResponse.from_dict(obj["storage"]) if obj.get("storage") is not None else None,
            "content_settings": ContentSettingsResponse.from_dict(obj["content_settings"]) if obj.get("content_settings") is not None else None,
            "domain_enabled": obj.get("domain_enabled")
        })
        return _obj


