"use strict";"use strict";const accounts={chart:null,update:function(raw){const labels=raw.labels;const dateMode=raw.mode;const avg=raw.avg.map((v)=>Number(v));const costBasis=raw.cost_basis.map((v)=>Number(v));const minLine=avg.map((v,i)=>Math.min(v,costBasis[i]));const canvas=htmx.find("#account-chart-canvas");const ctx=canvas.getContext("2d");const datasets=[{label:"Balance",type:"line",data:avg,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:{target:1,aboveRaw:["primary-container","80"],belowRaw:["error-container","80"],},},{label:"Cost Basis",type:"line",data:costBasis,borderColorRaw:"outline",backgroundColorRaw:["tertiary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,},{type:"line",data:minLine,borderWidth:0,pointRadius:0,hoverRadius:0,fill:{target:"origin",aboveRaw:["tertiary-container","80"],belowRaw:["error-container","80"],},},];if(this.chart&&ctx==this.chart.ctx){nummusChart.update(this.chart,labels,dateMode,datasets);}else{this.ctx=ctx;this.chart=nummusChart.create(ctx,labels,dateMode,datasets,null,{plugins:{tooltip:{callbacks:{footer:function(context){let profit=context[0].raw-context[1].raw;return"Return: "+formatterF2.format(profit);},},},},});}},showAllAssets:function(btn){htmx.addClass(btn,"hidden");htmx.removeClass(htmx.find("#account-assets-all"),"hidden");},confirmDelete:function(evt){dialog.confirm("Delete account","Delete",()=>{htmx.trigger(evt.target,"delete");},"Empty account will be deleted.",);},};"use strict";const allocation={chartCategory:null,chartSector:null,update:function(raw){const categories=raw.categories;const sectors=raw.sectors;const categoryTree={};const categoryEntries=Object.entries(categories);categoryEntries.forEach(([category,assets],i)=>{categoryTree[category]={};assets.forEach((asset)=>{categoryTree[category][asset.name]={category:category,name:asset.name,ticker:asset.ticker,value:Number(asset.value),};});});const sectorTree={};const sectorEntries=Object.entries(sectors);sectorEntries.forEach(([sector,assets],i)=>{sectorTree[sector]={};assets.forEach((asset)=>{sectorTree[sector][asset.name]={sector:sector,name:asset.name,ticker:asset.ticker,weight:Number(asset.weight)*100,value:Number(asset.value),};});});{const canvas=htmx.find("#category-chart-canvas");const ctx=canvas.getContext("2d");const datasets=[{key:"value",groups:[0,"name"],tree:categoryTree,treeLeafKey:"name",borderWidth:2,spacing:2,borderRadius:function(context){if(!context.raw){return 0;}
const zoom=context.chart.getZoomLevel();const size=Math.min(context.raw.w,context.raw.h)*zoom;return Math.min(8,size*0.2);},},];if(this.chartCategory){this.chartCategory.destroy();}
this.chartCategory=nummusChart.createTree(ctx,datasets);}
{const canvas=htmx.find("#sector-chart-canvas");const ctx=canvas.getContext("2d");const datasets=[{key:"value",groups:[0,"name"],tree:sectorTree,treeLeafKey:"name",borderWidth:2,spacing:2,borderRadius:function(context){if(!context.raw){return 0;}
const zoom=context.chart.getZoomLevel();const size=Math.min(context.raw.w,context.raw.h)*zoom;return Math.min(8,size*0.2);},},];if(this.chartSector){this.chartSector.destroy();}
const callbacks={label:function(context){const obj=context.raw._data;const sector=obj[0];const label=obj.name||sector;const value=formatterF2.format(obj.value);if(obj.name){const weight=sectorTree[sector][obj.name].weight;return`${label} (${weight.toFixed(2)}%): ${value}`;}
return`${label}: ${value}`;},};this.chartSector=nummusChart.createTree(ctx,datasets,null,{plugins:{tooltip:{callbacks:callbacks}},});}},};"use strict";const assets={chart:null,update:function(raw){const labels=raw.labels;const dateMode=raw.mode;const avg=raw.avg.map((v)=>Number(v));const min=raw.min&&raw.min.map((v)=>Number(v));const max=raw.max&&raw.max.map((v)=>Number(v));const canvas=htmx.find("#asset-chart-canvas");const ctx=canvas.getContext("2d");const datasets=[];if(min==null){datasets.push({label:"Value",type:"line",data:avg,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:{target:"origin",aboveRaw:["primary-container","80"],belowRaw:["error-container","80"],},});}else{datasets.push({label:"Average",type:"line",data:avg,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,});datasets.push({label:"Max",type:"line",data:max,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:0,pointRadius:0,hoverRadius:0,fill:2,});datasets.push({label:"Min",type:"line",data:min,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:0,pointRadius:0,hoverRadius:0,});}
if(this.chart)this.chart.destroy();this.ctx=ctx;this.chart=nummusChart.create(ctx,labels,dateMode,datasets);},changeTablePeriod:function(){const select=htmx.find("#valuation-filters [name='period']");const notCustom=select.value!="custom";htmx.findAll("#valuation-filters [type='date']").forEach((e)=>{e.disabled=notCustom;});},confirmDelete:function(evt){dialog.confirm("Delete asset","Delete",()=>{htmx.trigger(evt.target,"delete");},"Empty asset will be deleted.",);},confirmDeleteValuation:function(evt){dialog.confirm("Delete valuation","Delete",()=>{htmx.trigger(evt.target,"delete");},"Valuation will be deleted.",);},};"use strict";const budgeting={editing:false,sidebarChart:null,table:null,isGroup:false,dragItem:null,dragItemHeight:null,staticItems:[],staticItemsY:[],initialScroll:null,doScroll:0,initialMouseX:null,initialMouseY:null,mouseOffsetX:null,mouseOffsetY:null,isDragging:false,currentURI:null,barOn:true,barHeight:null,barTranslate:0,bar:null,isTouch:false,setupDrag(){this.table=htmx.find("#budget-table");this.dragStartBound=this.dragStart.bind(this);this.dragEndBound=this.dragEnd.bind(this);htmx.on(this.table,"mousedown",this.dragStartBound);htmx.on(this.table,"touchstart",this.dragStartBound);htmx.on("mouseup",this.dragEndBound);htmx.on("touchend",this.dragEndBound);},dragStart(evt){const target=evt.target;if(!target.matches(".budget-drag")){return;}
if(evt.type=="touchstart"){this.isTouch=true;evt.preventDefault();}
if(target.matches(".budget-category, .budget-category *")){this.isGroup=false;this.dragItem=target.closest(".budget-category");this.staticItems=Array.from(htmx.findAll(".budget-group>label, .budget-category"),);}else{this.isGroup=true;this.dragItem=target.closest(".budget-group");this.staticItems=Array.from(htmx.findAll(".budget-group:not(#group-ungrouped)"),);}
let firstGroup=true;this.staticItems=this.staticItems.filter((e)=>{if(e==this.dragItem)return false;if(this.isGroup||!firstGroup)return true;if(e.matches("label")){firstGroup=false;return false;}
return true;});htmx.findAll(".budget-category").forEach((e,i)=>{e.setAttribute("position",i);});htmx.findAll(".budget-group").forEach((e,i)=>{e.setAttribute("position",i);});const evtX=evt.clientX??evt.targetTouches[0].clientX;const evtY=evt.clientY??evt.targetTouches[0].clientY;const rect=this.dragItem.getBoundingClientRect();this.mouseOffsetX=evtX-rect.x;this.mouseOffsetY=evtY-rect.y;this.initialMouseX=evtX;this.initialMouseY=evtY;this.initialScroll=window.scrollY;this.dragItemHeight=rect.height;htmx.addClass(this.table,"select-none");this.dragStartTestBound=this.dragStartTest.bind(this);htmx.on(this.isTouch?"touchmove":"mousemove",this.dragStartTestBound,{passive:false,});},dragStartTest(evt){const evtX=evt.clientX??evt.targetTouches[0].clientX;const evtY=evt.clientY??evt.targetTouches[0].clientY;const dx=evtX-this.initialMouseX;const dy=evtY-this.initialMouseY+(window.scrollY-this.initialScroll);const delta=Math.sqrt(dx*dx+dy*dy);if(delta<10){return;}
htmx.off("mousemove",this.dragStartTestBound);htmx.off("touchmove",this.dragStartTestBound);this.dragStartTestBound=null;htmx.addClass(this.dragItem,"budget-dragging");this.isDragging=true;const scrollY=window.scrollY;if(this.isGroup){htmx.findAll(".budget-group-items").forEach((e)=>{htmx.addClass(e,"hidden");});}
const dyScroll=window.scrollY-scrollY;this.initialScroll+=dyScroll;const rect=this.dragItem.getBoundingClientRect();this.initialMouseX=rect.x+this.mouseOffsetX;this.initialMouseY=rect.y+this.mouseOffsetY;this.dragItemHeight=rect.height;this.staticItems.forEach((e,i)=>{const rect=e.getBoundingClientRect();this.staticItemsY[i]=rect.y+rect.height/2;});this.drag(evt);this.dragBound=this.drag.bind(this);htmx.on(this.isTouch?"touchmove":"mousemove",this.dragBound,{passive:false,});},doScrollFrame(){if(!this.doScroll)return;window.scrollBy(0,this.doScroll);requestAnimationFrame(this.doScrollFrame.bind(this));},drag(evt){const evtX=evt.clientX??evt.targetTouches[0].clientX;const evtY=evt.clientY??evt.targetTouches[0].clientY;if(evt.type=="touchmove"){evt.preventDefault();const prevDoScroll=this.doScroll;const th=150;if(evtY<th)this.doScroll=(evtY-th)*2;else if(evtY>window.innerHeight-th)
this.doScroll=evtY-window.innerHeight+th;else this.doScroll=0;if(this.doScroll&&!prevDoScroll)
requestAnimationFrame(this.doScrollFrame.bind(this));}
const offsetX=evtX-this.initialMouseX;const scrollY=window.scrollY-this.initialScroll;const offsetY=evtY-this.initialMouseY+scrollY;this.dragItem.style.transform=`translate(${offsetX}px, ${offsetY}px)`;const dragItemYTop=evtY-this.mouseOffsetY+scrollY;const dragItemYBot=dragItemYTop+this.dragItemHeight;this.staticItems.forEach((e,i)=>{const initialY=this.staticItemsY[i];let offset=0;if(offsetY>0){if(initialY<dragItemYBot&&initialY>this.initialMouseY){offset=-this.dragItemHeight;e.setAttribute("reorder","up");}else{e.setAttribute("reorder","");}}else{if(initialY>dragItemYTop&&initialY<this.initialMouseY){offset=this.dragItemHeight;e.setAttribute("reorder","down");}else{e.setAttribute("reorder","");}}
e.style.transform=`translateY(${offset}px)`;});},dragEnd(evt){if(!this.isDragging){this.cleanUpDrag();return;}
let anyMoved=false;let lastChange=null;let invalid=false;const movedUp=Array.from(htmx.findAll(`.budget-${this.isGroup ? "group" : "category"}:not(.budget-dragging)[reorder="up"]`,),);const movedDown=Array.from(htmx.findAll(`.budget-${this.isGroup ? "group" : "category"}:not(.budget-dragging)[reorder="down"]`,),);const groupLabelsMovedUp=Array.from(htmx.findAll('.budget-group>label:not(.budget-dragging)[reorder="up"]'),);const groupLabelsMovedDown=Array.from(htmx.findAll('.budget-group>label:not(.budget-dragging)[reorder="down"]'),);let items=null;let before=null;if(movedUp.length){let last=movedUp[movedUp.length-1];items=last.parentNode;before=last.nextElementSibling;if(groupLabelsMovedUp.length){const group=groupLabelsMovedUp[groupLabelsMovedUp.length-1].parentNode;if(group!=last.closest(".budget-group")){items=htmx.find(group,".budget-group-items");before=items.firstChild;}}}else if(movedDown.length){const first=movedDown[0];items=first.parentNode;before=first;if(groupLabelsMovedDown.length){const group=groupLabelsMovedDown[0].parentNode;const prevGroup=group.previousElementSibling;if(prevGroup&&!htmx.find(prevGroup,'.budget-category:not([reorder=""])')){items=htmx.find(prevGroup,".budget-group-items");before=null;}}}else if(groupLabelsMovedUp.length){items=groupLabelsMovedUp[groupLabelsMovedUp.length-1].nextElementSibling;before=items.firstChild;}else if(groupLabelsMovedDown.length){const prevGroup=groupLabelsMovedDown[0].parentNode.previousElementSibling;if(prevGroup){items=htmx.find(prevGroup,".budget-group-items");before=null;}}
if(!items){this.cleanUpDrag();return;}
try{items.insertBefore(this.dragItem,before);}catch(error){console.error(this.dragItem,items,before);console.error(error);}
htmx.findAll(".budget-category").forEach((e,i)=>{const group=e.closest(".budget-group");const groupURI=group.id.slice(6);const inputGroup=document.createElement("input");inputGroup.name="group";inputGroup.type="text";inputGroup.value=groupURI;inputGroup.hidden=true;e.append(inputGroup);});htmx.trigger("#budget-table","reorder");this.cleanUpDrag();},cleanUpDrag(){this.staticItems.forEach((e)=>{e.style.transform="";});this.staticItems.length=0;this.isTouch=false;this.doScroll=0;if(this.dragBound){htmx.off("mousemove",this.dragBound);htmx.off("touchmove",this.dragBound);this.dragBound=null;}
if(this.dragStartTestBound){htmx.off("mousemove",this.dragStartTestBound);htmx.off("touchmove",this.dragStartTestBound);this.dragStartTestBound=null;}
htmx.findAll(".budget-group-items").forEach((e)=>{htmx.removeClass(e,"hidden");});if(this.dragItem){this.dragItem.style.transform="";htmx.removeClass(this.dragItem,"budget-dragging");if(this.isGroup)this.dragItem.scrollIntoView({block:"center"});this.dragItem=null;}
htmx.removeClass(this.table,"select-none");htmx.findAll('.budget-category>input[name="group"]').forEach((e)=>{htmx.remove(e);});this.isDragging=false;},update(assigned,targetAmount,onTrack){const remaining=targetAmount-assigned;const percent=Math.min(100,(assigned/targetAmount)*100);const canvas=htmx.find("#budget-sidebar-canvas");const ctx=canvas.getContext("2d");const datasets=[{name:"Assigned",amount:assigned,borderColorRaw:"primary",backgroundColorRaw:"primary-container",},];if(remaining>0){datasets.push({name:"Remaining",amount:remaining,borderColorRaw:"tertiary",backgroundColorRaw:"tertiary-container",});}
if(this.sidebarChart&&ctx==this.sidebarChart.ctx){nummusChart.updatePie(this.sidebarChart,datasets,`${percent.toFixed(0)}%`,);}else{this.sidebarChart=nummusChart.createPie(ctx,datasets,null,{plugins:{doughnutText:{text:`${percent.toFixed(0)}%`}},animations:false,});}},openGroup(e,uri){if(this.editing)return;htmx.trigger(e,"send-state");const isOpen=e.checked;if(isOpen){htmx.addClass(htmx.find(`#group-${uri}`),"open");}else{htmx.removeClass(htmx.find(`#group-${uri}`),"open");}},onClickCategory(e,evt){if(this.editing)return;if(!e){if(this.currentURI&&(!evt||!evt.target.matches(".budget-category, .budget-category * "))){htmx.removeClass(htmx.find(`#category-${this.currentURI}`),"budget-category-active",);this.currentURI=null;this.updateBar(false);nav.setOverrideBarOff(true);}
return;}
if(window.screen.width<768){const uri=e.id.slice(9);if(this.currentURI==uri){this.currentURI=null;this.updateBar(false);nav.setOverrideBarOff(true);htmx.removeClass(e,"budget-category-active");}else{if(this.currentURI){htmx.removeClass(htmx.find(`#category-${this.currentURI}`),"budget-category-active",);}
htmx.find("#budget-button-bar input").value=uri;this.currentURI=uri;this.updateBar(true);nav.setOverrideBarOff();htmx.addClass(e,"budget-category-active");}
return;}
htmx.trigger(e,"sidebar");},updateBar(on){this.barOn=on;if(this.bar==null)this.bar=htmx.find("#budget-button-bar");if(this.barHeight==null){const rect=this.bar.getBoundingClientRect();this.barHeight=rect.height;}
this.barTranslate=on?0:this.barHeight*1.1;this.bar.style.translate=`0 ${this.barTranslate}px`;},confirmDelete(evt){dialog.confirm("Delete target","Delete",()=>{htmx.trigger(evt.target,"delete");},"Target will be deleted.",);},onBarMove(){const e=htmx.find(`#category-${this.currentURI} .hx-assign`);htmx.trigger(e,"button");},onBarTarget(){const e=htmx.find(`#category-${this.currentURI} .hx-target`);htmx.trigger(e,"button");},reset(){this.bar=null;if(this.currentURI){this.currentURI=null;this.updateBar(false);nav.setOverrideBarOff(true);}},toggleEdit(e){this.editing=e.checked;htmx.findAll(".budget-category button, .budget-sidebar-target select, .budget-sidebar-target button",).forEach((button)=>{button.setAttribute("disabled","");});if(this.editing){htmx.addClass(htmx.find("#budget-table"),"edit");this.setupDrag();}else{this.cleanUpDrag();htmx.trigger(document.body,"budget");}},deleteGroup(btn){const group=btn.closest(".budget-group");const items=htmx.find(group,".budget-group-items");const prevGroup=group.previousElementSibling;if(prevGroup&&prevGroup.matches(".budget-group")){const newItems=htmx.find(prevGroup,".budget-group-items");htmx.findAll(items,".budget-category").forEach((e)=>{newItems.insertBefore(e,null);});htmx.remove(group);}else{const nextGroup=group.nextElementSibling;const newItems=htmx.find(nextGroup,".budget-group-items");const first=newItems.firstChild;htmx.findAll(items,".budget-category").forEach((e)=>{newItems.insertBefore(e,first);});htmx.remove(group);}
htmx.findAll(".budget-category").forEach((e,i)=>{const group=e.closest(".budget-group");const groupURI=group.id.slice(6);const inputGroup=document.createElement("input");inputGroup.name="group";inputGroup.type="text";inputGroup.value=groupURI;inputGroup.hidden=true;e.append(inputGroup);});htmx.trigger("#budget-table","reorder");this.cleanUpDrag();},};htmx.on("click",(evt)=>{budgeting.onClickCategory(null,evt);});"use strict";const chips={append(evt,name){if(evt.detail.xhr.response)return;if(evt.detail.requestConfig.triggeringEvent.type!=="keyup")return;const tgt=evt.target;if(!tgt.value)return;const chip=document.createElement("div");chip.innerHTML=`
      <input type="hidden" name="${name}" value="${tgt.value}" />
      ${tgt.value}
      <icon onclick="this.parentNode.remove()">clear</icon>
    `;tgt.parentNode.insertBefore(chip,tgt);tgt.value="";tgt.scrollIntoView({block:"nearest",inline:"end",container:"nearest",});},};"use strict";const dialog={pending:false,close(force){if(!force&&this.pending){this.confirm("Discard draft?","Discard",()=>{this.pending=false;htmx.find("#dialog").innerHTML="";});return;}
htmx.find("#dialog").innerHTML="";this.reset();},changes(){this.pending=true;},reset(){this.pending=false;if(location.hash=="#dialog")history.back();},checkRequired(){let allFilled=true;htmx.findAll("#dialog [required]").forEach((e)=>{if(!allFilled)return;if(!e.value){allFilled=false;return;}});return allFilled;},updateSave(){const saveBtn=htmx.find("#dialog-save");if(!saveBtn)return;const allFilled=this.checkRequired();const anyInvalid=htmx.find("#dialog error:not(:empty)")!=null;saveBtn.disabled=!allFilled||anyInvalid;},addListeners(){const d=htmx.find("#dialog");htmx.findAll(d,"[required]").forEach((e)=>{htmx.on(e,"input",this.updateSave.bind(this));});const focusNext=function(start){const results=htmx.findAll(d,"input:not(:disabled), textarea:not(:disabled), select:not(:disabled)",);for(const next of results){if(next.compareDocumentPosition(start)===Node.DOCUMENT_POSITION_PRECEDING){next.focus({preventScroll:true});next.selectionStart=0;next.selectionEnd=next.value.length;return;}}};htmx.findAll(d,"input, textarea, select").forEach((e)=>{htmx.on(e,"input",this.changes.bind(this));if(e.attributes["enterkeyhint"]=="next"){htmx.on(e,"keydown",(evt)=>{if(evt.key=="Enter"){evt.preventDefault();focusNext(e);}});}
htmx.on(e,"focus",(evt)=>{evt.preventDefault();e.scrollIntoView({block:"nearest"});});});},onLoad(){this.addListeners();if(window.screen.width>=768){const d=htmx.find("#dialog");const firstInput=htmx.find(d,"input, textarea, select");firstInput.focus();if(firstInput.type=="text"){const n=firstInput.value.length;firstInput.setSelectionRange(n,n);}}},confirm(headline,actionLabel,action,details){const e=htmx.find("#confirm-dialog");e.innerHTML=`
            <div><h1>${headline}</h1></div>
            <p>${details ?? ""}</p>
            <div class="flex justify-end">
                <button class="btn-text" onclick="dialog.closeConfirm()">Cancel</button>
                <button class="btn-text" onclick="dialog.closeConfirm()">
                    ${actionLabel}
                </button>
            </div>
            `;htmx.on(htmx.find(e,"button:last-child"),"click",action);},closeConfirm(){htmx.find("#confirm-dialog").innerHTML="";},onHashChange(event){if(location.hash)return;if(!this.pending){this.close();return;}
window.location.hash="dialog";this.confirm("Discard draft?","Discard",()=>{this.close(true);history.back();});},};htmx.on(window,"hashchange",dialog.onHashChange.bind(dialog));"use strict";const emergencyFund={chart:null,update:function(raw){const labels=raw.labels;const dateMode=raw.date_mode;const values=raw.balances;const spendingLower=raw.spending_lower;const spendingUpper=raw.spending_upper;const canvas=htmx.find("#e-fund-chart-canvas");const ctx=canvas.getContext("2d");const datasets=[{label:"Balance",type:"line",data:values,borderColorRaw:"outline",backgroundColorRaw:["tertiary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:{target:"origin",aboveRaw:["tertiary-container","80"],belowRaw:["error-container","80"],},},{label:"3-Month Spending",type:"line",data:spendingLower,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:{target:"+1",},},{label:"6-Month Spending",type:"line",data:spendingUpper,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,},];if(this.chart)this.chart.destroy();this.ctx=ctx;this.chart=nummusChart.create(ctx,labels,dateMode,datasets);},updateDashboard:function(raw){const labels=raw.labels;const dateMode=raw.date_mode;const values=raw.balances;const spendingLower=raw.spending_lower;const spendingUpper=raw.spending_upper;const canvas=htmx.find("#e-fund-chart-canvas-dashboard");const ctx=canvas.getContext("2d");const datasets=[{label:"Balance",type:"line",data:values,borderColorRaw:"outline",backgroundColorRaw:["tertiary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:{target:"origin",aboveRaw:["tertiary-container","80"],belowRaw:["error-container","80"],},},{label:"3-Month Spending",type:"line",data:spendingLower,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:{target:"+1",},},{label:"6-Month Spending",type:"line",data:spendingUpper,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,},];if(this.chart)this.chart.destroy();this.ctx=ctx;this.chart=nummusChart.create(ctx,labels,dateMode,datasets,null,{scales:{y:{ticks:{display:false},grid:{drawTicks:false}},},});},};"use strict";const importFile={beforeSend(){const success=htmx.find("#import-success");if(success){success.remove();}},xhrLoadStart(evt){const file=htmx.find("#dialog>form input[type=file]").value;if(file){htmx.removeClass(htmx.find("#import-upload-progress"),"hidden");}},xhrProgress(evt){htmx.find("#import-upload-progress>progress").setAttribute("value",(evt.detail.loaded/evt.detail.total)*100);},xhrLoadEnd(){htmx.addClass(htmx.find("#import-upload-progress"),"hidden");},};"use strict";const nummusLabels={confirmDelete:function(evt){dialog.confirm("Delete label","Delete",()=>{htmx.trigger(evt.target,"delete");},"This label will be removed from all transactions.",);},};"use strict";const nav={barOn:true,overrideBarOff:false,lastToggleY:null,barHeight:null,barTranslate:0,fabRatio:null,bar:null,fab:null,openDrawer:function(){htmx.addClass(htmx.find("#nav-drawer"),"open");},closeDrawer:function(evt){if(!evt||evt.target.matches("a, a *, button, button *")){htmx.removeClass(htmx.find("#nav-drawer"),"open");}},update:function(){const query="nav button, nav a";const currentPath=window.location.pathname;htmx.findAll(query).forEach((e)=>{const url=e&&(e.getAttribute("hx-get")||e.getAttribute("hx-post"));const path=url&&url.split("?")[0];if(path&&path==currentPath)htmx.addClass(e,"nav-current");else htmx.removeClass(e,"nav-current");});},onScroll:function(){if(window.screen.width>=768){return;}
const scrollY=window.scrollY;const hyst=20;if(nav.lastToggleY==null){nav.lastToggleY=scrollY;}
if(nav.barOn){nav.lastToggleY=Math.min(scrollY,nav.lastToggleY??scrollY);if(scrollY>nav.lastToggleY+hyst){nav.updateBar(false);}}else{nav.lastToggleY=Math.max(scrollY,nav.lastToggleY??scrollY);if(scrollY<nav.lastToggleY-hyst){nav.updateBar(true);}}},updateBar:function(on){on=on??nav.barOn;nav.barOn=on;if(nav.overrideBarOff)on=false;if(nav.bar==null)nav.bar=htmx.find("#nav-bar");if(nav.barHeight==null){const rect=nav.bar.getBoundingClientRect();nav.barHeight=rect.height;}
if(nav.fab==null)nav.fab=htmx.find("#nav-fab");if(nav.fabRatio==null){const rect=nav.fab.getBoundingClientRect();nav.fabRatio=(rect.width+window.screen.width-rect.right)/nav.barHeight;}
nav.barTranslate=on?0:nav.barHeight*1.1;const fabTranslate=nav.barTranslate*nav.fabRatio;nav.bar.style.translate=`0 ${nav.barTranslate}px`;nav.fab.style.translate=`${fabTranslate}px ${-nav.barTranslate}px`;},setOverrideBarOff:function(on){nav.overrideBarOff=!(on??false);nav.updateBar();},};htmx.on(window,"scroll",nav.onScroll);htmx.onLoad(nav.update);"use strict";const netWorth={chart:null,chartAssets:null,chartLiabilities:null,chartPieAssets:null,chartPieLiabilities:null,update:function(raw,rawAccounts){const labels=raw.labels;const dateMode=raw.mode;const avg=raw.avg.map((v)=>Number(v));const min=raw.min&&raw.min.map((v)=>Number(v));const max=raw.max&&raw.max.map((v)=>Number(v));const accounts=rawAccounts.map((a)=>{a.avg=a.avg.map((v)=>Number(v));return a;});{const canvas=document.getElementById("net-worth-chart-canvas");const ctx=canvas.getContext("2d");const datasets=[];if(min==null){datasets.push({label:"Portfolio",type:"line",data:avg,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:{target:"origin",aboveRaw:["primary-container","80"],belowRaw:["error-container","80"],},});}else{datasets.push({label:"Max",type:"line",data:max,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:0,pointRadius:0,hoverRadius:0,fill:2,order:1,});datasets.push({label:"Average",type:"line",data:avg,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,order:0,});datasets.push({label:"Min",type:"line",data:min,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:0,pointRadius:0,hoverRadius:0,order:2,});}
if(this.chart&&ctx==this.chart.ctx){nummusChart.update(this.chart,labels,dateMode,datasets);}else{this.chart=nummusChart.create(ctx,labels,dateMode,datasets);}}
const assets=[];const liabilities=[];for(let i=0;i<accounts.length;++i){const a=accounts[i];const spin=(i*300)/accounts.length;assets.push({name:a.name,values:[...a.avg].map((v)=>Math.max(0,v)),colorSpin:spin,});liabilities.push({name:a.name,values:[...a.avg].map((v)=>Math.min(0,v)),colorSpin:spin,});}
liabilities.reverse();const options={plugins:{tooltip:{filter:function(context){return(context.dataset.label!=null&&context.dataset.dataRaw[context.dataIndex]);},callbacks:{label:function(context){let label=context.dataset.label||"";if(label)label+=": ";const y=context.dataset.dataRaw[context.dataIndex];if(y!=null)label+=formatterF2.format(y);return label;},},},},};{const canvas=document.getElementById("assets-chart-canvas");const ctx=canvas.getContext("2d");const datasets=nummusChart.datasetsStacked(assets);if(this.chartAssets&&ctx==this.chartAssets.ctx){nummusChart.update(this.chartAssets,labels,dateMode,datasets);}else{this.chartAssets=nummusChart.create(ctx,labels,dateMode,datasets,null,options,);}}
{const canvas=document.getElementById("liabilities-chart-canvas");const ctx=canvas.getContext("2d");const datasets=nummusChart.datasetsStacked(liabilities);if(this.chartLiabilities&&ctx==this.chartLiabilities.ctx){nummusChart.update(this.chartLiabilities,labels,dateMode,datasets);}else{this.chartLiabilities=nummusChart.create(ctx,labels,dateMode,datasets,null,options,);}}},updateDashboard:function(raw){const labels=raw.labels;const dateMode=raw.mode;const total=raw.avg.map((v)=>Number(v));const canvas=document.getElementById("net-worth-chart-canvas-dashboard");const ctx=canvas.getContext("2d");const dataset={label:"Total",type:"line",data:total,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:true,};if(this.chart&&ctx==this.chart.ctx){nummusChart.update(this.chart,labels,dateMode,[dataset]);}else{this.chart=nummusChart.create(ctx,labels,dateMode,[dataset],null,{scales:{y:{ticks:{display:false},grid:{drawTicks:false}},},});}},};"use strict";const nummusChart={create:function(ctx,labels,dateMode,datasets,plugins,options){setChartDefaults();if(labels.length==1){labels.push(labels[0]);datasets.forEach((d)=>{d.data.push(d.data[0]);});}
const pluginObjects=[pluginColor];const pluginOptions={legend:{display:false,},tooltip:{intersect:false,mode:"index",enabled:window.screen.width>=768,filter:function(context){return context.dataset.label!=null;},callbacks:{label:function(context){let label=context.dataset.label||"";if(label)label+=": ";if(context.parsed.y!=null)
label+=formatterF2.format(context.parsed.y);return label;},labelColor:function(context){const dataset=context.dataset;let color={borderColor:dataset.borderColor,backgroundColor:dataset.backgroundColor.slice(0,7),borderWidth:1,};if(context.chart.data.datasets.length!=1)return color;if(dataset.fill&&dataset.fill.above&&dataset.fill.below){color.backgroundColor=context.raw>=0?dataset.fill.above:dataset.fill.below;}
return color;},},},};if(plugins){for(const item of plugins){const plugin=item[0];pluginObjects.push(plugin);pluginOptions[plugin.id]=item[1];}}
options=merge({responsive:true,maintainAspectRatio:false,scales:{x:{grid:{display:true,},ticks:{callback:formatDateTicks,dateMode:dateMode,},},y:{ticks:{callback:formatMoneyTicks,precision:0,},},},plugins:pluginOptions,},options??{},);return new Chart(ctx,{data:{labels:labels,datasets:datasets},options:options,plugins:pluginObjects,});},update:function(chart,labels,dateMode,datasets){chart.data.labels=labels;if(chart.data.datasets.length==datasets.length){for(let i=0;i<datasets.length;++i){chart.data.datasets[i].data=datasets[i].data;}}else{chart.data.datasets=datasets;}
chart.config.options.scales.x.ticks.dateMode=dateMode;pluginColor.updateChartColor(chart);chart.update();},datasetsStacked:function(sources){const datasets=[];const n=sources[0].values.length;let values=new Array(n).fill(0);let first=true;for(const source of sources){if(source.values.every((v)=>v==0))continue;for(let i=0;i<n;++i)values[i]+=source.values[i];datasets.push({label:source.name,type:"line",data:[...values],dataRaw:source.values,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],colorSpin:source.colorSpin,borderWidth:1,pointRadius:0,hoverRadius:0,fill:first?"origin":"-1",});first=false;}
return datasets;},datasetsPie:function(sources){const labels=[];const datasets=[];const data=[];const colors=[];const backgroundColors=[];const spins=[];let total=0;let nCollapse=sources.filter((item)=>item.collapse).length;let totalOther=0;for(const source of sources){const value=source.amount??source.values[source.values.length-1];total+=value;if(nCollapse>1&&source.collapse){totalOther+=value;}else{data.push(value);labels.push(source.name);colors.push(source.borderColorRaw);backgroundColors.push(source.backgroundColorRaw);spins.push(source.colorSpin);}}
if(totalOther){data.push(totalOther);labels.push("Other");colors.push("outline");backgroundColors.push("surface-container-high");spins.push(null);}
datasets.push({data:data,borderWidth:1,borderColorRaw:colors,backgroundColorRaw:backgroundColors,colorSpin:spins,total:total,});return{labels:labels,datasets:datasets,total:total,};},createPie:function(ctx,sources,plugins,options){setChartDefaults();const{labels,datasets,total}=this.datasetsPie(sources);const pluginObjects=[pluginColor,pluginDoughnutText];const pluginOptions={legend:{display:false,},tooltip:{enabled:true,callbacks:{label:function(context){let label=context.dataset.label||"";if(label)label+=": ";if(context.parsed!=null){label+=formatterF2.format(context.parsed);const percent=(context.parsed/context.dataset.total)*100;label+=` (${percent.toFixed(1)}%)`;}
return label;},},},doughnutText:{text:formatterF0.format(total),font:"'liberation-sans', 'sans-serif'",},};if(plugins){for(const plugin of plugins){pluginObjects.push(plugin);}}
options=merge({responsive:true,maintainAspectRatio:true,plugins:pluginOptions,},options??{},);return new Chart(ctx,{type:"doughnut",data:{labels:labels,datasets:datasets},options:options,plugins:pluginObjects,});},updatePie:function(chart,sources,doughnutText){const{labels,datasets,total}=this.datasetsPie(sources);if(chart.data.datasets.length==datasets.length){for(let i=0;i<datasets.length;++i){chart.data.datasets[i].data=datasets[i].data;chart.data.datasets[i].borderColorRaw=datasets[i].borderColorRaw;chart.data.datasets[i].backgroundColorRaw=datasets[i].backgroundColorRaw;chart.data.datasets[i].colorSpin=datasets[i].colorSpin;chart.data.datasets[i].total=datasets[i].total;}}else{chart.data.datasets=datasets;}
chart.data.labels=labels;chart.config.options.plugins.doughnutText.text=doughnutText??formatterF0.format(total);pluginColor.updateChartColor(chart);pluginHoverHighlight.addListeners(chart);chart.update();},createTree:function(ctx,datasets,plugins,options){setChartDefaults();const pluginObjects=[pluginColor,pluginTreeColor,pluginTreeLabel];const pluginOptions={legend:{display:false,},tooltip:{callbacks:{title:function(){return"Asset Value";},label:function(context){const obj=context.raw._data;let label=obj.name||obj[0];return label+": "+formatterF2.format(obj.value);},},},zoom:{pan:{enabled:true,mode:"xy",},limits:{x:{min:"original",max:"original"},y:{min:"original",max:"original"},},zoom:{wheel:{enabled:true},pinch:{enabled:true},mode:"xy",},},};if(plugins){for(const item of plugins){const plugin=item[0];pluginObjects.push(plugin);pluginOptions[plugin.id]=item[1];}}
options=merge({responsive:true,maintainAspectRatio:false,animations:false,plugins:pluginOptions,},options??{},);return new Chart(ctx,{type:"treemap",data:{datasets:datasets},options:options,plugins:pluginObjects,});},};"use strict";const performance={chart:null,update:function(raw){const labels=raw.labels;const dateMode=raw.mode;const avg=raw.avg.map((v)=>Number(v)*100);const min=raw.min&&raw.min.map((v)=>Number(v)*100);const max=raw.max&&raw.max.map((v)=>Number(v)*100);const index=raw.index.map((v)=>Number(v)*100);const indexName=raw.index_name;const indexMin=raw.index_min&&raw.index_min.map((v)=>Number(v)*100);const indexMax=raw.index_max&&raw.index_max.map((v)=>Number(v)*100);const mwrr=raw.mwrr&&raw.mwrr.map((v)=>Number(v)*100);{const canvas=document.getElementById("performance-chart-canvas");const ctx=canvas.getContext("2d");const datasets=[];if(min==null){datasets.push({label:"Portfolio",type:"line",data:avg,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,fill:true,});datasets.push({label:indexName,type:"line",data:index,borderColorRaw:"tertiary",backgroundColorRaw:["tertiary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,});datasets.push({label:"MWRR Interpolation",type:"line",data:mwrr,borderColorRaw:"secondary",backgroundColorRaw:["secondary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,});}else{datasets.push({label:"Max",type:"line",data:max,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:0,pointRadius:0,hoverRadius:0,fill:2,});datasets.push({label:"Average",type:"line",data:avg,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,});datasets.push({label:"Min",type:"line",data:min,borderColorRaw:"primary",backgroundColorRaw:["primary-container","80"],borderWidth:0,pointRadius:0,hoverRadius:0,});datasets.push({label:`${indexName} Max`,type:"line",data:indexMax,borderColorRaw:"tertiary",backgroundColorRaw:["tertiary-container","80"],borderWidth:0,pointRadius:0,hoverRadius:0,fill:5,});datasets.push({label:`${indexName} Average`,type:"line",data:index,borderColorRaw:"tertiary",backgroundColorRaw:["tertiary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,});datasets.push({label:`${indexName} Min`,type:"line",data:indexMin,borderColorRaw:"tertiary",backgroundColorRaw:["tertiary-container","80"],borderWidth:0,pointRadius:0,hoverRadius:0,});datasets.push({label:"MWRR Interpolation",type:"line",data:mwrr,borderColorRaw:"secondary",backgroundColorRaw:["secondary-container","80"],borderWidth:2,pointRadius:0,hoverRadius:0,});}
const options={scales:{y:{ticks:{callback:formatPercentTicks}},},plugins:{tooltip:{callbacks:{label:function(context){let label=context.dataset.label||"";if(label)label+=": ";if(context.parsed.y!=null)
label+=`${context.parsed.y.toFixed(1)}%`;return label;},},},},};if(this.chart&&ctx==this.chart.ctx){nummusChart.update(this.chart,labels,dateMode,datasets);}else{this.chart=nummusChart.create(ctx,labels,dateMode,datasets,null,options,);}}},};"use strict";const progress={bar:null,update:function(evt,v){if(evt&&(evt.detail.target??evt.detail.elt).id!="main")return;if(this.bar==null)this.bar=htmx.find("#page-progress");if(v==0){htmx.addClass(this.bar,"open");this.bar.innerHTML="<div style='width:0'></div>";}else if(v==1){htmx.removeClass(this.bar,"open");this.bar.firstElementChild.style.width="100%";}else{htmx.addClass(this.bar,"open");this.bar.firstElementChild.style.width=`${v * 100}%`;}},};"use strict";const snackbar={duration:2500,timeout:null,show:function(msg){const e=htmx.find("#snackbar");e.innerHTML=msg;htmx.addClass(e,"open");if(self.timeout)clearTimeout(self.timeout);self.timeout=setTimeout(this.hide,this.duration);},hide:function(){const e=htmx.find("#snackbar");htmx.removeClass(e,"open");},};"use strict";const spending={charts:{},changePeriod(){const select=htmx.find("#spending-filters [name='period']");const notCustom=select.value!="custom";htmx.findAll("#spending-filters [type='date']").forEach((e)=>{e.disabled=notCustom;});},update(byAccount,byPayee,byCategory,byLabel){this.updateOne("spending-by-account",byAccount);this.updateOne("spending-by-payee",byPayee);this.updateOne("spending-by-category",byCategory);this.updateOne("spending-by-label",byLabel);updateColorSwatches();},updateOne(id,raw){const canvas=htmx.find(`#${id} canvas`);const breakdown=htmx.find(`#${id}>div:last-of-type`);const ctx=canvas.getContext("2d");const total=raw.reduce((cum,item)=>cum+item[1],0);const collapseThreshold=total*0.005;const spin=Math.max(20,300/raw.length);const data=raw.map((item,i)=>({name:item[0]??"[none]",amount:item[1],colorSpin:item[0]?i*spin:0,borderColorRaw:item[0]?"primary":"outline",backgroundColorRaw:[item[0]?"primary-container":"surface-container-low","80",],collapse:item[1]<collapseThreshold,}));breakdown.innerHTML="";let totalOther=0;data.forEach((category,i)=>{const v=category.amount;if(i>=200){totalOther+=v;return;}
const row=document.createElement("div");htmx.addClass(row,"flex");htmx.addClass(row,"gap-1");htmx.addClass(row,"not-last:mb-0.5");const square=document.createElement("div");square.setAttribute("color-spin",category.colorSpin);square.setAttribute("border",category.borderColorRaw);square.setAttribute("bg",category.backgroundColorRaw[0]);htmx.addClass(square,"w-6");htmx.addClass(square,"h-6");htmx.addClass(square,"shrink-0");htmx.addClass(square,"border");htmx.addClass(square,"rounded");row.appendChild(square);const name=document.createElement("div");name.innerHTML=category.name;htmx.addClass(name,"grow");htmx.addClass(name,"truncate");row.appendChild(name);const value=document.createElement("div");value.innerHTML=formatterF2.format(v);row.appendChild(value);breakdown.appendChild(row);});if(totalOther){const row=document.createElement("div");htmx.addClass(row,"flex");htmx.addClass(row,"gap-1");htmx.addClass(row,"not-last:mb-0.5");const square=document.createElement("div");htmx.addClass(square,"w-6");htmx.addClass(square,"h-6");htmx.addClass(square,"shrink-0");htmx.addClass(square,"border");htmx.addClass(square,"border-outline");htmx.addClass(square,"bg-surface-container-high");htmx.addClass(square,"rounded");row.appendChild(square);const name=document.createElement("div");name.innerHTML=`Other (${data.length - 200} more)`;htmx.addClass(name,"grow");htmx.addClass(name,"truncate");row.appendChild(name);const value=document.createElement("div");value.innerHTML=formatterF2.format(totalOther);row.appendChild(value);breakdown.appendChild(row);}
if(this.charts[id]&&ctx==this.charts[id].ctx){nummusChart.updatePie(this.charts[id],data);}else{this.charts[id]=nummusChart.createPie(ctx,data,[pluginHoverHighlight],{plugins:{hoverHighlight:{parent:`${id}>div:last-of-type`}}},);}},};"use strict";const txnCat={updateEssential:function(){const isIncome=htmx.find("#dialog [name='group']").value=="INCOME";const essential=htmx.find("#dialog [name='essential-spending']");essential.disabled=isIncome;essential.checked=!isIncome&&essential.checked;},confirmDelete:function(evt){dialog.confirm("Delete category","Delete",()=>{htmx.trigger(evt.target,"delete");},"Any transactions assigned to this category will revert to uncategorized.",);},};"use strict";const txn={changePeriod:function(){const select=htmx.find("#txn-filters [name='period']");const notCustom=select.value!="custom";htmx.findAll("#txn-filters [type='date']").forEach((e)=>{e.disabled=notCustom;});},confirmDelete:function(evt){dialog.confirm("Delete transaction","Delete",()=>{htmx.trigger(evt.target,"delete");},"Unlinked transaction will be deleted.",);},};"use strict";function getThemeColor(name){const style=getComputedStyle(document.body);return style.getPropertyValue(`--color-${name}`);}
function downsampleMonths(dates,values){let labels=[];let min=[];let max=[];let avg=[];let currentMonth=dates[0].slice(0,7);let currentMin=values[0];let currentMax=values[0];let currentSum=0;let currentN=0;for(let i=0;i<dates.length;++i){let month=dates[i].slice(0,7);let v=values[i];if(month!=currentMonth){labels.push(currentMonth);min.push(currentMin);max.push(currentMax);avg.push(currentSum/currentN);currentMonth=month;currentMin=v;currentMax=v;currentSum=0;currentN=0;}
currentMin=Math.min(currentMin,v);currentMax=Math.max(currentMax,v);currentSum+=v;++currentN;}
labels.push(currentMonth);min.push(currentMin);max.push(currentMax);avg.push(currentSum/currentN);return{labels:labels,min:min,max:max,avg:avg,};}
const formatterF0=new Intl.NumberFormat("en-US",{style:"currency",currency:"USD",minimumFractionDigits:0,maximumFractionDigits:0,});const formatterF1=new Intl.NumberFormat("en-US",{style:"currency",currency:"USD",minimumFractionDigits:1,maximumFractionDigits:1,});const formatterF2=new Intl.NumberFormat("en-US",{style:"currency",currency:"USD",minimumFractionDigits:2,maximumFractionDigits:2,});function formatMoneyTicks(value,index,ticks){if(index==0){const step=Math.abs(ticks[0].value-ticks[1].value);const smallest=Math.min(...ticks.map((t)=>Math.abs(t.value)));ticks.forEach((t)=>{if(step>=1000){t.label=formatterF0.format(t.value/1000)+"k";}else if(step>=100&&smallest>=1000){t.label=formatterF1.format(t.value/1000)+"k";}else{t.label=formatterF0.format(t.value);}});}
return ticks[index].label;}
function formatPercentTicks(value,index,ticks){if(index==0){const step=Math.abs(ticks[0].value-ticks[1].value);const smallest=Math.min(...ticks.map((t)=>Math.abs(t.value)));ticks.forEach((t)=>{t.label=`${t.value.toFixed(0)}%`;});}
return ticks[index].label;}
function formatDateTicks(value,index,ticks){if(index==0){const chart=this.chart;const labels=chart.data.labels;const dateMode=chart.config.options.scales.x.ticks.dateMode;switch(dateMode){case"years":ticks.forEach((t,i)=>{let l=labels[i];if(l.slice(-2)=="01")t.label=l.slice(0,4);});break;case"months":formatDateTicksMonths.bind(this)(value,index,ticks);break;case"weeks":ticks.forEach((t,i)=>{let l=labels[i];let date=new Date(l);if(date.getUTCDay()==0)t.label=l.slice(5,10);});break;case"days":ticks.forEach((t,i)=>(t.label=labels[i].slice(5,10)));break;default:ticks.forEach((t,i)=>(t.label=labels[i]));break;}}
return ticks[index].label;}
function formatDateTicksMonths(value,index,ticks){if(index==0){const chart=this.chart;const labels=chart.data.labels;const months={"01":"Jan","02":"Feb","03":"Mar","04":"Apr","05":"May","06":"Jun","07":"Jul","08":"Aug","09":"Sep",10:"Oct",11:"Nov",12:"Dec",};ticks.forEach((t,i)=>{let l=labels[i];if(l.length==7||l.slice(-2)=="01"){t.label=months[l.slice(5,7)];}});}
return ticks[index].label;}
const average=(array)=>array.reduce((a,b)=>a+b)/array.length;function setChartDefaults(){Chart.defaults.font.family="'liberation-sans', 'sans-serif'";}
function widenRange(min,max,amount){const center=(min+max)/2;const range=(max-min)*(1+amount);return{min:center-range/2,max:center+range/2};}
function isObject(item){return item&&typeof item==="object"&&!Array.isArray(item);}
function merge(target,...sources){if(!sources.length)return target;const source=sources.shift();if(isObject(target)&&isObject(source)){for(const key in source){if(isObject(source[key])){if(!target[key])Object.assign(target,{[key]:{}});merge(target[key],source[key]);}else{Object.assign(target,{[key]:source[key]});}}}
return merge(target,...sources);}
function word_wrap(rawLines,maxWidth,maxLines,ctx){if(maxLines<1){return[];}
const lines=[];for(const rawLine of rawLines){if(!rawLine){continue;}
const words=rawLine.split(" ");let currentLine=null;for(const word of words){const newLine=currentLine?currentLine+" "+word:word;const width=ctx.measureText(newLine).width;if(width<maxWidth){currentLine=newLine;}else if(currentLine){const wordWidth=ctx.measureText(word).width;if(wordWidth>=maxWidth){return lines;}
lines.push(currentLine);if(lines.length==maxLines){return lines;}
currentLine=word;}else{return lines;}}
if(currentLine){lines.push(currentLine);if(lines.length==maxLines){return lines;}}}
return lines;}
function nummusSendError(evt){const url=evt.detail.pathInfo.finalRequestPath;const e=htmx.find("#hx-error");htmx.removeClass(e,"hidden");htmx.find(e,"span").innerHTML=`Failed to send request for '${url}'`;}
function nummusResponseError(evt){const e=htmx.find("#hx-error");htmx.removeClass(e,"hidden");htmx.find(e,"span").innerHTML=evt.detail.error;}
function nummusClearHistory(){sessionStorage.removeItem("htmx-history-cache");}
function onSelectKey(evt){const k=evt.key.toLowerCase();if(k.length!=1||!k.match(/[a-z]/))return;const e=evt.target;const values=[];for(const option of e.options){if(option.disabled)continue;const cat=option.innerText.toLowerCase().trim();if(cat[0]==k)values[values.length]=option.value;}
const i=values.indexOf(e.value)+1;e.value=values[i%values.length];}
function addTimezone(evt){const d=new Date();evt.detail.headers["Timezone-Offset"]=d.getTimezoneOffset();}
function updateColorSwatches(){htmx.findAll("div[color-spin]").forEach((e)=>{const border=e.getAttribute("border");const bg=e.getAttribute("bg");const spin=Number(e.getAttribute("color-spin"));e.style.borderColor=tinycolor(getThemeColor(border)).spin(spin).toHexString();e.style.backgroundColor=tinycolor(getThemeColor(bg)).spin(spin).toHexString()+"80";});}
htmx.config.methodsThatUseUrlParams=["get"];"use strict";const pluginBoxAnnotation={id:"boxAnnotation",beforeInit:function(chart){const{config:{options:{plugins:{boxAnnotation},scales:{y},},},}=chart;let{yMin,yMax}=boxAnnotation;let{min,max}=widenRange(yMin,yMax,0.05);min=Math.min(min,y.suggestedMin??min);max=Math.max(max,y.suggestedMax??max);y.suggestedMin=min;y.suggestedMax=max;chart.boxAnnotation=boxAnnotation;},beforeDatasetsDraw:function(chart){let{ctx,chartArea:{top,bottom,left,right,width,height},scales,boxAnnotation:{yMin,yMax,borderColor,borderWidth,backgroundColor},}=chart;borderWidth=borderWidth??1;borderColor=borderColor??"#000";const yMinPx=scales.y.getPixelForValue(yMin);const yMaxPx=scales.y.getPixelForValue(yMax);const x=left;const y=yMinPx;const w=right-left;const h=yMaxPx-yMinPx;ctx.save();if(backgroundColor!=null){ctx.fillStyle=backgroundColor;ctx.fillRect(x,y,w,h);}
if(borderWidth>0){ctx.beginPath();ctx.moveTo(left,yMinPx);ctx.lineTo(right,yMinPx);ctx.moveTo(left,yMaxPx);ctx.lineTo(right,yMaxPx);ctx.lineWidth=borderWidth;ctx.strokeStyle=borderColor;ctx.stroke();}
ctx.restore();},};"use strict";const pluginColor={id:"color",charts:{},afterInit:function(chart){this.charts[chart.id]=chart;this.updateChartColor(chart);},updateChartColor:function(chart){const getColor=function(src,spin){let opacity="";if(Array.isArray(src)){opacity=src[1];src=src[0];}
const c=getThemeColor(src);if(spin)return tinycolor(c).spin(spin).toHexString()+opacity;return c+opacity;};const fields=["borderColor","backgroundColor"];const{config:{type,options,data:{datasets},},}=chart;for(const dataset of datasets){const{borderColorRaw,backgroundColorRaw,colorSpin,fill:{aboveRaw,belowRaw}={},}=dataset;if(type=="doughnut"){if(borderColorRaw)
dataset.borderColor=borderColorRaw.map((raw,i)=>getColor(raw,colorSpin[i]),);if(backgroundColorRaw)
dataset.backgroundColor=backgroundColorRaw.map((raw,i)=>getColor(raw,colorSpin[i]),);}else{if(borderColorRaw)
dataset.borderColor=getColor(borderColorRaw,colorSpin);if(backgroundColorRaw)
dataset.backgroundColor=getColor(backgroundColorRaw,colorSpin);if(aboveRaw)dataset.fill.above=getColor(aboveRaw,colorSpin);if(belowRaw)dataset.fill.below=getColor(belowRaw,colorSpin);}}
const text=getThemeColor("on-surface");const surface=getThemeColor("inverse-surface");const textInv=getThemeColor("inverse-on-surface");const outline=getThemeColor("outline-variant");if(options.scales.x){options.scales.x.ticks.color=text;options.scales.x.grid.color=outline;options.scales.x.border.color=outline;}
if(options.scales.y){options.scales.y.ticks.color=text;options.scales.y.grid.color=(ctx)=>ctx.tick.value==0?text:outline;options.scales.y.border.color=outline;}
options.plugins.tooltip.backgroundColor=surface;options.plugins.tooltip.titleColor=textInv;options.plugins.tooltip.bodyColor=textInv;if(options.plugins.doughnutText){options.plugins.doughnutText.color=text;}},update:function(){for(const chart of Object.values(this.charts)){this.updateChartColor(chart);chart.update();}},afterDestroy:function(chart){delete this.charts[chart.id];},};"use strict";const pluginDoughnutText={id:"doughnutText",beforeInit:function(chart){const{config:{options:{plugins:{doughnutText},},},}=chart;chart.doughnutText=doughnutText;},afterDatasetsDraw:function(chart){const{ctx,chartArea:{top,bottom,left,right,width,height},doughnutText:{text,font,color},}=chart;const px=Math.floor(height/10);ctx.save();ctx.textBaseline="middle";ctx.textAlign="center";ctx.font=`${px}px ${font}`;ctx.fillStyle=color;ctx.fillText(text,(left+right)/2,(top+bottom)/2);ctx.restore();},};"use strict";const pluginFixedAxisWidth={id:"fixedAxisWidth",beforeInit:function(chart){const{config:{options:{scales:{y},plugins:{fixedAxisWidth:{width},},},},}=chart;y.afterFit=function(scale){if(scale.width>width)
console.error(`Scale width ${scale.width} already `+`over desired ${width}`,);scale.width=width;};},};"use strict";const pluginHoverHighlight={id:"hoverHighlight",beforeInit:function(chart){const{config:{options:{plugins:{hoverHighlight},},},}=chart;hoverHighlight.scroll=hoverHighlight.scroll??true;hoverHighlight.listenersEnter=[];hoverHighlight.listenersExit=[];chart.hoverHighlight=hoverHighlight;this.addListeners(chart);},addListeners(chart){const hoverHighlight=chart.hoverHighlight;if(!hoverHighlight)return;this.removeListeners(chart);document.querySelectorAll(`#${hoverHighlight.parent}>*`).forEach((child,i)=>{const enter=function(){child.style.fontWeight="bold";this.setHover(chart,i,true);}.bind(this);const exit=function(){child.style.fontWeight="";this.setHover(chart,i,false);}.bind(this);child.addEventListener("mouseenter",enter);child.addEventListener("mouseleave",exit);hoverHighlight.listenersEnter[i]=enter;hoverHighlight.listenersExit[i]=exit;});},removeListeners(chart){const hoverHighlight=chart.hoverHighlight;document.querySelectorAll(`#${hoverHighlight.parent}>*`).forEach((child,i)=>{child.removeEventListener("mouseenter",hoverHighlight.listenersEnter[i],);child.removeEventListener("mouseexit",hoverHighlight.listenersExit[i]);});hoverHighlight.listenersEnter.length=0;hoverHighlight.listenersExit.length=0;},getChild(chart,i){const hoverHighlight=chart.hoverHighlight;return document.querySelector(`#${hoverHighlight.parent}>:nth-child(${i + 1})`,);},setActive(chart,i,active){const hoverHighlight=chart.hoverHighlight;const child=this.getChild(chart,i);if(active&&(chart.data.labels[i]??"Other")!="Other"){if(hoverHighlight.scroll)
child.scrollIntoView({block:"nearest",inline:"nearest"});child.style.fontWeight="bold";}else{child.style.fontWeight="";}},setHover(chart,i,active){const tooltip=chart.tooltip;if(active&&(chart.data.labels[i]??"Other")!="Other"){tooltip.setActiveElements([{datasetIndex:0,index:i}]);}else{tooltip.setActiveElements([]);}
chart.update();},beforeEvent(chart,args,pluginOptions){const hoverHighlight=chart.hoverHighlight;const event=args.event;if(event.type=="mouseout"){if(hoverHighlight.previous!=null){this.setActive(chart,hoverHighlight.previous,false);}
hoverHighlight.previous=null;}else if(event.type=="mousemove"&&chart.tooltip.dataPoints!=null&&chart.tooltip.dataPoints.length>0){const dataPoint=chart.tooltip.dataPoints[0];if(dataPoint.element.active){const i=dataPoint.dataIndex;if(hoverHighlight.previous==i)return;this.setActive(chart,i,true);if(hoverHighlight.previous!=null){this.setActive(chart,hoverHighlight.previous,false);}
hoverHighlight.previous=i;}else if(hoverHighlight.previous!=null){this.setActive(chart,hoverHighlight.previous,false);hoverHighlight.previous=null;}}},};"use strict";const pluginHoverLine={id:"hoverLine",afterDatasetsDraw:function(chart){const{ctx,tooltip,chartArea:{top,bottom,left,right},data,scales,}=chart;if(tooltip._active.length==0){return;}
const tt=tooltip._active[0];const i=tt.index;const date=data.labels[i];const values=data.datasets[data.datasets.length-1].data;const value=values[i];const change=i==0?0:value-values[i-1];const x=Math.min(right-1,Math.floor(tt.element.x));const y=Math.floor(scales.y.getPixelForValue(value));const black=getThemeColor("black");const white=getThemeColor("white");ctx.save();ctx.beginPath();ctx.lineWidth=1;ctx.strokeStyle=black;ctx.moveTo(x+0.5,top);ctx.lineTo(x+0.5,bottom);ctx.stroke();ctx.beginPath();ctx.arc(x,y,6,0,2*Math.PI);ctx.fillStyle=white;ctx.fill();ctx.stroke();const canvasW=ctx.canvas.clientWidth;const canvasH=ctx.canvas.clientHeight;const padding=2;ctx.textAlign="center";const valueStr=formatterF2.format(value);const metricsDate=ctx.measureText(date);const metricsValue=ctx.measureText(valueStr);const textW=Math.max(metricsDate.width,metricsValue.width)+padding*2;const fontAscent=metricsDate.fontBoundingBoxAscent;const fontDescent=metricsDate.fontBoundingBoxDescent;const fontH=fontAscent+fontDescent;const textH=fontH*2+padding*2;const textX=Math.min(Math.max(x,textW/2),canvasW-textW/2);const textY=bottom+fontAscent;ctx.fillStyle=white;ctx.fillRect(textX-textW/2,bottom+0.5,textW,canvasH-bottom);ctx.fillStyle=black;ctx.fillText(date,textX,textY);if(value>0)ctx.fillStyle=getThemeColor("green-600");else if(value<0)ctx.fillStyle=getThemeColor("red-600");ctx.fillText(valueStr,textX,textY+fontH);ctx.restore();},};"use strict";const pluginTreeColor={id:"treeColor",charts:{},beforeInit:function(chart){const{config:{data:{datasets},},}=chart;for(const dataset of datasets){let treeValues=Object.values(dataset.tree);treeValues.forEach((group)=>{let sum=0;Object.values(group).forEach((item)=>{sum+=item.value??0;});group.sum=sum;});treeValues.sort((a,b)=>{return b.sum-a.sum;});treeValues.forEach((group,i)=>{group.i=i;});}},afterInit:function(chart){this.charts[chart.id]=chart;this.updateChartColor(chart);},updateChartColor:function(chart){const base=getThemeColor("primary");const baseContainer=getThemeColor("primary-container");const onBase=getThemeColor("on-primary");const onContainer=getThemeColor("on-surface");const{config:{options,data:{datasets},},}=chart;options.elements.treemap.captions.color=onContainer;options.elements.treemap.captions.hoverColor=onContainer;for(const dataset of datasets){const treeValues=Object.values(dataset.tree);treeValues.forEach((group)=>{const spin=(group.i*360)/treeValues.length;const color=tinycolor(baseContainer).spin(spin).toHexString();const hoverColor=tinycolor(base).spin(spin).toHexString();group.color=color;group.hoverColor=hoverColor;});dataset.labels.color=onContainer;dataset.labels.hoverColor=onBase;dataset.backgroundColor=this.backgroundColor;dataset.borderColor=this.backgroundColor;dataset.hoverBackgroundColor=this.hoverBackgroundColor;dataset.hoverBorderColor=this.hoverBorderColor;}},update:function(){for(const chart of Object.values(this.charts)){this.updateChartColor(chart);chart.update();}},afterDestroy:function(chart){delete this.charts[chart.id];},backgroundColor:function(context){if(context.type!="data"){return"transparent";}
const treeData=context.dataset.tree;const obj=context.raw._data;const group=obj[0];if(obj.name){return treeData[group].color;}
return treeData[group].color+"80";},hoverBackgroundColor:function(context){if(context.type!="data"){return"transparent";}
const treeData=context.dataset.tree;const obj=context.raw._data;const group=obj[0];if(obj.name){return treeData[group].hoverColor;}
return treeData[group].color+"80";},hoverBorderColor:function(context){if(context.type!="data"){return"transparent";}
const treeData=context.dataset.tree;const obj=context.raw._data;const group=obj[0];return treeData[group].hoverColor;},};"use strict";const pluginTreeLabel={id:"treeLabel",defaults:{padding:2,},beforeInit:function(chart){const{config:{options,data:{datasets},},}=chart;const{plugins:{treeLabels:{padding}=this.defaults},}=options;const elements=merge({treemap:{captions:{align:"center",formatter:this.formatGroup,},},},options.elements??{},);options.elements=elements;datasets.forEach((dataset)=>{const labels=merge({display:true,padding:padding,formatter:this.formatItem,},dataset.labels??{},);dataset.labels=labels;});},formatGroup:function(context){const padding=context.dataset.labels.padding+context.dataset.borderWidth;const rawObj=context.raw._data;if(rawObj.name){return null;}
let group=rawObj[0];let label=group;const ctx=context.chart.ctx;const zoom=context.chart.getZoomLevel();const maxWidth=context.raw.w*zoom-padding*2;let width=ctx.measureText(label).width;while(group&&width>=maxWidth){group=group.slice(0,-1);label=group+"...";width=ctx.measureText(label).width;}
return label;},formatItem:function(context){const padding=context.dataset.labels.padding+context.dataset.borderWidth;const treeData=context.dataset.tree;const rawObj=context.raw._data;let group=rawObj[0];const obj=treeData[group][rawObj.name];const ctx=context.chart.ctx;const zoom=context.chart.getZoomLevel();const maxWidth=context.raw.w*zoom-padding*2;const font=Chart.helpers.toFont(ctx.font);const maxLines=Math.floor((context.raw.h*zoom-padding*2)/font.lineHeight,);let lines=[obj.ticker,obj.name,formatterF2.format(obj.value)];return word_wrap(lines,maxWidth,maxLines,ctx);},};