/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.RandomAccessFile;
import ucar.atd.dorade.DoradeDescriptor;

class DoradeCELV
extends DoradeDescriptor {
    protected int nCells;
    protected float[] ranges;

    public DoradeCELV(RandomAccessFile file2, boolean littleEndianData) throws DoradeDescriptor.DescriptorException {
        byte[] data = this.readDescriptor(file2, littleEndianData, "CELV");
        this.nCells = this.grabInt(data, 8);
        this.ranges = new float[this.nCells];
        for (int i = 0; i < this.nCells; ++i) {
            this.ranges[i] = this.grabFloat(data, 12 + 4 * i);
        }
        if (this.verbose) {
            System.out.println(this);
        }
    }

    protected DoradeCELV() {
    }

    public String toString() {
        String s2 = "CELV\n";
        s2 = s2 + "  number of cells: " + this.nCells + "\n";
        s2 = s2 + "  ranges: " + this.ranges[0] + ", " + this.ranges[1] + ", ..., " + this.ranges[this.nCells - 1];
        return s2;
    }

    public int getNCells() {
        return this.nCells;
    }

    public float[] getCellRanges() {
        return this.ranges;
    }
}

