/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayInt;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.MadisStationObsDataset;
import ucar.nc2.dt.point.PointObsDatasetImpl;
import ucar.nc2.dt.point.RecordDatasetHelper;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class MadisPointObsDataset
extends PointObsDatasetImpl
implements TypedDatasetFactoryIF {
    private Structure recordVar;
    private RecordDatasetHelper recordHelper;
    private String obsTimeVName;
    private String nomTimeVName;
    private String stnIdVName;
    private String stnDescVName;
    private String altVName;
    private boolean debug = false;
    private boolean debugLinks = false;

    public static boolean isValidFile(NetcdfFile ds) {
        if (ds.findVariable("staticIds") == null) {
            return false;
        }
        if (ds.findVariable("nStaticIds") == null) {
            return false;
        }
        if (ds.findVariable("lastRecord") == null) {
            return false;
        }
        if (ds.findVariable("prevRecord") == null) {
            return false;
        }
        if (ds.findVariable("latitude") == null) {
            return false;
        }
        if (ds.findVariable("longitude") == null) {
            return false;
        }
        if (!ds.hasUnlimitedDimension()) {
            return false;
        }
        if (ds.findGlobalAttribute("timeVariables") == null) {
            return false;
        }
        if (ds.findGlobalAttribute("idVariables") == null) {
            return false;
        }
        Attribute att = ds.findGlobalAttribute("title");
        return att == null || !att.getStringValue().equals("MADIS ACARS data");
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return MadisPointObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new MadisStationObsDataset(ncd);
    }

    public MadisPointObsDataset() {
    }

    public MadisPointObsDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        this.altVName = "elevation";
        String timeNames = ds.findAttValueIgnoreCase(null, "timeVariables", null);
        StringTokenizer stoker = new StringTokenizer(timeNames, ", ");
        this.obsTimeVName = stoker.nextToken();
        if (ds.findVariable("timeNominal") != null) {
            this.nomTimeVName = "timeNominal";
        }
        String idNames = ds.findAttValueIgnoreCase(null, "idVariables", null);
        stoker = new StringTokenizer(idNames, ", ");
        this.stnIdVName = stoker.nextToken();
        if (this.stnIdVName.equals("stationName")) {
            if (ds.findVariable("locationName") != null) {
                this.stnDescVName = "locationName";
            }
            if (this.debug) {
                System.out.println("filetype 1 (metars)");
            }
        } else if (this.stnIdVName.equals("latitude")) {
            if (ds.findVariable("en_tailNumber") != null) {
                this.stnIdVName = "en_tailNumber";
            }
            this.altVName = "altitude";
            if (this.debug) {
                System.out.println("filetype 3 (acars)");
            }
        } else {
            if (ds.findVariable("stationId") != null) {
                this.stnIdVName = "stationId";
            }
            if (ds.findVariable("stationName") != null) {
                this.stnDescVName = "stationName";
            }
            if (this.debug) {
                System.out.println("filetype 2 (mesonet)");
            }
        }
        if (this.debug) {
            System.out.println("title= " + this.netcdfDataset.findAttValueIgnoreCase(null, "title", null));
        }
        this.recordHelper = new RecordDatasetHelper(ds, this.obsTimeVName, this.nomTimeVName, this.dataVariables, this.parseInfo);
        this.removeDataVariable("prevRecord");
        this.timeUnit = this.recordHelper.timeUnit;
        Variable lastRecordVar = ds.findVariable("lastRecord");
        ArrayInt.D1 lastRecord = (ArrayInt.D1)lastRecordVar.read();
        Variable inventoryVar = ds.findVariable("inventory");
        ArrayInt.D1 inventoryData = (ArrayInt.D1)inventoryVar.read();
        Variable v = ds.findVariable("nStaticIds");
        int n = v.readScalarInt();
        this.recordHelper.stnHash = new HashMap<Object, Station>(2 * n);
        this.recordVar = (Structure)ds.findVariable("record");
        for (int stnIndex = 0; stnIndex < n; ++stnIndex) {
            int lastValue = lastRecord.get(stnIndex);
            int inventory = inventoryData.get(stnIndex);
            if (lastValue < 0) continue;
            StructureData sdata = null;
            try {
                sdata = this.recordVar.readStructure(lastValue);
            }
            catch (InvalidRangeException e) {
                this.parseInfo.append("Invalid lastValue=" + lastValue + " for station at index " + stnIndex + "\n");
                continue;
            }
            String stationId = sdata.getScalarString(this.stnIdVName).trim();
            String string = this.stnDescVName == null ? null : sdata.getScalarString(this.stnDescVName);
        }
        Variable timeVar = ds.findVariable(this.obsTimeVName);
        Array timeData = timeVar.read();
        MAMath.MinMax minmax = MAMath.getMinMax(timeData);
        this.startDate = this.timeUnit.makeDate(minmax.min);
        this.endDate = this.timeUnit.makeDate(minmax.max);
        this.setBoundingBox();
    }

    @Override
    protected void setTimeUnits() {
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        ArrayList<PointObsDatatype> allData = new ArrayList<PointObsDatatype>();
        for (int i = 0; i < this.getDataCount(); ++i) {
            allData.add(this.makeObs(i));
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return allData;
    }

    protected PointObsDatatype makeObs(int recno) throws IOException {
        try {
            StructureData sdata = this.recordVar.readStructure(recno);
            float obsTime = sdata.convertScalarFloat(this.obsTimeVName);
            float nomTime = this.nomTimeVName == null ? obsTime : sdata.convertScalarFloat(this.nomTimeVName);
            float lat = sdata.convertScalarFloat("latitude");
            float lon = sdata.convertScalarFloat("longitude");
            float alt = sdata.convertScalarFloat(this.altVName);
            RecordDatasetHelper recordDatasetHelper = this.recordHelper;
            recordDatasetHelper.getClass();
            return new RecordDatasetHelper.RecordPointObs(recordDatasetHelper, new EarthLocationImpl(lat, lon, alt), obsTime, nomTime, recno);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int getDataCount() {
        Dimension unlimitedDim = this.netcdfDataset.getUnlimitedDimension();
        return unlimitedDim.getLength();
    }

    @Override
    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return null;
    }

    @Override
    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        return null;
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new MadisDatatypeIterator(this.recordHelper.recordVar, bufferSize);
    }

    private class MadisDatatypeIterator
    extends DatatypeIterator {
        @Override
        protected Object makeDatatypeWithData(int recnum, StructureData sdata) {
            RecordDatasetHelper recordDatasetHelper = MadisPointObsDataset.this.recordHelper;
            recordDatasetHelper.getClass();
            return new RecordDatasetHelper.RecordStationObs(recordDatasetHelper, recnum, sdata);
        }

        MadisDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }
}

