"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayToSageMakerEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-cdk/core");
/**
 * @summary The ApiGatewayToSageMakerEndpoint class.
 */
class ApiGatewayToSageMakerEndpoint extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the ApiGatewayToSageMakerEndpoint class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {ApiGatewayToSageMakerEndpointProps} props - user provided props for the construct.
     * @since 1.68.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Setup the API Gateway
        [this.apiGateway, this.apiGatewayCloudWatchRole, this.apiGatewayLogGroup] = defaults.GlobalRestApi(this, props.apiGatewayProps, props.logGroupProps);
        // Setup the API Gateway role
        if (props.apiGatewayExecutionRole !== undefined) {
            this.apiGatewayRole = props.apiGatewayExecutionRole;
        }
        else {
            this.apiGatewayRole = new iam.Role(this, 'api-gateway-role', {
                assumedBy: new iam.ServicePrincipal('apigateway.amazonaws.com')
            });
            // Setup the IAM policy for SageMaker endpoint
            const invokePolicy = new iam.Policy(this, 'InvokeEndpointPolicy', {
                statements: [
                    new iam.PolicyStatement({
                        actions: ['sagemaker:InvokeEndpoint'],
                        resources: [`arn:${core_1.Aws.PARTITION}:sagemaker:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:endpoint/${props.endpointName}`]
                    })
                ]
            });
            invokePolicy.attachToRole(this.apiGatewayRole);
        }
        // Setup request validation
        const requestValidator = this.apiGateway.addRequestValidator('request-validator', {
            requestValidatorName: 'request-param-validator',
            // Setting this property to true makes sure the following are validated:
            // - Required request parameters in the URI
            // - Query string
            // - Headers
            validateRequestParameters: true
        });
        // Setup method and integration responses
        const methodResponses = [
            { statusCode: '200' },
            { statusCode: '500' },
            { statusCode: '400' }
        ];
        const integResponses = [];
        if (props.responseMappingTemplate !== undefined) {
            integResponses.push({
                statusCode: '200',
                responseTemplates: { 'application/json': props.responseMappingTemplate }
            });
        }
        else {
            integResponses.push({ statusCode: '200' });
        }
        integResponses.push({ statusCode: '500', selectionPattern: '5\\d{2}' }, { statusCode: '400', selectionPattern: '4\\d{2}' });
        // The SageMaker integration can be added either at the root of the API (GET https://execute-api.amazonaws.com/{some-param}),
        // or as a sub-resource (GET https://execute-api.amazonaws.com/inference/{some-param}).
        // The following lines will make sure only the necessary resources are created.
        let apiResource = this.apiGateway.root;
        if (props.resourceName !== undefined) {
            apiResource = apiResource.addResource(props.resourceName);
        }
        apiResource = apiResource.addResource(props.resourcePath);
        // Setup API Gateway method
        defaults.addProxyMethodToApiResource({
            service: 'runtime.sagemaker',
            path: `endpoints/${props.endpointName}/invocations`,
            apiGatewayRole: this.apiGatewayRole,
            apiMethod: 'GET',
            apiResource,
            requestValidator,
            requestTemplate: props.requestMappingTemplate,
            awsIntegrationProps: {
                options: { integrationResponses: integResponses }
            },
            methodOptions: { methodResponses }
        });
    }
}
exports.ApiGatewayToSageMakerEndpoint = ApiGatewayToSageMakerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayToSageMakerEndpoint[_a] = { fqn: "@aws-solutions-constructs/aws-apigateway-sagemakerendpoint.ApiGatewayToSageMakerEndpoint", version: "1.163.0" };
//# sourceMappingURL=data:application/json;base64,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