# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, List, Union, Iterable, Optional
from typing_extensions import Literal, Required, Annotated, TypeAlias, TypedDict

from ..._utils import PropertyInfo

__all__ = [
    "CompletionCreateParams",
    "Message",
    "MessageSystemMessageRequest",
    "MessageUserMessageRequest",
    "MessageUserMessageRequestContentUnionMember1",
    "MessageAssistantMessageRequest",
    "MessageAssistantMessageRequestToolCall",
    "MessageAssistantMessageRequestToolCallFunction",
    "MessageToolMessageRequest",
    "ResponseFormat",
    "ResponseFormatResponseFormatText",
    "ResponseFormatResponseFormatJsonObject",
    "ResponseFormatResponseFormatJsonSchema",
    "ResponseFormatResponseFormatJsonSchemaJsonSchema",
    "StreamOptions",
    "ToolChoice",
    "ToolChoiceChoiceObject",
    "ToolChoiceChoiceObjectFunction",
    "Tool",
    "ToolFunction",
]


class CompletionCreateParams(TypedDict, total=False):
    messages: Required[Iterable[Message]]

    model: Required[str]

    frequency_penalty: Optional[float]
    """Number between -2.0 and 2.0.

    Positive values penalize new tokens based on their existing frequency in the
    text so far, decreasing the model's likelihood to repeat the same line verbatim.
    """

    logit_bias: Optional[object]
    """Modify the likelihood of specified tokens appearing in the completion.

    Accepts a JSON object that maps tokens (specified by their token ID in the
    tokenizer) to an associated bias value from -100 to 100. Mathematically, the
    bias is added to the logits generated by the model prior to sampling. The exact
    effect will vary per model, but values between -1 and 1 should decrease or
    increase likelihood of selection; values like -100 or 100 should result in a ban
    or exclusive selection of the relevant token.
    """

    logprobs: Optional[bool]
    """Whether to return log probabilities of the output tokens or not.

    If true, returns the log probabilities of each output token returned in the
    content of message.
    """

    max_completion_tokens: Optional[int]
    """
    An upper bound for the number of tokens that can be generated for a completion,
    including visible output tokens and reasoning tokens.
    """

    max_tokens: Optional[int]
    """The maximum number of tokens that can be generated in the chat completion.

    The total length of input tokens and generated tokens is limited by the model's
    context length. This value is now deprecated in favor of max_completion_tokens.
    """

    min_completion_tokens: Optional[int]
    """The minimum number of tokens to generate for a completion.

    If not specified or set to 0, the model will generate as many tokens as it deems
    necessary. Setting to -1 sets to max sequence length.
    """

    min_tokens: Optional[int]
    """The minimum number of tokens to generate for a completion.

    If not specified or set to 0, the model will generate as many tokens as it deems
    necessary. Setting to -1 sets to max sequence length.
    """

    n: Optional[int]
    """How many chat completion choices to generate for each input message.

    Note that you will be charged based on the number of generated tokens across all
    of the choices. Keep n as 1 to minimize costs.
    """

    parallel_tool_calls: Optional[bool]

    presence_penalty: Optional[float]
    """Number between -2.0 and 2.0.

    Positive values penalize new tokens based on whether they appear in the text so
    far, increasing the model's likelihood to talk about new topics.
    """

    response_format: Optional[ResponseFormat]

    seed: Optional[int]
    """
    If specified, our system will make a best effort to sample deterministically,
    such that repeated requests with the same `seed` and parameters should return
    the same result. Determinism is not guaranteed.
    """

    service_tier: Optional[Literal["auto", "default"]]

    stop: Union[str, List[str], None]
    """Up to 4 sequences where the API will stop generating further tokens.

    The returned text will not contain the stop sequence.
    """

    stream: Optional[bool]

    stream_options: Optional[StreamOptions]

    temperature: Optional[float]
    """What sampling temperature to use, between 0 and 1.5.

    Higher values like 0.8 will make the output more random, while lower values like
    0.2 will make it more focused and deterministic. We generally recommend altering
    this or `top_p` but not both.
    """

    tool_choice: Optional[ToolChoice]

    tools: Optional[Iterable[Tool]]

    top_logprobs: Optional[int]
    """
    An integer between 0 and 20 specifying the number of most likely tokens to
    return at each token position, each with an associated log probability. logprobs
    must be set to true if this parameter is used.
    """

    top_p: Optional[float]
    """
    An alternative to sampling with temperature, called nucleus sampling, where the
    model considers the results of the tokens with top_p probability mass. So 0.1
    means only the tokens comprising the top 10% probability mass are considered. We
    generally recommend altering this or `temperature` but not both.
    """

    user: Optional[str]
    """
    A unique identifier representing your end-user, which can help Cerebras to
    monitor and detect abuse.
    """

    cf_ray: Annotated[str, PropertyInfo(alias="CF-RAY")]

    x_amz_cf_id: Annotated[str, PropertyInfo(alias="X-Amz-Cf-Id")]

    x_delay_time: Annotated[float, PropertyInfo(alias="X-delay-time")]


class MessageSystemMessageRequestTyped(TypedDict, total=False):
    content: Required[str]

    role: Required[Literal["system"]]

    name: Optional[str]


MessageSystemMessageRequest: TypeAlias = Union[MessageSystemMessageRequestTyped, Dict[str, object]]


class MessageUserMessageRequestContentUnionMember1Typed(TypedDict, total=False):
    text: Required[str]

    type: Required[Literal["text"]]


MessageUserMessageRequestContentUnionMember1: TypeAlias = Union[
    MessageUserMessageRequestContentUnionMember1Typed, Dict[str, object]
]


class MessageUserMessageRequestTyped(TypedDict, total=False):
    content: Required[Union[str, Iterable[MessageUserMessageRequestContentUnionMember1]]]

    role: Required[Literal["user"]]

    name: Optional[str]


MessageUserMessageRequest: TypeAlias = Union[MessageUserMessageRequestTyped, Dict[str, object]]


class MessageAssistantMessageRequestToolCallFunctionTyped(TypedDict, total=False):
    arguments: Required[str]

    name: Required[str]


MessageAssistantMessageRequestToolCallFunction: TypeAlias = Union[
    MessageAssistantMessageRequestToolCallFunctionTyped, Dict[str, object]
]


class MessageAssistantMessageRequestToolCallTyped(TypedDict, total=False):
    id: Required[str]

    function: Required[MessageAssistantMessageRequestToolCallFunction]

    type: Required[Literal["function"]]


MessageAssistantMessageRequestToolCall: TypeAlias = Union[
    MessageAssistantMessageRequestToolCallTyped, Dict[str, object]
]


class MessageAssistantMessageRequestTyped(TypedDict, total=False):
    role: Required[Literal["assistant"]]

    content: Optional[str]

    name: Optional[str]

    tool_calls: Optional[Iterable[MessageAssistantMessageRequestToolCall]]


MessageAssistantMessageRequest: TypeAlias = Union[MessageAssistantMessageRequestTyped, Dict[str, object]]


class MessageToolMessageRequestTyped(TypedDict, total=False):
    content: Required[str]

    role: Required[Literal["tool"]]

    tool_call_id: Required[str]

    name: Optional[str]


MessageToolMessageRequest: TypeAlias = Union[MessageToolMessageRequestTyped, Dict[str, object]]

Message: TypeAlias = Union[
    MessageSystemMessageRequest, MessageUserMessageRequest, MessageAssistantMessageRequest, MessageToolMessageRequest
]


class ResponseFormatResponseFormatTextTyped(TypedDict, total=False):
    type: Required[Literal["text"]]


ResponseFormatResponseFormatText: TypeAlias = Union[ResponseFormatResponseFormatTextTyped, Dict[str, object]]


class ResponseFormatResponseFormatJsonObjectTyped(TypedDict, total=False):
    type: Required[Literal["json_object"]]


ResponseFormatResponseFormatJsonObject: TypeAlias = Union[
    ResponseFormatResponseFormatJsonObjectTyped, Dict[str, object]
]


class ResponseFormatResponseFormatJsonSchemaJsonSchemaTyped(TypedDict, total=False):
    name: Required[str]

    description: Optional[str]

    schema: Optional[object]

    strict: Optional[bool]


ResponseFormatResponseFormatJsonSchemaJsonSchema: TypeAlias = Union[
    ResponseFormatResponseFormatJsonSchemaJsonSchemaTyped, Dict[str, object]
]


class ResponseFormatResponseFormatJsonSchemaTyped(TypedDict, total=False):
    json_schema: Required[ResponseFormatResponseFormatJsonSchemaJsonSchema]

    type: Required[Literal["json_schema"]]


ResponseFormatResponseFormatJsonSchema: TypeAlias = Union[
    ResponseFormatResponseFormatJsonSchemaTyped, Dict[str, object]
]

ResponseFormat: TypeAlias = Union[
    ResponseFormatResponseFormatText, ResponseFormatResponseFormatJsonObject, ResponseFormatResponseFormatJsonSchema
]


class StreamOptionsTyped(TypedDict, total=False):
    include_usage: Optional[bool]


StreamOptions: TypeAlias = Union[StreamOptionsTyped, Dict[str, object]]


class ToolChoiceChoiceObjectFunctionTyped(TypedDict, total=False):
    name: Required[str]


ToolChoiceChoiceObjectFunction: TypeAlias = Union[ToolChoiceChoiceObjectFunctionTyped, Dict[str, object]]


class ToolChoiceChoiceObjectTyped(TypedDict, total=False):
    function: Required[ToolChoiceChoiceObjectFunction]

    type: Required[str]


ToolChoiceChoiceObject: TypeAlias = Union[ToolChoiceChoiceObjectTyped, Dict[str, object]]

ToolChoice: TypeAlias = Union[Literal["none", "auto", "required"], ToolChoiceChoiceObject]


class ToolFunctionTyped(TypedDict, total=False):
    name: Required[str]

    description: Optional[str]

    parameters: Optional[object]
    """
    Represents the parameters a function accepts. This model is designed to be
    flexible to accommodate any JSON Schema. The key-value pairs you provide will
    define the parameters.
    """


ToolFunction: TypeAlias = Union[ToolFunctionTyped, Dict[str, object]]


class ToolTyped(TypedDict, total=False):
    function: Required[ToolFunction]

    type: Required[str]


Tool: TypeAlias = Union[ToolTyped, Dict[str, object]]
