/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ManagerConnectionBase;
import com.teradata.jdbc.jdbc.fastload.FastLoadManagerPreparedStatement;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FastLoadManagerConnection
extends ManagerConnectionBase {
    private List fastloads = Collections.synchronizedList(new ArrayList());

    public FastLoadManagerConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, string2, string3, uRLParameters);
    }

    private String getTeradataTypeCast(int n, FullContentMetadataItem fullContentMetadataItem, String string, long[] lArray) {
        String string2 = null;
        String string3 = fullContentMetadataItem.getCustomerVisibleColumnTypeName();
        if (string3.equals("BIGINT") || string3.startsWith("PERIOD") || string3.equals("BYTEINT") || string3.equals("DATE") || string3.equals("FLOAT") || string3.equals("INTEGER") || string3.equals("SMALLINT")) {
            string2 = string3;
            lArray[0] = lArray[0] + fullContentMetadataItem.getMaxDataLengthInBytes();
            if (string3.startsWith("PERIOD(TIMESTAMP")) {
                lArray[0] = lArray[0] + 2L;
            }
        } else if (string3.endsWith("BYTE")) {
            string2 = "VARBYTE(" + fullContentMetadataItem.getMaxDataLengthInBytes() + ")";
            lArray[0] = lArray[0] + (fullContentMetadataItem.getMaxDataLengthInBytes() + 2L);
        } else if (string3.endsWith("CHAR") || string3.startsWith("INTERVAL")) {
            long l = "UTF8".equals(string) ? Math.min(fullContentMetadataItem.getMaxDataLengthInBytes(), 32000L) : fullContentMetadataItem.getMaxDataLengthInBytes();
            string2 = "VARCHAR(" + l + ")";
            lArray[0] = lArray[0] + (l + 2L);
        } else if (string3.equals("DECIMAL")) {
            string2 = string3 + "(" + this.m_appSession.getMaxDecimalPrecision() + "," + fullContentMetadataItem.getNumberOfFractionalDigits() + ")";
            lArray[0] = lArray[0] + (this.m_appSession.isLargeDecimalAndBigIntSupported() ? 16L : 8L);
        } else if (string3.startsWith("TIME")) {
            long l;
            if (string3.startsWith("TIMESTAMP")) {
                int n2 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                l = 19 + n2;
            } else {
                int n3 = fullContentMetadataItem.getNumberOfFractionalDigits() == 0 ? 0 : fullContentMetadataItem.getNumberOfFractionalDigits() + 1;
                l = 8 + n3;
            }
            if (string3.endsWith("ZONE")) {
                l += 6L;
            }
            if (string.equals("UTF16")) {
                l *= 2L;
            }
            string2 = "CHAR(" + l + ")";
            lArray[0] = lArray[0] + l;
        } else {
            this.getLog().info("Cannot FastLoad because a data type of " + string3 + " in column " + n + " of the destination database table is not supported!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ546", string3, String.valueOf(n));
            this.addWarning(sQLWarning);
        }
        return string2;
    }

    public static String quoteName(String string) {
        return string == null ? string : "\"" + string.replaceAll("\"", "\"\"") + "\"";
    }

    public static String unquoteName(String string) {
        return string == null || string.length() < 2 || !string.startsWith("\"") ? string : string.substring(1, string.length() - 1).replaceAll("\"\"", "\"");
    }

    public static Matcher matchInsertValuesStatement(String string) {
        String string2 = "(?is)\\s*INSERT\\s+INTO\\s+(?:([^\"][^\\s.]*|\"(?:\"\"|[^\"])*\")\\s*\\.\\s*)?([^\"][^\\s]*|\"(?:\"\"|[^\"])*\")\\s*(?:\\((.*)\\))?\\s*(?:VALUES)?\\s*\\([\\s?,]+\\)\\s*(?:;\\s*)?";
        return Pattern.compile(string2).matcher(string);
    }

    protected synchronized PreparedStatement createManagerPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        String string = this.getURLParameters().getCharSet();
        if (!(string.equals("ASCII") || string.equals("UTF8") || string.equals("UTF16") || string.equals("KANJISJIS_0S") || string.equals("KANJIEUC_0U"))) {
            this.getLog().info("Cannot FastLoad because the specified Java Character Encoding is not supported: " + string);
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ540", string);
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)preparedStatement);
        MetaDataList metaDataList = tDPreparedStatement.getMetaDataList();
        if (metaDataList.size() == 0) {
            this.getLog().info("Cannot FastLoad because no metadata is available.");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ628");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        if (metaDataList.size() > 1) {
            this.getLog().info("Cannot FastLoad a multi-statement request!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ541");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        TeraResultSetMetaData teraResultSetMetaData = metaDataList.getFirstMetaData();
        if (!ActivityAnalyzer.isFastLoadCompatible(teraResultSetMetaData.getActivityType())) {
            this.getLog().info("Cannot FastLoad because statement is not an INSERT!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ542");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        if (tDPreparedStatement.hasGeneratedKeysRequest()) {
            this.getLog().info("Cannot FastLoad because auto-generated key retrieval was requested, but is not supported!");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ543");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        ArrayList arrayList = null;
        if (this.m_appSession.isStatementInfoSupported()) {
            arrayList = tDPreparedStatement.getParameterMarkerMetaData();
        }
        SQLWarning sQLWarning = null;
        Matcher matcher = FastLoadManagerConnection.matchInsertValuesStatement(tDPreparedStatement.getOriginalSql());
        if (!matcher.matches()) {
            this.getLog().info("Cannot FastLoad because the INSERT statement does not match the required syntax.");
            sQLWarning = ErrorFactory.makeSQLWarning("TJ544");
        } else if (arrayList == null) {
            this.getLog().info("Cannot FastLoad because StatementInfo parcel support is not available");
            sQLWarning = ErrorFactory.makeSQLWarning("TJ807");
        }
        if (sQLWarning != null) {
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        long[] lArray = new long[]{(arrayList.size() + 1 + 7) / 8 + 4};
        String string2 = null;
        String string3 = null;
        String string4 = "USING ";
        String string5 = " INSERT INTO ";
        String string6 = " VALUES ( ";
        for (int i = 0; i < arrayList.size(); ++i) {
            FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)arrayList.get(i);
            String string7 = this.getTeradataTypeCast(i + 1, fullContentMetadataItem, string, lArray);
            if (string7 == null) {
                return preparedStatement;
            }
            if (i == 0) {
                string2 = fullContentMetadataItem.getDatabaseName();
                string3 = fullContentMetadataItem.getProcedureOrTableName();
                string5 = string5 + FastLoadManagerConnection.quoteName(string2) + "." + FastLoadManagerConnection.quoteName(string3) + " ( ";
            } else {
                string4 = string4 + ", ";
                string5 = string5 + ", ";
                string6 = string6 + ", ";
            }
            String string8 = fullContentMetadataItem.getColumnOrParameterName();
            string4 = string4 + FastLoadManagerConnection.quoteName("F_" + string8) + " (" + string7 + ")";
            string5 = string5 + FastLoadManagerConnection.quoteName(string8);
            string6 = string6 + ":" + FastLoadManagerConnection.quoteName("F_" + string8);
        }
        string4 = string4 + ", " + FastLoadManagerConnection.quoteName("RowNumber") + " (INTEGER)";
        string5 = string5 + " )";
        string6 = string6 + " )";
        if (!this.m_appSession.getConfigResponse().isLargeIndicDataSupported() && lArray[0] > 64000L) {
            this.getLog().info("Cannot FastLoad because the potential row data size of " + lArray[0] + " bytes exceeds 64000 bytes");
            this.addWarning(ErrorFactory.makeSQLWarning("TJ839", String.valueOf(lArray[0])));
            return preparedStatement;
        }
        String string9 = string4 + string5 + string6;
        this.getLog().info("FastLoad " + string9);
        preparedStatement = this.constructPreparedStatement(this.machineName, this.userName, this.password, string2, string3, string9, preparedStatement, arrayList);
        this.fastloads.add(preparedStatement);
        return preparedStatement;
    }

    protected synchronized void removeStatement(Object object) {
        this.fastloads.remove(object);
    }

    public synchronized String getLogonSequenceNumber() {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < this.fastloads.size(); ++i) {
            FastLoadManagerPreparedStatement fastLoadManagerPreparedStatement = (FastLoadManagerPreparedStatement)this.fastloads.get(i);
            if (!fastLoadManagerPreparedStatement.isConnected()) continue;
            if (!bl) {
                string = string + ",";
            } else {
                bl = false;
            }
            string = string + fastLoadManagerPreparedStatement.hashCode() + ",";
            string = string + fastLoadManagerPreparedStatement.getLogonSequenceNumber();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            ArrayList arrayList = new ArrayList(this.fastloads);
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    FastLoadManagerPreparedStatement fastLoadManagerPreparedStatement = (FastLoadManagerPreparedStatement)arrayList.get(i);
                    boolean bl = fastLoadManagerPreparedStatement.isFastLoading();
                    try {
                        fastLoadManagerPreparedStatement.close();
                        if (!bl) continue;
                        fastLoadManagerPreparedStatement.rollbackFastLoad();
                        fastLoadManagerPreparedStatement.closeFastLoad();
                        continue;
                    }
                    catch (SQLException sQLException2) {
                        SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                        sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
                        sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                        continue;
                    }
                    finally {
                        if (bl) {
                            this.removeStatement(fastLoadManagerPreparedStatement);
                        }
                    }
                }
                this.m_appSession.close();
            }
            catch (SQLException sQLException4) {
                sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException4);
            }
            finally {
                this.connected = false;
            }
            if (sQLException != null) {
                SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ457");
                sQLException5.setNextException(sQLException);
                throw sQLException5;
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.doInternalCommit(null);
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.doInternalCommit(bl);
    }

    private synchronized void doInternalCommit(Boolean bl) throws SQLException {
        this.abortIfClosed();
        SQLException sQLException = null;
        ArrayList arrayList = new ArrayList(this.fastloads);
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((FastLoadManagerPreparedStatement)arrayList.get(i)).endFastLoad();
                    continue;
                }
                catch (SQLException sQLException2) {
                    SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            if (bl != null) {
                this.m_appSession.setAutoCommit(bl);
            } else {
                this.m_appSession.commit();
            }
        }
        catch (SQLException sQLException4) {
            sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException4);
        }
        if (sQLException != null) {
            SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ458");
            sQLException5.setNextException(sQLException);
            throw sQLException5;
        }
    }

    public synchronized void rollback() throws SQLException {
        this.abortIfClosed();
        SQLException sQLException = null;
        ArrayList arrayList = new ArrayList(this.fastloads);
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((FastLoadManagerPreparedStatement)arrayList.get(i)).rollbackFastLoad();
                    continue;
                }
                catch (SQLException sQLException2) {
                    SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ469", i, arrayList.size());
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException3);
                    sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                }
            }
            this.m_appSession.rollback();
        }
        catch (SQLException sQLException4) {
            sQLException = FastLoadManagerConnection.chainSQLExceptions(sQLException, sQLException4);
        }
        if (sQLException != null) {
            SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ474");
            sQLException5.setNextException(sQLException);
            throw sQLException5;
        }
    }

    protected abstract PreparedStatement constructPreparedStatement(String var1, String var2, String var3, String var4, String var5, String var6, PreparedStatement var7, ArrayList var8) throws SQLException;
}

