/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.resolver.EnvVariableResolver;

public class LDAPSSLSocketFactory
extends SSLSocketFactory {
    static final ThreadLocal<Properties> connectionProperties = new ThreadLocal();
    private static SSLSocketFactory defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    public static SocketFactory getDefault() {
        return new LDAPSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return defaultFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return defaultFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n2, boolean bl) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(socket, string, n2, bl), properties);
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException, UnknownHostException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(string, n2), properties);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(inetAddress, n2), properties);
    }

    @Override
    public Socket createSocket(String string, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(string, n2, inetAddress, n3), properties);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        Properties properties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(properties).createSocket(inetAddress, n2, inetAddress2, n3), properties);
    }

    private SSLSocketFactory getSSLSocketFactory(Properties properties) throws IOException {
        return CustomSSLSocketFactory.getSSLSocketFactory(properties);
    }

    private Properties getSSLProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        Properties properties2 = new Properties();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.walletLocation")) {
                string = properties.getProperty("oracle.net.ldap.ssl.walletLocation");
                properties2.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(string, properties));
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.walletPassword")) {
                string = properties.getProperty("oracle.net.ldap.ssl.walletPassword");
                properties2.put((Object)16, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.supportedVersions")) {
                string = properties.getProperty("oracle.net.ldap.ssl.supportedVersions");
                properties2.put((Object)6, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.supportedCiphers")) {
                string = properties.getProperty("oracle.net.ldap.ssl.supportedCiphers");
                properties2.put((Object)7, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.keyStore")) {
                string = properties.getProperty("oracle.net.ldap.ssl.keyStore");
                properties2.put((Object)8, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.keyStoreType")) {
                string = properties.getProperty("oracle.net.ldap.ssl.keyStoreType");
                properties2.put((Object)9, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.keyStorePassword")) {
                string = properties.getProperty("oracle.net.ldap.ssl.keyStorePassword");
                properties2.put((Object)10, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.trustStore")) {
                string = properties.getProperty("oracle.net.ldap.ssl.trustStore");
                properties2.put((Object)11, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.trustStoreType")) {
                string = properties.getProperty("oracle.net.ldap.ssl.trustStoreType");
                properties2.put((Object)12, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.trustStorePassword")) {
                string = properties.getProperty("oracle.net.ldap.ssl.trustStorePassword");
                properties2.put((Object)13, string);
                continue;
            }
            if (string2.equalsIgnoreCase("oracle.net.ldap.ssl.keyManagerFactory.algorithm")) {
                string = properties.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
                properties2.put((Object)14, string);
                continue;
            }
            if (!string2.equalsIgnoreCase("oracle.net.ldap.ssl.trustManagerFactory.algorithm")) continue;
            string = properties.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
            properties2.put((Object)15, string);
        }
        return properties2;
    }

    private Socket initializeSSLSocket(SSLSocket sSLSocket, Properties properties) {
        Object object;
        String string = (String)properties.get(6);
        if (string != null && !string.trim().isEmpty()) {
            object = string.split(",");
            sSLSocket.setEnabledProtocols((String[])object);
        } else {
            sSLSocket.setEnabledProtocols(sSLSocket.getSupportedProtocols());
        }
        object = (String)properties.get(7);
        if (object != null && !((String)object).trim().isEmpty()) {
            String[] stringArray = ((String)object).split(",");
            sSLSocket.setEnabledCipherSuites(stringArray);
        } else {
            sSLSocket.setEnabledCipherSuites(sSLSocket.getSupportedCipherSuites());
        }
        return sSLSocket;
    }
}

