# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/ml.lang.dataset.ipynb.

# %% auto 0
__all__ = ['alpaca2sharegpt', 'alpaca2openai', 'sharegpt_from2openai_role', 'openai_role2sharegpt_from', 'sharegpt2openai']

# %% ../../../nbs/ml.lang.dataset.ipynb 3
def alpaca2sharegpt(example):
    messages = []
    if "instruction" in example:
        messages.append({"from": "system", "value": example["instruction"]})
    messages.append({"from": "human", "value": example["input"]})
    messages.append({"from": "gpt", "value": example["output"]})
    return {"conversations": messages}


def alpaca2openai(example):
    messages = []
    if "instruction" in example:
        messages.append({"role": "system", "content": example["instruction"]})
    messages.append({"role": "user", "content": example["input"]})
    messages.append({"role": "assistant", "content": example["output"]})
    return {"conversations": messages}


def sharegpt_from2openai_role(message):
    return {"system": "system", "human": "user", "gpt": "assistant"}[message["from"]]


def openai_role2sharegpt_from(message):
    return {"system": "system", "user": "human", "assistant": "gpt"}[message["role"]]


def sharegpt2openai(example):
    return {
        "conversations": [
            {"role": sharegpt_from2openai_role(message), "content": message["value"]}
            for message in example["conversations"]
        ],
    }
