""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.uhost.schemas import apis


class UHostClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UHostClient, self).__init__(config, transport, middleware, logger)

    def copy_custom_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CopyCustomImage - 复制自制镜像

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **SourceImageId** (str) - (Required) 源镜像Id, 参见 DescribeImage
        - **TargetProjectId** (str) - (Required) 目标项目Id, 参见 GetProjectList
        - **TargetImageDescription** (str) - 目标镜像描述
        - **TargetImageName** (str) - 目标镜像名称
        - **TargetRegion** (str) - 目标地域，不跨地域不用填
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **TargetImageId** (str) - 目标镜像Id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CopyCustomImageRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CopyCustomImage", d, **kwargs)
        return apis.CopyCustomImageResponseSchema().loads(resp)

    def create_custom_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateCustomImage - 从指定UHost实例，生成自定义镜像。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ImageName** (str) - (Required) 镜像名称
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **ImageDescription** (str) - 镜像描述
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **ImageId** (str) - 镜像Id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateCustomImageRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateCustomImage", d, **kwargs)
        return apis.CreateCustomImageResponseSchema().loads(resp)

    def create_isolation_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateIsolationGroup - 创建硬件隔离组，组内机器严格隔离在不同宿主机上。

        **Request**

        - **ProjectId** (str) - (Config) 项目id
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupName** (str) - (Required) 硬件隔离组名称。请遵照 `字段规范 <https://docs.ucloud.cn/api/uhost-api/specification>`_ 设定隔离组名称。
        - **Remark** (str) - 备注。请遵照 `字段规范 <https://docs.ucloud.cn/api/uhost-api/specification>`_ 设定隔离组备注。

        **Response**

        - **GroupId** (str) - 硬件隔离组id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateIsolationGroupRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateIsolationGroup", d, **kwargs)
        return apis.CreateIsolationGroupResponseSchema().loads(resp)

    def create_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUHostInstance - 创建UHost实例。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ImageId** (str) - (Required) 镜像ID。 请通过  `DescribeImage <https://docs.ucloud.cn/api/uhost-api/describe_image.html>`_ 获取
        - **LoginMode** (str) - (Required) 主机登陆模式。密码（默认选项）: Password，密钥：KeyPair。
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **AlarmTemplateId** (int) - 告警模板id，如果传了告警模板id，且告警模板id正确，则绑定告警模板。绑定告警模板失败只会在后台有日志，不会影响创建主机流程，也不会在前端报错。
        - **AutoDataDiskInit** (str) - 数据盘是否需要自动分区挂载。当镜像支持“Cloud-init”Feature时可填写此字段。取值 >“On” 自动挂载（默认值）> “Off” 不自动挂载。
        - **CPU** (int) - 虚拟CPU核数。可选参数：1-64（具体机型与CPU的对应关系参照控制台）。默认值: 4。
        - **ChargeType** (str) - 计费模式。枚举值为： \\ > Year，按年付费； \\ > Month，按月付费；\\ > Dynamic，按小时预付费 \\ > Postpay，按小时后付费（支持关机不收费，目前仅部分可用区支持，请联系您的客户经理） \\Preemptive计费为抢占式实例 \\ 默认为月付
        - **CouponId** (str) - 主机代金券ID。请通过DescribeCoupon接口查询，或登录用户中心查看
        - **Disks** (list) - 见 **CreateUHostInstanceParamDisks** 模型定义
        - **GPU** (int) - GPU卡核心数。仅GPU机型支持此字段（可选范围与MachineType+GpuType相关）
        - **GpuType** (str) - GPU类型，枚举值["K80", "P40", "V100", "T4", "T4S","2080Ti","2080Ti-4C","1080Ti"]，MachineType为G时必填
        - **HotplugFeature** (bool) - 热升级特性。True为开启，False为未开启，默认False。
        - **IsolationGroup** (str) - 硬件隔离组id。可通过DescribeIsolationGroup获取。
        - **KeyPairId** (str) - KeypairId 密钥对ID，LoginMode为KeyPair时此项必须
        - **MachineType** (str) - 云主机机型（V2.0），在本字段和字段UHostType中，仅需要其中1个字段即可。枚举值["N", "C", "G", "O", "OS", "OPRO", "OMAX", "O.BM"]。参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type>`_ 。
        - **MaxCount** (int) - 本次最大创建主机数量，取值范围是[1,100]，默认值为1。
        - **Memory** (int) - 内存大小。单位：MB。范围 ：[1024, 262144]，取值为1024的倍数（可选范围参考控制台）。默认值：8192
        - **MinimalCpuPlatform** (str) - 最低cpu平台，枚举值["Intel/Auto", "Intel/IvyBridge", "Intel/Haswell", "Intel/Broadwell", "Intel/Skylake", "Intel/Cascadelake"；"Intel/CascadelakeR"; “Amd/Epyc2”,"Amd/Auto"],默认值是"Intel/Auto"。
        - **Name** (str) - UHost实例名称。默认：UHost。请遵照 `字段规范 <https://docs.ucloud.cn/api/uhost-api/specification>`_ 设定实例名称。
        - **NetCapability** (str) - 网络增强特性。枚举值：Normal（默认），不开启;  Super，开启网络增强1.0； Ultra，开启网络增强2.0（仅支持部分可用区，请参考控制台）
        - **NetworkInterface** (list) - 见 **CreateUHostInstanceParamNetworkInterface** 模型定义
        - **Password** (str) - UHost密码。请遵照 `字段规范 <https://docs.ucloud.cn/api/uhost-api/specification>`_ 设定密码。密码需使用base64进行编码，举例如下：# echo -n Password1 | base64UGFzc3dvcmQx。
        - **PrivateIp** (list) - 【数组】创建云主机时指定内网IP。若不传值，则随机分配当前子网下的IP。调用方式举例：PrivateIp.0=x.x.x.x。当前只支持一个内网IP。
        - **Quantity** (int) - 购买时长。默认:值 1。按小时购买（Dynamic/Postpay）时无需此参数。 月付时，此参数传0，代表购买至月末。
        - **SecurityGroupId** (str) - 防火墙ID，默认：Web推荐防火墙。如何查询SecurityGroupId请参见  `DescribeFirewall <https://docs.ucloud.cn/api/uhost-api/api/unet-api/describe_firewall.html>`_ 。
        - **SubnetId** (str) - 子网 ID。默认为当前地域的默认子网。
        - **Tag** (str) - 业务组。默认：Default（Default即为未分组）。请遵照 `字段规范 <https://docs.ucloud.cn/api/uhost-api/specification>`_ 设定业务组。
        - **UHostType** (str) - 【建议后续不再使用】云主机机型（V1.0），在本字段和字段MachineType中，仅需要其中1个字段即可。参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type>`_ 。
        - **UserData** (str) - 用户自定义数据。当镜像支持Cloud-init Feature时可填写此字段。注意：1、总数据量大小不超过 16K；2、使用base64编码
        - **VPCId** (str) - VPC ID。默认为当前地域的默认VPC。

        **Response**

        - **IPs** (list) - 【批量创建不会返回】IP信息
        - **UHostIds** (list) - UHost实例Id集合

        **Request Model**

        **CreateUHostInstanceParamDisks**
        - **BackupType** (str) - 磁盘备份方案。枚举值：\\ > NONE，无备份 \\ > DATAARK，数据方舟 \\ > SNAPSHOT（SNAPSHOT模式目前仅在上海C支持），快照 \\当前磁盘支持的备份模式参考  `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ ,默认值:NONE
        - **CouponId** (str) - 云盘代金券id。不适用于系统盘/本地盘。请通过DescribeCoupon接口查询，或登录用户中心查看
        - **Encrypted** (bool) - 【功能仅部分可用区开放，详询技术支持】磁盘是否加密。加密：true, 不加密: false加密必须传入对应的的KmsKeyId,默认值false
        - **IsBoot** (str) - 是否是系统盘。枚举值：\\ > True，是系统盘 \\ > False，是数据盘（默认）。Disks数组中有且只能有一块盘是系统盘。
        - **KmsKeyId** (str) - 【功能仅部分可用区开放，详询技术支持】kms key id。选择加密盘时必填。
        - **Size** (int) - 磁盘大小，单位GB，必须是10GB的整数倍。请参考 `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ 。
        - **Type** (str) - 磁盘类型。请参考 `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ 。


        **CreateUHostInstanceParamNetworkInterfaceEIPGlobalSSH**
        - **Area** (str) - 填写支持SSH访问IP的地区名称，如“洛杉矶”，“新加坡”，“香港”，“东京”，“华盛顿”，“法兰克福”。Area和AreaCode两者必填其中之一。
        - **AreaCode** (str) - GlobalSSH的地区编码，格式为区域航空港国际通用代码。Area和AreaCode两者必填其中之一。
        - **Port** (int) - SSH端口，1-65535且不能使用80，443端口


        **CreateUHostInstanceParamNetworkInterfaceEIP**
        - **Bandwidth** (int) - 【若绑定EIP，此参数必填】弹性IP的外网带宽, 单位为Mbps. 共享带宽模式必须指定0M带宽, 非共享带宽模式必须指定非0Mbps带宽. 各地域非共享带宽的带宽范围如下： 流量计费[1-300]，带宽计费[1-800]
        - **CouponId** (str) - 当前EIP代金券id。请通过DescribeCoupon接口查询，或登录用户中心查看。
        - **GlobalSSH** (dict) - 见 **CreateUHostInstanceParamNetworkInterfaceEIPGlobalSSH** 模型定义
        - **OperatorName** (str) - 【若绑定EIP，此参数必填】弹性IP的线路。枚举值: 国际: International BGP: Bgp 各地域允许的线路参数如下: cn-sh1: Bgp cn-sh2: Bgp cn-gd: Bgp cn-bj1: Bgp cn-bj2: Bgp hk: International us-ca: International th-bkk: International kr-seoul:International us-ws:International ge-fra:International sg:International tw-kh:International.其他海外线路均为 International
        - **PayMode** (str) - 弹性IP的计费模式. 枚举值: "Traffic", 流量计费; "Bandwidth", 带宽计费; "ShareBandwidth",共享带宽模式. "Free":免费带宽模式,默认为 "Bandwidth"
        - **ShareBandwidthId** (str) - 绑定的共享带宽Id，仅当PayMode为ShareBandwidth时有效


        **CreateUHostInstanceParamNetworkInterfaceIPv6**


        **CreateUHostInstanceParamNetworkInterface**
        - **CreateCernetIp** (bool) - 申请并绑定一个教育网EIP。True为申请并绑定，False为不会申请绑定，默认False。当前只支持具有HPC特性的机型。
        - **EIP** (dict) - 见 **CreateUHostInstanceParamNetworkInterfaceEIP** 模型定义


        **CreateUHostInstanceParamVirtualGpuGPUVirtualGpu**


        **CreateUHostInstanceParamVirtualGpu**


        **CreateUHostInstanceParamVolumes**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUHostInstanceRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUHostInstance", d, **kwargs)
        return apis.CreateUHostInstanceResponseSchema().loads(resp)

    def create_uhost_key_pair(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUHostKeyPair - 创建主机密钥对信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **KeyPairName** (str) - (Required) 密钥对名称。 由字母，数字，符号组成，长度为1-63位。
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **KeyPair** (dict) - 见 **KeyPair** 模型定义

        **Response Model**

        **KeyPair**
        - **CreateTime** (int) - 密钥对的创建时间，格式为Unix Timestamp。
        - **KeyPairFingerPrint** (str) - 密钥对指纹。md5(ProjectId|KeyPairId|PublicKey)
        - **KeyPairId** (str) - 密钥对ID。
        - **KeyPairName** (str) - 密钥对名称。 长度为1~63个英文或中文字符。
        - **PrivateKeyBody** (str) - 密钥对的私钥内容。只有创建接口才会返回。
        - **ProjectId** (str) - 项目ID。


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUHostKeyPairRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUHostKeyPair", d, **kwargs)
        return apis.CreateUHostKeyPairResponseSchema().loads(resp)

    def delete_isolation_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteIsolationGroup - 删除硬件隔离组。

        **Request**

        - **ProjectId** (str) - (Config) 项目id
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 硬件隔离组id

        **Response**

        - **GroupId** (str) - 硬件隔离组id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteIsolationGroupRequestSchema().dumps(d)

        resp = self.invoke("DeleteIsolationGroup", d, **kwargs)
        return apis.DeleteIsolationGroupResponseSchema().loads(resp)

    def delete_uhost_key_pairs(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUHostKeyPairs - 删除一对或者多对密钥对。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **KeyPairIds** (list) - (Required) 密钥对ID，最多支持 100 对。
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteUHostKeyPairsRequestSchema().dumps(d)

        resp = self.invoke("DeleteUHostKeyPairs", d, **kwargs)
        return apis.DeleteUHostKeyPairsResponseSchema().loads(resp)

    def describe_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeImage - 获取指定数据中心镜像列表，用户可通过指定操作系统类型，镜像Id进行过滤。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ImageId** (str) - 镜像Id
        - **ImageType** (str) - 镜像类型。标准镜像：Base，镜像市场：Business， 自定义镜像：Custom，默认返回所有类型
        - **Limit** (int) - 返回数据长度，默认为20
        - **Offset** (int) - 列表起始位置偏移量，默认为0
        - **OsType** (str) - 操作系统类型：Linux， Windows 默认返回所有类型
        - **PriceSet** (int) - 是否返回价格：1返回，0不返回；默认不返回
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Action** (str) - 操作名称
        - **ImageSet** (list) - 见 **UHostImageSet** 模型定义
        - **RetCode** (int) - 返回码
        - **TotalCount** (int) - 满足条件的镜像总数

        **Response Model**

        **UHostImageSet**
        - **CreateTime** (int) - 创建时间，格式为Unix时间戳
        - **Features** (list) - 特殊状态标识， 目前包含NetEnhnced（网络增强1.0）, NetEnhanced_Ultra]（网络增强2.0）, HotPlug(热升级), CloudInit, IPv6
        - **FuncType** (str) - 行业镜像类型（仅行业镜像将返回这个值）
        - **ImageDescription** (str) - 镜像描述
        - **ImageId** (str) - 镜像ID
        - **ImageName** (str) - 镜像名称
        - **ImageSize** (int) - 镜像大小
        - **ImageType** (str) - 镜像类型 标准镜像：Base， 行业镜像：Business，自定义镜像：Custom
        - **IntegratedSoftware** (str) - 集成软件名称（仅行业镜像将返回这个值）
        - **Links** (str) - 介绍链接（仅行业镜像将返回这个值）
        - **MinimalCPU** (str) - 默认值为空'''。当CentOS 7.3/7.4/7.5等镜像会标记为“Broadwell”
        - **OsName** (str) - 操作系统名称
        - **OsType** (str) - 操作系统类型：Linux，Windows
        - **State** (str) - 镜像状态， 可用：Available，制作中：Making， 不可用：Unavailable
        - **Vendor** (str) - 供应商（仅行业镜像将返回这个值）
        - **Zone** (str) - 可用区，参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeImageRequestSchema().dumps(d)

        resp = self.invoke("DescribeImage", d, **kwargs)
        return apis.DescribeImageResponseSchema().loads(resp)

    def describe_isolation_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeIsolationGroup - 查询硬件隔离组列表。

        **Request**

        - **ProjectId** (str) - (Config) 项目id
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - 待查的硬件隔离组id
        - **Limit** (int) - 返回数据长度，默认为20，最大100
        - **Offset** (int) - 列表起始位置偏移量，默认为0

        **Response**

        - **IsolationGroupSet** (list) - 见 **IsolationGroup** 模型定义
        - **TotalCount** (int) - 硬件隔离组总数

        **Response Model**

        **IsolationGroup**
        - **GroupId** (str) - 硬件隔离组id
        - **GroupName** (str) - 硬件隔离组名称
        - **Remark** (str) - 备注
        - **SpreadInfoSet** (list) - 见 **SpreadInfo** 模型定义


        **SpreadInfo**
        - **UHostCount** (int) - 当前地域所有可用区中硬件隔离组中云主机的数量，不超过7。
        - **Zone** (str) - 可用区信息


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeIsolationGroupRequestSchema().dumps(d)

        resp = self.invoke("DescribeIsolationGroup", d, **kwargs)
        return apis.DescribeIsolationGroupResponseSchema().loads(resp)

    def describe_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUHostInstance - 获取主机或主机列表信息，并可根据数据中心，主机ID等参数进行过滤。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **IsolationGroup** (str) - 硬件隔离组id。通过硬件隔离组筛选主机。
        - **Limit** (int) - 返回数据长度，默认为20，最大100
        - **Offset** (int) - 列表起始位置偏移量，默认为0
        - **SubnetId** (str) - 子网id。通过子网筛选主机。北京一地域无效。
        - **Tag** (str) - 要查询的业务组名称
        - **UDiskIdForAttachment** (str) - 要挂载的云盘id，过滤返回能被UDiskId挂载的云主机。目前主要针对rssd云盘使用
        - **UHostIds** (list) - 【数组】UHost主机的资源ID，例如UHostIds.0代表希望获取信息 的主机1，UHostIds.1代表主机2。 如果不传入，则返回当前Region 所有符合条件的UHost实例。
        - **VPCId** (str) - vpc id。通过VPC筛选主机。北京一地域无效。
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **TotalCount** (int) - UHostInstance总数
        - **UHostSet** (list) - 见 **UHostInstanceSet** 模型定义

        **Response Model**

        **UHostInstanceSet**
        - **AutoRenew** (str) - 是否自动续费，自动续费：“Yes”，不自动续费：“No”
        - **BasicImageId** (str) - 基础镜像ID（指当前自定义镜像的来源镜像）
        - **BasicImageName** (str) - 基础镜像名称（指当前自定义镜像的来源镜像）
        - **BootDiskState** (str) - 系统盘状态 Normal表示初始化完成；Initializing表示在初始化。仍在初始化的系统盘无法制作镜像。
        - **CPU** (int) - 虚拟CPU核数，单位: 个
        - **ChargeType** (str) - 计费模式，枚举值为： Year，按年付费； Month，按月付费； Dynamic，按需付费（需开启权限）；Preemptive 为抢占式实例；
        - **CloudInitFeature** (bool) - true，支持cloutinit方式初始化；false,不支持
        - **CpuPlatform** (str) - 云主机CPU平台。参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type#主机概念20版本>`_ 。
        - **CreateTime** (int) - 创建时间，格式为Unix时间戳
        - **DiskSet** (list) - 见 **UHostDiskSet** 模型定义
        - **ExpireTime** (int) - 到期时间，格式为Unix时间戳
        - **GPU** (int) - GPU个数
        - **HostType** (str) - 【建议不再使用】主机系列：N2，表示系列2；N1，表示系列1
        - **HotplugFeature** (bool) - true: 开启热升级； false，未开启热升级
        - **HpcFeature** (bool) - true: 开启 hpc 系列功能；false: 未开启
        - **IPSet** (list) - 见 **UHostIPSet** 模型定义
        - **IPv6Feature** (bool) - true:有ipv6特性；false，没有ipv6特性
        - **ImageId** (str) - 【建议不再使用】主机的系统盘ID。
        - **IsolationGroup** (str) - 隔离组id，不在隔离组则返回""
        - **KeyPair** (dict) - 见 **UHostKeyPair** 模型定义
        - **LifeCycle** (str) - 主机的生命周期类型。目前仅支持Normal：普通；
        - **MachineType** (str) - 云主机机型（新）。参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type#主机概念20版本>`_ 。
        - **Memory** (int) - 内存大小，单位: MB
        - **Name** (str) - UHost实例名称
        - **NetCapability** (str) - 网络增强。Normal: 无；Super： 网络增强1.0； Ultra: 网络增强2.0
        - **NetworkState** (str) - 【建议不再使用】网络状态。 连接：Connected， 断开：NotConnected
        - **OsName** (str) - 创建主机的最初来源镜像的操作系统名称（若直接通过基础镜像创建，此处返回和BasicImageName一致）
        - **OsType** (str) - 操作系统类别。返回"Linux"或者"Windows"
        - **RdmaClusterId** (str) - RDMA集群id，仅快杰云主机返回该值；其他类型云主机返回""。当云主机的此值与RSSD云盘的RdmaClusterId相同时，RSSD可以挂载到这台云主机。
        - **Remark** (str) - 备注
        - **RestrictMode** (str) - 仅抢占式实例返回，LowSpeed为低速模式，PowerOff为关机模式
        - **State** (str) - 实例状态，枚举值：\\ >初始化: Initializing; \\ >启动中: Starting; \\> 运行中: Running; \\> 关机中: Stopping; \\ >关机: Stopped \\ >安装失败: Install Fail; \\ >重启中: Rebooting; \\ > 未知(空字符串，获取状态超时或出错)：""
        - **StorageType** (str) - 【建议不再使用】主机磁盘类型。 枚举值为：\\ > LocalDisk，本地磁盘; \\ > UDisk 云盘。\\只要有一块磁盘为本地盘，即返回LocalDisk。
        - **SubnetType** (str) - 【建议不再使用】仅北京A的云主机会返回此字段。基础网络模式：Default；子网模式：Private
        - **Tag** (str) - 业务组名称
        - **TimemachineFeature** (str) - 【建议不再使用】数据方舟模式。枚举值：\\ > Yes: 开启方舟； \\ > no，未开启方舟
        - **TotalDiskSpace** (int) - 总的数据盘存储空间。
        - **UHostId** (str) - UHost实例ID
        - **UHostType** (str) - 【建议不再使用】云主机机型（旧）。参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type>`_ 。
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_


        **UHostDiskSet**
        - **BackupType** (str) - 备份方案。若开通了数据方舟，则为DATAARK
        - **DiskId** (str) - 磁盘ID
        - **DiskType** (str) - 磁盘类型。请参考 `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ 。
        - **Drive** (str) - 磁盘盘符
        - **Encrypted** (str) - "true": 加密盘 "false"：非加密盘
        - **IsBoot** (str) - 是否是系统盘。枚举值：\\ > True，是系统盘 \\ > False，是数据盘（默认）。Disks数组中有且只能有一块盘是系统盘。
        - **Name** (str) - UDisk名字（仅当磁盘是UDisk时返回）
        - **Size** (int) - 磁盘大小，单位: GB
        - **Type** (str) - 【建议不再使用】磁盘类型。系统盘: Boot，数据盘: Data,网络盘：Udisk


        **UHostIPSet**
        - **Bandwidth** (int) - IP对应的带宽, 单位: Mb  (内网IP不显示带宽信息)
        - **Default** (str) - 内网 Private 类型下，表示是否为默认网卡。true: 是默认网卡；其他值：不是。
        - **IP** (str) - IP地址
        - **IPId** (str) - 外网IP资源ID 。(内网IP无对应的资源ID)
        - **IPMode** (str) - IPv4/IPv6；
        - **Mac** (str) - 内网 Private 类型下，当前网卡的Mac。
        - **NetworkInterfaceId** (str) - 弹性网卡为默认网卡时，返回对应的 ID 值
        - **SubnetId** (str) - IP地址对应的子网 ID。（北京一不支持，字段返回为空）
        - **Type** (str) - 国际: Internation，BGP: Bgp，内网: Private
        - **VPCId** (str) - IP地址对应的VPC ID。（北京一不支持，字段返回为空）
        - **Weight** (int) - 当前EIP的权重。权重最大的为当前的出口IP。


        **UHostKeyPair**
        - **KeyPairId** (str) - 密钥对ID
        - **KeyPairState** (str) - 主机密钥对状态，Normal 正常，Deleted 删除


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUHostInstance", d, **kwargs)
        return apis.DescribeUHostInstanceResponseSchema().loads(resp)

    def describe_uhost_instance_snapshot(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUHostInstanceSnapshot -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Region** (str) - (Config)
        - **UHostId** (str) - (Required)
        - **Zone** (str) -

        **Response**

        - **SnapshotSet** (list) - 见 **UHostSnapshotSet** 模型定义
        - **UhostId** (str) -

        **Response Model**

        **UHostSnapshotSet**
        - **SnapshotName** (str) -
        - **SnapshotState** (str) -
        - **SnapshotTime** (str) -


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUHostInstanceSnapshotRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("DescribeUHostInstanceSnapshot", d, **kwargs)
        return apis.DescribeUHostInstanceSnapshotResponseSchema().loads(resp)

    def describe_uhost_key_pairs(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUHostKeyPairs - 查询一个或多个密钥对。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **KeyPairFingerPrint** (str) - 密钥对的指纹。
        - **KeyPairName** (str) - 密钥对名称。
        - **Limit** (int) - 返回数据长度，默认为20，最大100
        - **Offset** (int) - 列表起始位置偏移量，默认为0
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **KeyPairs** (list) - 见 **KeyPairDesc** 模型定义
        - **TotalCount** (int) - 密钥对总数

        **Response Model**

        **KeyPairDesc**
        - **CreateTime** (int) - 密钥对的创建时间，格式为Unix Timestamp。
        - **KeyPairFingerPrint** (str) - 密钥对指纹。md5(ProjectId|KeyPairId|PublicKey)
        - **KeyPairId** (str) - 密钥对ID。
        - **KeyPairName** (str) - 密钥对名称。 长度为1~63个英文或中文字符。
        - **ProjectId** (str) - 项目ID。


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUHostKeyPairsRequestSchema().dumps(d)

        resp = self.invoke("DescribeUHostKeyPairs", d, **kwargs)
        return apis.DescribeUHostKeyPairsResponseSchema().loads(resp)

    def describe_uhost_tags(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUHostTags - 获取指定数据中心的业务组列表。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **TagSet** (list) - 见 **UHostTagSet** 模型定义
        - **TotalCount** (int) - 已有主机的业务组总数

        **Response Model**

        **UHostTagSet**
        - **Tag** (str) - 业务组名称
        - **TotalCount** (int) - 该业务组中包含的主机个数
        - **Zone** (str) - 可用区


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUHostTagsRequestSchema().dumps(d)

        resp = self.invoke("DescribeUHostTags", d, **kwargs)
        return apis.DescribeUHostTagsResponseSchema().loads(resp)

    def get_attached_disk_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetAttachedDiskUpgradePrice - 获取挂载磁盘的升级价格

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DiskId** (str) - (Required) 磁盘ID。参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_ 返回值中的DiskSet。
        - **DiskSpace** (int) - (Required) 磁盘大小，单位GB，步长为10。取值范围需大于当前磁盘大小，最大值请参考 `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ 。
        - **UHostId** (str) - (Required) UHost实例ID。 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_ 。
        - **BackupMode** (str) - 磁盘备份方案。枚举值：\\ > NONE，无备份 \\ > DATAARK，数据方舟 \\> SNAPSHOT(SNAPSHOT模式目前仅在上海C支持)，快照 \\ 当前磁盘支持的备份模式参考  `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ 。默认值为当前的备份模式。
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Price** (float) - 升级差价。精度为小数点后2位。

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetAttachedDiskUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("GetAttachedDiskUpgradePrice", d, **kwargs)
        return apis.GetAttachedDiskUpgradePriceResponseSchema().loads(resp)

    def get_uhost_instance_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUHostInstancePrice - 根据UHost实例配置，获取UHost实例的价格。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CPU** (int) - (Required) CPU核数。可选参数：1-64。可选范围参照控制台。默认值: 4
        - **Count** (int) - (Required) 购买台数，范围[1,5]
        - **Memory** (int) - (Required) 内存大小。单位：MB。范围 ：[1024, 262144]，取值为1024的倍数（可选范围参照好控制台）。默认值：8192
        - **ChargeType** (str) - 计费模式。枚举值为： \\ > Year，按年付费； \\ > Month，按月付费；\\ > Dynamic，按小时付费 // >Preemptive 抢占式实例 \\ 如果不传某个枚举值，默认返回年付、月付、时付的价格组合集。
        - **CpuPlatform** (str) - 取值"Intel" "Amd"，默认值“Intel”
        - **Disks** (list) - 见 **GetUHostInstancePriceParamDisks** 模型定义
        - **GPU** (int) - GPU卡核心数。仅GPU机型支持此字段。
        - **GpuType** (str) - GPU类型，枚举值["K80", "P40", "V100", "T4","T4S","2080Ti","2080Ti-4C","1080Ti"]
        - **ImageId** (str) - 镜像Id，可通过  `DescribeImage <https://docs.ucloud.cn/api/uhost-api/describe_image.html>`_  获取镜像ID， 如果镜像ID不传，系统盘大小必传
        - **MachineType** (str) - 云主机机型（V2版本概念）。枚举值["N", "C", "G", "O", "OS", "OPRO", "OMAX", "O.BM"]。参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type>`_ 。
        - **NetCapability** (str) - 网络增强。枚举值：Normal，不开启; Super，开启网络增强1.0。 默认值为Normal。
        - **Quantity** (int) - 购买时长。默认: 1。按小时购买(Dynamic)时无需此参数。 月付时，此参数传0，代表了购买至月末。
        - **UHostType** (str) - 【待废弃】云主机机型（V1版本概念）。参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type>`_ 。
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **PriceSet** (list) - 见 **UHostPriceSet** 模型定义

        **Request Model**

        **GetUHostInstancePriceParamDisks**
        - **BackupType** (str) - 磁盘备份方案。枚举值：\\ > NONE，无备份 \\ > DATAARK，数据方舟 \\ > SNAPSHOT，快照\\ 当前磁盘支持的备份模式参考  `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_
        - **IsBoot** (str) - 是否是系统盘。枚举值：\\ > True，是系统盘 \\ > False，是数据盘（默认）。Disks数组中有且只能有一块盘是系统盘。
        - **Size** (int) - 磁盘大小，单位GB。请参考 `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ 。
        - **Type** (str) - 磁盘类型。请参考 `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ 。


        **GetUHostInstancePriceParamVolumes**


        **GetUHostInstancePriceParamVirtualGpu**


        **Response Model**

        **UHostPriceSet**
        - **ChargeType** (str) - 计费类型。Year，Month，Dynamic
        - **ListPrice** (float) - 产品列表价。
        - **OriginalPrice** (float) - 限时优惠的折前原价（即列表价乘以商务折扣后的单价）。
        - **Price** (float) - 价格，单位: 元，保留小数点后两位有效数字


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetUHostInstancePriceRequestSchema().dumps(d)

        resp = self.invoke("GetUHostInstancePrice", d, **kwargs)
        return apis.GetUHostInstancePriceResponseSchema().loads(resp)

    def get_uhost_instance_vnc_info(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUHostInstanceVncInfo - 获取指定UHost实例的管理VNC配置详细信息。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID
        - **VncIP** (str) - Vnc登录IP
        - **VncPassword** (str) - Vnc 登录密码
        - **VncPort** (int) - Vnc登录端口

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetUHostInstanceVncInfoRequestSchema().dumps(d)

        resp = self.invoke("GetUHostInstanceVncInfo", d, **kwargs)
        return apis.GetUHostInstanceVncInfoResponseSchema().loads(resp)

    def get_uhost_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUHostUpgradePrice - 获取UHost实例升级配置的价格。可选配置范围请参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type>`_ 。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID。 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_ 。
        - **CPU** (int) - 虚拟CPU核数。可选参数：1-64（可选范围参考控制台）。默认值为当前实例的CPU核数。
        - **Memory** (int) - 内存大小。单位：MB。范围 ：[1024, 262144]，取值为1024的倍数（可选范围参考控制台）。默认值为当前实例的内存大小。
        - **NetCapValue** (int) - 网卡升降级（1，表示升级，2表示降级，0表示不变）
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **OriginalPrice** (float) - 限时优惠的折前原价
        - **Price** (float) - 规格调整差价。精确到小数点后2位。

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetUHostUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("GetUHostUpgradePrice", d, **kwargs)
        return apis.GetUHostUpgradePriceResponseSchema().loads(resp)

    def import_custom_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ImportCustomImage - 把UFile的镜像文件导入到UHost，生成自定义镜像

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Auth** (bool) - (Required) 是否授权。必须填true
        - **Format** (str) - (Required) 镜像格式，可选RAW、VHD、VMDK、qcow2
        - **ImageName** (str) - (Required) 镜像名称
        - **OsName** (str) - (Required) 操作系统详细版本，请参考控制台的镜像版本；OsType为Other时，输入参数为Other
        - **OsType** (str) - (Required) 操作系统平台，比如CentOS、Ubuntu、Windows、RedHat等，请参考控制台的镜像版本；若导入控制台上没有的操作系统，参数为Other
        - **UFileUrl** (str) - (Required) UFile私有空间地址
        - **ImageDescription** (str) - 镜像描述

        **Response**

        - **ImageId** (str) - 镜像Id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ImportCustomImageRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("ImportCustomImage", d, **kwargs)
        return apis.ImportCustomImageResponseSchema().loads(resp)

    def import_uhost_key_pairs(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ImportUHostKeyPairs - 导入密钥对后，仅保管公钥部分，需自行妥善保存密钥对的私钥部分。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **KeyPairName** (str) - (Required) 密钥对名称。由字母，数字，符号组成，长度为1-63位。
        - **PublicKeyBody** (str) - (Required) 密钥对的公钥内容。
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **KeyPairFingerPrint** (str) - 密钥对指纹。根据RFC4716定义的公钥指纹格式，采用MD5信息摘要算法。算法处理的具体信息格式：`ProjectIdKeyPairId|PublicKeyBody`。
        - **KeyPairId** (str) - 密钥对标识
        - **KeyPairName** (str) - 密钥对名称

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ImportUHostKeyPairsRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("ImportUHostKeyPairs", d, **kwargs)
        return apis.ImportUHostKeyPairsResponseSchema().loads(resp)

    def leave_isolation_group(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """LeaveIsolationGroup - 移除硬件隔离组中的主机

        **Request**

        - **ProjectId** (str) - (Config) 项目id
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **GroupId** (str) - (Required) 硬件隔离组id
        - **UHostId** (str) - (Required) 主机id
        - **Zone** (str) - 可用区信息

        **Response**

        - **UHostId** (str) - 主机id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.LeaveIsolationGroupRequestSchema().dumps(d)

        resp = self.invoke("LeaveIsolationGroup", d, **kwargs)
        return apis.LeaveIsolationGroupResponseSchema().loads(resp)

    def modify_uhost_ip(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUHostIP - 修改云主机内网 IP 地址

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写时为默认项目。请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **PresentIpAddress** (str) - (Required) 需要修改为的 IP 地址。新的IP地址和旧IP地址必须属于统一子网，且和主机内部的配置文件一致。
        - **UHostId** (str) - (Required) 指定云主机 ID。
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **PreviousIpAddress** (str) - 所需修改的原 IP 地址 ，当云主机只有一个IP地址时，此参数不必填写。

        **Response**

        - **Message** (str) - 输出错误的信息
        - **UHostId** (str) - 目标云主机 ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyUHostIPRequestSchema().dumps(d)

        resp = self.invoke("ModifyUHostIP", d, **kwargs)
        return apis.ModifyUHostIPResponseSchema().loads(resp)

    def modify_uhost_instance_name(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUHostInstanceName - 修改指定UHost实例名称，需要给出数据中心，UHostId，及新的实例名称。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **Name** (str) - UHost实例名称
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyUHostInstanceNameRequestSchema().dumps(d)

        resp = self.invoke("ModifyUHostInstanceName", d, **kwargs)
        return apis.ModifyUHostInstanceNameResponseSchema().loads(resp)

    def modify_uhost_instance_remark(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUHostInstanceRemark - 修改指定UHost实例备注信息。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **Remark** (str) - 备注
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyUHostInstanceRemarkRequestSchema().dumps(d)

        resp = self.invoke("ModifyUHostInstanceRemark", d, **kwargs)
        return apis.ModifyUHostInstanceRemarkResponseSchema().loads(resp)

    def modify_uhost_instance_tag(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUHostInstanceTag - 修改指定UHost实例业务组标识。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **Tag** (str) - 业务组名称
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyUHostInstanceTagRequestSchema().dumps(d)

        resp = self.invoke("ModifyUHostInstanceTag", d, **kwargs)
        return apis.ModifyUHostInstanceTagResponseSchema().loads(resp)

    def poweroff_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """PoweroffUHostInstance - 直接关闭UHost实例电源，无需等待实例正常关闭。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost的实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.PoweroffUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("PoweroffUHostInstance", d, **kwargs)
        return apis.PoweroffUHostInstanceResponseSchema().loads(resp)

    def reboot_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RebootUHostInstance - 重新启动UHost实例，需要指定数据中心及UHostID两个参数的值。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **DiskPassword** (str) - 加密盘密码
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RebootUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("RebootUHostInstance", d, **kwargs)
        return apis.RebootUHostInstanceResponseSchema().loads(resp)

    def reinstall_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ReinstallUHostInstance - 重新安装指定UHost实例的操作系统

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例资源ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **AutoDataDiskInit** (str) - 数据盘是否需要自动分区挂载。当镜像支持Cloud-init Feature时可填写此字段。取值“On”（默认值）， “Off”
        - **BootDiskSpace** (int) - 系统盘大小。 单位：GB， 范围[20,100]， 步长：10
        - **ImageId** (str) - 镜像Id，默认使用原镜像 参见  `DescribeImage <https://docs.ucloud.cn/api/uhost-api/describe_image.html>`_
        - **KeyPairId** (str) - KeypairId 密钥对ID，LoginMode为KeyPair时此项必须。
        - **LoginMode** (str) - 主机登陆模式。密码（默认选项）: Password，密钥 KeyPair。
        - **Password** (str) - 如果重装UHost实例时LoginMode为Password，则必须填写，如果LoginMode为KeyPair，不需要填写 （密码格式使用BASE64编码；举例如下：# echo -n Password1 | base64UGFzc3dvcmQx。）
        - **ReserveDisk** (str) - 是否保留数据盘，保留：Yes，不报留：No， 默认：Yes；如果是从Windows重装为Linux或反之，则无法保留数据盘（该参数目前仅对本地数据盘起作用）
        - **UserData** (str) - cloudinit初始化使用。注意：1、总数据量大小不超多16K 2、使用base64编码
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例资源ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ReinstallUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("ReinstallUHostInstance", d, **kwargs)
        return apis.ReinstallUHostInstanceResponseSchema().loads(resp)

    def reset_uhost_instance_password(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ResetUHostInstancePassword - 重置UHost实例的管理员密码。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Password** (str) - (Required) UHost新密码（密码格式使用BASE64编码）
        - **UHostId** (str) - (Required) UHost实例ID
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ResetUHostInstancePasswordRequestSchema().dumps(d)

        resp = self.invoke("ResetUHostInstancePassword", d, **kwargs)
        return apis.ResetUHostInstancePasswordResponseSchema().loads(resp)

    def resize_attached_disk(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ResizeAttachedDisk - 修改挂载的磁盘大小，包含系统盘和数据盘

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DiskId** (str) - (Required) 磁盘ID。参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_ 返回值中的DiskSet。
        - **DiskSpace** (int) - (Required) 磁盘大小，单位GB，步长为10。取值范围需大于当前磁盘大小，最大值请参考 `磁盘类型 <https://docs.ucloud.cn/api/uhost-api/disk_type>`_ 。
        - **UHostId** (str) - (Required) UHost实例ID。 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_ 。
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DryRun** (bool) - 用于测试磁盘是否支持在线扩容。DryRun=true,不会执行实际操作，只会返回操作的预期结果。DryRun = false ，正常执行扩容操作。

        **Response**

        - **DiskId** (str) - 改配成功的磁盘id
        - **NeedRestart** (bool) - 扩容后的状态。NeedRestart = true，必须关闭后启动实例才能使用扩容的磁盘空间。NeedRestart = false,磁盘扩容后无需重启操作。

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ResizeAttachedDiskRequestSchema().dumps(d)

        resp = self.invoke("ResizeAttachedDisk", d, **kwargs)
        return apis.ResizeAttachedDiskResponseSchema().loads(resp)

    def resize_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ResizeUHostInstance - 修改指定UHost实例的资源配置，如CPU核心数，内存容量大小，网络增强等。可选配置范围请参考 `云主机机型说明 <https://docs.ucloud.cn/api/uhost-api/uhost_type>`_ 。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **CPU** (int) - 虚拟CPU核数。可选参数：1-240（可选范围与UHostType相关）。默认值为当前实例的CPU核数
        - **Memory** (int) - 内存大小。单位：MB。范围 ：[1024, 1966080]，取值为1024的倍数（可选范围与UHostType相关）。默认值为当前实例的内存大小。
        - **NetCapValue** (int) - 网卡升降级（1，表示升级，2表示降级，0表示不变）
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ResizeUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("ResizeUHostInstance", d, **kwargs)
        return apis.ResizeUHostInstanceResponseSchema().loads(resp)

    def start_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StartUHostInstance - 启动处于关闭状态的UHost实例，需要指定数据中心及UHostID两个参数的值。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **DiskPassword** (str) - 加密盘密码
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.StartUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("StartUHostInstance", d, **kwargs)
        return apis.StartUHostInstanceResponseSchema().loads(resp)

    def stop_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StopUHostInstance - 指停止处于运行状态的UHost实例，需指定数据中心及UhostID。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost实例ID 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **UHostId** (str) - UHost实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.StopUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("StopUHostInstance", d, **kwargs)
        return apis.StopUHostInstanceResponseSchema().loads(resp)

    def terminate_custom_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """TerminateCustomImage - 删除用户自定义镜像

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ImageId** (str) - (Required) 自制镜像ID 参见  `DescribeImage <https://docs.ucloud.cn/api/uhost-api/describe_image.html>`_

        **Response**

        - **ImageId** (str) - 自制镜像Id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.TerminateCustomImageRequestSchema().dumps(d)

        resp = self.invoke("TerminateCustomImage", d, **kwargs)
        return apis.TerminateCustomImageResponseSchema().loads(resp)

    def terminate_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """TerminateUHostInstance - 删除指定数据中心的UHost实例。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostId** (str) - (Required) UHost资源Id 参见  `DescribeUHostInstance <https://docs.ucloud.cn/api/uhost-api/describe_uhost_instance.html>`_
        - **ReleaseEIP** (bool) - 删除主机时是否释放绑定的EIP。默认为false。
        - **ReleaseUDisk** (bool) - 删除主机时是否同时删除挂载的数据盘。默认为false。
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **InRecycle** (str) - 用于判断主机删除时是否进入回收站。放入回收站:"Yes", 彻底删除：“No”。
        - **UHostId** (str) - UHost 实例 Id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.TerminateUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("TerminateUHostInstance", d, **kwargs)
        return apis.TerminateUHostInstanceResponseSchema().loads(resp)

    def upgrade_to_ark_uhost_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpgradeToArkUHostInstance - 普通升级为方舟机型

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **UHostIds** (list) - (Required) UHost主机的资源ID，例如UHostIds.0代表希望升级的主机1，UHostIds.1代表主机2。
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CouponId** (str) - 代金券ID 请参考DescribeCoupon接口

        **Response**

        - **UHostSet** (list) - UHost主机的资源ID数组

        """
        # build request
        d = {
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpgradeToArkUHostInstanceRequestSchema().dumps(d)

        resp = self.invoke("UpgradeToArkUHostInstance", d, **kwargs)
        return apis.UpgradeToArkUHostInstanceResponseSchema().loads(resp)
