"""Exceptions."""
# -*- coding: utf-8 -*-


class FilmAffinityException(Exception):
    """Any exception generated by FilmAffinityException."""
    pass


class FilmAffinityInvalidLanguage(FilmAffinityException):
    """Invalid language given on FilmAffinity."""
    def __init__(self, value, supported):
        self.value = value
        self.supported = supported

    def __str__(self):
        return repr('Invalid Language selected: {}    '
                    '[Available languages are: {}]'.format(
                        self.value, ', '.join(self.supported)))


class FilmAffinityInvalidBackend(FilmAffinityException):
    """Invalid Backend for requests-cache."""
    def __init__(self, value):
        self.value = value

    def __str__(self):
        return repr('Invalid Backend for requests-cache: {}'.format(
            self.value))


class FilmAffinityConnectionError(FilmAffinityException):
    """Invalid connection tp FilmAffinity."""
    def __init__(self, value):
        self.value = value

    def __str__(self):
        return repr('Error connecting to FilmAffinity: {}'.format(self.value))
