"""more cascade delete

Revision ID: 0005
Revises: 0004
Create Date: 2025-01-17 15:21:42.028597

"""

from collections.abc import Sequence

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "0005"
down_revision: str | None = "0004"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("generations", schema=None) as batch_op:
        batch_op.drop_constraint(
            "generations_prompt_uuid_prompts_fkey", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "generations_response_model_uuid_response_models_fkey", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "generations_project_uuid_projects_fkey", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("generations_prompt_uuid_prompts_fkey"),
            "prompts",
            ["prompt_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("generations_project_uuid_projects_fkey"),
            "projects",
            ["project_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("generations_response_model_uuid_response_models_fkey"),
            "response_models",
            ["response_model_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("prompts", schema=None) as batch_op:
        batch_op.drop_constraint(
            "prompts_project_uuid_projects_fkey", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("prompts_project_uuid_projects_fkey"),
            "projects",
            ["project_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("response_models", schema=None) as batch_op:
        batch_op.drop_constraint(
            "response_models_project_uuid_projects_fkey", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("response_models_project_uuid_projects_fkey"),
            "projects",
            ["project_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("spans", schema=None) as batch_op:
        batch_op.drop_constraint(
            "spans_generation_uuid_generations_fkey", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "spans_response_model_uuid_response_models_fkey", type_="foreignkey"
        )
        batch_op.drop_constraint("spans_prompt_uuid_prompts_fkey", type_="foreignkey")
        batch_op.drop_constraint("spans_project_uuid_projects_fkey", type_="foreignkey")
        batch_op.create_foreign_key(
            batch_op.f("spans_generation_uuid_generations_fkey"),
            "generations",
            ["generation_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("spans_response_model_uuid_response_models_fkey"),
            "response_models",
            ["response_model_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("spans_project_uuid_projects_fkey"),
            "projects",
            ["project_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )
        batch_op.create_foreign_key(
            batch_op.f("spans_prompt_uuid_prompts_fkey"),
            "prompts",
            ["prompt_uuid"],
            ["uuid"],
            ondelete="CASCADE",
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("spans", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("spans_prompt_uuid_prompts_fkey"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("spans_project_uuid_projects_fkey"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("spans_response_model_uuid_response_models_fkey"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("spans_generation_uuid_generations_fkey"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            "spans_project_uuid_projects_fkey", "projects", ["project_uuid"], ["uuid"]
        )
        batch_op.create_foreign_key(
            "spans_prompt_uuid_prompts_fkey", "prompts", ["prompt_uuid"], ["uuid"]
        )
        batch_op.create_foreign_key(
            "spans_response_model_uuid_response_models_fkey",
            "response_models",
            ["response_model_uuid"],
            ["uuid"],
        )
        batch_op.create_foreign_key(
            "spans_generation_uuid_generations_fkey",
            "generations",
            ["generation_uuid"],
            ["uuid"],
        )

    with op.batch_alter_table("response_models", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("response_models_project_uuid_projects_fkey"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            "response_models_project_uuid_projects_fkey",
            "projects",
            ["project_uuid"],
            ["uuid"],
        )

    with op.batch_alter_table("prompts", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("prompts_project_uuid_projects_fkey"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            "prompts_project_uuid_projects_fkey", "projects", ["project_uuid"], ["uuid"]
        )

    with op.batch_alter_table("generations", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("generations_response_model_uuid_response_models_fkey"),
            type_="foreignkey",
        )
        batch_op.drop_constraint(
            batch_op.f("generations_project_uuid_projects_fkey"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("generations_prompt_uuid_prompts_fkey"), type_="foreignkey"
        )
        batch_op.create_foreign_key(
            "generations_project_uuid_projects_fkey",
            "projects",
            ["project_uuid"],
            ["uuid"],
        )
        batch_op.create_foreign_key(
            "generations_response_model_uuid_response_models_fkey",
            "response_models",
            ["response_model_uuid"],
            ["uuid"],
        )
        batch_op.create_foreign_key(
            "generations_prompt_uuid_prompts_fkey", "prompts", ["prompt_uuid"], ["uuid"]
        )

    # ### end Alembic commands ###
